/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.hudi.client.utils.LazyIterableIterator;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.io.HoodieKeyLookupHandle;
import org.apache.hudi.io.HoodieKeyLookupResult;
import org.apache.hudi.table.HoodieTable;

public class HoodieBloomIndexCheckFunction<I>
implements Function<Iterator<I>, Iterator<List<HoodieKeyLookupResult>>>,
Serializable {
    private final HoodieTable hoodieTable;
    private final HoodieWriteConfig config;
    private final SerializableFunction<I, HoodieFileGroupId> fileGroupIdExtractor;
    private final SerializableFunction<I, String> recordKeyExtractor;

    public HoodieBloomIndexCheckFunction(HoodieTable hoodieTable, HoodieWriteConfig config, SerializableFunction<I, HoodieFileGroupId> fileGroupIdExtractor, SerializableFunction<I, String> recordKeyExtractor) {
        this.hoodieTable = hoodieTable;
        this.config = config;
        this.fileGroupIdExtractor = fileGroupIdExtractor;
        this.recordKeyExtractor = recordKeyExtractor;
    }

    @Override
    public Iterator<List<HoodieKeyLookupResult>> apply(Iterator<I> fileGroupIdRecordKeyPairIterator) {
        return new LazyKeyCheckIterator(fileGroupIdRecordKeyPairIterator);
    }

    protected class LazyKeyCheckIterator
    extends LazyIterableIterator<I, List<HoodieKeyLookupResult>> {
        private HoodieKeyLookupHandle keyLookupHandle;

        LazyKeyCheckIterator(Iterator<I> filePartitionRecordKeyTripletItr) {
            super(filePartitionRecordKeyTripletItr);
        }

        @Override
        protected List<HoodieKeyLookupResult> computeNext() {
            ArrayList<HoodieKeyLookupResult> ret = new ArrayList<HoodieKeyLookupResult>();
            try {
                while (this.inputItr.hasNext()) {
                    Object tuple = this.inputItr.next();
                    HoodieFileGroupId fileGroupId = (HoodieFileGroupId)HoodieBloomIndexCheckFunction.this.fileGroupIdExtractor.apply(tuple);
                    String recordKey = (String)HoodieBloomIndexCheckFunction.this.recordKeyExtractor.apply(tuple);
                    String fileId = fileGroupId.getFileId();
                    String partitionPath = fileGroupId.getPartitionPath();
                    Pair partitionPathFilePair = Pair.of((Object)partitionPath, (Object)fileId);
                    if (this.keyLookupHandle == null) {
                        this.keyLookupHandle = new HoodieKeyLookupHandle(HoodieBloomIndexCheckFunction.this.config, HoodieBloomIndexCheckFunction.this.hoodieTable, (Pair<String, String>)partitionPathFilePair);
                    }
                    if (this.keyLookupHandle.getPartitionPathFileIDPair().equals((Object)partitionPathFilePair)) {
                        this.keyLookupHandle.addKey(recordKey);
                        continue;
                    }
                    ret.add(this.keyLookupHandle.getLookupResult());
                    this.keyLookupHandle = new HoodieKeyLookupHandle(HoodieBloomIndexCheckFunction.this.config, HoodieBloomIndexCheckFunction.this.hoodieTable, (Pair<String, String>)partitionPathFilePair);
                    this.keyLookupHandle.addKey(recordKey);
                    break;
                }
                if (!this.inputItr.hasNext()) {
                    ret.add(this.keyLookupHandle.getLookupResult());
                }
            }
            catch (Throwable e) {
                if (e instanceof HoodieException) {
                    throw (HoodieException)e;
                }
                throw new HoodieIndexException("Error checking bloom filter index. ", e);
            }
            return ret;
        }
    }
}

