/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializableBiFunction;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieDeltaWriteStat;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.hudi.table.marker.WriteMarkersFactory;

public class CommitMetadataUtils {
    public static HoodieCommitMetadata reconcileMetadataForMissingFiles(HoodieTable table, String commitActionType, String instantTime, HoodieCommitMetadata commitMetadata, HoodieWriteConfig config, HoodieEngineContext context, Configuration hadoopConf, String classNameForContext) throws IOException {
        if (!table.getMetaClient().getTableType().equals((Object)HoodieTableType.MERGE_ON_READ) || !commitActionType.equals("deltacommit")) {
            return commitMetadata;
        }
        WriteMarkers markers = WriteMarkersFactory.get(config.getMarkersType(), table, instantTime);
        boolean hasLogFileInDeltaCommit = commitMetadata.getPartitionToWriteStats().values().stream().flatMap(Collection::stream).anyMatch(writeStat -> FSUtils.isLogFile((String)new Path(config.getBasePath(), writeStat.getPath()).getName()));
        if (hasLogFileInDeltaCommit) {
            HashSet<String> allLogFilesMarkerPath = new HashSet<String>(markers.getAppendedLogPaths(context, config.getFinalizeWriteParallelism()));
            HashSet<String> logFilesMarkerPath = new HashSet<String>();
            allLogFilesMarkerPath.stream().filter(logFilePath -> !logFilePath.endsWith("cdc")).forEach(logFilesMarkerPath::add);
            for (Map.Entry partitionAndWriteStats : commitMetadata.getPartitionToWriteStats().entrySet()) {
                for (HoodieWriteStat hoodieWriteStat : (List)partitionAndWriteStats.getValue()) {
                    logFilesMarkerPath.remove(hoodieWriteStat.getPath());
                }
            }
            if (!logFilesMarkerPath.isEmpty()) {
                StorageConfiguration storageConf = HadoopFSUtils.getStorageConfWithCopy((Configuration)hadoopConf);
                context.setJobStatus(classNameForContext, "Preparing data for missing files to assist with generating write stats");
                HoodiePairData<String, Map<String, HoodieWriteStat>> partitionToWriteStatHoodieData = CommitMetadataUtils.getPartitionToFileIdToFilesMap(commitMetadata, context);
                String basePathStr = config.getBasePath();
                HoodiePairData<String, Map<String, List<String>>> partitionToMissingLogFilesHoodieData = CommitMetadataUtils.getPartitionToFileIdToMissingLogFileMap(basePathStr, logFilesMarkerPath, context, config.getFileListingParallelism());
                context.setJobStatus(classNameForContext, "Generating writeStat for missing log files");
                List<Pair<String, List<HoodieWriteStat>>> additionalLogFileWriteStat = CommitMetadataUtils.getWriteStatsForMissingLogFiles(partitionToWriteStatHoodieData, partitionToMissingLogFilesHoodieData, storageConf, basePathStr);
                for (Pair<String, List<HoodieWriteStat>> partitionDeltaStats : additionalLogFileWriteStat) {
                    String partitionPath = (String)partitionDeltaStats.getKey();
                    ((List)partitionDeltaStats.getValue()).forEach(ws -> commitMetadata.addWriteStat(partitionPath, ws));
                }
            }
        }
        return commitMetadata;
    }

    private static HoodiePairData<String, Map<String, HoodieWriteStat>> getPartitionToFileIdToFilesMap(HoodieCommitMetadata commitMetadata, HoodieEngineContext context) {
        ArrayList partitionToWriteStats = new ArrayList(commitMetadata.getPartitionToWriteStats().entrySet());
        return context.parallelize(partitionToWriteStats).mapToPair((SerializablePairFunction & Serializable)t -> {
            HashMap fileIdToWriteStat = new HashMap();
            ((List)t.getValue()).forEach(writeStat -> {
                if (!fileIdToWriteStat.containsKey(writeStat.getFileId())) {
                    fileIdToWriteStat.put(writeStat.getFileId(), writeStat);
                }
            });
            return Pair.of(t.getKey(), fileIdToWriteStat);
        });
    }

    private static HoodiePairData<String, Map<String, List<String>>> getPartitionToFileIdToMissingLogFileMap(String basePathStr, Set<String> logFilesMarkerPath, HoodieEngineContext context, int parallelism) {
        ArrayList<String> logFilePaths = new ArrayList<String>(logFilesMarkerPath);
        HoodiePairData partitionPathLogFilePair = context.parallelize(logFilePaths).mapToPair((SerializablePairFunction & Serializable)logFilePath -> {
            Path logFileFullPath = new Path(basePathStr, logFilePath);
            String partitionPath = HadoopFSUtils.getRelativePartitionPath((Path)new Path(basePathStr), (Path)logFileFullPath.getParent());
            return Pair.of((Object)partitionPath, Collections.singletonList(logFileFullPath.getName()));
        });
        HoodiePairData partitionPathToFileIdAndLogFileList = partitionPathLogFilePair.reduceByKey((SerializableBiFunction & Serializable)(strings, strings2) -> {
            ArrayList logFilePaths1 = new ArrayList(strings);
            logFilePaths1.addAll(strings2);
            return logFilePaths1;
        }, parallelism).mapToPair((SerializablePairFunction & Serializable)t -> {
            String partitionPath = (String)t.getKey();
            Path fullPartitionPath = StringUtils.isNullOrEmpty((String)partitionPath) ? new Path(basePathStr) : new Path(basePathStr, partitionPath);
            List missingLogFiles = (List)t.getValue();
            HashMap fileIdtologFiles = new HashMap();
            missingLogFiles.forEach(logFile -> {
                String fileId = HadoopFSUtils.getFileIdFromLogPath((Path)new Path(fullPartitionPath, logFile));
                if (!fileIdtologFiles.containsKey(fileId)) {
                    fileIdtologFiles.put(fileId, new ArrayList());
                }
                ((List)fileIdtologFiles.get(fileId)).add(logFile);
            });
            return Pair.of((Object)partitionPath, fileIdtologFiles);
        });
        return partitionPathToFileIdAndLogFileList;
    }

    private static List<Pair<String, List<HoodieWriteStat>>> getWriteStatsForMissingLogFiles(HoodiePairData<String, Map<String, HoodieWriteStat>> partitionToWriteStatHoodieData, HoodiePairData<String, Map<String, List<String>>> partitionToMissingLogFilesHoodieData, StorageConfiguration<?> storageConf, String basePathStr) {
        return partitionToWriteStatHoodieData.join(partitionToMissingLogFilesHoodieData).map((SerializableFunction & Serializable)v1 -> {
            StoragePath basePathLocal = new StoragePath(basePathStr);
            String partitionPath = (String)v1.getKey();
            Map fileIdToOriginalWriteStat = (Map)((Pair)v1.getValue()).getKey();
            Map missingFileIdToLogFileNames = (Map)((Pair)v1.getValue()).getValue();
            List missingLogFileNames = missingFileIdToLogFileNames.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            StoragePath fullPartitionPath = StringUtils.isNullOrEmpty((String)partitionPath) ? new StoragePath(basePathStr) : new StoragePath(basePathStr, partitionPath);
            HoodieStorage storage = HoodieStorageUtils.getStorage((StoragePath)fullPartitionPath, (StorageConfiguration)storageConf);
            List pathInfoOptList = FSUtils.getPathInfoUnderPartition((HoodieStorage)storage, (StoragePath)fullPartitionPath, new HashSet(missingLogFileNames), (boolean)true);
            List<StoragePathInfo> pathInfoList = pathInfoOptList.stream().filter(fileStatusOpt -> fileStatusOpt.isPresent()).map(fileStatusOption -> (StoragePathInfo)fileStatusOption.get()).collect(Collectors.toList());
            HashMap<String, List> missingFileIdToLogFilesList = new HashMap<String, List>();
            pathInfoList.forEach(pathInfo -> {
                String fileId = FSUtils.getFileIdFromLogPath((StoragePath)pathInfo.getPath());
                missingFileIdToLogFilesList.putIfAbsent(fileId, new ArrayList());
                ((List)missingFileIdToLogFilesList.get(fileId)).add(pathInfo);
            });
            ArrayList missingWriteStats = new ArrayList();
            missingFileIdToLogFilesList.forEach((k, logFileStatuses) -> {
                String fileId = k;
                HoodieDeltaWriteStat originalWriteStat = (HoodieDeltaWriteStat)fileIdToOriginalWriteStat.get(fileId);
                logFileStatuses.forEach(pathInfo -> {
                    HoodieDeltaWriteStat writeStat = CommitMetadataUtils.getHoodieDeltaWriteStatFromPreviousStat(pathInfo, basePathLocal, partitionPath, fileId, originalWriteStat);
                    missingWriteStats.add(writeStat);
                });
            });
            return Pair.of((Object)partitionPath, missingWriteStats);
        }).collectAsList();
    }

    private static HoodieDeltaWriteStat getHoodieDeltaWriteStatFromPreviousStat(StoragePathInfo pathInfo, StoragePath basePathLocal, String partitionPath, String fileId, HoodieDeltaWriteStat originalWriteStat) {
        HoodieDeltaWriteStat writeStat = new HoodieDeltaWriteStat();
        HoodieLogFile logFile = new HoodieLogFile(pathInfo);
        writeStat.setPath(basePathLocal, logFile.getPath());
        writeStat.setPartitionPath(partitionPath);
        writeStat.setFileId(fileId);
        writeStat.setTotalWriteBytes(logFile.getFileSize());
        writeStat.setFileSizeInBytes(logFile.getFileSize());
        writeStat.setLogVersion(logFile.getLogVersion());
        ArrayList<String> logFiles = new ArrayList<String>(originalWriteStat.getLogFiles());
        logFiles.add(logFile.getFileName());
        writeStat.setLogFiles(logFiles);
        writeStat.setBaseFile(originalWriteStat.getBaseFile());
        writeStat.setPrevCommit(logFile.getBaseCommitTime());
        return writeStat;
    }
}

