/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.daemon.impl.comparator;

import java.util.Comparator;
import org.apache.hadoop.hive.llap.daemon.impl.TaskExecutorService;
import org.apache.hadoop.hive.llap.daemon.impl.TaskRunnerCallable;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;

public class FirstInFirstOutComparator
implements Comparator<TaskExecutorService.TaskWrapper> {
    @Override
    public int compare(TaskExecutorService.TaskWrapper t1, TaskExecutorService.TaskWrapper t2) {
        int knownPending2;
        TaskRunnerCallable o1 = t1.getTaskRunnerCallable();
        TaskRunnerCallable o2 = t2.getTaskRunnerCallable();
        boolean o1CanFinish = o1.canFinish();
        boolean o2CanFinish = o2.canFinish();
        if (o1CanFinish && !o2CanFinish) {
            return -1;
        }
        if (!o1CanFinish && o2CanFinish) {
            return 1;
        }
        LlapDaemonProtocolProtos.FragmentRuntimeInfo fri1 = o1.getFragmentRuntimeInfo();
        LlapDaemonProtocolProtos.FragmentRuntimeInfo fri2 = o2.getFragmentRuntimeInfo();
        if (fri1.getDagStartTime() < fri2.getDagStartTime()) {
            return -1;
        }
        if (fri1.getDagStartTime() > fri2.getDagStartTime()) {
            return 1;
        }
        if (o1.getQueryId().equals(o2.getQueryId())) {
            if (fri1.getWithinDagPriority() < fri2.getWithinDagPriority()) {
                return -1;
            }
            if (fri1.getWithinDagPriority() > fri2.getWithinDagPriority()) {
                return 1;
            }
        }
        if (fri1.getFirstAttemptStartTime() < fri2.getFirstAttemptStartTime()) {
            return -1;
        }
        if (fri1.getFirstAttemptStartTime() > fri2.getFirstAttemptStartTime()) {
            return 1;
        }
        int knownPending1 = fri1.getNumSelfAndUpstreamTasks() - fri1.getNumSelfAndUpstreamCompletedTasks();
        if (knownPending1 < (knownPending2 = fri2.getNumSelfAndUpstreamTasks() - fri2.getNumSelfAndUpstreamCompletedTasks())) {
            return -1;
        }
        if (knownPending1 > knownPending2) {
            return 1;
        }
        return 0;
    }
}

