/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.security;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.PrivilegedAction;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.llap.security.LlapTokenIdentifier;
import org.apache.hadoop.hive.llap.security.SigningSecretManager;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.security.token.delegation.ZKDelegationTokenSecretManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretManager
extends ZKDelegationTokenSecretManager<LlapTokenIdentifier>
implements SigningSecretManager {
    private static final Logger LOG = LoggerFactory.getLogger(SecretManager.class);
    private final String clusterId;

    public SecretManager(Configuration conf, String clusterId) {
        super(conf);
        this.clusterId = clusterId;
        this.checkForZKDTSMBug(conf);
    }

    private void checkForZKDTSMBug(Configuration conf) {
        long expectedRenewTimeSec = conf.getLong("delegation-token.renew-interval.sec", -1L);
        LOG.info("Checking for tokenRenewInterval bug: " + expectedRenewTimeSec);
        if (expectedRenewTimeSec == -1L) {
            return;
        }
        Field f = null;
        try {
            Class<AbstractDelegationTokenSecretManager> c = AbstractDelegationTokenSecretManager.class;
            f = c.getDeclaredField("tokenRenewInterval");
            f.setAccessible(true);
        }
        catch (Throwable t) {
            LOG.error("Failed to check for tokenRenewInterval bug, hoping for the best", t);
            return;
        }
        try {
            long realValue = f.getLong(this);
            long expectedValue = expectedRenewTimeSec * 1000L;
            LOG.info("tokenRenewInterval is: " + realValue + " (expected " + expectedValue + ")");
            if (realValue == expectedRenewTimeSec) {
                f.setLong(this, expectedValue);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to address tokenRenewInterval bug", ex);
        }
    }

    public LlapTokenIdentifier createIdentifier() {
        return new LlapTokenIdentifier();
    }

    public LlapTokenIdentifier decodeTokenIdentifier(Token<LlapTokenIdentifier> token) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(token.getIdentifier()));
        LlapTokenIdentifier id = new LlapTokenIdentifier();
        id.readFields(dis);
        dis.close();
        return id;
    }

    @Override
    public synchronized DelegationKey getCurrentKey() {
        return (DelegationKey)this.allKeys.get(this.getCurrentKeyId());
    }

    @Override
    public byte[] signWithKey(byte[] message, DelegationKey key) {
        return SecretManager.createPassword((byte[])message, (SecretKey)key.getKey());
    }

    @Override
    public byte[] signWithKey(byte[] message, int keyId) throws SecurityException {
        DelegationKey key = this.getDelegationKey(keyId);
        if (key == null) {
            throw new SecurityException("The key ID " + keyId + " was not found");
        }
        return SecretManager.createPassword((byte[])message, (SecretKey)key.getKey());
    }

    private static LlapZkConf createLlapZkConf(Configuration conf, String llapPrincipal, String llapKeytab, String clusterId) {
        String principal = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ZKSM_KERBEROS_PRINCIPAL, (String)llapPrincipal);
        String keyTab = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ZKSM_KERBEROS_KEYTAB_FILE, (String)llapKeytab);
        Configuration zkConf = new Configuration(conf);
        long tokenLifetime = HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DELEGATION_TOKEN_LIFETIME, (TimeUnit)TimeUnit.SECONDS);
        zkConf.setLong("delegation-token.max-lifetime.sec", tokenLifetime);
        zkConf.setLong("delegation-token.renew-interval.sec", tokenLifetime);
        zkConf.set("zk-dt-secret-manager.kerberos.principal", principal);
        zkConf.set("zk-dt-secret-manager.kerberos.keytab", keyTab);
        String zkPath = "zkdtsm_" + clusterId;
        LOG.info("Using {} as ZK secret manager path", (Object)zkPath);
        zkConf.set("zk-dt-secret-manager.znodeWorkingPath", zkPath);
        SecretManager.setZkConfIfNotSet(zkConf, "zk-dt-secret-manager.zkAuthType", "sasl");
        SecretManager.setZkConfIfNotSet(zkConf, "zk-dt-secret-manager.zkConnectionString", HiveConf.getVar((Configuration)zkConf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ZKSM_ZK_CONNECTION_STRING));
        UserGroupInformation zkUgi = null;
        try {
            zkUgi = LlapUtil.loginWithKerberos(principal, keyTab);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new LlapZkConf(zkConf, zkUgi);
    }

    public static SecretManager createSecretManager(Configuration conf, String clusterId) {
        String llapPrincipal = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_KERBEROS_PRINCIPAL);
        String llapKeytab = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_KERBEROS_KEYTAB_FILE);
        return SecretManager.createSecretManager(conf, llapPrincipal, llapKeytab, clusterId);
    }

    public static SecretManager createSecretManager(Configuration conf, String llapPrincipal, String llapKeytab, final String clusterId) {
        final LlapZkConf c = SecretManager.createLlapZkConf(conf, llapPrincipal, llapKeytab, clusterId);
        return (SecretManager)c.zkUgi.doAs((PrivilegedAction)new PrivilegedAction<SecretManager>(){

            @Override
            public SecretManager run() {
                SecretManager zkSecretManager = new SecretManager(c.zkConf, clusterId);
                try {
                    zkSecretManager.startThreads();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return zkSecretManager;
            }
        });
    }

    private static void setZkConfIfNotSet(Configuration zkConf, String name, String value) {
        if (zkConf.get(name) != null) {
            return;
        }
        zkConf.set(name, value);
    }

    public Token<LlapTokenIdentifier> createLlapToken(String appId, String user, boolean isSignatureRequired) throws IOException {
        Text realUser = null;
        Text renewer = null;
        if (user == null) {
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            user = ugi.getUserName();
            if (ugi.getRealUser() != null) {
                realUser = new Text(ugi.getRealUser().getUserName());
            }
            renewer = new Text(ugi.getShortUserName());
        } else {
            renewer = new Text(user);
        }
        LlapTokenIdentifier llapId = new LlapTokenIdentifier(new Text(user), renewer, realUser, this.clusterId, appId, isSignatureRequired);
        Token token = new Token((TokenIdentifier)llapId, (org.apache.hadoop.security.token.SecretManager)this);
        if (LOG.isInfoEnabled()) {
            LOG.info("Created LLAP token {}", (Object)token);
        }
        return token;
    }

    static final class LlapZkConf {
        public Configuration zkConf;
        public UserGroupInformation zkUgi;

        public LlapZkConf(Configuration zkConf, UserGroupInformation zkUgi) {
            this.zkConf = zkConf;
            this.zkUgi = zkUgi;
        }
    }
}

