/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.ColumnarSplit;
import org.apache.hadoop.hive.ql.io.LlapAwareSplit;
import org.apache.hadoop.hive.ql.io.SyntheticFileId;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.orc.OrcProto;
import org.apache.orc.impl.OrcTail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcSplit
extends FileSplit
implements ColumnarSplit,
LlapAwareSplit {
    private static final Logger LOG = LoggerFactory.getLogger(OrcSplit.class);
    private OrcTail orcTail;
    private boolean hasFooter;
    private boolean isOriginal;
    private boolean hasBase;
    private final List<AcidInputFormat.DeltaMetaData> deltas = new ArrayList<AcidInputFormat.DeltaMetaData>();
    private long projColsUncompressedSize;
    private transient Object fileKey;
    private long fileLen;
    static final int HAS_SYNTHETIC_FILEID_FLAG = 16;
    static final int HAS_LONG_FILEID_FLAG = 8;
    static final int BASE_FLAG = 4;
    static final int ORIGINAL_FLAG = 2;
    static final int FOOTER_FLAG = 1;

    protected OrcSplit() {
        super(null, 0L, 0L, (String[])null);
    }

    public OrcSplit(Path path, Object fileId, long offset, long length, String[] hosts, OrcTail orcTail, boolean isOriginal, boolean hasBase, List<AcidInputFormat.DeltaMetaData> deltas, long projectedDataSize, long fileLen) {
        super(path, offset, length, hosts);
        this.fileKey = fileId;
        this.orcTail = orcTail;
        this.hasFooter = this.orcTail != null;
        this.isOriginal = isOriginal;
        this.hasBase = hasBase;
        this.deltas.addAll(deltas);
        this.projColsUncompressedSize = projectedDataSize <= 0L ? length : projectedDataSize;
        this.fileLen = fileLen <= 0L ? Long.MAX_VALUE : fileLen;
    }

    public void write(DataOutput out) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        super.write((DataOutput)dos);
        int required = bos.size();
        this.writeAdditionalPayload(dos);
        int additional = bos.size() - required;
        out.write(bos.toByteArray());
        if (LOG.isTraceEnabled()) {
            LOG.trace("Writing additional {} bytes to OrcSplit as payload. Required {} bytes.", (Object)additional, (Object)required);
        }
    }

    private void writeAdditionalPayload(DataOutputStream out) throws IOException {
        boolean isFileIdLong = this.fileKey instanceof Long;
        boolean isFileIdWritable = this.fileKey instanceof Writable;
        int flags = (this.hasBase ? 4 : 0) | (this.isOriginal ? 2 : 0) | (this.hasFooter ? 1 : 0) | (isFileIdLong ? 8 : 0) | (isFileIdWritable ? 16 : 0);
        out.writeByte(flags);
        out.writeInt(this.deltas.size());
        for (AcidInputFormat.DeltaMetaData delta : this.deltas) {
            delta.write(out);
        }
        if (this.hasFooter) {
            OrcProto.FileTail fileTail = this.orcTail.getMinimalFileTail();
            byte[] tailBuffer = fileTail.toByteArray();
            int tailLen = tailBuffer.length;
            WritableUtils.writeVInt((DataOutput)out, (int)tailLen);
            out.write(tailBuffer);
        }
        if (isFileIdLong) {
            out.writeLong((Long)this.fileKey);
        } else if (isFileIdWritable) {
            ((Writable)this.fileKey).write((DataOutput)out);
        }
        out.writeLong(this.fileLen);
    }

    public void readFields(DataInput in) throws IOException {
        boolean hasWritableFileId;
        super.readFields(in);
        byte flags = in.readByte();
        this.hasFooter = (1 & flags) != 0;
        this.isOriginal = (2 & flags) != 0;
        this.hasBase = (4 & flags) != 0;
        boolean hasLongFileId = (8 & flags) != 0;
        boolean bl = hasWritableFileId = (0x10 & flags) != 0;
        if (hasLongFileId && hasWritableFileId) {
            throw new IOException("Invalid split - both file ID types present");
        }
        this.deltas.clear();
        int numDeltas = in.readInt();
        for (int i = 0; i < numDeltas; ++i) {
            AcidInputFormat.DeltaMetaData dmd = new AcidInputFormat.DeltaMetaData();
            dmd.readFields(in);
            this.deltas.add(dmd);
        }
        if (this.hasFooter) {
            int tailLen = WritableUtils.readVInt((DataInput)in);
            byte[] tailBuffer = new byte[tailLen];
            in.readFully(tailBuffer);
            OrcProto.FileTail fileTail = OrcProto.FileTail.parseFrom(tailBuffer);
            this.orcTail = new OrcTail(fileTail, null);
        }
        if (hasLongFileId) {
            this.fileKey = in.readLong();
        } else if (hasWritableFileId) {
            SyntheticFileId fileId = new SyntheticFileId();
            fileId.readFields(in);
            this.fileKey = fileId;
        }
        this.fileLen = in.readLong();
    }

    public OrcTail getOrcTail() {
        return this.orcTail;
    }

    public boolean hasFooter() {
        return this.hasFooter;
    }

    public boolean isOriginal() {
        return this.isOriginal;
    }

    public boolean hasBase() {
        return this.hasBase;
    }

    public List<AcidInputFormat.DeltaMetaData> getDeltas() {
        return this.deltas;
    }

    public long getFileLength() {
        return this.fileLen;
    }

    public boolean isAcid() {
        return this.hasBase || this.deltas.size() > 0;
    }

    public long getProjectedColumnsUncompressedSize() {
        return this.projColsUncompressedSize;
    }

    public Object getFileKey() {
        return this.fileKey;
    }

    @Override
    public long getColumnarProjectionSize() {
        return this.projColsUncompressedSize;
    }

    @Override
    public boolean canUseLlapIo() {
        return this.isOriginal && (this.deltas == null || this.deltas.isEmpty());
    }

    public String toString() {
        return "OrcSplit [" + this.getPath() + ", start=" + this.getStart() + ", length=" + this.getLength() + ", isOriginal=" + this.isOriginal + ", fileLength=" + this.fileLen + ", hasFooter=" + this.hasFooter + ", hasBase=" + this.hasBase + ", deltas=" + this.deltas + "]";
    }
}

