/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.counter;

import java.io.Serializable;
import org.apache.spark.Accumulator;
import org.apache.spark.AccumulatorParam;
import org.apache.spark.api.java.JavaSparkContext;

public class SparkCounter
implements Serializable {
    private String name;
    private String displayName;
    private Accumulator<Long> accumulator;
    private long accumValue;

    public SparkCounter() {
    }

    private SparkCounter(String name, String displayName, long value) {
        this.name = name;
        this.displayName = displayName;
        this.accumValue = value;
    }

    public SparkCounter(String name, String displayName, String groupName, long initValue, JavaSparkContext sparkContext) {
        this.name = name;
        this.displayName = displayName;
        LongAccumulatorParam longParam = new LongAccumulatorParam();
        String accumulatorName = groupName + "_" + name;
        this.accumulator = sparkContext.accumulator((Object)initValue, accumulatorName, (AccumulatorParam)longParam);
    }

    public long getValue() {
        if (this.accumulator != null) {
            return (Long)this.accumulator.value();
        }
        return this.accumValue;
    }

    public void increment(long incr) {
        this.accumulator.add((Object)incr);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    SparkCounter snapshot() {
        return new SparkCounter(this.name, this.displayName, (Long)this.accumulator.value());
    }

    class LongAccumulatorParam
    implements AccumulatorParam<Long> {
        LongAccumulatorParam() {
        }

        public Long addAccumulator(Long t1, Long t2) {
            return t1 + t2;
        }

        public Long addInPlace(Long r1, Long r2) {
            return r1 + r2;
        }

        public Long zero(Long initialValue) {
            return 0L;
        }
    }
}

