/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.ListSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ListSinkDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

@Explain(displayName="Fetch Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class FetchWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Path tblDir;
    private TableDesc tblDesc;
    private ArrayList<Path> partDir;
    private ArrayList<PartitionDesc> partDesc;
    private Operator<?> source;
    private ListSinkOperator sink;
    private int limit;
    private int leastNumRows;
    private SplitSample splitSample;
    private transient List<List<Object>> rowsComputedFromStats;
    private transient StructObjectInspector statRowOI;
    private String serializationNullFormat = "NULL";
    private boolean isHiveServerQuery;
    private boolean isUsingThriftJDBCBinarySerDe = false;

    public boolean isHiveServerQuery() {
        return this.isHiveServerQuery;
    }

    public void setHiveServerQuery(boolean isHiveServerQuery) {
        this.isHiveServerQuery = isHiveServerQuery;
    }

    public boolean isUsingThriftJDBCBinarySerDe() {
        return this.isUsingThriftJDBCBinarySerDe;
    }

    public void setIsUsingThriftJDBCBinarySerDe(boolean isUsingThriftJDBCBinarySerDe) {
        this.isUsingThriftJDBCBinarySerDe = isUsingThriftJDBCBinarySerDe;
    }

    public FetchWork() {
    }

    public FetchWork(List<List<Object>> rowsComputedFromStats, StructObjectInspector statRowOI) {
        this.rowsComputedFromStats = rowsComputedFromStats;
        this.statRowOI = statRowOI;
    }

    public StructObjectInspector getStatRowOI() {
        return this.statRowOI;
    }

    public List<List<Object>> getRowsComputedUsingStats() {
        return this.rowsComputedFromStats;
    }

    public FetchWork(Path tblDir, TableDesc tblDesc) {
        this(tblDir, tblDesc, -1);
    }

    public FetchWork(Path tblDir, TableDesc tblDesc, int limit) {
        this.tblDir = tblDir;
        this.tblDesc = tblDesc;
        this.limit = limit;
    }

    public FetchWork(List<Path> partDir, List<PartitionDesc> partDesc, TableDesc tblDesc) {
        this(partDir, partDesc, tblDesc, -1);
    }

    public FetchWork(List<Path> partDir, List<PartitionDesc> partDesc, TableDesc tblDesc, int limit) {
        this.tblDesc = tblDesc;
        this.partDir = new ArrayList<Path>(partDir);
        this.partDesc = new ArrayList<PartitionDesc>(partDesc);
        this.limit = limit;
    }

    public void initializeForFetch(CompilationOpContext ctx) {
        if (this.source == null) {
            ListSinkDesc desc = new ListSinkDesc(this.serializationNullFormat);
            this.source = this.sink = (ListSinkOperator)OperatorFactory.get(ctx, desc);
        }
    }

    public String getSerializationNullFormat() {
        return this.serializationNullFormat;
    }

    public void setSerializationNullFormat(String format) {
        this.serializationNullFormat = format;
    }

    public boolean isNotPartitioned() {
        return this.tblDir != null;
    }

    public boolean isPartitioned() {
        return this.tblDir == null;
    }

    public Path getTblDir() {
        return this.tblDir;
    }

    public void setTblDir(Path tblDir) {
        this.tblDir = tblDir;
    }

    public TableDesc getTblDesc() {
        return this.tblDesc;
    }

    public void setTblDesc(TableDesc tblDesc) {
        this.tblDesc = tblDesc;
    }

    public ArrayList<Path> getPartDir() {
        return this.partDir;
    }

    public void setPartDir(ArrayList<Path> partDir) {
        this.partDir = partDir;
    }

    public ArrayList<PartitionDesc> getPartDesc() {
        return this.partDesc;
    }

    public List<Path> getPathLists() {
        return this.isPartitioned() ? (this.partDir == null ? null : new ArrayList<Path>(this.partDir)) : Arrays.asList(this.tblDir);
    }

    @Explain(displayName="Partition Description", explainLevels={Explain.Level.EXTENDED})
    public ArrayList<PartitionDesc> getPartDescOrderedByPartDir() {
        ArrayList<PartitionDesc> partDescOrdered = this.partDesc;
        if (this.partDir != null && this.partDir.size() > 1) {
            if (this.partDesc == null || this.partDir.size() != this.partDesc.size()) {
                throw new RuntimeException("Partiton Directory list size doesn't match Partition Descriptor list size");
            }
            TreeMap<Path, PartitionDesc> partDirToPartSpecMap = new TreeMap<Path, PartitionDesc>();
            for (int i = 0; i < this.partDir.size(); ++i) {
                partDirToPartSpecMap.put(this.partDir.get(i), this.partDesc.get(i));
            }
            partDescOrdered = new ArrayList(partDirToPartSpecMap.values());
        }
        return partDescOrdered;
    }

    public List<PartitionDesc> getPartDescs(List<Path> paths) {
        ArrayList<PartitionDesc> parts = new ArrayList<PartitionDesc>(paths.size());
        for (Path path : paths) {
            parts.add(this.partDesc.get(this.partDir.indexOf(path.getParent())));
        }
        return parts;
    }

    public void setPartDesc(ArrayList<PartitionDesc> partDesc) {
        this.partDesc = partDesc;
    }

    @Explain(displayName="limit", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLeastNumRows() {
        return this.leastNumRows;
    }

    public void setLeastNumRows(int leastNumRows) {
        this.leastNumRows = leastNumRows;
    }

    @Explain(displayName="Processor Tree", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Operator<?> getSource() {
        return this.source;
    }

    public void setSource(Operator<?> source) {
        this.source = source;
    }

    public ListSinkOperator getSink() {
        return this.sink;
    }

    public void setSink(ListSinkOperator sink) {
        this.sink = sink;
    }

    public void setSplitSample(SplitSample splitSample) {
        this.splitSample = splitSample;
    }

    public SplitSample getSplitSample() {
        return this.splitSample;
    }

    public String toString() {
        if (this.tblDir != null) {
            return new String("table = " + this.tblDir);
        }
        if (this.partDir == null) {
            return "null fetchwork";
        }
        String ret = "partition = ";
        for (Path part : this.partDir) {
            ret = ret.concat(part.toUri().toString());
        }
        return ret;
    }
}

