/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.WindowFunctionInfo;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;

public class WindowingSpec {
    private HashMap<String, WindowExpressionSpec> aliasToWdwExpr = new HashMap();
    private HashMap<String, WindowSpec> windowSpecs = new HashMap();
    private ArrayList<WindowExpressionSpec> windowExpressions = new ArrayList();

    public void addWindowSpec(String name, WindowSpec wdwSpec) {
        this.windowSpecs.put(name, wdwSpec);
    }

    public void addWindowFunction(WindowFunctionSpec wFn) {
        this.windowExpressions.add(wFn);
        this.aliasToWdwExpr.put(wFn.getAlias(), wFn);
    }

    public HashMap<String, WindowExpressionSpec> getAliasToWdwExpr() {
        return this.aliasToWdwExpr;
    }

    public HashMap<String, WindowSpec> getWindowSpecs() {
        return this.windowSpecs;
    }

    public ArrayList<WindowExpressionSpec> getWindowExpressions() {
        return this.windowExpressions;
    }

    public PTFInvocationSpec.PartitioningSpec getQueryPartitioningSpec() {
        WindowFunctionSpec wFn = (WindowFunctionSpec)this.getWindowExpressions().get(0);
        return wFn.getWindowSpec().getPartitioning();
    }

    public PTFInvocationSpec.PartitionSpec getQueryPartitionSpec() {
        return this.getQueryPartitioningSpec().getPartSpec();
    }

    public PTFInvocationSpec.OrderSpec getQueryOrderSpec() {
        return this.getQueryPartitioningSpec().getOrderSpec();
    }

    public void validateAndMakeEffective() throws SemanticException {
        for (WindowExpressionSpec expr : this.getWindowExpressions()) {
            WindowFunctionSpec wFn = (WindowFunctionSpec)expr;
            WindowSpec wdwSpec = wFn.getWindowSpec();
            this.precheckSyntax(wFn, wdwSpec);
            if (wdwSpec != null) {
                ArrayList<String> sources = new ArrayList<String>();
                this.fillInWindowSpec(wdwSpec.getSourceId(), wdwSpec, sources);
            }
            if (wdwSpec == null) {
                wdwSpec = new WindowSpec();
                wFn.setWindowSpec(wdwSpec);
            }
            this.applyConstantPartition(wdwSpec);
            this.effectiveWindowFrame(wFn, wdwSpec);
            this.validateWindowFrame(wdwSpec);
            this.setAndValidateOrderSpec(wFn, wdwSpec);
        }
    }

    private void precheckSyntax(WindowFunctionSpec wFn, WindowSpec wdwSpec) throws SemanticException {
        if (wdwSpec != null && wFn.isDistinct && (wdwSpec.windowFrame != null || wdwSpec.getOrder() != null)) {
            throw new SemanticException("Function with DISTINCT cannot work with partition ORDER BY or windowing clause.");
        }
    }

    private void fillInWindowSpec(String sourceId, WindowSpec dest, ArrayList<String> visited) throws SemanticException {
        if (sourceId != null) {
            if (visited.contains(sourceId)) {
                visited.add(sourceId);
                throw new SemanticException(String.format("Cycle in Window references %s", visited));
            }
            WindowSpec source = this.getWindowSpecs().get(sourceId);
            if (source == null || source.equals(dest)) {
                throw new SemanticException(String.format("%s refers to an unknown source", dest));
            }
            if (dest.getPartition() == null) {
                dest.setPartition(source.getPartition());
            }
            if (dest.getOrder() == null) {
                dest.setOrder(source.getOrder());
            }
            if (dest.getWindowFrame() == null) {
                dest.setWindowFrame(source.getWindowFrame());
            }
            visited.add(sourceId);
            this.fillInWindowSpec(source.getSourceId(), dest, visited);
        }
    }

    private void applyConstantPartition(WindowSpec wdwSpec) {
        PTFInvocationSpec.PartitionSpec partSpec = wdwSpec.getPartition();
        if (partSpec == null) {
            partSpec = new PTFInvocationSpec.PartitionSpec();
            PTFInvocationSpec.PartitionExpression partExpr = new PTFInvocationSpec.PartitionExpression();
            partExpr.setExpression(new ASTNode((Token)new CommonToken(321, "0")));
            partSpec.addExpression(partExpr);
            wdwSpec.setPartition(partSpec);
        }
    }

    private void effectiveWindowFrame(WindowFunctionSpec wFn, WindowSpec wdwSpec) throws SemanticException {
        WindowFunctionInfo wFnInfo = FunctionRegistry.getWindowFunctionInfo(wFn.getName());
        boolean supportsWindowing = wFnInfo == null ? true : wFnInfo.isSupportsWindow();
        WindowFrameSpec wFrame = wdwSpec.getWindowFrame();
        PTFInvocationSpec.OrderSpec orderSpec = wdwSpec.getOrder();
        if (wFrame == null) {
            wFrame = !supportsWindowing ? (wFn.getName().toLowerCase().equals("last_value") && orderSpec != null ? new WindowFrameSpec(new CurrentRowSpec(), new RangeBoundarySpec(Direction.FOLLOWING, 0)) : new WindowFrameSpec(new RangeBoundarySpec(Direction.PRECEDING, BoundarySpec.UNBOUNDED_AMOUNT), new RangeBoundarySpec(Direction.FOLLOWING, BoundarySpec.UNBOUNDED_AMOUNT))) : (orderSpec == null ? new WindowFrameSpec(new RangeBoundarySpec(Direction.PRECEDING, BoundarySpec.UNBOUNDED_AMOUNT), new RangeBoundarySpec(Direction.FOLLOWING, BoundarySpec.UNBOUNDED_AMOUNT)) : new WindowFrameSpec(new ValueBoundarySpec(Direction.PRECEDING, BoundarySpec.UNBOUNDED_AMOUNT), new CurrentRowSpec()));
            wdwSpec.setWindowFrame(wFrame);
        } else if (wFrame.getEnd() == null) {
            wFrame.setEnd(new CurrentRowSpec());
        }
    }

    private void validateWindowFrame(WindowSpec wdwSpec) throws SemanticException {
        WindowFrameSpec wFrame = wdwSpec.getWindowFrame();
        BoundarySpec start = wFrame.getStart();
        BoundarySpec end = wFrame.getEnd();
        if (start.getDirection() == Direction.FOLLOWING && start.getAmt() == BoundarySpec.UNBOUNDED_AMOUNT) {
            throw new SemanticException("Start of a WindowFrame cannot be UNBOUNDED FOLLOWING");
        }
        if (end.getDirection() == Direction.PRECEDING && end.getAmt() == BoundarySpec.UNBOUNDED_AMOUNT) {
            throw new SemanticException("End of a WindowFrame cannot be UNBOUNDED PRECEDING");
        }
    }

    private void setAndValidateOrderSpec(WindowFunctionSpec wFn, WindowSpec wdwSpec) throws SemanticException {
        wdwSpec.ensureOrderSpec(wFn);
        WindowFrameSpec wFrame = wdwSpec.getWindowFrame();
        PTFInvocationSpec.OrderSpec order = wdwSpec.getOrder();
        BoundarySpec start = wFrame.getStart();
        BoundarySpec end = wFrame.getEnd();
        if (start instanceof ValueBoundarySpec || end instanceof ValueBoundarySpec) {
            boolean multiOrderAllowed;
            if (order == null || order.getExpressions().size() == 0) {
                throw new SemanticException("Range based Window Frame needs to specify ORDER BY clause");
            }
            boolean defaultPreceding = start.getDirection() == Direction.PRECEDING && start.getAmt() == BoundarySpec.UNBOUNDED_AMOUNT && end.getDirection() == Direction.CURRENT;
            boolean defaultFollowing = start.getDirection() == Direction.CURRENT && end.getDirection() == Direction.FOLLOWING && end.getAmt() == BoundarySpec.UNBOUNDED_AMOUNT;
            boolean defaultPrecedingFollowing = start.getDirection() == Direction.PRECEDING && start.getAmt() == BoundarySpec.UNBOUNDED_AMOUNT && end.getDirection() == Direction.FOLLOWING && end.getAmt() == BoundarySpec.UNBOUNDED_AMOUNT;
            boolean bl = multiOrderAllowed = defaultPreceding || defaultFollowing || defaultPrecedingFollowing;
            if (order.getExpressions().size() != 1 && !multiOrderAllowed) {
                throw new SemanticException("Range value based Window Frame can have only 1 Sort Key");
            }
            if (start instanceof ValueBoundarySpec) {
                ((ValueBoundarySpec)start).setOrderExpressions(order.getExpressions());
            }
            if (end instanceof ValueBoundarySpec) {
                ((ValueBoundarySpec)end).setOrderExpressions(order.getExpressions());
            }
        }
    }

    public static class ValueBoundarySpec
    extends BoundarySpec {
        Direction direction;
        int amt;
        List<PTFInvocationSpec.OrderExpression> orderExpressions;

        public ValueBoundarySpec() {
        }

        public ValueBoundarySpec(Direction direction, int amt) {
            this.direction = direction;
            this.amt = amt;
        }

        @Override
        public Direction getDirection() {
            return this.direction;
        }

        @Override
        public void setDirection(Direction direction) {
            this.direction = direction;
        }

        public List<PTFInvocationSpec.OrderExpression> getOrderExpressions() {
            return this.orderExpressions;
        }

        public void setOrderExpressions(List<PTFInvocationSpec.OrderExpression> orderExpressions) {
            this.orderExpressions = orderExpressions;
        }

        @Override
        public int getAmt() {
            return this.amt;
        }

        @Override
        public void setAmt(int amt) {
            this.amt = amt;
        }

        public String toString() {
            StringBuilder exprs = new StringBuilder();
            if (this.orderExpressions != null) {
                for (int i = 0; i < this.orderExpressions.size(); ++i) {
                    exprs.append(i == 0 ? this.orderExpressions.get(i).getExpression().toStringTree() : ", " + this.orderExpressions.get(i).getExpression().toStringTree());
                }
            } else {
                exprs.append("No order expression");
            }
            return String.format("value(%s %s %s)", new Object[]{exprs.toString(), this.amt, this.direction});
        }

        @Override
        public int compareTo(BoundarySpec other) {
            int c = this.direction.compareTo(other.getDirection());
            if (c != 0) {
                return c;
            }
            ValueBoundarySpec vb = (ValueBoundarySpec)other;
            return this.direction == Direction.PRECEDING ? vb.amt - this.amt : this.amt - vb.amt;
        }
    }

    public static class CurrentRowSpec
    extends BoundarySpec {
        public String toString() {
            return "currentRow";
        }

        @Override
        public Direction getDirection() {
            return Direction.CURRENT;
        }

        @Override
        public void setDirection(Direction dir) {
        }

        @Override
        public void setAmt(int amt) {
        }

        @Override
        public int compareTo(BoundarySpec other) {
            return this.getDirection().compareTo(other.getDirection());
        }

        @Override
        public int getAmt() {
            return 0;
        }
    }

    public static class RangeBoundarySpec
    extends BoundarySpec {
        Direction direction;
        int amt;

        public RangeBoundarySpec() {
        }

        public RangeBoundarySpec(Direction direction, int amt) {
            this.direction = direction;
            this.amt = amt;
        }

        @Override
        public Direction getDirection() {
            return this.direction;
        }

        @Override
        public void setDirection(Direction direction) {
            this.direction = direction;
        }

        @Override
        public int getAmt() {
            return this.amt;
        }

        @Override
        public void setAmt(int amt) {
            this.amt = amt;
        }

        public String toString() {
            return String.format("range(%s %s)", new Object[]{this.amt == UNBOUNDED_AMOUNT ? "Unbounded" : Integer.valueOf(this.amt), this.direction});
        }

        @Override
        public int compareTo(BoundarySpec other) {
            int c = this.direction.compareTo(other.getDirection());
            if (c != 0) {
                return c;
            }
            RangeBoundarySpec rb = (RangeBoundarySpec)other;
            return this.direction == Direction.PRECEDING ? rb.amt - this.amt : this.amt - rb.amt;
        }
    }

    public static abstract class BoundarySpec
    implements Comparable<BoundarySpec> {
        public static int UNBOUNDED_AMOUNT = Integer.MAX_VALUE;

        public abstract Direction getDirection();

        public abstract void setDirection(Direction var1);

        public abstract void setAmt(int var1);

        public abstract int getAmt();
    }

    public static enum Direction {
        PRECEDING,
        CURRENT,
        FOLLOWING;

    }

    public static class WindowFrameSpec {
        BoundarySpec start;
        BoundarySpec end;

        public WindowFrameSpec() {
        }

        public WindowFrameSpec(BoundarySpec start, BoundarySpec end) {
            this.start = start;
            this.end = end;
        }

        public WindowFrameSpec(BoundarySpec start) {
            this(start, null);
        }

        public BoundarySpec getStart() {
            return this.start;
        }

        public void setStart(BoundarySpec start) {
            this.start = start;
        }

        public BoundarySpec getEnd() {
            return this.end;
        }

        public void setEnd(BoundarySpec end) {
            this.end = end;
        }

        public String toString() {
            return String.format("window(start=%s, end=%s)", this.start, this.end);
        }
    }

    public static class WindowSpec {
        private String sourceId;
        private PTFInvocationSpec.PartitioningSpec partitioning;
        private WindowFrameSpec windowFrame;

        public String getSourceId() {
            return this.sourceId;
        }

        public void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        public PTFInvocationSpec.PartitioningSpec getPartitioning() {
            return this.partitioning;
        }

        public void setPartitioning(PTFInvocationSpec.PartitioningSpec partitioning) {
            this.partitioning = partitioning;
        }

        public WindowFrameSpec getWindowFrame() {
            return this.windowFrame;
        }

        public void setWindowFrame(WindowFrameSpec windowFrame) {
            this.windowFrame = windowFrame;
        }

        public PTFInvocationSpec.PartitionSpec getPartition() {
            return this.getPartitioning() == null ? null : this.getPartitioning().getPartSpec();
        }

        public void setPartition(PTFInvocationSpec.PartitionSpec partSpec) {
            this.partitioning = this.partitioning == null ? new PTFInvocationSpec.PartitioningSpec() : this.partitioning;
            this.partitioning.setPartSpec(partSpec);
        }

        public PTFInvocationSpec.OrderSpec getOrder() {
            return this.getPartitioning() == null ? null : this.getPartitioning().getOrderSpec();
        }

        public void setOrder(PTFInvocationSpec.OrderSpec orderSpec) {
            this.partitioning = this.partitioning == null ? new PTFInvocationSpec.PartitioningSpec() : this.partitioning;
            this.partitioning.setOrderSpec(orderSpec);
        }

        protected void ensureOrderSpec(WindowFunctionSpec wFn) throws SemanticException {
            if (this.getOrder() == null) {
                PTFInvocationSpec.OrderSpec order = new PTFInvocationSpec.OrderSpec();
                order.prefixBy(this.getPartition());
                if (wFn.isDistinct) {
                    order.addExpressions(wFn.getArgs());
                }
                this.setOrder(order);
            }
        }

        public String toString() {
            return String.format("Window Spec=[%s%s%s]", this.sourceId == null ? "" : "Name='" + this.sourceId + "'", this.partitioning == null ? "" : this.partitioning, this.windowFrame == null ? "" : this.windowFrame);
        }
    }

    public static class WindowFunctionSpec
    extends WindowExpressionSpec {
        String name;
        boolean isStar;
        boolean isDistinct;
        ArrayList<ASTNode> args;
        WindowSpec windowSpec;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isStar() {
            return this.isStar;
        }

        public void setStar(boolean isStar) {
            this.isStar = isStar;
        }

        public boolean isDistinct() {
            return this.isDistinct;
        }

        public void setDistinct(boolean isDistinct) {
            this.isDistinct = isDistinct;
        }

        public ArrayList<ASTNode> getArgs() {
            this.args = this.args == null ? new ArrayList<ASTNode>() : this.args;
            return this.args;
        }

        public void setArgs(ArrayList<ASTNode> args) {
            this.args = args;
        }

        public void addArg(ASTNode arg) {
            this.args = this.args == null ? new ArrayList<ASTNode>() : this.args;
            this.args.add(arg);
        }

        public WindowSpec getWindowSpec() {
            return this.windowSpec;
        }

        public void setWindowSpec(WindowSpec windowSpec) {
            this.windowSpec = windowSpec;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.name).append("(");
            if (this.isStar) {
                buf.append("*");
            } else {
                if (this.isDistinct) {
                    buf.append("distinct ");
                }
                if (this.args != null) {
                    boolean first = true;
                    for (ASTNode arg : this.args) {
                        if (first) {
                            first = false;
                        } else {
                            buf.append(", ");
                        }
                        buf.append(arg.toStringTree());
                    }
                }
            }
            buf.append(")");
            if (this.windowSpec != null) {
                buf.append(" ").append(this.windowSpec.toString());
            }
            if (this.alias != null) {
                buf.append(" as ").append(this.alias);
            }
            return buf.toString();
        }
    }

    public static class WindowExpressionSpec {
        String alias;
        ASTNode expression;

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public ASTNode getExpression() {
            return this.expression;
        }

        public void setExpression(ASTNode expression) {
            this.expression = expression;
        }
    }
}

