/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.RecordUpdater;
import org.apache.hadoop.hive.ql.io.StatsProvidingRecordWriter;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcRecordUpdater;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Writer;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.orc.CompressionKind;
import org.apache.orc.TypeDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcOutputFormat
extends FileOutputFormat<NullWritable, OrcSerde.OrcSerdeRow>
implements AcidOutputFormat<NullWritable, OrcSerde.OrcSerdeRow> {
    private static final Logger LOG = LoggerFactory.getLogger(OrcOutputFormat.class);

    private OrcFile.WriterOptions getOptions(JobConf conf, Properties props) {
        OrcFile.WriterOptions result = OrcFile.writerOptions(props, (Configuration)conf);
        if (props != null) {
            String columnNameProperty = props.getProperty("columns");
            String columnTypeProperty = props.getProperty("columns.types");
            if (columnNameProperty != null && !columnNameProperty.isEmpty() && columnTypeProperty != null && !columnTypeProperty.isEmpty()) {
                List<Object> columnNames = columnNameProperty.length() == 0 ? new ArrayList() : Arrays.asList(columnNameProperty.split(","));
                ArrayList<TypeInfo> columnTypes = columnTypeProperty.length() == 0 ? new ArrayList() : TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
                TypeDescription schema = TypeDescription.createStruct();
                for (int i = 0; i < columnNames.size(); ++i) {
                    schema.addField((String)columnNames.get(i), OrcInputFormat.convertTypeInfo((TypeInfo)columnTypes.get(i)));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ORC schema = " + schema);
                }
                result.setSchema(schema);
            }
        }
        return result;
    }

    public RecordWriter<NullWritable, OrcSerde.OrcSerdeRow> getRecordWriter(FileSystem fileSystem, JobConf conf, String name, Progressable reporter) throws IOException {
        return new OrcRecordWriter(new Path(name), this.getOptions(conf, null));
    }

    @Override
    public StatsProvidingRecordWriter getHiveRecordWriter(JobConf conf, Path path, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable reporter) throws IOException {
        return new OrcRecordWriter(path, this.getOptions(conf, tableProperties));
    }

    @Override
    public RecordUpdater getRecordUpdater(Path path, AcidOutputFormat.Options options) throws IOException {
        if (options.getDummyStream() != null) {
            return new DummyOrcRecordUpdater(path, options);
        }
        return new OrcRecordUpdater(path, options);
    }

    @Override
    public FileSinkOperator.RecordWriter getRawRecordWriter(Path path, AcidOutputFormat.Options options) throws IOException {
        Path filename = AcidUtils.createFilename(path, options);
        OrcFile.WriterOptions opts = OrcFile.writerOptions(options.getConfiguration());
        if (!options.isWritingBase()) {
            opts.bufferSize(16384).stripeSize(0x1000000L).blockPadding(false).compress(CompressionKind.NONE).rowIndexStride(0);
        }
        final OrcRecordUpdater.KeyIndexBuilder watcher = new OrcRecordUpdater.KeyIndexBuilder();
        opts.inspector(options.getInspector()).callback(watcher);
        final Writer writer = OrcFile.createWriter(filename, opts);
        return new FileSinkOperator.RecordWriter(){

            @Override
            public void write(Writable w) throws IOException {
                OrcStruct orc = (OrcStruct)w;
                watcher.addKey(((IntWritable)orc.getFieldValue(0)).get(), ((LongWritable)orc.getFieldValue(1)).get(), ((IntWritable)orc.getFieldValue(2)).get(), ((LongWritable)orc.getFieldValue(3)).get());
                writer.addRow(w);
            }

            @Override
            public void close(boolean abort) throws IOException {
                writer.close();
            }
        };
    }

    private class DummyOrcRecordUpdater
    implements RecordUpdater {
        private final Path path;
        private final ObjectInspector inspector;
        private final PrintStream out;

        private DummyOrcRecordUpdater(Path path, AcidOutputFormat.Options options) {
            this.path = path;
            this.inspector = options.getInspector();
            this.out = options.getDummyStream();
        }

        @Override
        public void insert(long currentTransaction, Object row) throws IOException {
            this.out.println("insert " + this.path + " currTxn: " + currentTransaction + " obj: " + this.stringifyObject(row, this.inspector));
        }

        @Override
        public void update(long currentTransaction, Object row) throws IOException {
            this.out.println("update " + this.path + " currTxn: " + currentTransaction + " obj: " + this.stringifyObject(row, this.inspector));
        }

        @Override
        public void delete(long currentTransaction, Object row) throws IOException {
            this.out.println("delete " + this.path + " currTxn: " + currentTransaction + " obj: " + row);
        }

        @Override
        public void flush() throws IOException {
            this.out.println("flush " + this.path);
        }

        @Override
        public void close(boolean abort) throws IOException {
            this.out.println("close " + this.path);
        }

        @Override
        public SerDeStats getStats() {
            return null;
        }

        private void stringifyObject(StringBuilder buffer, Object obj, ObjectInspector inspector) throws IOException {
            if (inspector instanceof StructObjectInspector) {
                buffer.append("{ ");
                StructObjectInspector soi = (StructObjectInspector)inspector;
                boolean isFirst = true;
                for (StructField structField : soi.getAllStructFieldRefs()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        buffer.append(", ");
                    }
                    buffer.append(structField.getFieldName());
                    buffer.append(": ");
                    this.stringifyObject(buffer, soi.getStructFieldData(obj, structField), structField.getFieldObjectInspector());
                }
                buffer.append(" }");
            } else if (inspector instanceof PrimitiveObjectInspector) {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)inspector;
                buffer.append(poi.getPrimitiveJavaObject(obj).toString());
            } else {
                buffer.append("*unknown*");
            }
        }

        private String stringifyObject(Object obj, ObjectInspector inspector) throws IOException {
            StringBuilder buffer = new StringBuilder();
            this.stringifyObject(buffer, obj, inspector);
            return buffer.toString();
        }
    }

    private static class OrcRecordWriter
    implements RecordWriter<NullWritable, OrcSerde.OrcSerdeRow>,
    StatsProvidingRecordWriter {
        private Writer writer = null;
        private final Path path;
        private final OrcFile.WriterOptions options;
        private final SerDeStats stats;

        OrcRecordWriter(Path path, OrcFile.WriterOptions options) {
            this.path = path;
            this.options = options;
            this.stats = new SerDeStats();
        }

        public void write(NullWritable nullWritable, OrcSerde.OrcSerdeRow row) throws IOException {
            if (this.writer == null) {
                this.options.inspector(row.getInspector());
                this.writer = OrcFile.createWriter(this.path, this.options);
            }
            this.writer.addRow(row.getRow());
        }

        @Override
        public void write(Writable row) throws IOException {
            OrcSerde.OrcSerdeRow serdeRow = (OrcSerde.OrcSerdeRow)row;
            if (this.writer == null) {
                this.options.inspector(serdeRow.getInspector());
                this.writer = OrcFile.createWriter(this.path, this.options);
            }
            this.writer.addRow(serdeRow.getRow());
        }

        public void close(Reporter reporter) throws IOException {
            this.close(true);
        }

        @Override
        public void close(boolean b) throws IOException {
            if (this.writer == null) {
                FileSystem fs = this.options.getFileSystem() == null ? this.path.getFileSystem(this.options.getConfiguration()) : this.options.getFileSystem();
                fs.createNewFile(this.path);
                return;
            }
            this.writer.close();
        }

        @Override
        public SerDeStats getStats() {
            this.stats.setRawDataSize(null == this.writer ? 0L : this.writer.getRawDataSize());
            this.stats.setRowCount(null == this.writer ? 0L : this.writer.getNumberOfRows());
            return this.stats;
        }
    }
}

