/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.index;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.LineRecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveIndexResult {
    public static final Logger l4j = LoggerFactory.getLogger((String)HiveIndexResult.class.getSimpleName());
    JobConf job = null;
    BytesRefWritable[] bytesRef = new BytesRefWritable[2];
    boolean ignoreHdfsLoc = false;
    Map<String, IBucket> buckets = new HashMap<String, IBucket>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HiveIndexResult(List<String> indexFiles, JobConf conf) throws IOException, HiveException {
        this.job = conf;
        this.bytesRef[0] = new BytesRefWritable();
        this.bytesRef[1] = new BytesRefWritable();
        this.ignoreHdfsLoc = HiveConf.getBoolVar((Configuration)conf, HiveConf.ConfVars.HIVE_INDEX_IGNORE_HDFS_LOC);
        if (indexFiles != null && indexFiles.size() > 0) {
            ArrayList<Path> paths = new ArrayList<Path>();
            for (String indexFile : indexFiles) {
                Path indexFilePath = new Path(indexFile);
                FileSystem fs = indexFilePath.getFileSystem((Configuration)conf);
                FileStatus indexStat = fs.getFileStatus(indexFilePath);
                if (indexStat.isDir()) {
                    FileStatus[] fss;
                    for (FileStatus f : fss = fs.listStatus(indexFilePath, FileUtils.HIDDEN_FILES_PATH_FILTER)) {
                        paths.add(f.getPath());
                    }
                    continue;
                }
                paths.add(indexFilePath);
            }
            long maxEntriesToLoad = HiveConf.getLongVar((Configuration)conf, HiveConf.ConfVars.HIVE_INDEX_COMPACT_QUERY_MAX_ENTRIES);
            if (maxEntriesToLoad < 0L) {
                maxEntriesToLoad = Long.MAX_VALUE;
            }
            long lineCounter = 0L;
            for (Path indexFinalPath : paths) {
                FileSystem fs = indexFinalPath.getFileSystem((Configuration)conf);
                FSDataInputStream ifile = fs.open(indexFinalPath);
                try (LineRecordReader.LineReader lr = new LineRecordReader.LineReader((InputStream)ifile, (Configuration)conf);){
                    Text line = new Text();
                    while (lr.readLine(line) > 0) {
                        if (++lineCounter > maxEntriesToLoad) {
                            throw new HiveException("Number of compact index entries loaded during the query exceeded the maximum of " + maxEntriesToLoad + " set in " + HiveConf.ConfVars.HIVE_INDEX_COMPACT_QUERY_MAX_ENTRIES.varname);
                        }
                        this.add(line);
                    }
                }
            }
        }
    }

    private void add(Text line) throws HiveException {
        String one_offset;
        int currentEnd;
        IBucket bucket;
        String l = line.toString();
        byte[] bytes = l.getBytes();
        int firstEnd = 0;
        int i = 0;
        for (int index = 0; index < bytes.length; ++index) {
            if (bytes[index] != LazySerDeParameters.DefaultSeparators[0]) continue;
            ++i;
            firstEnd = index;
        }
        if (i > 1) {
            throw new HiveException("Bad index file row (index file should only contain two columns: bucket_file_name and offset lists.) ." + line.toString());
        }
        String bucketFileName = new String(bytes, 0, firstEnd);
        if (this.ignoreHdfsLoc) {
            Path tmpPath = new Path(bucketFileName);
            bucketFileName = tmpPath.toUri().getPath();
        }
        if ((bucket = this.buckets.get(bucketFileName)) == null) {
            bucket = new IBucket(bucketFileName);
            this.buckets.put(bucketFileName, bucket);
        }
        int currentStart = firstEnd + 1;
        for (currentEnd = firstEnd + 1; currentEnd < bytes.length; ++currentEnd) {
            if (bytes[currentEnd] != LazySerDeParameters.DefaultSeparators[1]) continue;
            one_offset = new String(bytes, currentStart, currentEnd - currentStart);
            Long offset = Long.parseLong(one_offset);
            bucket.getOffsets().add(offset);
            currentStart = currentEnd + 1;
        }
        one_offset = new String(bytes, currentStart, currentEnd - currentStart);
        bucket.getOffsets().add(Long.parseLong(one_offset));
    }

    public boolean contains(FileSplit split) throws HiveException {
        if (this.buckets == null) {
            return false;
        }
        String bucketName = split.getPath().toString();
        IBucket bucket = this.buckets.get(bucketName);
        if (bucket == null && (bucket = this.buckets.get(bucketName = split.getPath().toUri().getPath())) == null) {
            return false;
        }
        for (Long offset : bucket.getOffsets()) {
            if (offset < split.getStart() || offset > split.getStart() + split.getLength()) continue;
            return true;
        }
        return false;
    }

    static class IBucket {
        private String name = null;
        private final SortedSet<Long> offsets = new TreeSet<Long>();

        public IBucket(String n) {
            this.name = n;
        }

        public void add(Long offset) {
            this.offsets.add(offset);
        }

        public String getName() {
            return this.name;
        }

        public SortedSet<Long> getOffsets() {
            return this.offsets;
        }

        public boolean equals(Object obj) {
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            return ((IBucket)obj).name.compareToIgnoreCase(this.name) == 0;
        }
    }
}

