/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastKeyStore;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashSetResult;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.common.util.HashCodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VectorMapJoinFastBytesHashSet
extends VectorMapJoinFastBytesHashTable
implements VectorMapJoinBytesHashSet {
    private static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinFastBytesHashSet.class);

    @Override
    public VectorMapJoinHashSetResult createHashSetResult() {
        return new VectorMapJoinFastHashSet.HashSetResult();
    }

    @Override
    public void assignSlot(int slot, byte[] keyBytes, int keyStart, int keyLength, long hashCode, boolean isNewKey, BytesWritable currentValue) {
        int tripleIndex = 3 * slot;
        if (isNewKey) {
            this.slotTriples[tripleIndex] = this.keyStore.add(keyBytes, keyStart, keyLength);
            this.slotTriples[tripleIndex + 1] = hashCode;
            this.slotTriples[tripleIndex + 2] = 1L;
        }
    }

    @Override
    public JoinUtil.JoinResult contains(byte[] keyBytes, int keyStart, int keyLength, VectorMapJoinHashSetResult hashSetResult) {
        VectorMapJoinFastHashSet.HashSetResult optimizedHashSetResult = (VectorMapJoinFastHashSet.HashSetResult)hashSetResult;
        optimizedHashSetResult.forget();
        long hashCode = HashCodeUtil.murmurHash(keyBytes, keyStart, keyLength);
        long existance = this.findReadSlot(keyBytes, keyStart, keyLength, hashCode, hashSetResult.getReadPos());
        JoinUtil.JoinResult joinResult = existance == -1L ? JoinUtil.JoinResult.NOMATCH : JoinUtil.JoinResult.MATCH;
        optimizedHashSetResult.setJoinResult(joinResult);
        return joinResult;
    }

    public VectorMapJoinFastBytesHashSet(int initialCapacity, float loadFactor, int writeBuffersSize) {
        super(initialCapacity, loadFactor, writeBuffersSize);
        this.keyStore = new VectorMapJoinFastKeyStore(writeBuffersSize);
    }
}

