/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.DemuxOperator;
import org.apache.hadoop.hive.ql.exec.DependencyCollectionTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.MoveTask;
import org.apache.hadoop.hive.ql.exec.NodeUtils;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecDriver;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.exec.spark.SparkTask;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.merge.MergeFileWork;
import org.apache.hadoop.hive.ql.io.orc.OrcFileStripeMergeInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.rcfile.merge.RCFileBlockMergeInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.SamplePruner;
import org.apache.hadoop.hive.ql.optimizer.listbucketingpruner.ListBucketingPruner;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.ConditionalResolverMergeFiles;
import org.apache.hadoop.hive.ql.plan.ConditionalWork;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FileMergeDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.OrcFileMergeDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.RCFileMergeDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GenMapRedUtils {
    private static Logger LOG = LoggerFactory.getLogger((String)"org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils");

    public static boolean needsTagging(ReduceWork rWork) {
        return rWork != null && (rWork.getReducer().getClass() == JoinOperator.class || rWork.getReducer().getClass() == DemuxOperator.class);
    }

    public static void initPlan(ReduceSinkOperator op, GenMRProcContext opProcCtx) throws SemanticException {
        Operator<OperatorDesc> reducer = op.getChildOperators().get(0);
        LinkedHashMap<Operator<? extends OperatorDesc>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = opProcCtx.getMapCurrCtx();
        GenMRProcContext.GenMapRedCtx mapredCtx = (GenMRProcContext.GenMapRedCtx)mapCurrCtx.get(op.getParentOperators().get(0));
        Task<? extends Serializable> currTask = mapredCtx.getCurrTask();
        MapredWork plan = (MapredWork)currTask.getWork();
        HashMap<Operator<? extends OperatorDesc>, Task<? extends Serializable>> opTaskMap = opProcCtx.getOpTaskMap();
        TableScanOperator currTopOp = opProcCtx.getCurrTopOp();
        opTaskMap.put(reducer, currTask);
        plan.setReduceWork(new ReduceWork());
        plan.getReduceWork().setReducer(reducer);
        ReduceSinkDesc desc = (ReduceSinkDesc)op.getConf();
        plan.getReduceWork().setNumReduceTasks(desc.getNumReducers());
        if (GenMapRedUtils.needsTagging(plan.getReduceWork())) {
            plan.getReduceWork().setNeedsTagging(true);
        }
        assert (currTopOp != null);
        String currAliasId = opProcCtx.getCurrAliasId();
        if (!opProcCtx.isSeenOp(currTask, currTopOp)) {
            GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, currTask, false, opProcCtx);
        }
        currTopOp = null;
        currAliasId = null;
        opProcCtx.setCurrTask(currTask);
        opProcCtx.setCurrTopOp(currTopOp);
        opProcCtx.setCurrAliasId(currAliasId);
    }

    public static void initUnionPlan(ReduceSinkOperator op, UnionOperator currUnionOp, GenMRProcContext opProcCtx, Task<? extends Serializable> unionTask) throws SemanticException {
        Operator<OperatorDesc> reducer = op.getChildOperators().get(0);
        MapredWork plan = (MapredWork)unionTask.getWork();
        HashMap<Operator<? extends OperatorDesc>, Task<? extends Serializable>> opTaskMap = opProcCtx.getOpTaskMap();
        opTaskMap.put(reducer, unionTask);
        plan.setReduceWork(new ReduceWork());
        plan.getReduceWork().setReducer(reducer);
        plan.getReduceWork().setReducer(reducer);
        ReduceSinkDesc desc = (ReduceSinkDesc)op.getConf();
        plan.getReduceWork().setNumReduceTasks(desc.getNumReducers());
        if (GenMapRedUtils.needsTagging(plan.getReduceWork())) {
            plan.getReduceWork().setNeedsTagging(true);
        }
        GenMapRedUtils.initUnionPlan(opProcCtx, currUnionOp, unionTask, false);
    }

    private static void setUnionPlan(GenMRProcContext opProcCtx, boolean local, Task<? extends Serializable> currTask, GenMRProcContext.GenMRUnionCtx uCtx, boolean mergeTask) throws SemanticException {
        TableScanOperator currTopOp = opProcCtx.getCurrTopOp();
        if (currTopOp != null) {
            String currAliasId = opProcCtx.getCurrAliasId();
            if (mergeTask || !opProcCtx.isSeenOp(currTask, currTopOp)) {
                GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, currTask, local, opProcCtx);
            }
            currTopOp = null;
            opProcCtx.setCurrTopOp(currTopOp);
        } else {
            List<String> taskTmpDirLst = uCtx.getTaskTmpDir();
            if (taskTmpDirLst != null && !taskTmpDirLst.isEmpty()) {
                List<TableDesc> tt_descLst = uCtx.getTTDesc();
                assert (!taskTmpDirLst.isEmpty() && !tt_descLst.isEmpty());
                assert (taskTmpDirLst.size() == tt_descLst.size());
                int size = taskTmpDirLst.size();
                assert (!local);
                List<TableScanOperator> topOperators = uCtx.getListTopOperators();
                MapredWork plan = (MapredWork)currTask.getWork();
                for (int pos = 0; pos < size; ++pos) {
                    String taskTmpDir = taskTmpDirLst.get(pos);
                    TableDesc tt_desc = tt_descLst.get(pos);
                    MapWork mWork = plan.getMapWork();
                    if (mWork.getPathToAliases().get(taskTmpDir) != null) continue;
                    mWork.getPathToAliases().put(taskTmpDir, new ArrayList());
                    mWork.getPathToAliases().get(taskTmpDir).add(taskTmpDir);
                    mWork.getPathToPartitionInfo().put(taskTmpDir, new PartitionDesc(tt_desc, null));
                    mWork.getAliasToWork().put(taskTmpDir, topOperators.get(pos));
                }
            }
        }
    }

    public static void initUnionPlan(GenMRProcContext opProcCtx, UnionOperator currUnionOp, Task<? extends Serializable> currTask, boolean local) throws SemanticException {
        if (currUnionOp != null) {
            GenMRProcContext.GenMRUnionCtx uCtx = opProcCtx.getUnionTask(currUnionOp);
            assert (uCtx != null);
            GenMapRedUtils.setUnionPlan(opProcCtx, local, currTask, uCtx, false);
        }
    }

    public static void joinUnionPlan(GenMRProcContext opProcCtx, UnionOperator currUnionOp, Task<? extends Serializable> currentUnionTask, Task<? extends Serializable> existingTask, boolean local) throws SemanticException {
        assert (currUnionOp != null);
        GenMRProcContext.GenMRUnionCtx uCtx = opProcCtx.getUnionTask(currUnionOp);
        assert (uCtx != null);
        GenMapRedUtils.setUnionPlan(opProcCtx, local, existingTask, uCtx, true);
        ArrayList<Task<Serializable>> parTasks = null;
        if (opProcCtx.getRootTasks().contains(currentUnionTask)) {
            opProcCtx.getRootTasks().remove(currentUnionTask);
            if (!opProcCtx.getRootTasks().contains(existingTask) && (existingTask.getParentTasks() == null || existingTask.getParentTasks().isEmpty())) {
                opProcCtx.getRootTasks().add(existingTask);
            }
        }
        if (currentUnionTask != null && currentUnionTask.getParentTasks() != null && !currentUnionTask.getParentTasks().isEmpty()) {
            Object[] parTaskArr;
            parTasks = new ArrayList<Task<Serializable>>();
            parTasks.addAll(currentUnionTask.getParentTasks());
            for (Object parTask : parTaskArr = parTasks.toArray()) {
                ((Task)parTask).removeDependentTask(currentUnionTask);
            }
        }
        if (currentUnionTask != null && parTasks != null) {
            for (Task task : parTasks) {
                task.addDependentTask(existingTask);
                if (!opProcCtx.getRootTasks().contains(existingTask)) continue;
                opProcCtx.getRootTasks().remove(existingTask);
            }
        }
        opProcCtx.setCurrTask(existingTask);
    }

    public static void joinPlan(Task<? extends Serializable> currTask, Task<? extends Serializable> oldTask, GenMRProcContext opProcCtx) throws SemanticException {
        assert (currTask != null && oldTask != null);
        TableScanOperator currTopOp = opProcCtx.getCurrTopOp();
        ArrayList<Task<Serializable>> parTasks = null;
        if (currTask.getParentTasks() != null && !currTask.getParentTasks().isEmpty()) {
            Object[] parTaskArr;
            parTasks = new ArrayList<Task<Serializable>>();
            parTasks.addAll(currTask.getParentTasks());
            for (Object element : parTaskArr = parTasks.toArray()) {
                ((Task)element).removeDependentTask(currTask);
            }
        }
        if (currTopOp != null) {
            GenMapRedUtils.mergeInput(currTopOp, opProcCtx, oldTask, false);
        }
        if (parTasks != null) {
            for (Task task : parTasks) {
                task.addDependentTask(oldTask);
            }
        }
        if (oldTask instanceof MapRedTask && currTask instanceof MapRedTask) {
            ((MapredWork)((MapRedTask)currTask).getWork()).getMapWork().mergingInto(((MapredWork)((MapRedTask)oldTask).getWork()).getMapWork());
        }
        opProcCtx.setCurrTopOp(null);
        opProcCtx.setCurrTask(oldTask);
    }

    static boolean mergeInput(TableScanOperator currTopOp, GenMRProcContext opProcCtx, Task<? extends Serializable> task, boolean local) throws SemanticException {
        if (!opProcCtx.isSeenOp(task, currTopOp)) {
            String currAliasId = opProcCtx.getCurrAliasId();
            GenMapRedUtils.setTaskPlan(currAliasId, currTopOp, task, local, opProcCtx);
            return true;
        }
        return false;
    }

    static void splitPlan(ReduceSinkOperator cRS, Task<? extends Serializable> parentTask, Task<? extends Serializable> childTask, GenMRProcContext opProcCtx) throws SemanticException {
        assert (parentTask != null && childTask != null);
        GenMapRedUtils.splitTasks(cRS, parentTask, childTask, opProcCtx);
    }

    static void splitPlan(ReduceSinkOperator cRS, GenMRProcContext opProcCtx) throws SemanticException {
        ParseContext parseCtx = opProcCtx.getParseCtx();
        Task<? extends Serializable> parentTask = opProcCtx.getCurrTask();
        MapredWork childPlan = GenMapRedUtils.getMapRedWork(parseCtx);
        Task<MapredWork> childTask = TaskFactory.get(childPlan, parseCtx.getConf(), new Task[0]);
        Operator<OperatorDesc> reducer = cRS.getChildOperators().get(0);
        ReduceWork rWork = new ReduceWork();
        childPlan.setReduceWork(rWork);
        rWork.setReducer(reducer);
        ReduceSinkDesc desc = (ReduceSinkDesc)cRS.getConf();
        childPlan.getReduceWork().setNumReduceTasks(new Integer(desc.getNumReducers()));
        opProcCtx.getOpTaskMap().put(reducer, childTask);
        GenMapRedUtils.splitTasks(cRS, parentTask, childTask, opProcCtx);
    }

    public static void setTaskPlan(String alias_id, TableScanOperator topOp, Task<?> task, boolean local, GenMRProcContext opProcCtx) throws SemanticException {
        GenMapRedUtils.setTaskPlan(alias_id, topOp, task, local, opProcCtx, null);
    }

    public static void setTaskPlan(String alias_id, TableScanOperator topOp, Task<?> task, boolean local, GenMRProcContext opProcCtx, PrunedPartitionList pList) throws SemanticException {
        GenMapRedUtils.setMapWork(((MapredWork)task.getWork()).getMapWork(), opProcCtx.getParseCtx(), opProcCtx.getInputs(), pList, topOp, alias_id, opProcCtx.getConf(), local);
        opProcCtx.addSeenOp(task, topOp);
    }

    public static void setMapWork(MapWork plan, ParseContext parseCtx, Set<ReadEntity> inputs, PrunedPartitionList partsList, TableScanOperator tsOp, String alias_id, HiveConf conf, boolean local) throws SemanticException {
        Map<String, String> props;
        ArrayList<Path> partDir = new ArrayList<Path>();
        ArrayList<PartitionDesc> partDesc = new ArrayList<PartitionDesc>();
        boolean isAcidTable = false;
        Path tblDir = null;
        plan.setNameToSplitSample(parseCtx.getNameToSplitSample());
        if (partsList == null) {
            partsList = PartitionPruner.prune(tsOp, parseCtx, alias_id);
            isAcidTable = ((TableScanDesc)tsOp.getConf()).isAcidTable();
        }
        Set<Partition> parts = partsList.getPartitions();
        PartitionDesc aliasPartnDesc = null;
        try {
            if (!parts.isEmpty()) {
                aliasPartnDesc = Utilities.getPartitionDesc(parts.iterator().next());
            }
        }
        catch (HiveException e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new SemanticException(e.getMessage(), e);
        }
        if (aliasPartnDesc == null) {
            aliasPartnDesc = new PartitionDesc(Utilities.getTableDesc(((TableScanDesc)tsOp.getConf()).getTableMetadata()), null);
        }
        if ((props = ((TableScanDesc)tsOp.getConf()).getOpProps()) != null) {
            Properties target = aliasPartnDesc.getProperties();
            target.putAll(props);
        }
        plan.getAliasToPartnInfo().put(alias_id, aliasPartnDesc);
        long sizeNeeded = Integer.MAX_VALUE;
        int fileLimit = -1;
        if (parseCtx.getGlobalLimitCtx().isEnable()) {
            if (isAcidTable) {
                LOG.info("Skip Global Limit optimization for ACID table");
                parseCtx.getGlobalLimitCtx().disableOpt();
            } else {
                long sizePerRow = HiveConf.getLongVar(parseCtx.getConf(), HiveConf.ConfVars.HIVELIMITMAXROWSIZE);
                sizeNeeded = (long)(parseCtx.getGlobalLimitCtx().getGlobalOffset() + parseCtx.getGlobalLimitCtx().getGlobalLimit()) * sizePerRow;
                fileLimit = HiveConf.getIntVar(parseCtx.getConf(), HiveConf.ConfVars.HIVELIMITOPTLIMITFILE);
                if (sizePerRow <= 0L || fileLimit <= 0) {
                    LOG.info("Skip optimization to reduce input size of 'limit'");
                    parseCtx.getGlobalLimitCtx().disableOpt();
                } else if (parts.isEmpty()) {
                    LOG.info("Empty input: skip limit optimiztion");
                } else {
                    LOG.info("Try to reduce input size for 'limit' sizeNeeded: " + sizeNeeded + "  file limit : " + fileLimit);
                }
            }
        }
        boolean isFirstPart = true;
        boolean emptyInput = true;
        boolean singlePartition = parts.size() == 1;
        Map<String, ReadEntity> viewToInput = parseCtx.getViewAliasToInput();
        ReadEntity parentViewInfo = PlanUtils.getParentViewInfo(alias_id, viewToInput);
        boolean isDirectRead = parentViewInfo == null;
        TableDesc tblDesc = null;
        boolean initTableDesc = false;
        PlanUtils.addPartitionInputs(parts, inputs, parentViewInfo, isDirectRead);
        for (Partition part : parts) {
            ExprNodeDesc listBucketingPruner;
            Path[] paths = null;
            FilterDesc.SampleDesc sampleDescr = parseCtx.getOpToSamplePruner().get(tsOp);
            Map<String, ExprNodeDesc> partToPruner = parseCtx.getOpToPartToSkewedPruner().get(tsOp);
            ExprNodeDesc exprNodeDesc = listBucketingPruner = partToPruner != null ? partToPruner.get(part.getName()) : null;
            if (sampleDescr != null) {
                assert (listBucketingPruner == null) : "Sampling and list bucketing can't coexit.";
                paths = SamplePruner.prune(part, sampleDescr);
                parseCtx.getGlobalLimitCtx().disableOpt();
            } else if (listBucketingPruner != null) {
                assert (sampleDescr == null) : "Sampling and list bucketing can't coexist.";
                paths = ListBucketingPruner.prune(parseCtx, part, listBucketingPruner);
            } else {
                if (parseCtx.getGlobalLimitCtx().isEnable()) {
                    if (isFirstPart) {
                        long sizeLeft = sizeNeeded;
                        ArrayList<Path> retPathList = new ArrayList<Path>();
                        SamplePruner.LimitPruneRetStatus status = SamplePruner.limitPrune(part, sizeLeft, fileLimit, retPathList);
                        if (status.equals((Object)SamplePruner.LimitPruneRetStatus.NoFile)) continue;
                        if (status.equals((Object)SamplePruner.LimitPruneRetStatus.NotQualify)) {
                            LOG.info("Use full input -- first " + fileLimit + " files are more than " + sizeNeeded + " bytes");
                            parseCtx.getGlobalLimitCtx().disableOpt();
                        } else {
                            emptyInput = false;
                            paths = new Path[retPathList.size()];
                            int index = 0;
                            for (Path path : retPathList) {
                                paths[index++] = path;
                            }
                            if (status.equals((Object)SamplePruner.LimitPruneRetStatus.NeedAllFiles) && singlePartition) {
                                parseCtx.getGlobalLimitCtx().disableOpt();
                            }
                        }
                        isFirstPart = false;
                    } else {
                        paths = new Path[]{};
                    }
                }
                if (!parseCtx.getGlobalLimitCtx().isEnable()) {
                    paths = part.getPath();
                }
            }
            if (!part.getTable().isPartitioned()) {
                assert (tblDir == null);
                tblDir = paths[0];
                if (!initTableDesc) {
                    tblDesc = Utilities.getTableDesc(part.getTable());
                    initTableDesc = true;
                }
            } else if (tblDesc == null && !initTableDesc) {
                tblDesc = Utilities.getTableDesc(part.getTable());
                initTableDesc = true;
            }
            if (props != null) {
                Properties target = tblDesc.getProperties();
                target.putAll(props);
            }
            for (Path p : paths) {
                if (p == null) continue;
                String path = p.toString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding " + path + " of table" + alias_id);
                }
                partDir.add(p);
                try {
                    if (part.getTable().isPartitioned()) {
                        partDesc.add(Utilities.getPartitionDesc(part));
                        continue;
                    }
                    partDesc.add(Utilities.getPartitionDescFromTableDesc(tblDesc, part, false));
                }
                catch (HiveException e) {
                    LOG.error(StringUtils.stringifyException((Throwable)e));
                    throw new SemanticException(e.getMessage(), e);
                }
            }
        }
        if (emptyInput) {
            parseCtx.getGlobalLimitCtx().disableOpt();
        }
        Utilities.addSchemaEvolutionToTableScanOperator(partsList.getSourceTable(), tsOp);
        Iterator iterPath = partDir.iterator();
        Iterator iterPartnDesc = partDesc.iterator();
        if (!local) {
            while (iterPath.hasNext()) {
                assert (iterPartnDesc.hasNext());
                String path = ((Path)iterPath.next()).toString();
                PartitionDesc prtDesc = (PartitionDesc)iterPartnDesc.next();
                if (plan.getPathToAliases().get(path) == null) {
                    plan.getPathToAliases().put(path, new ArrayList());
                }
                plan.getPathToAliases().get(path).add(alias_id);
                plan.getPathToPartitionInfo().put(path, prtDesc);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Information added for path " + path);
            }
            assert (plan.getAliasToWork().get(alias_id) == null);
            plan.getAliasToWork().put(alias_id, tsOp);
        } else {
            MapredLocalWork localPlan = plan.getMapRedLocalWork();
            if (localPlan == null) {
                localPlan = new MapredLocalWork(new LinkedHashMap<String, Operator<? extends OperatorDesc>>(), new LinkedHashMap<String, FetchWork>());
            }
            assert (localPlan.getAliasToWork().get(alias_id) == null);
            assert (localPlan.getAliasToFetchWork().get(alias_id) == null);
            localPlan.getAliasToWork().put(alias_id, tsOp);
            if (tblDir == null) {
                tblDesc = Utilities.getTableDesc(partsList.getSourceTable());
                localPlan.getAliasToFetchWork().put(alias_id, new FetchWork(partDir, partDesc, tblDesc));
            } else {
                localPlan.getAliasToFetchWork().put(alias_id, new FetchWork(tblDir, tblDesc));
            }
            plan.setMapRedLocalWork(localPlan);
        }
    }

    public static void setTaskPlan(String path, String alias, Operator<? extends OperatorDesc> topOp, MapWork plan, boolean local, TableDesc tt_desc) throws SemanticException {
        if (path == null || alias == null) {
            return;
        }
        if (topOp instanceof TableScanOperator) {
            try {
                Utilities.addSchemaEvolutionToTableScanOperator((StructObjectInspector)tt_desc.getDeserializer().getObjectInspector(), (TableScanOperator)topOp);
            }
            catch (Exception e) {
                throw new SemanticException(e);
            }
        }
        if (!local) {
            if (plan.getPathToAliases().get(path) == null) {
                plan.getPathToAliases().put(path, new ArrayList());
            }
            plan.getPathToAliases().get(path).add(alias);
            plan.getPathToPartitionInfo().put(path, new PartitionDesc(tt_desc, null));
            plan.getAliasToWork().put(alias, topOp);
        } else {
            MapredLocalWork localPlan = plan.getMapRedLocalWork();
            if (localPlan == null) {
                localPlan = new MapredLocalWork(new LinkedHashMap<String, Operator<? extends OperatorDesc>>(), new LinkedHashMap<String, FetchWork>());
            }
            assert (localPlan.getAliasToWork().get(alias) == null);
            assert (localPlan.getAliasToFetchWork().get(alias) == null);
            localPlan.getAliasToWork().put(alias, topOp);
            localPlan.getAliasToFetchWork().put(alias, new FetchWork(new Path(alias), tt_desc));
            plan.setMapRedLocalWork(localPlan);
        }
    }

    public static void setKeyAndValueDesc(ReduceWork work, ReduceSinkOperator rs) {
        work.setKeyDesc(((ReduceSinkDesc)rs.getConf()).getKeySerializeInfo());
        int tag = Math.max(0, ((ReduceSinkDesc)rs.getConf()).getTag());
        List<TableDesc> tagToSchema = work.getTagToValueDesc();
        while (tag + 1 > tagToSchema.size()) {
            tagToSchema.add(null);
        }
        tagToSchema.set(tag, ((ReduceSinkDesc)rs.getConf()).getValueSerializeInfo());
    }

    public static void setKeyAndValueDesc(ReduceWork plan, Operator<? extends OperatorDesc> topOp) {
        if (topOp == null) {
            return;
        }
        if (topOp instanceof ReduceSinkOperator) {
            ReduceSinkOperator rs = (ReduceSinkOperator)topOp;
            GenMapRedUtils.setKeyAndValueDesc(plan, rs);
        } else {
            List<Operator<OperatorDesc>> children = topOp.getChildOperators();
            if (children != null) {
                for (Operator<OperatorDesc> op : children) {
                    GenMapRedUtils.setKeyAndValueDesc(plan, op);
                }
            }
        }
    }

    public static void setKeyAndValueDescForTaskTree(Task<? extends Serializable> task) {
        AbstractOperatorDesc work;
        if (task instanceof ConditionalTask) {
            List<Task<? extends Serializable>> listTasks = ((ConditionalTask)task).getListTasks();
            for (Task<? extends Serializable> tsk : listTasks) {
                GenMapRedUtils.setKeyAndValueDescForTaskTree(tsk);
            }
        } else if (task instanceof ExecDriver) {
            work = (MapredWork)task.getWork();
            ((MapredWork)work).getMapWork().deriveExplainAttributes();
            LinkedHashMap<String, Operator<? extends OperatorDesc>> opMap = ((MapredWork)work).getMapWork().getAliasToWork();
            if (opMap != null && !opMap.isEmpty()) {
                for (Operator op : ((HashMap)opMap).values()) {
                    GenMapRedUtils.setKeyAndValueDesc(((MapredWork)work).getReduceWork(), op);
                }
            }
        } else if (task != null && task.getWork() instanceof TezWork) {
            work = (TezWork)task.getWork();
            for (BaseWork w : ((TezWork)work).getAllWorkUnsorted()) {
                if (!(w instanceof MapWork)) continue;
                ((MapWork)w).deriveExplainAttributes();
            }
        } else if (task instanceof SparkTask) {
            work = (SparkWork)task.getWork();
            for (BaseWork w : ((SparkWork)work).getAllWorkUnsorted()) {
                if (!(w instanceof MapWork)) continue;
                ((MapWork)w).deriveExplainAttributes();
            }
        }
        if (task.getChildTasks() == null) {
            return;
        }
        for (Task<Serializable> childTask : task.getChildTasks()) {
            GenMapRedUtils.setKeyAndValueDescForTaskTree(childTask);
        }
    }

    public static void deriveFinalExplainAttributes(Task<? extends Serializable> task, Configuration conf) {
        AbstractOperatorDesc work;
        if (task instanceof ConditionalTask) {
            for (Task<? extends Serializable> task2 : ((ConditionalTask)task).getListTasks()) {
                GenMapRedUtils.deriveFinalExplainAttributes(task2, conf);
            }
        } else if (task instanceof ExecDriver) {
            work = (MapredWork)task.getWork();
            ((MapredWork)work).getMapWork().deriveLlap(conf);
        } else if (task != null && task.getWork() instanceof TezWork) {
            work = (TezWork)task.getWork();
            for (BaseWork w : ((TezWork)work).getAllWorkUnsorted()) {
                if (!(w instanceof MapWork)) continue;
                ((MapWork)w).deriveLlap(conf);
            }
        } else if (task instanceof SparkTask) {
            work = (SparkWork)task.getWork();
            for (BaseWork w : ((SparkWork)work).getAllWorkUnsorted()) {
                if (!(w instanceof MapWork)) continue;
                ((MapWork)w).deriveLlap(conf);
            }
        }
        if (task.getChildTasks() == null) {
            return;
        }
        for (Task<? extends Serializable> task3 : task.getChildTasks()) {
            GenMapRedUtils.deriveFinalExplainAttributes(task3, conf);
        }
    }

    public static void internTableDesc(Task<?> task, Interner<TableDesc> interner) {
        AbstractOperatorDesc work;
        if (task instanceof ConditionalTask) {
            for (Task<? extends Serializable> task2 : ((ConditionalTask)task).getListTasks()) {
                GenMapRedUtils.internTableDesc(task2, interner);
            }
        } else if (task instanceof ExecDriver) {
            work = (MapredWork)task.getWork();
            ((MapredWork)work).getMapWork().internTable(interner);
        } else if (task != null && task.getWork() instanceof TezWork) {
            work = (TezWork)task.getWork();
            for (BaseWork w : ((TezWork)work).getAllWorkUnsorted()) {
                if (!(w instanceof MapWork)) continue;
                ((MapWork)w).internTable(interner);
            }
        }
        if (task.getNumChild() > 0) {
            for (Task<? extends Serializable> task3 : task.getChildTasks()) {
                GenMapRedUtils.internTableDesc(task3, interner);
            }
        }
    }

    public static MapredWork getMapRedWork(ParseContext parseCtx) {
        MapredWork work = GenMapRedUtils.getMapRedWorkFromConf(parseCtx.getConf());
        work.getMapWork().setNameToSplitSample(parseCtx.getNameToSplitSample());
        return work;
    }

    public static MapredWork getMapRedWorkFromConf(HiveConf conf) {
        MapredWork mrWork = new MapredWork();
        MapWork work = mrWork.getMapWork();
        boolean mapperCannotSpanPartns = conf.getBoolVar(HiveConf.ConfVars.HIVE_MAPPER_CANNOT_SPAN_MULTIPLE_PARTITIONS);
        work.setMapperCannotSpanPartns(mapperCannotSpanPartns);
        work.setPathToAliases(new LinkedHashMap<String, ArrayList<String>>());
        work.setPathToPartitionInfo(new LinkedHashMap<String, PartitionDesc>());
        work.setAliasToWork(new LinkedHashMap<String, Operator<? extends OperatorDesc>>());
        return mrWork;
    }

    public static TableScanOperator createTemporaryTableScanOperator(CompilationOpContext ctx, RowSchema rowSchema) {
        TableScanOperator tableScanOp = (TableScanOperator)OperatorFactory.get(ctx, new TableScanDesc(null), rowSchema);
        ArrayList<Integer> neededColumnIds = new ArrayList<Integer>();
        ArrayList<String> neededColumnNames = new ArrayList<String>();
        ArrayList<ColumnInfo> parentColumnInfos = rowSchema.getSignature();
        for (int i = 0; i < parentColumnInfos.size(); ++i) {
            neededColumnIds.add(i);
            neededColumnNames.add(((ColumnInfo)parentColumnInfos.get(i)).getInternalName());
        }
        tableScanOp.setNeededColumnIDs(neededColumnIds);
        tableScanOp.setNeededColumns(neededColumnNames);
        tableScanOp.setReferencedColumns(neededColumnNames);
        return tableScanOp;
    }

    public static TableScanOperator createTemporaryFile(Operator<? extends OperatorDesc> parent, Operator<? extends OperatorDesc> child, Path taskTmpDir, TableDesc tt_desc, ParseContext parseCtx) {
        boolean compressIntermediate = parseCtx.getConf().getBoolVar(HiveConf.ConfVars.COMPRESSINTERMEDIATE);
        FileSinkDesc desc = new FileSinkDesc(taskTmpDir, tt_desc, compressIntermediate);
        if (compressIntermediate) {
            desc.setCompressCodec(parseCtx.getConf().getVar(HiveConf.ConfVars.COMPRESSINTERMEDIATECODEC));
            desc.setCompressType(parseCtx.getConf().getVar(HiveConf.ConfVars.COMPRESSINTERMEDIATETYPE));
        }
        Operator<FileSinkDesc> fileSinkOp = OperatorFactory.get(parent.getCompilationOpContext(), desc, parent.getSchema());
        parent.replaceChild(child, fileSinkOp);
        fileSinkOp.setParentOperators(Utilities.makeList(parent));
        TableScanOperator tableScanOp = GenMapRedUtils.createTemporaryTableScanOperator(parent.getCompilationOpContext(), parent.getSchema());
        tableScanOp.setChildOperators(Utilities.makeList(child));
        child.replaceParent(parent, tableScanOp);
        return tableScanOp;
    }

    private static void splitTasks(ReduceSinkOperator op, Task<? extends Serializable> parentTask, Task<? extends Serializable> childTask, GenMRProcContext opProcCtx) throws SemanticException {
        if (op.getNumParent() != 1) {
            throw new IllegalStateException("Expecting operator " + op + " to have one parent. " + "But found multiple parents : " + op.getParentOperators());
        }
        ParseContext parseCtx = opProcCtx.getParseCtx();
        parentTask.addDependentTask(childTask);
        List<Task<? extends Serializable>> rootTasks = opProcCtx.getRootTasks();
        if (rootTasks.contains(childTask)) {
            rootTasks.remove(childTask);
        }
        Context baseCtx = parseCtx.getContext();
        Path taskTmpDir = baseCtx.getMRTmpPath();
        Operator<OperatorDesc> parent = op.getParentOperators().get(0);
        TableDesc tt_desc = PlanUtils.getIntermediateFileTableDesc(PlanUtils.getFieldSchemasFromRowSchema(parent.getSchema(), "temporarycol"));
        TableScanOperator tableScanOp = GenMapRedUtils.createTemporaryFile(parent, op, taskTmpDir, tt_desc, parseCtx);
        LinkedHashMap<Operator<? extends OperatorDesc>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = opProcCtx.getMapCurrCtx();
        mapCurrCtx.put(tableScanOp, new GenMRProcContext.GenMapRedCtx(childTask, null));
        String streamDesc = taskTmpDir.toUri().toString();
        MapredWork cplan = (MapredWork)childTask.getWork();
        if (GenMapRedUtils.needsTagging(cplan.getReduceWork())) {
            Operator<?> reducerOp = cplan.getReduceWork().getReducer();
            String id = null;
            if (reducerOp instanceof JoinOperator) {
                if (parseCtx.getJoinOps().contains(reducerOp)) {
                    id = ((JoinDesc)((JoinOperator)reducerOp).getConf()).getId();
                }
            } else if (reducerOp instanceof MapJoinOperator) {
                if (parseCtx.getMapJoinOps().contains(reducerOp)) {
                    id = ((MapJoinDesc)((MapJoinOperator)reducerOp).getConf()).getId();
                }
            } else if (reducerOp instanceof SMBMapJoinOperator && parseCtx.getSmbMapJoinOps().contains(reducerOp)) {
                id = ((SMBJoinDesc)((SMBMapJoinOperator)reducerOp).getConf()).getId();
            }
            streamDesc = id != null ? id + ":$INTNAME" : "$INTNAME";
            String origStreamDesc = streamDesc;
            int pos = 0;
            while (cplan.getMapWork().getAliasToWork().get(streamDesc) != null) {
                streamDesc = origStreamDesc.concat(String.valueOf(++pos));
            }
            cplan.getReduceWork().setNeedsTagging(true);
        }
        GenMapRedUtils.setTaskPlan(taskTmpDir.toUri().toString(), streamDesc, tableScanOp, cplan.getMapWork(), false, tt_desc);
        opProcCtx.setCurrTopOp(null);
        opProcCtx.setCurrAliasId(null);
        opProcCtx.setCurrTask(childTask);
        opProcCtx.addRootIfPossible(parentTask);
    }

    static boolean hasBranchFinished(Object ... children) {
        for (Object child : children) {
            if (child != null) continue;
            return false;
        }
        return true;
    }

    public static void replaceMapWork(String sourceAlias, String targetAlias, MapWork source, MapWork target) {
        LinkedHashMap<String, ArrayList<String>> sourcePathToAliases = source.getPathToAliases();
        LinkedHashMap<String, PartitionDesc> sourcePathToPartitionInfo = source.getPathToPartitionInfo();
        LinkedHashMap<String, Operator<? extends OperatorDesc>> sourceAliasToWork = source.getAliasToWork();
        LinkedHashMap<String, PartitionDesc> sourceAliasToPartnInfo = source.getAliasToPartnInfo();
        LinkedHashMap<String, ArrayList<String>> targetPathToAliases = target.getPathToAliases();
        LinkedHashMap<String, PartitionDesc> targetPathToPartitionInfo = target.getPathToPartitionInfo();
        LinkedHashMap<String, Operator<? extends OperatorDesc>> targetAliasToWork = target.getAliasToWork();
        LinkedHashMap<String, PartitionDesc> targetAliasToPartnInfo = target.getAliasToPartnInfo();
        if (!sourceAliasToWork.containsKey(sourceAlias) || !targetAliasToWork.containsKey(targetAlias)) {
            return;
        }
        if (sourceAliasToWork.size() > 1) {
            return;
        }
        targetAliasToWork.remove(targetAlias);
        targetAliasToPartnInfo.remove(targetAlias);
        ArrayList pathsToRemove = new ArrayList();
        for (Map.Entry entry : targetPathToAliases.entrySet()) {
            ArrayList aliases = (ArrayList)entry.getValue();
            aliases.remove(targetAlias);
            if (!aliases.isEmpty()) continue;
            pathsToRemove.add(entry.getKey());
        }
        for (String pathToRemove : pathsToRemove) {
            targetPathToAliases.remove(pathToRemove);
            targetPathToPartitionInfo.remove(pathToRemove);
        }
        targetAliasToWork.put(sourceAlias, (Operator<? extends OperatorDesc>)sourceAliasToWork.get(sourceAlias));
        targetAliasToPartnInfo.putAll(sourceAliasToPartnInfo);
        targetPathToPartitionInfo.putAll(sourcePathToPartitionInfo);
        ArrayList pathsToAdd = new ArrayList();
        for (Map.Entry entry : sourcePathToAliases.entrySet()) {
            ArrayList aliases = (ArrayList)entry.getValue();
            if (!aliases.contains(sourceAlias)) continue;
            pathsToAdd.add(entry.getKey());
        }
        for (String pathToAdd : pathsToAdd) {
            if (!targetPathToAliases.containsKey(pathToAdd)) {
                targetPathToAliases.put(pathToAdd, new ArrayList());
            }
            ((ArrayList)targetPathToAliases.get(pathToAdd)).add(sourceAlias);
        }
    }

    public static void createMRWorkForMergingFiles(FileSinkOperator fsInput, Path finalName, DependencyCollectionTask dependencyTask, List<Task<MoveWork>> mvTasks, HiveConf conf, Task<? extends Serializable> currTask) throws SemanticException {
        AbstractOperatorDesc work;
        MapWork cplan;
        FileSinkDesc fsInputDesc = (FileSinkDesc)fsInput.getConf();
        RowSchema inputRS = fsInput.getSchema();
        TableScanOperator tsMerge = GenMapRedUtils.createTemporaryTableScanOperator(fsInput.getCompilationOpContext(), inputRS);
        TableDesc ts = (TableDesc)fsInputDesc.getTableInfo().clone();
        FileSinkDesc fsOutputDesc = new FileSinkDesc(finalName, ts, conf.getBoolVar(HiveConf.ConfVars.COMPRESSRESULT));
        FileSinkOperator fsOutput = (FileSinkOperator)OperatorFactory.getAndMakeChild(fsOutputDesc, inputRS, (Operator)tsMerge, new Operator[0]);
        DynamicPartitionCtx dpCtx = fsInputDesc.getDynPartCtx();
        if (dpCtx != null && dpCtx.getNumDPCols() > 0) {
            ArrayList<ColumnInfo> signature = inputRS.getSignature();
            String tblAlias = fsInputDesc.getTableInfo().getTableName();
            for (String dpCol : dpCtx.getDPColNames()) {
                ColumnInfo colInfo = new ColumnInfo(dpCol, TypeInfoFactory.stringTypeInfo, tblAlias, true);
                signature.add(colInfo);
            }
            inputRS.setSignature(signature);
            DynamicPartitionCtx dpCtx2 = new DynamicPartitionCtx(dpCtx);
            fsOutputDesc.setDynPartCtx(dpCtx2);
            GenMapRedUtils.usePartitionColumns(fsInputDesc.getTableInfo().getProperties(), dpCtx.getDPColNames());
        } else {
            fsInputDesc.getTableInfo().getProperties().remove("partition_columns");
        }
        MoveWork dummyMv = new MoveWork(null, null, null, new LoadFileDesc(fsInputDesc.getFinalDirName(), finalName, true, null, null), false);
        if (conf.getBoolVar(HiveConf.ConfVars.HIVEMERGERCFILEBLOCKLEVEL) && fsInputDesc.getTableInfo().getInputFileFormatClass().equals(RCFileInputFormat.class) || conf.getBoolVar(HiveConf.ConfVars.HIVEMERGEORCFILESTRIPELEVEL) && fsInputDesc.getTableInfo().getInputFileFormatClass().equals(OrcInputFormat.class)) {
            cplan = GenMapRedUtils.createMergeTask(fsInputDesc, finalName, dpCtx != null && dpCtx.getNumDPCols() > 0, fsInput.getCompilationOpContext());
            if (conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
                work = new TezWork(conf.getVar(HiveConf.ConfVars.HIVEQUERYID), conf);
                cplan.setName("File Merge");
                work.add(cplan);
            } else if (conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("spark")) {
                work = new SparkWork(conf.getVar(HiveConf.ConfVars.HIVEQUERYID));
                cplan.setName("Spark Merge File Work");
                ((SparkWork)work).add(cplan);
            } else {
                work = cplan;
            }
        } else {
            cplan = GenMapRedUtils.createMRWorkForMergingFiles(conf, tsMerge, fsInputDesc);
            if (conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
                work = new TezWork(conf.getVar(HiveConf.ConfVars.HIVEQUERYID), conf);
                cplan.setName("File Merge");
                work.add(cplan);
            } else if (conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("spark")) {
                work = new SparkWork(conf.getVar(HiveConf.ConfVars.HIVEQUERYID));
                cplan.setName("Spark Merge File Work");
                ((SparkWork)work).add(cplan);
            } else {
                work = new MapredWork();
                ((MapredWork)work).setMapWork(cplan);
            }
        }
        cplan.setInputformat("org.apache.hadoop.hive.ql.io.CombineHiveInputFormat");
        ConditionalTask cndTsk = GenMapRedUtils.createCondTask(conf, currTask, dummyMv, work, fsInputDesc.getFinalDirName().toString());
        ConditionalResolverMergeFiles.ConditionalResolverMergeFilesCtx mrCtx = (ConditionalResolverMergeFiles.ConditionalResolverMergeFilesCtx)cndTsk.getResolverCtx();
        mrCtx.setDPCtx(fsInputDesc.getDynPartCtx());
        mrCtx.setLbCtx(fsInputDesc.getLbCtx());
        GenMapRedUtils.linkMoveTask(fsOutput, cndTsk, mvTasks, conf, dependencyTask);
    }

    public static void linkMoveTask(FileSinkOperator newOutput, ConditionalTask cndTsk, List<Task<MoveWork>> mvTasks, HiveConf hconf, DependencyCollectionTask dependencyTask) {
        Task<MoveWork> mvTask = GenMapRedUtils.findMoveTask(mvTasks, newOutput);
        for (Task<? extends Serializable> tsk : cndTsk.getListTasks()) {
            GenMapRedUtils.linkMoveTask(mvTask, tsk, hconf, dependencyTask);
        }
    }

    public static void linkMoveTask(Task<MoveWork> mvTask, Task<? extends Serializable> task, HiveConf hconf, DependencyCollectionTask dependencyTask) {
        if (task.getDependentTasks() == null || task.getDependentTasks().isEmpty()) {
            GenMapRedUtils.addDependentMoveTasks(mvTask, hconf, task, dependencyTask);
        } else {
            for (Task<Serializable> childTask : task.getDependentTasks()) {
                GenMapRedUtils.linkMoveTask(mvTask, childTask, hconf, dependencyTask);
            }
        }
    }

    public static void addDependentMoveTasks(Task<MoveWork> mvTask, HiveConf hconf, Task<? extends Serializable> parentTask, DependencyCollectionTask dependencyTask) {
        if (mvTask != null) {
            if (dependencyTask != null) {
                parentTask.addDependentTask(dependencyTask);
                if (mvTask.getWork().getLoadTableWork() != null) {
                    dependencyTask.addDependentTask(mvTask);
                } else {
                    parentTask.addDependentTask(mvTask);
                }
            } else {
                parentTask.addDependentTask(mvTask);
            }
        }
    }

    public static void addStatsTask(FileSinkOperator nd, MoveTask mvTask, Task<? extends Serializable> currTask, HiveConf hconf) {
        AbstractOperatorDesc work;
        MoveWork mvWork = (MoveWork)mvTask.getWork();
        StatsWork statsWork = null;
        if (mvWork.getLoadTableWork() != null) {
            statsWork = new StatsWork(mvWork.getLoadTableWork());
        } else if (mvWork.getLoadFileWork() != null) {
            statsWork = new StatsWork(mvWork.getLoadFileWork());
        }
        assert (statsWork != null) : "Error when genereting StatsTask";
        statsWork.setSourceTask(currTask);
        statsWork.setStatsReliable(hconf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE));
        statsWork.setStatsTmpDir(((FileSinkDesc)nd.getConf()).getStatsTmpDir());
        if (currTask.getWork() instanceof MapredWork) {
            MapredWork mrWork = (MapredWork)currTask.getWork();
            mrWork.getMapWork().setGatheringStats(true);
            if (mrWork.getReduceWork() != null) {
                mrWork.getReduceWork().setGatheringStats(true);
            }
        } else if (currTask.getWork() instanceof SparkWork) {
            work = (SparkWork)currTask.getWork();
            for (BaseWork w : ((SparkWork)work).getAllWork()) {
                w.setGatheringStats(true);
            }
        } else {
            work = (TezWork)currTask.getWork();
            for (BaseWork w : ((TezWork)work).getAllWork()) {
                w.setGatheringStats(true);
            }
        }
        statsWork.setAggKey(((FileSinkDesc)nd.getConf()).getStatsAggPrefix());
        Task<StatsWork> statsTask = TaskFactory.get(statsWork, hconf, new Task[0]);
        ((FileSinkDesc)nd.getConf()).setGatherStats(true);
        ((FileSinkDesc)nd.getConf()).setStatsReliable(hconf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE));
        mvTask.addDependentTask(statsTask);
        statsTask.subscribeFeed(mvTask);
    }

    public static boolean isInsertInto(ParseContext parseCtx, FileSinkOperator fsOp) {
        return ((FileSinkDesc)fsOp.getConf()).getTableInfo().getTableName() != null;
    }

    private static MapWork createMRWorkForMergingFiles(HiveConf conf, TableScanOperator topOp, FileSinkDesc fsDesc) {
        ArrayList<String> aliases = new ArrayList<String>();
        String inputDir = fsDesc.getFinalDirName().toString();
        TableDesc tblDesc = fsDesc.getTableInfo();
        aliases.add(inputDir);
        MapredWork cMrPlan = GenMapRedUtils.getMapRedWorkFromConf(conf);
        MapWork cplan = cMrPlan.getMapWork();
        cplan.getPathToAliases().put(inputDir, aliases);
        cplan.getPathToPartitionInfo().put(inputDir, new PartitionDesc(tblDesc, null));
        cplan.getAliasToWork().put(inputDir, topOp);
        cplan.setMapperCannotSpanPartns(true);
        return cplan;
    }

    public static MapWork createMergeTask(FileSinkDesc fsInputDesc, Path finalName, boolean hasDynamicPartitions, CompilationOpContext ctx) throws SemanticException {
        Class internalIFClass;
        Path inputDir = fsInputDesc.getFinalDirName();
        TableDesc tblDesc = fsInputDesc.getTableInfo();
        ArrayList<Path> inputDirs = new ArrayList<Path>(1);
        ArrayList<String> inputDirstr = new ArrayList<String>(1);
        if (!hasDynamicPartitions && !GenMapRedUtils.isSkewedStoredAsDirs(fsInputDesc)) {
            inputDirs.add(inputDir);
        }
        inputDirstr.add(inputDir.toString());
        if (tblDesc.getInputFileFormatClass().equals(RCFileInputFormat.class)) {
            internalIFClass = RCFileBlockMergeInputFormat.class;
        } else if (tblDesc.getInputFileFormatClass().equals(OrcInputFormat.class)) {
            internalIFClass = OrcFileStripeMergeInputFormat.class;
        } else {
            throw new SemanticException("createMergeTask called on a table with file format other than RCFile or ORCFile");
        }
        MergeFileWork work = new MergeFileWork(inputDirs, finalName, hasDynamicPartitions, tblDesc.getInputFileFormatClass().getName());
        LinkedHashMap<String, ArrayList<String>> pathToAliases = new LinkedHashMap<String, ArrayList<String>>();
        pathToAliases.put(inputDir.toString(), inputDirstr);
        work.setMapperCannotSpanPartns(true);
        work.setPathToAliases(pathToAliases);
        PartitionDesc pDesc = new PartitionDesc(tblDesc, null);
        pDesc.setInputFileFormatClass(internalIFClass);
        work.getPathToPartitionInfo().put(inputDir.toString(), pDesc);
        work.setListBucketingCtx(fsInputDesc.getLbCtx());
        LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = new LinkedHashMap<String, Operator<? extends OperatorDesc>>();
        Operator<FileMergeDesc> mergeOp = null;
        FileMergeDesc fmd = tblDesc.getInputFileFormatClass().equals(RCFileInputFormat.class) ? new RCFileMergeDesc() : new OrcFileMergeDesc();
        fmd.setDpCtx(fsInputDesc.getDynPartCtx());
        fmd.setOutputPath(finalName);
        fmd.setHasDynamicPartitions(work.hasDynamicPartitions());
        fmd.setListBucketingAlterTableConcatenate(work.isListBucketingAlterTableConcatenate());
        int lbLevel = work.getListBucketingCtx() == null ? 0 : work.getListBucketingCtx().calculateListBucketingLevel();
        fmd.setListBucketingDepth(lbLevel);
        mergeOp = OperatorFactory.get(ctx, fmd);
        aliasToWork.put(inputDir.toString(), mergeOp);
        work.setAliasToWork(aliasToWork);
        return work;
    }

    public static ConditionalTask createCondTask(HiveConf conf, Task<? extends Serializable> currTask, MoveWork mvWork, Serializable mergeWork, String inputPath) {
        Task<Serializable> mergeOnlyMergeTask = TaskFactory.get(mergeWork, conf, new Task[0]);
        Task<MoveWork> moveOnlyMoveTask = TaskFactory.get(mvWork, conf, new Task[0]);
        Task<Serializable> mergeAndMoveMergeTask = TaskFactory.get(mergeWork, conf, new Task[0]);
        Task<MoveWork> mergeAndMoveMoveTask = TaskFactory.get(mvWork, conf, new Task[0]);
        mergeAndMoveMergeTask.addDependentTask(mergeAndMoveMoveTask);
        ArrayList<Serializable> listWorks = new ArrayList<Serializable>();
        listWorks.add(mvWork);
        listWorks.add(mergeWork);
        ConditionalWork cndWork = new ConditionalWork(listWorks);
        ArrayList<Task<? extends Serializable>> listTasks = new ArrayList<Task<? extends Serializable>>();
        listTasks.add(moveOnlyMoveTask);
        listTasks.add(mergeOnlyMergeTask);
        listTasks.add(mergeAndMoveMergeTask);
        ConditionalTask cndTsk = (ConditionalTask)TaskFactory.get(cndWork, conf, new Task[0]);
        cndTsk.setListTasks(listTasks);
        cndTsk.setResolver(new ConditionalResolverMergeFiles());
        ConditionalResolverMergeFiles.ConditionalResolverMergeFilesCtx mrCtx = new ConditionalResolverMergeFiles.ConditionalResolverMergeFilesCtx(listTasks, inputPath);
        cndTsk.setResolverCtx(mrCtx);
        currTask.addDependentTask(cndTsk);
        return cndTsk;
    }

    public static boolean isSkewedStoredAsDirs(FileSinkDesc fsInputDesc) {
        return fsInputDesc.getLbCtx() == null ? false : fsInputDesc.getLbCtx().isSkewedStoredAsDir();
    }

    public static Task<MoveWork> findMoveTask(List<Task<MoveWork>> mvTasks, FileSinkOperator fsOp) {
        for (Task<MoveWork> mvTsk : mvTasks) {
            MoveWork mvWork = mvTsk.getWork();
            Path srcDir = null;
            if (mvWork.getLoadFileWork() != null) {
                srcDir = mvWork.getLoadFileWork().getSourcePath();
            } else if (mvWork.getLoadTableWork() != null) {
                srcDir = mvWork.getLoadTableWork().getSourcePath();
            }
            if (srcDir == null || !srcDir.equals((Object)((FileSinkDesc)fsOp.getConf()).getFinalDirName())) continue;
            return mvTsk;
        }
        return null;
    }

    public static boolean isMergeRequired(List<Task<MoveWork>> mvTasks, HiveConf hconf, FileSinkOperator fsOp, Task<? extends Serializable> currTask, boolean isInsertTable) {
        if (mvTasks != null && !mvTasks.isEmpty()) {
            MoveTask mvTask = (MoveTask)GenMapRedUtils.findMoveTask(mvTasks, fsOp);
            if (mvTask != null && isInsertTable && hconf.getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER) && !((FileSinkDesc)fsOp.getConf()).isMaterialization()) {
                GenMapRedUtils.addStatsTask(fsOp, mvTask, currTask, hconf);
            }
            if (mvTask != null && !mvTask.isLocal() && ((FileSinkDesc)fsOp.getConf()).canBeMerged()) {
                if (currTask.getWork() instanceof TezWork) {
                    return hconf.getBoolVar(HiveConf.ConfVars.HIVEMERGETEZFILES);
                }
                if (currTask.getWork() instanceof SparkWork) {
                    return hconf.getBoolVar(HiveConf.ConfVars.HIVEMERGESPARKFILES);
                }
                if (((FileSinkDesc)fsOp.getConf()).isLinkedFileSink()) {
                    if (hconf.getBoolVar(HiveConf.ConfVars.HIVEMERGEMAPFILES) || hconf.getBoolVar(HiveConf.ConfVars.HIVEMERGEMAPREDFILES)) {
                        return true;
                    }
                } else if (currTask.getWork() instanceof MapredWork) {
                    boolean mergeMapRed;
                    ReduceWork reduceWork = ((MapredWork)currTask.getWork()).getReduceWork();
                    boolean mergeMapOnly = hconf.getBoolVar(HiveConf.ConfVars.HIVEMERGEMAPFILES) && reduceWork == null;
                    boolean bl = mergeMapRed = hconf.getBoolVar(HiveConf.ConfVars.HIVEMERGEMAPREDFILES) && reduceWork != null;
                    if (mergeMapOnly || mergeMapRed) {
                        return true;
                    }
                } else {
                    return false;
                }
            }
        }
        return false;
    }

    public static Path createMoveTask(Task<? extends Serializable> currTask, boolean chDir, FileSinkOperator fsOp, ParseContext parseCtx, List<Task<MoveWork>> mvTasks, HiveConf hconf, DependencyCollectionTask dependencyTask) {
        Path dest = null;
        if (chDir) {
            dest = ((FileSinkDesc)fsOp.getConf()).getFinalDirName();
            Context baseCtx = parseCtx.getContext();
            Path tmpDir = baseCtx.getExternalTmpPath(dest);
            FileSinkDesc fileSinkDesc = (FileSinkDesc)fsOp.getConf();
            if (fileSinkDesc.isLinkedFileSink()) {
                for (FileSinkDesc fsConf : fileSinkDesc.getLinkedFileSinkDesc()) {
                    fsConf.setParentDir(tmpDir);
                    fsConf.setDirName(new Path(tmpDir, fsConf.getDirName().getName()));
                }
            } else {
                fileSinkDesc.setDirName(tmpDir);
            }
        }
        Task<MoveWork> mvTask = null;
        if (!chDir) {
            mvTask = GenMapRedUtils.findMoveTask(mvTasks, fsOp);
        }
        if (mvTask != null) {
            GenMapRedUtils.addDependentMoveTasks(mvTask, hconf, currTask, dependencyTask);
        }
        return dest;
    }

    public static Set<Partition> getConfirmedPartitionsForScan(TableScanOperator tableScanOp) {
        HashSet<Partition> confirmedPartns = new HashSet<Partition>();
        BaseSemanticAnalyzer.TableSpec tblSpec = ((TableScanDesc)tableScanOp.getConf()).getTableMetadata().getTableSpec();
        if (tblSpec.specType == BaseSemanticAnalyzer.TableSpec.SpecType.STATIC_PARTITION) {
            if (tblSpec.partHandle != null) {
                confirmedPartns.add(tblSpec.partHandle);
            } else {
                confirmedPartns.addAll(tblSpec.partitions);
            }
        } else if (tblSpec.specType == BaseSemanticAnalyzer.TableSpec.SpecType.DYNAMIC_PARTITION) {
            confirmedPartns.addAll(tblSpec.partitions);
        }
        return confirmedPartns;
    }

    public static List<String> getPartitionColumns(TableScanOperator tableScanOp) {
        BaseSemanticAnalyzer.TableSpec tblSpec = ((TableScanDesc)tableScanOp.getConf()).getTableMetadata().getTableSpec();
        if (tblSpec.tableHandle.isPartitioned()) {
            return new ArrayList<String>(tblSpec.getPartSpec().keySet());
        }
        return Collections.emptyList();
    }

    public static List<Path> getInputPathsForPartialScan(TableScanOperator tableScanOp, Appendable aggregationKey) throws SemanticException {
        ArrayList<Path> inputPaths = new ArrayList<Path>();
        switch (((TableScanDesc)tableScanOp.getConf()).getTableMetadata().getTableSpec().specType) {
            case TABLE_ONLY: {
                inputPaths.add(((TableScanDesc)tableScanOp.getConf()).getTableMetadata().getTableSpec().tableHandle.getPath());
                break;
            }
            case STATIC_PARTITION: {
                Partition part = ((TableScanDesc)tableScanOp.getConf()).getTableMetadata().getTableSpec().partHandle;
                try {
                    aggregationKey.append(Warehouse.makePartPath(part.getSpec()));
                }
                catch (MetaException e) {
                    throw new SemanticException(ErrorMsg.ANALYZE_TABLE_PARTIALSCAN_AGGKEY.getMsg(part.getDataLocation().toString() + e.getMessage()));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                inputPaths.add(part.getDataLocation());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return inputPaths;
    }

    public static Set<String> findAliases(MapWork work, Operator<?> startOp) {
        LinkedHashSet<String> aliases = new LinkedHashSet<String>();
        for (Operator<?> topOp : GenMapRedUtils.findTopOps(startOp, null)) {
            String alias = GenMapRedUtils.findAlias(work, topOp);
            if (alias == null) continue;
            aliases.add(alias);
        }
        return aliases;
    }

    public static Set<Operator<?>> findTopOps(Operator<?> startOp, final Class<?> clazz) {
        final LinkedHashSet operators = new LinkedHashSet();
        OperatorUtils.iterateParents(startOp, new NodeUtils.Function<Operator<?>>(){

            @Override
            public void apply(Operator<?> argument) {
                if (argument.getNumParent() == 0 && (clazz == null || clazz.isInstance(argument))) {
                    operators.add(argument);
                }
            }
        });
        return operators;
    }

    public static String findAlias(MapWork work, Operator<?> operator) {
        for (Map.Entry<String, Operator<? extends OperatorDesc>> entry : work.getAliasToWork().entrySet()) {
            if (entry.getValue() != operator) continue;
            return entry.getKey();
        }
        return null;
    }

    static void usePartitionColumns(Properties properties, List<String> partColNames) {
        Preconditions.checkArgument(!partColNames.isEmpty(), "No partition columns provided to use");
        Preconditions.checkArgument(new HashSet<String>(partColNames).size() == partColNames.size(), "Partition columns should be unique: " + partColNames);
        Object[] partNames = properties.getProperty("partition_columns").split("/");
        Object[] partTypes = properties.getProperty("partition_columns.types").split(":");
        Preconditions.checkArgument(partNames.length == partTypes.length, "Partition Names, " + Arrays.toString(partNames) + " don't match partition Types, " + Arrays.toString(partTypes));
        HashMap<Object, Object> typeMap = new HashMap<Object, Object>();
        for (int i = 0; i < partNames.length; ++i) {
            String previousValue = (String)typeMap.put(partNames[i], partTypes[i]);
            Preconditions.checkArgument(previousValue == null, "Partition columns configuration is inconsistent. There are duplicates in partition column names: " + partNames);
        }
        StringBuilder partNamesBuf = new StringBuilder();
        StringBuilder partTypesBuf = new StringBuilder();
        for (String partName : partColNames) {
            partNamesBuf.append(partName).append('/');
            String partType = (String)typeMap.get(partName);
            if (partType == null) {
                throw new RuntimeException("Type information for partition column " + partName + " is missing.");
            }
            partTypesBuf.append(partType).append(':');
        }
        partNamesBuf.setLength(partNamesBuf.length() - 1);
        partTypesBuf.setLength(partTypesBuf.length() - 1);
        properties.setProperty("partition_columns", partNamesBuf.toString());
        properties.setProperty("partition_columns.types", partTypesBuf.toString());
    }

    private GenMapRedUtils() {
    }
}

