/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Timestamp;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.util.DateTimeMath;
import org.apache.hadoop.hive.serde2.io.DateWritable;

public class DateColSubtractDateColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;
    private int outputColumn;
    private Timestamp scratchTimestamp1;
    private Timestamp scratchTimestamp2;
    private DateTimeMath dtm = new DateTimeMath();

    public DateColSubtractDateColumn(int colNum1, int colNum2, int outputColumn) {
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
        this.outputColumn = outputColumn;
        this.scratchTimestamp1 = new Timestamp(0L);
        this.scratchTimestamp2 = new Timestamp(0L);
    }

    public DateColSubtractDateColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector1 = (LongColumnVector)batch.cols[this.colNum1];
        LongColumnVector inputColVector2 = (LongColumnVector)batch.cols[this.colNum2];
        IntervalDayTimeColumnVector outputColVector = (IntervalDayTimeColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        long[] vector1 = inputColVector1.vector;
        long[] vector2 = inputColVector2.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = inputColVector1.isRepeating && inputColVector2.isRepeating || inputColVector1.isRepeating && !inputColVector1.noNulls && inputColVector1.isNull[0] || inputColVector2.isRepeating && !inputColVector2.noNulls && inputColVector2.isNull[0];
        NullUtil.propagateNullsColCol(inputColVector1, inputColVector2, outputColVector, sel, n, batch.selectedInUse);
        HiveIntervalDayTime resultIntervalDayTime = outputColVector.getScratchIntervalDayTime();
        if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            this.scratchTimestamp1.setTime(DateWritable.daysToMillis((int)vector1[0]));
            this.scratchTimestamp2.setTime(DateWritable.daysToMillis((int)vector2[0]));
            this.dtm.subtract(this.scratchTimestamp1, this.scratchTimestamp2, outputColVector.getScratchIntervalDayTime());
            outputColVector.setFromScratchIntervalDayTime(0);
        } else if (inputColVector1.isRepeating) {
            this.scratchTimestamp1.setTime(DateWritable.daysToMillis((int)vector1[0]));
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.scratchTimestamp2.setTime(DateWritable.daysToMillis((int)vector2[i]));
                    this.dtm.subtract(this.scratchTimestamp1, this.scratchTimestamp2, outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.scratchTimestamp2.setTime(DateWritable.daysToMillis((int)vector2[i]));
                    this.dtm.subtract(this.scratchTimestamp1, this.scratchTimestamp2, outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                }
            }
        } else if (inputColVector2.isRepeating) {
            this.scratchTimestamp2.setTime(DateWritable.daysToMillis((int)vector2[0]));
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.scratchTimestamp1.setTime(DateWritable.daysToMillis((int)vector1[i]));
                    this.dtm.subtract(this.scratchTimestamp1, this.scratchTimestamp2, outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.scratchTimestamp1.setTime(DateWritable.daysToMillis((int)vector1[i]));
                    this.dtm.subtract(this.scratchTimestamp1, this.scratchTimestamp2, outputColVector.getScratchIntervalDayTime());
                    outputColVector.setFromScratchIntervalDayTime(i);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                this.scratchTimestamp1.setTime(DateWritable.daysToMillis((int)vector1[i]));
                this.scratchTimestamp2.setTime(DateWritable.daysToMillis((int)vector2[i]));
                this.dtm.subtract(this.scratchTimestamp1, this.scratchTimestamp2, outputColVector.getScratchIntervalDayTime());
                outputColVector.setFromScratchIntervalDayTime(i);
            }
        } else {
            for (int i = 0; i != n; ++i) {
                this.scratchTimestamp1.setTime(DateWritable.daysToMillis((int)vector1[i]));
                this.scratchTimestamp2.setTime(DateWritable.daysToMillis((int)vector2[i]));
                this.dtm.subtract(this.scratchTimestamp1, this.scratchTimestamp2, outputColVector.getScratchIntervalDayTime());
                outputColVector.setFromScratchIntervalDayTime(i);
            }
        }
        NullUtil.setNullDataEntriesIntervalDayTime(outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "timestamp";
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("date"), VectorExpressionDescriptor.ArgumentType.getType("date")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

