/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.AlterHandler;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hive.common.util.HiveStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAlterHandler
implements AlterHandler {
    protected Configuration hiveConf;
    private static final Logger LOG = LoggerFactory.getLogger((String)HiveAlterHandler.class.getName());

    public Configuration getConf() {
        return this.hiveConf;
    }

    public void setConf(Configuration conf) {
        this.hiveConf = conf;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void alterTable(RawStore msdb, Warehouse wh, String dbname, String name, Table newt, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException {
        boolean success;
        block45: {
            boolean cascade;
            boolean bl = cascade = environmentContext != null && environmentContext.isSetProperties() && "true".equals(environmentContext.getProperties().get("CASCADE"));
            if (newt == null) {
                throw new InvalidOperationException("New table is invalid: " + newt);
            }
            if (!MetaStoreUtils.validateName(newt.getTableName(), this.hiveConf)) {
                throw new InvalidOperationException(newt.getTableName() + " is not a valid object name");
            }
            String validate = MetaStoreUtils.validateTblColumns(newt.getSd().getCols());
            if (validate != null) {
                throw new InvalidOperationException("Invalid column " + validate);
            }
            Path srcPath = null;
            FileSystem srcFs = null;
            Path destPath = null;
            FileSystem destFs = null;
            success = false;
            boolean moveData = false;
            boolean rename = false;
            Table oldt = null;
            ArrayList<ObjectPair<Partition, String>> altps = new ArrayList<ObjectPair<Partition, String>>();
            try {
                Database db;
                msdb.openTransaction();
                name = name.toLowerCase();
                dbname = dbname.toLowerCase();
                if (!newt.getTableName().equalsIgnoreCase(name) || !newt.getDbName().equalsIgnoreCase(dbname)) {
                    if (msdb.getTable(newt.getDbName(), newt.getTableName()) != null) {
                        throw new InvalidOperationException("new table " + newt.getDbName() + "." + newt.getTableName() + " already exists");
                    }
                    rename = true;
                }
                if ((oldt = msdb.getTable(dbname, name)) == null) {
                    throw new InvalidOperationException("table " + dbname + "." + name + " doesn't exist");
                }
                if (HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.METASTORE_DISALLOW_INCOMPATIBLE_COL_TYPE_CHANGES, false)) {
                    MetaStoreUtils.throwExceptionIfIncompatibleColTypeChange(oldt.getSd().getCols(), newt.getSd().getCols());
                }
                if (cascade) {
                    if (MetaStoreUtils.isCascadeNeededInAlterTable(oldt, newt)) {
                        List<Partition> parts = msdb.getPartitions(dbname, name, -1);
                        for (Partition part : parts) {
                            List<FieldSchema> list = part.getSd().getCols();
                            part.getSd().setCols(newt.getSd().getCols());
                            String string = Warehouse.makePartName(oldt.getPartitionKeys(), part.getValues());
                            this.updatePartColumnStatsForAlterColumns(msdb, part, string, part.getValues(), list, part);
                            msdb.alterPartition(dbname, name, part.getValues(), part);
                        }
                    } else {
                        LOG.warn("Alter table does not cascade changes to its partitions.");
                    }
                }
                boolean partKeysPartiallyEqual = this.checkPartialPartKeysEqual(oldt.getPartitionKeys(), newt.getPartitionKeys());
                if (!oldt.getTableType().equals(TableType.VIRTUAL_VIEW.toString())) {
                    if (oldt.getPartitionKeys().size() != newt.getPartitionKeys().size()) throw new InvalidOperationException("partition keys can not be changed.");
                    if (!partKeysPartiallyEqual) {
                        throw new InvalidOperationException("partition keys can not be changed.");
                    }
                }
                if (rename && !oldt.getTableType().equals(TableType.VIRTUAL_VIEW.toString()) && (oldt.getSd().getLocation().compareTo(newt.getSd().getLocation()) == 0 || StringUtils.isEmpty(newt.getSd().getLocation())) && !MetaStoreUtils.isExternalTable(oldt)) {
                    srcPath = new Path(oldt.getSd().getLocation());
                    srcFs = wh.getFs(srcPath);
                    db = msdb.getDatabase(newt.getDbName());
                    Path databasePath = this.constructRenamedPath(wh.getDatabasePath(db), srcPath);
                    destPath = new Path(databasePath, newt.getTableName().toLowerCase());
                    destFs = wh.getFs(destPath);
                    newt.getSd().setLocation(destPath.toString());
                    moveData = true;
                    if (!FileUtils.equalsFileSystem(srcFs, destFs)) {
                        throw new InvalidOperationException("table new location " + destPath + " is on a different file system than the old location " + srcPath + ". This operation is not supported");
                    }
                    try {
                        srcFs.exists(srcPath);
                        if (destFs.exists(destPath)) {
                            throw new InvalidOperationException("New location for this table " + newt.getDbName() + "." + newt.getTableName() + " already exists : " + destPath);
                        }
                    }
                    catch (IOException iOException) {
                        throw new InvalidOperationException("Unable to access new location " + destPath + " for table " + newt.getDbName() + "." + newt.getTableName());
                    }
                    String string = srcPath.toUri().getPath();
                    String string2 = destPath.toUri().getPath();
                    List<Partition> parts = msdb.getPartitions(dbname, name, -1);
                    for (Partition part : parts) {
                        String oldPartLoc = part.getSd().getLocation();
                        if (!oldPartLoc.contains(string)) continue;
                        URI oldUri = new Path(oldPartLoc).toUri();
                        String newPath = oldUri.getPath().replace(string, string2);
                        Path newPartLocPath = new Path(oldUri.getScheme(), oldUri.getAuthority(), newPath);
                        altps.add(ObjectPair.create(part, part.getSd().getLocation()));
                        part.getSd().setLocation(newPartLocPath.toString());
                        String oldPartName = Warehouse.makePartName(oldt.getPartitionKeys(), part.getValues());
                        try {
                            msdb.deletePartitionColumnStatistics(dbname, name, oldPartName, part.getValues(), null);
                        }
                        catch (InvalidInputException iie) {
                            throw new InvalidOperationException("Unable to update partition stats in table rename." + iie);
                        }
                        msdb.alterPartition(dbname, name, part.getValues(), part);
                    }
                } else if (MetaStoreUtils.requireCalStats(this.hiveConf, null, null, newt, environmentContext) && newt.getPartitionKeysSize() == 0) {
                    db = msdb.getDatabase(newt.getDbName());
                    MetaStoreUtils.updateTableStatsFast(db, newt, wh, false, true, environmentContext);
                }
                this.alterTableUpdateTableColumnStats(msdb, oldt, newt);
                success = msdb.commitTransaction();
                if (!success) {
                    msdb.rollbackTransaction();
                }
                if (!success || !moveData) break block45;
            }
            catch (InvalidObjectException e) {
                try {
                    LOG.debug("Failed to get object from Metastore ", (Throwable)e);
                    throw new InvalidOperationException("Unable to change partition or table. Check metastore logs for detailed stack." + e.getMessage());
                    catch (NoSuchObjectException e2) {
                        LOG.debug("Object not found in metastore ", (Throwable)e2);
                        throw new InvalidOperationException("Unable to change partition or table. Database " + dbname + " does not exist" + " Check metastore logs for detailed stack." + e2.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (!success) {
                        msdb.rollbackTransaction();
                    }
                    if (!success) throw throwable;
                    if (!moveData) throw throwable;
                    try {
                        if (!srcFs.exists(srcPath)) throw throwable;
                        if (srcFs.rename(srcPath, destPath)) throw throwable;
                        throw new IOException("Renaming " + srcPath + " to " + destPath + " failed");
                    }
                    catch (IOException e3) {
                        LOG.error("Alter Table operation for " + dbname + "." + name + " failed.", (Throwable)e3);
                        boolean revertMetaDataTransaction = false;
                        try {
                            msdb.openTransaction();
                            msdb.alterTable(newt.getDbName(), newt.getTableName(), oldt);
                            Iterator i$ = altps.iterator();
                            while (true) {
                                if (!i$.hasNext()) {
                                    revertMetaDataTransaction = msdb.commitTransaction();
                                    throw new InvalidOperationException("Alter Table operation for " + dbname + "." + name + " failed to move data due to: '" + this.getSimpleMessage(e3) + "' See hive log file for details.");
                                }
                                ObjectPair objectPair = (ObjectPair)i$.next();
                                Partition partition = (Partition)objectPair.getFirst();
                                partition.getSd().setLocation((String)objectPair.getSecond());
                                msdb.alterPartition(newt.getDbName(), name, partition.getValues(), partition);
                            }
                        }
                        catch (Exception e1) {
                            LOG.error("Reverting metadata by HDFS operation failure failed During HDFS operation failed", (Throwable)e1);
                            LOG.error("Table " + Warehouse.getQualifiedName(newt) + " should be renamed to " + Warehouse.getQualifiedName(oldt));
                            LOG.error("Table " + Warehouse.getQualifiedName(newt) + " should have path " + srcPath);
                            for (ObjectPair objectPair : altps) {
                                LOG.error("Partition " + Warehouse.getQualifiedName((Partition)objectPair.getFirst()) + " should have path " + (String)objectPair.getSecond());
                            }
                            if (revertMetaDataTransaction) throw new InvalidOperationException("Alter Table operation for " + dbname + "." + name + " failed to move data due to: '" + this.getSimpleMessage(e3) + "' See hive log file for details.");
                            msdb.rollbackTransaction();
                        }
                        throw new InvalidOperationException("Alter Table operation for " + dbname + "." + name + " failed to move data due to: '" + this.getSimpleMessage(e3) + "' See hive log file for details.");
                    }
                }
            }
            try {
                if (srcFs.exists(srcPath) && !srcFs.rename(srcPath, destPath)) {
                    throw new IOException("Renaming " + srcPath + " to " + destPath + " failed");
                }
            }
            catch (IOException e) {
                LOG.error("Alter Table operation for " + dbname + "." + name + " failed.", (Throwable)e);
                boolean revertMetaDataTransaction = false;
                try {
                    msdb.openTransaction();
                    msdb.alterTable(newt.getDbName(), newt.getTableName(), oldt);
                    Iterator i$ = altps.iterator();
                    while (true) {
                        if (!i$.hasNext()) {
                            revertMetaDataTransaction = msdb.commitTransaction();
                            throw new InvalidOperationException("Alter Table operation for " + dbname + "." + name + " failed to move data due to: '" + this.getSimpleMessage(e) + "' See hive log file for details.");
                        }
                        ObjectPair objectPair = (ObjectPair)i$.next();
                        Partition partition = (Partition)objectPair.getFirst();
                        partition.getSd().setLocation((String)objectPair.getSecond());
                        msdb.alterPartition(newt.getDbName(), name, partition.getValues(), partition);
                    }
                }
                catch (Exception e1) {
                    LOG.error("Reverting metadata by HDFS operation failure failed During HDFS operation failed", (Throwable)e1);
                    LOG.error("Table " + Warehouse.getQualifiedName(newt) + " should be renamed to " + Warehouse.getQualifiedName(oldt));
                    LOG.error("Table " + Warehouse.getQualifiedName(newt) + " should have path " + srcPath);
                    for (ObjectPair objectPair : altps) {
                        LOG.error("Partition " + Warehouse.getQualifiedName((Partition)objectPair.getFirst()) + " should have path " + (String)objectPair.getSecond());
                    }
                    if (revertMetaDataTransaction) throw new InvalidOperationException("Alter Table operation for " + dbname + "." + name + " failed to move data due to: '" + this.getSimpleMessage(e) + "' See hive log file for details.");
                    msdb.rollbackTransaction();
                }
                throw new InvalidOperationException("Alter Table operation for " + dbname + "." + name + " failed to move data due to: '" + this.getSimpleMessage(e) + "' See hive log file for details.");
            }
        }
        if (success) return;
        throw new MetaException("Committing the alter table transaction was not successful.");
    }

    String getSimpleMessage(IOException ex) {
        if (ex instanceof RemoteException) {
            String msg = ex.getMessage();
            if (msg == null || !msg.contains("\n")) {
                return msg;
            }
            return msg.substring(0, msg.indexOf(10));
        }
        return ex.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Partition alterPartition(RawStore msdb, Warehouse wh, String dbname, String name, List<String> part_vals, Partition new_part, EnvironmentContext environmentContext) throws InvalidOperationException, InvalidObjectException, AlreadyExistsException, MetaException {
        boolean success = false;
        Path srcPath = null;
        Path destPath = null;
        FileSystem srcFs = null;
        FileSystem destFs = null;
        Partition oldPart = null;
        String oldPartLoc = null;
        String newPartLoc = null;
        if (new_part.getParameters() == null || new_part.getParameters().get("transient_lastDdlTime") == null || Integer.parseInt(new_part.getParameters().get("transient_lastDdlTime")) == 0) {
            new_part.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
        }
        Table tbl = msdb.getTable(dbname, name);
        if (part_vals == null || part_vals.size() == 0) {
            try {
                oldPart = msdb.getPartition(dbname, name, new_part.getValues());
                if (MetaStoreUtils.requireCalStats(this.hiveConf, oldPart, new_part, tbl, environmentContext)) {
                    MetaStoreUtils.updatePartitionStatsFast(new_part, wh, false, true, environmentContext);
                }
                this.updatePartColumnStats(msdb, dbname, name, new_part.getValues(), new_part);
                msdb.alterPartition(dbname, name, new_part.getValues(), new_part);
                return oldPart;
            }
            catch (InvalidObjectException e) {
                throw new InvalidOperationException("alter is not possible");
            }
            catch (NoSuchObjectException e) {
                throw new InvalidOperationException("alter is not possible");
            }
        }
        try {
            String oldPartName;
            msdb.openTransaction();
            try {
                oldPart = msdb.getPartition(dbname, name, part_vals);
            }
            catch (NoSuchObjectException e) {
                throw new InvalidObjectException("Unable to rename partition because old partition does not exist");
            }
            Partition check_part = null;
            try {
                check_part = msdb.getPartition(dbname, name, new_part.getValues());
            }
            catch (NoSuchObjectException e) {
                check_part = null;
            }
            if (check_part != null) {
                throw new AlreadyExistsException("Partition already exists:" + dbname + "." + name + "." + new_part.getValues());
            }
            if (tbl == null) {
                throw new InvalidObjectException("Unable to rename partition because table or database do not exist");
            }
            if (tbl.getTableType().equals(TableType.EXTERNAL_TABLE.toString())) {
                new_part.getSd().setLocation(oldPart.getSd().getLocation());
                oldPartName = Warehouse.makePartName(tbl.getPartitionKeys(), oldPart.getValues());
                try {
                    msdb.deletePartitionColumnStatistics(dbname, name, oldPartName, oldPart.getValues(), null);
                }
                catch (NoSuchObjectException nsoe) {
                }
                catch (InvalidInputException iie) {
                    throw new InvalidOperationException("Unable to update partition stats in table rename." + iie);
                }
                msdb.alterPartition(dbname, name, part_vals, new_part);
            } else {
                try {
                    destPath = new Path(wh.getTablePath(msdb.getDatabase(dbname), name), Warehouse.makePartName(tbl.getPartitionKeys(), new_part.getValues()));
                    destPath = this.constructRenamedPath(destPath, new Path(new_part.getSd().getLocation()));
                }
                catch (NoSuchObjectException e) {
                    LOG.debug("Didn't find object in metastore ", (Throwable)e);
                    throw new InvalidOperationException("Unable to change partition or table. Database " + dbname + " does not exist" + " Check metastore logs for detailed stack." + e.getMessage());
                }
                if (destPath != null) {
                    newPartLoc = destPath.toString();
                    oldPartLoc = oldPart.getSd().getLocation();
                    srcPath = new Path(oldPartLoc);
                    LOG.info("srcPath:" + oldPartLoc);
                    LOG.info("descPath:" + newPartLoc);
                    srcFs = wh.getFs(srcPath);
                    destFs = wh.getFs(destPath);
                    if (!FileUtils.equalsFileSystem(srcFs, destFs)) {
                        throw new InvalidOperationException("table new location " + destPath + " is on a different file system than the old location " + srcPath + ". This operation is not supported");
                    }
                    try {
                        srcFs.exists(srcPath);
                        if (newPartLoc.compareTo(oldPartLoc) != 0 && destFs.exists(destPath)) {
                            throw new InvalidOperationException("New location for this table " + tbl.getDbName() + "." + tbl.getTableName() + " already exists : " + destPath);
                        }
                    }
                    catch (IOException e) {
                        throw new InvalidOperationException("Unable to access new location " + destPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + new_part.getValues());
                    }
                    new_part.getSd().setLocation(newPartLoc);
                    if (MetaStoreUtils.requireCalStats(this.hiveConf, oldPart, new_part, tbl, environmentContext)) {
                        MetaStoreUtils.updatePartitionStatsFast(new_part, wh, false, true, environmentContext);
                    }
                    oldPartName = Warehouse.makePartName(tbl.getPartitionKeys(), oldPart.getValues());
                    try {
                        msdb.deletePartitionColumnStatistics(dbname, name, oldPartName, oldPart.getValues(), null);
                    }
                    catch (NoSuchObjectException nsoe) {
                    }
                    catch (InvalidInputException iie) {
                        throw new InvalidOperationException("Unable to update partition stats in table rename." + iie);
                    }
                    msdb.alterPartition(dbname, name, part_vals, new_part);
                }
            }
            success = msdb.commitTransaction();
            if (!success) {
                msdb.rollbackTransaction();
            }
            if (!success || newPartLoc == null || newPartLoc.compareTo(oldPartLoc) == 0) return oldPart;
        }
        catch (Throwable throwable) {
            if (!success) {
                msdb.rollbackTransaction();
            }
            if (!success || newPartLoc == null || newPartLoc.compareTo(oldPartLoc) == 0) throw throwable;
            try {
                if (!srcFs.exists(srcPath)) throw throwable;
                Path destParentPath = destPath.getParent();
                if (!wh.mkdirs(destParentPath, true)) {
                    throw new IOException("Unable to create path " + destParentPath);
                }
                wh.renameDir(srcPath, destPath, true);
                LOG.info("rename done!");
                throw throwable;
            }
            catch (IOException e) {
                boolean revertMetaDataTransaction = false;
                try {
                    msdb.openTransaction();
                    msdb.alterPartition(dbname, name, new_part.getValues(), oldPart);
                    revertMetaDataTransaction = msdb.commitTransaction();
                    throw new InvalidOperationException("Unable to access old location " + srcPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + part_vals);
                }
                catch (Exception e1) {
                    LOG.error("Reverting metadata opeation failed During HDFS operation failed", (Throwable)e1);
                    if (revertMetaDataTransaction) throw new InvalidOperationException("Unable to access old location " + srcPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + part_vals);
                    msdb.rollbackTransaction();
                }
                throw new InvalidOperationException("Unable to access old location " + srcPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + part_vals);
            }
        }
        try {
            if (!srcFs.exists(srcPath)) return oldPart;
            Path destParentPath = destPath.getParent();
            if (!wh.mkdirs(destParentPath, true)) {
                throw new IOException("Unable to create path " + destParentPath);
            }
            wh.renameDir(srcPath, destPath, true);
            LOG.info("rename done!");
            return oldPart;
        }
        catch (IOException e) {
            boolean revertMetaDataTransaction = false;
            try {
                msdb.openTransaction();
                msdb.alterPartition(dbname, name, new_part.getValues(), oldPart);
                revertMetaDataTransaction = msdb.commitTransaction();
                throw new InvalidOperationException("Unable to access old location " + srcPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + part_vals);
            }
            catch (Exception e1) {
                LOG.error("Reverting metadata opeation failed During HDFS operation failed", (Throwable)e1);
                if (revertMetaDataTransaction) throw new InvalidOperationException("Unable to access old location " + srcPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + part_vals);
                msdb.rollbackTransaction();
            }
            throw new InvalidOperationException("Unable to access old location " + srcPath + " for partition " + tbl.getDbName() + "." + tbl.getTableName() + " " + part_vals);
        }
    }

    @Override
    public List<Partition> alterPartitions(RawStore msdb, Warehouse wh, String dbname, String name, List<Partition> new_parts, EnvironmentContext environmentContext) throws InvalidOperationException, InvalidObjectException, AlreadyExistsException, MetaException {
        ArrayList<Partition> oldParts = new ArrayList<Partition>();
        ArrayList<List<String>> partValsList = new ArrayList<List<String>>();
        Table tbl = msdb.getTable(dbname, name);
        try {
            for (Partition tmpPart : new_parts) {
                if (tmpPart.getParameters() == null || tmpPart.getParameters().get("transient_lastDdlTime") == null || Integer.parseInt(tmpPart.getParameters().get("transient_lastDdlTime")) == 0) {
                    tmpPart.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
                }
                Partition oldTmpPart = msdb.getPartition(dbname, name, tmpPart.getValues());
                oldParts.add(oldTmpPart);
                partValsList.add(tmpPart.getValues());
                if (MetaStoreUtils.requireCalStats(this.hiveConf, oldTmpPart, tmpPart, tbl, environmentContext)) {
                    MetaStoreUtils.updatePartitionStatsFast(tmpPart, wh, false, true, environmentContext);
                }
                this.updatePartColumnStats(msdb, dbname, name, oldTmpPart.getValues(), tmpPart);
            }
            msdb.alterPartitions(dbname, name, partValsList, new_parts);
        }
        catch (InvalidObjectException e) {
            throw new InvalidOperationException("alter is not possible");
        }
        catch (NoSuchObjectException e) {
            throw new InvalidOperationException("alter is not possible");
        }
        return oldParts;
    }

    private boolean checkPartialPartKeysEqual(List<FieldSchema> oldPartKeys, List<FieldSchema> newPartKeys) {
        if (newPartKeys == null || oldPartKeys == null) {
            return oldPartKeys == newPartKeys;
        }
        if (oldPartKeys.size() != newPartKeys.size()) {
            return false;
        }
        Iterator<FieldSchema> oldPartKeysIter = oldPartKeys.iterator();
        Iterator<FieldSchema> newPartKeysIter = newPartKeys.iterator();
        while (oldPartKeysIter.hasNext()) {
            FieldSchema oldFs = oldPartKeysIter.next();
            FieldSchema newFs = newPartKeysIter.next();
            if (oldFs.getName().equals(newFs.getName())) continue;
            return false;
        }
        return true;
    }

    private Path constructRenamedPath(Path defaultNewPath, Path currentPath) {
        URI currentUri = currentPath.toUri();
        return new Path(currentUri.getScheme(), currentUri.getAuthority(), defaultNewPath.toUri().getPath());
    }

    private void updatePartColumnStatsForAlterColumns(RawStore msdb, Partition oldPartition, String oldPartName, List<String> partVals, List<FieldSchema> oldCols, Partition newPart) throws MetaException, InvalidObjectException {
        String dbName = oldPartition.getDbName();
        String tableName = oldPartition.getTableName();
        try {
            ArrayList<String> oldPartNames = Lists.newArrayList(oldPartName);
            ArrayList<String> oldColNames = new ArrayList<String>(oldCols.size());
            for (FieldSchema oldCol : oldCols) {
                oldColNames.add(oldCol.getName());
            }
            List<FieldSchema> newCols = newPart.getSd().getCols();
            List<ColumnStatistics> partsColStats = msdb.getPartitionColumnStatistics(dbName, tableName, oldPartNames, oldColNames);
            assert (partsColStats.size() <= 1);
            for (ColumnStatistics partColStats : partsColStats) {
                List<ColumnStatisticsObj> statsObjs = partColStats.getStatsObj();
                for (ColumnStatisticsObj statsObj : statsObjs) {
                    boolean found = false;
                    for (FieldSchema newCol : newCols) {
                        if (!statsObj.getColName().equals(newCol.getName()) || !statsObj.getColType().equals(newCol.getType())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    msdb.deletePartitionColumnStatistics(dbName, tableName, oldPartName, partVals, statsObj.getColName());
                }
            }
        }
        catch (NoSuchObjectException nsoe) {
            LOG.debug("Could not find db entry." + nsoe);
        }
        catch (InvalidInputException iie) {
            throw new InvalidObjectException("Invalid input to update partition column stats in alter table change columns" + iie);
        }
    }

    private void updatePartColumnStats(RawStore msdb, String dbName, String tableName, List<String> partVals, Partition newPart) throws MetaException, InvalidObjectException {
        dbName = HiveStringUtils.normalizeIdentifier(dbName);
        tableName = HiveStringUtils.normalizeIdentifier(tableName);
        String newDbName = HiveStringUtils.normalizeIdentifier(newPart.getDbName());
        String newTableName = HiveStringUtils.normalizeIdentifier(newPart.getTableName());
        Table oldTable = msdb.getTable(dbName, tableName);
        if (oldTable == null) {
            return;
        }
        try {
            String oldPartName = Warehouse.makePartName(oldTable.getPartitionKeys(), partVals);
            String newPartName = Warehouse.makePartName(oldTable.getPartitionKeys(), newPart.getValues());
            if (!(dbName.equals(newDbName) && tableName.equals(newTableName) && oldPartName.equals(newPartName))) {
                msdb.deletePartitionColumnStatistics(dbName, tableName, oldPartName, partVals, null);
            } else {
                List<FieldSchema> oldCols;
                Partition oldPartition = msdb.getPartition(dbName, tableName, partVals);
                if (oldPartition == null) {
                    return;
                }
                if (oldPartition.getSd() != null && newPart.getSd() != null && !MetaStoreUtils.areSameColumns(oldCols = oldPartition.getSd().getCols(), newPart.getSd().getCols())) {
                    this.updatePartColumnStatsForAlterColumns(msdb, oldPartition, oldPartName, partVals, oldCols, newPart);
                }
            }
        }
        catch (NoSuchObjectException nsoe) {
            LOG.debug("Could not find db entry." + nsoe);
        }
        catch (InvalidInputException iie) {
            throw new InvalidObjectException("Invalid input to update partition column stats." + iie);
        }
    }

    private void alterTableUpdateTableColumnStats(RawStore msdb, Table oldTable, Table newTable) throws MetaException, InvalidObjectException {
        String dbName = oldTable.getDbName().toLowerCase();
        String tableName = HiveStringUtils.normalizeIdentifier(oldTable.getTableName());
        String newDbName = newTable.getDbName().toLowerCase();
        String newTableName = HiveStringUtils.normalizeIdentifier(newTable.getTableName());
        try {
            List<FieldSchema> oldCols = oldTable.getSd().getCols();
            List<FieldSchema> newCols = newTable.getSd().getCols();
            ArrayList<ColumnStatisticsObj> newStatsObjs = new ArrayList<ColumnStatisticsObj>();
            ColumnStatistics colStats = null;
            boolean updateColumnStats = true;
            if (newDbName.equals(dbName) && newTableName.equals(tableName) && MetaStoreUtils.areSameColumns(oldCols, newCols)) {
                updateColumnStats = false;
            }
            if (updateColumnStats) {
                ArrayList<String> oldColNames = new ArrayList<String>(oldCols.size());
                for (FieldSchema oldCol : oldCols) {
                    oldColNames.add(oldCol.getName());
                }
                colStats = msdb.getTableColumnStatistics(dbName, tableName, oldColNames);
                if (colStats == null) {
                    updateColumnStats = false;
                } else {
                    List<ColumnStatisticsObj> statsObjs = colStats.getStatsObj();
                    if (statsObjs != null) {
                        for (ColumnStatisticsObj statsObj : statsObjs) {
                            boolean found = false;
                            for (FieldSchema newCol : newCols) {
                                if (!statsObj.getColName().equalsIgnoreCase(newCol.getName()) || !statsObj.getColType().equals(newCol.getType())) continue;
                                found = true;
                                break;
                            }
                            if (found) {
                                if (newDbName.equals(dbName) && newTableName.equals(tableName)) continue;
                                msdb.deleteTableColumnStatistics(dbName, tableName, statsObj.getColName());
                                newStatsObjs.add(statsObj);
                                continue;
                            }
                            msdb.deleteTableColumnStatistics(dbName, tableName, statsObj.getColName());
                        }
                    }
                }
            }
            msdb.alterTable(dbName, tableName, newTable);
            if (updateColumnStats && !newStatsObjs.isEmpty()) {
                ColumnStatisticsDesc statsDesc = colStats.getStatsDesc();
                statsDesc.setDbName(newDbName);
                statsDesc.setTableName(newTableName);
                colStats.setStatsObj(newStatsObjs);
                msdb.updateTableColumnStatistics(colStats);
            }
        }
        catch (NoSuchObjectException nsoe) {
            LOG.debug("Could not find db entry." + nsoe);
        }
        catch (InvalidInputException e) {
            throw new InvalidObjectException("Invalid inputs to update table column stats: " + e);
        }
    }
}

