/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.hbase.io.TagCompressionContext;
import org.apache.hadoop.hbase.io.util.Dictionary;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor", "Phoenix"})
public class CompressionContext {
    static final String ENABLE_WAL_TAGS_COMPRESSION = "hbase.regionserver.wal.tags.enablecompression";
    public final Dictionary regionDict;
    public final Dictionary tableDict;
    public final Dictionary familyDict;
    final Dictionary qualifierDict;
    final Dictionary rowDict;
    TagCompressionContext tagCompressionContext = null;

    public CompressionContext(Class<? extends Dictionary> dictType, boolean recoveredEdits, boolean hasTagCompression) throws SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<? extends Dictionary> dictConstructor = dictType.getConstructor(new Class[0]);
        this.regionDict = dictConstructor.newInstance(new Object[0]);
        this.tableDict = dictConstructor.newInstance(new Object[0]);
        this.familyDict = dictConstructor.newInstance(new Object[0]);
        this.qualifierDict = dictConstructor.newInstance(new Object[0]);
        this.rowDict = dictConstructor.newInstance(new Object[0]);
        if (recoveredEdits) {
            this.regionDict.init(1);
            this.tableDict.init(1);
        } else {
            this.regionDict.init(Short.MAX_VALUE);
            this.tableDict.init(Short.MAX_VALUE);
        }
        this.rowDict.init(Short.MAX_VALUE);
        this.familyDict.init(127);
        this.qualifierDict.init(127);
        if (hasTagCompression) {
            this.tagCompressionContext = new TagCompressionContext(dictType, Short.MAX_VALUE);
        }
    }

    void clear() {
        this.regionDict.clear();
        this.tableDict.clear();
        this.familyDict.clear();
        this.qualifierDict.clear();
        this.rowDict.clear();
        if (this.tagCompressionContext != null) {
            this.tagCompressionContext.clear();
        }
    }
}

