/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.AbstractProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.FailedRemoteDispatchException;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class RegionTransitionProcedure
extends Procedure<MasterProcedureEnv>
implements TableProcedureInterface,
RemoteProcedureDispatcher.RemoteProcedure<MasterProcedureEnv, ServerName> {
    private static final Logger LOG = LoggerFactory.getLogger(RegionTransitionProcedure.class);
    protected final AtomicBoolean aborted = new AtomicBoolean(false);
    private MasterProcedureProtos.RegionTransitionState transitionState = MasterProcedureProtos.RegionTransitionState.REGION_TRANSITION_QUEUE;
    private RegionInfo regionInfo;
    private int attempt;
    private volatile boolean lock = false;

    public RegionTransitionProcedure() {
    }

    public RegionTransitionProcedure(RegionInfo regionInfo) {
        this.regionInfo = regionInfo;
    }

    @VisibleForTesting
    public RegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    protected void setRegionInfo(RegionInfo regionInfo) {
        this.regionInfo = regionInfo;
    }

    protected void setAttempt(int attempt) {
        this.attempt = attempt;
    }

    protected int getAttempt() {
        return this.attempt;
    }

    @Override
    public TableName getTableName() {
        RegionInfo hri = this.getRegionInfo();
        return hri != null ? hri.getTable() : null;
    }

    public boolean isMeta() {
        return TableName.isMetaTableName((TableName)this.getTableName());
    }

    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" table=");
        sb.append(this.getTableName());
        sb.append(", region=");
        sb.append(this.getRegionInfo() == null ? null : this.getRegionInfo().getEncodedName());
    }

    public RegionStates.RegionStateNode getRegionState(MasterProcedureEnv env) {
        return env.getAssignmentManager().getRegionStates().getOrCreateRegionStateNode(this.getRegionInfo());
    }

    void setTransitionState(MasterProcedureProtos.RegionTransitionState state) {
        this.transitionState = state;
    }

    MasterProcedureProtos.RegionTransitionState getTransitionState() {
        return this.transitionState;
    }

    protected abstract boolean startTransition(MasterProcedureEnv var1, RegionStates.RegionStateNode var2) throws IOException, ProcedureSuspendedException;

    protected abstract boolean updateTransition(MasterProcedureEnv var1, RegionStates.RegionStateNode var2) throws IOException, ProcedureSuspendedException;

    protected abstract void finishTransition(MasterProcedureEnv var1, RegionStates.RegionStateNode var2) throws IOException, ProcedureSuspendedException;

    protected abstract void reportTransition(MasterProcedureEnv var1, RegionStates.RegionStateNode var2, RegionServerStatusProtos.RegionStateTransition.TransitionCode var3, long var4) throws UnexpectedStateException;

    public abstract RemoteProcedureDispatcher.RemoteOperation remoteCallBuild(MasterProcedureEnv var1, ServerName var2);

    protected abstract boolean remoteCallFailed(MasterProcedureEnv var1, RegionStates.RegionStateNode var2, IOException var3);

    public void remoteCallCompleted(MasterProcedureEnv env, ServerName serverName, RemoteProcedureDispatcher.RemoteOperation response) {
    }

    public synchronized void remoteCallFailed(MasterProcedureEnv env, ServerName serverName, IOException exception) {
        RegionStates.RegionStateNode regionNode = this.getRegionState(env);
        LOG.warn("Remote call failed {}; {}; {}; exception={}", new Object[]{serverName, this, regionNode.toShortString(), exception.getClass().getSimpleName()});
        if (this.remoteCallFailed(env, regionNode, exception)) {
            regionNode.getProcedureEvent().wake((AbstractProcedureScheduler)env.getProcedureScheduler());
        }
    }

    protected boolean addToRemoteDispatcher(MasterProcedureEnv env, ServerName targetServer) {
        LOG.info("Dispatch {}; {}", (Object)this, (Object)this.getRegionState(env).toShortString());
        this.getRegionState(env).getProcedureEvent().suspend();
        try {
            env.getRemoteDispatcher().addOperationToNode((Comparable)targetServer, this);
        }
        catch (FailedRemoteDispatchException frde) {
            this.remoteCallFailed(env, targetServer, (IOException)((Object)frde));
            return false;
        }
        return true;
    }

    protected void reportTransition(MasterProcedureEnv env, ServerName serverName, RegionServerStatusProtos.RegionStateTransition.TransitionCode code, long seqId) throws UnexpectedStateException {
        RegionStates.RegionStateNode regionNode = this.getRegionState(env);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received report " + code + " seqId=" + seqId + ", " + this + "; " + regionNode.toShortString());
        }
        if (!serverName.equals((Object)regionNode.getRegionLocation())) {
            if (this.isMeta() && regionNode.getRegionLocation() == null) {
                regionNode.setRegionLocation(serverName);
            } else {
                throw new UnexpectedStateException(String.format("Unexpected state=%s from server=%s; expected server=%s; %s; %s", code, serverName, regionNode.getRegionLocation(), this, regionNode.toShortString()));
            }
        }
        this.reportTransition(env, regionNode, code, seqId);
        regionNode.getProcedureEvent().wake((AbstractProcedureScheduler)env.getProcedureScheduler());
    }

    protected boolean isServerOnline(MasterProcedureEnv env, RegionStates.RegionStateNode regionNode) {
        return this.isServerOnline(env, regionNode.getRegionLocation());
    }

    protected boolean isServerOnline(MasterProcedureEnv env, ServerName serverName) {
        return env.getMasterServices().getServerManager().isServerOnline(serverName);
    }

    protected void toStringState(StringBuilder builder) {
        super.toStringState(builder);
        MasterProcedureProtos.RegionTransitionState ts = this.transitionState;
        if (!this.isFinished() && ts != null) {
            builder.append(":").append(ts);
        }
    }

    protected Procedure[] execute(MasterProcedureEnv env) throws ProcedureSuspendedException {
        block12: {
            RegionStates.RegionStateNode regionNode;
            AssignmentManager am = env.getAssignmentManager();
            if (!am.addRegionInTransition(regionNode = this.getRegionState(env), this)) {
                String msg = String.format("There is already another procedure running on this region this=%s owner=%s", this, regionNode.getProcedure());
                LOG.warn(msg + " " + this + "; " + regionNode.toShortString());
                this.setAbortFailure(this.getClass().getSimpleName(), msg);
                return null;
            }
            try {
                boolean retry;
                do {
                    retry = false;
                    switch (this.transitionState) {
                        case REGION_TRANSITION_QUEUE: {
                            if (!this.startTransition(env, regionNode)) {
                                am.removeRegionInTransition(this.getRegionState(env), this);
                                return null;
                            }
                            this.transitionState = MasterProcedureProtos.RegionTransitionState.REGION_TRANSITION_DISPATCH;
                            if (!regionNode.getProcedureEvent().suspendIfNotReady((Procedure)this)) break;
                            throw new ProcedureSuspendedException();
                        }
                        case REGION_TRANSITION_DISPATCH: {
                            if (!this.updateTransition(env, regionNode)) {
                                am.removeRegionInTransition(regionNode, this);
                                return null;
                            }
                            if (this.transitionState != MasterProcedureProtos.RegionTransitionState.REGION_TRANSITION_DISPATCH) {
                                retry = true;
                                break;
                            }
                            if (!regionNode.getProcedureEvent().suspendIfNotReady((Procedure)this)) break;
                            throw new ProcedureSuspendedException();
                        }
                        case REGION_TRANSITION_FINISH: {
                            LOG.debug("Finishing {}; {}", (Object)this, (Object)regionNode.toShortString());
                            this.finishTransition(env, regionNode);
                            am.removeRegionInTransition(regionNode, this);
                            return null;
                        }
                    }
                } while (retry);
                this.attempt = 0;
            }
            catch (IOException e) {
                long backoff = this.getBackoffTime(this.attempt++);
                LOG.warn("Failed transition, suspend {}secs {}; {}; waiting on rectified condition fixed by other Procedure or operator intervention", new Object[]{backoff / 1000L, this, regionNode.toShortString(), e});
                this.getRegionState(env).getProcedureEvent().suspend();
                if (!this.getRegionState(env).getProcedureEvent().suspendIfNotReady((Procedure)this)) break block12;
                this.setTimeout(Math.toIntExact(backoff));
                this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
                throw new ProcedureSuspendedException();
            }
        }
        return new Procedure[]{this};
    }

    private long getBackoffTime(int attempts) {
        long maxBackoffTime;
        long backoffTime = (long)(1000.0 * Math.pow(2.0, attempts));
        return backoffTime < (maxBackoffTime = 3600000L) ? backoffTime : maxBackoffTime;
    }

    protected synchronized boolean setTimeoutFailure(MasterProcedureEnv env) {
        this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
        this.getRegionState(env).getProcedureEvent().wake((AbstractProcedureScheduler)env.getProcedureScheduler());
        return false;
    }

    protected void rollback(MasterProcedureEnv env) {
        if (this.isRollbackSupported(this.transitionState)) {
            env.getAssignmentManager().removeRegionInTransition(this.getRegionState(env), this);
            return;
        }
        throw new UnsupportedOperationException("Unhandled state " + this.transitionState + "; there is no rollback for assignment unless we cancel the operation by dropping/disabling the table");
    }

    protected abstract boolean isRollbackSupported(MasterProcedureProtos.RegionTransitionState var1);

    protected boolean abort(MasterProcedureEnv env) {
        if (this.isRollbackSupported(this.transitionState)) {
            this.aborted.set(true);
            return true;
        }
        return false;
    }

    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (!this.isMeta() && (env.waitFailoverCleanup(this) || env.getAssignmentManager().waitMetaInitialized(this, this.getRegionInfo()))) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        if (env.getProcedureScheduler().waitRegion(this, this.getRegionInfo())) {
            try {
                LOG.debug(Procedure.LockState.LOCK_EVENT_WAIT + " pid=" + this.getProcId() + " " + env.getProcedureScheduler().dumpLocks());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        this.lock = true;
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureScheduler().wakeRegion(this, this.getRegionInfo());
        this.lock = false;
    }

    protected boolean holdLock(MasterProcedureEnv env) {
        return true;
    }

    protected boolean hasLock(MasterProcedureEnv env) {
        return this.lock;
    }

    protected boolean shouldWaitClientAck(MasterProcedureEnv env) {
        return false;
    }

    public abstract ServerName getServer(MasterProcedureEnv var1);
}

