/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MasterMetaBootstrap {
    private static final Logger LOG = LoggerFactory.getLogger(MasterMetaBootstrap.class);
    private final HMaster master;

    public MasterMetaBootstrap(HMaster master) {
        this.master = master;
    }

    public void recoverMeta() throws InterruptedException, IOException {
        this.master.recoverMeta();
        this.master.getTableStateManager().start();
        this.enableCrashedServerProcessing();
    }

    public void processDeadServers() {
        Set<ServerName> previouslyFailedServers = this.master.getMasterWalManager().getFailedServersFromLogFolders();
        for (ServerName tmpServer : previouslyFailedServers) {
            this.master.getServerManager().processDeadServer(tmpServer, true);
        }
    }

    protected void assignMetaReplicas() throws IOException, InterruptedException, KeeperException {
        int numReplicas = this.master.getConfiguration().getInt("hbase.meta.replica.count", 1);
        if (numReplicas <= 1) {
            return;
        }
        AssignmentManager assignmentManager = this.master.getAssignmentManager();
        if (!assignmentManager.isMetaInitialized()) {
            throw new IllegalStateException("hbase:meta must be initialized first before we can assign out its replicas");
        }
        ServerName metaServername = this.master.getMetaTableLocator().getMetaRegionLocation(this.master.getZooKeeper());
        for (int i = 1; i < numReplicas; ++i) {
            RegionState metaState = MetaTableLocator.getMetaRegionState((ZKWatcher)this.master.getZooKeeper(), (int)i);
            RegionInfo hri = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (int)i);
            LOG.debug(hri.getRegionNameAsString() + " replica region state from zookeeper=" + metaState);
            if (metaServername.equals((Object)metaState.getServerName())) {
                metaState = null;
                LOG.info(hri.getRegionNameAsString() + " old location is same as current hbase:meta location; setting location as null...");
            }
            if (metaState != null && metaState.getServerName() != null) {
                assignmentManager.assign(hri, metaState.getServerName());
                continue;
            }
            assignmentManager.assign(hri);
        }
        this.unassignExcessMetaReplica(numReplicas);
    }

    private void unassignExcessMetaReplica(int numMetaReplicasConfigured) {
        ZKWatcher zooKeeper = this.master.getZooKeeper();
        try {
            List metaReplicaZnodes = zooKeeper.getMetaReplicaNodes();
            for (String metaReplicaZnode : metaReplicaZnodes) {
                int replicaId = zooKeeper.znodePaths.getMetaReplicaIdFromZnode(metaReplicaZnode);
                if (replicaId < numMetaReplicasConfigured) continue;
                RegionState r = MetaTableLocator.getMetaRegionState((ZKWatcher)zooKeeper, (int)replicaId);
                LOG.info("Closing excess replica of meta region " + r.getRegion());
                ServerManager.closeRegionSilentlyAndWait(this.master.getClusterConnection(), r.getServerName(), r.getRegion(), 30000L);
                ZKUtil.deleteNode((ZKWatcher)zooKeeper, (String)zooKeeper.znodePaths.getZNodeForReplica(replicaId));
            }
        }
        catch (Exception ex) {
            LOG.warn("Ignoring exception " + ex);
        }
    }

    private void enableCrashedServerProcessing() throws InterruptedException {
        if (!this.master.isServerCrashProcessingEnabled()) {
            this.master.setServerCrashProcessingEnabled(true);
            this.master.getServerManager().processQueuedDeadServers();
        }
    }
}

