/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.webapp;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CrossOriginFilter
implements Filter {
    private static final Log LOG = LogFactory.getLog(CrossOriginFilter.class);
    static final String ORIGIN = "Origin";
    static final String ACCESS_CONTROL_REQUEST_METHOD = "Access-Control-Request-Method";
    static final String ACCESS_CONTROL_REQUEST_HEADERS = "Access-Control-Request-Headers";
    static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    static final String ACCESS_CONTROL_ALLOW_CREDENTIALS = "Access-Control-Allow-Credentials";
    static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    static final String ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    static final String ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String ALLOWED_ORIGINS = "allowed-origins";
    public static final String ALLOWED_ORIGINS_DEFAULT = "*";
    public static final String ALLOWED_METHODS = "allowed-methods";
    public static final String ALLOWED_METHODS_DEFAULT = "GET,POST,HEAD";
    public static final String ALLOWED_HEADERS = "allowed-headers";
    public static final String ALLOWED_HEADERS_DEFAULT = "X-Requested-With,Content-Type,Accept,Origin";
    public static final String MAX_AGE = "max-age";
    public static final String MAX_AGE_DEFAULT = "1800";
    private List<String> allowedMethods = new ArrayList();
    private List<String> allowedHeaders = new ArrayList();
    private List<String> allowedOrigins = new ArrayList();
    private boolean allowAllOrigins = true;
    private String maxAge;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.initializeAllowedMethods(filterConfig);
        this.initializeAllowedHeaders(filterConfig);
        this.initializeAllowedOrigins(filterConfig);
        this.initializeMaxAge(filterConfig);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        this.doCrossFilter((HttpServletRequest)req, (HttpServletResponse)res);
        chain.doFilter(req, res);
    }

    public void destroy() {
        this.allowedMethods.clear();
        this.allowedHeaders.clear();
        this.allowedOrigins.clear();
    }

    private void doCrossFilter(HttpServletRequest req, HttpServletResponse res) {
        String originsList = CrossOriginFilter.encodeHeader((String)req.getHeader("Origin"));
        if (!CrossOriginFilter.isCrossOrigin((String)originsList)) {
            return;
        }
        if (!this.areOriginsAllowed(originsList)) {
            return;
        }
        String accessControlRequestMethod = req.getHeader("Access-Control-Request-Method");
        if (!this.isMethodAllowed(accessControlRequestMethod)) {
            return;
        }
        String accessControlRequestHeaders = req.getHeader("Access-Control-Request-Headers");
        if (!this.areHeadersAllowed(accessControlRequestHeaders)) {
            return;
        }
        res.setHeader("Access-Control-Allow-Origin", originsList);
        res.setHeader("Access-Control-Allow-Credentials", Boolean.TRUE.toString());
        res.setHeader("Access-Control-Allow-Methods", this.getAllowedMethodsHeader());
        res.setHeader("Access-Control-Allow-Headers", this.getAllowedHeadersHeader());
        res.setHeader("Access-Control-Max-Age", this.maxAge);
    }

    @VisibleForTesting
    String getAllowedHeadersHeader() {
        return StringUtils.join((Collection)this.allowedHeaders, (char)',');
    }

    @VisibleForTesting
    String getAllowedMethodsHeader() {
        return StringUtils.join((Collection)this.allowedMethods, (char)',');
    }

    private void initializeAllowedMethods(FilterConfig filterConfig) {
        String allowedMethodsConfig = filterConfig.getInitParameter("allowed-methods");
        if (allowedMethodsConfig == null) {
            allowedMethodsConfig = "GET,POST,HEAD";
        }
        this.allowedMethods.addAll(Arrays.asList(allowedMethodsConfig.trim().split("\\s*,\\s*")));
        LOG.info((Object)("Allowed Methods: " + this.getAllowedMethodsHeader()));
    }

    private void initializeAllowedHeaders(FilterConfig filterConfig) {
        String allowedHeadersConfig = filterConfig.getInitParameter("allowed-headers");
        if (allowedHeadersConfig == null) {
            allowedHeadersConfig = "X-Requested-With,Content-Type,Accept,Origin";
        }
        this.allowedHeaders.addAll(Arrays.asList(allowedHeadersConfig.trim().split("\\s*,\\s*")));
        LOG.info((Object)("Allowed Headers: " + this.getAllowedHeadersHeader()));
    }

    private void initializeAllowedOrigins(FilterConfig filterConfig) {
        String allowedOriginsConfig = filterConfig.getInitParameter("allowed-origins");
        if (allowedOriginsConfig == null) {
            allowedOriginsConfig = "*";
        }
        this.allowedOrigins.addAll(Arrays.asList(allowedOriginsConfig.trim().split("\\s*,\\s*")));
        this.allowAllOrigins = this.allowedOrigins.contains("*");
        LOG.info((Object)("Allowed Origins: " + StringUtils.join((Collection)this.allowedOrigins, (char)',')));
        LOG.info((Object)("Allow All Origins: " + this.allowAllOrigins));
    }

    private void initializeMaxAge(FilterConfig filterConfig) {
        this.maxAge = filterConfig.getInitParameter("max-age");
        if (this.maxAge == null) {
            this.maxAge = "1800";
        }
        LOG.info((Object)("Max Age: " + this.maxAge));
    }

    static String encodeHeader(String header) {
        if (header == null) {
            return null;
        }
        return header.split("\n|\r")[0].trim();
    }

    static boolean isCrossOrigin(String originsList) {
        return originsList != null;
    }

    @VisibleForTesting
    boolean areOriginsAllowed(String originsList) {
        String[] origins;
        if (this.allowAllOrigins) {
            return true;
        }
        for (String origin : origins = originsList.trim().split("\\s+")) {
            for (String allowedOrigin : this.allowedOrigins) {
                String regex;
                Pattern p;
                Matcher m;
                if (!(allowedOrigin.contains("*") ? (m = (p = Pattern.compile(regex = allowedOrigin.replace(".", "\\.").replace("*", ".*"))).matcher(origin)).matches() : allowedOrigin.equals(origin))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean areHeadersAllowed(String accessControlRequestHeaders) {
        if (accessControlRequestHeaders == null) {
            return true;
        }
        String[] headers = accessControlRequestHeaders.trim().split("\\s*,\\s*");
        return this.allowedHeaders.containsAll(Arrays.asList(headers));
    }

    private boolean isMethodAllowed(String accessControlRequestMethod) {
        if (accessControlRequestMethod == null) {
            return true;
        }
        return this.allowedMethods.contains(accessControlRequestMethod);
    }
}

