/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.security;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.security.TestTimelineACLsManager;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.junit.Assert;
import org.junit.Test;

public class TestTimelineACLsManager {
    private static TimelineDomain domain = new TimelineDomain();

    @Test
    public void testYarnACLsNotEnabledForEntity() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.acl.enable", false);
        TimelineACLsManager timelineACLsManager = new TimelineACLsManager((Configuration)conf);
        timelineACLsManager.setTimelineStore((TimelineStore)new TestTimelineStore(null));
        TimelineEntity entity = new TimelineEntity();
        entity.addPrimaryFilter(TimelineStore.SystemFilter.ENTITY_OWNER.toString(), (Object)"owner");
        entity.setDomainId("domain_id_1");
        Assert.assertTrue((String)"Always true when ACLs are not enabled", (boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"user"), ApplicationAccessType.VIEW_APP, entity));
        Assert.assertTrue((String)"Always true when ACLs are not enabled", (boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"user"), ApplicationAccessType.MODIFY_APP, entity));
    }

    @Test
    public void testYarnACLsEnabledForEntity() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.acl.enable", true);
        conf.set("yarn.admin.acl", "admin");
        TimelineACLsManager timelineACLsManager = new TimelineACLsManager((Configuration)conf);
        timelineACLsManager.setTimelineStore((TimelineStore)new TestTimelineStore(null));
        TimelineEntity entity = new TimelineEntity();
        entity.addPrimaryFilter(TimelineStore.SystemFilter.ENTITY_OWNER.toString(), (Object)"owner");
        entity.setDomainId("domain_id_1");
        Assert.assertTrue((String)"Owner should be allowed to view", (boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"owner"), ApplicationAccessType.VIEW_APP, entity));
        Assert.assertTrue((String)"Reader should be allowed to view", (boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"reader"), ApplicationAccessType.VIEW_APP, entity));
        Assert.assertFalse((String)"Other shouldn't be allowed to view", (boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"other"), ApplicationAccessType.VIEW_APP, entity));
        Assert.assertTrue((String)"Admin should be allowed to view", (boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"admin"), ApplicationAccessType.VIEW_APP, entity));
        Assert.assertTrue((String)"Owner should be allowed to modify", (boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"owner"), ApplicationAccessType.MODIFY_APP, entity));
        Assert.assertTrue((String)"Writer should be allowed to modify", (boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"writer"), ApplicationAccessType.MODIFY_APP, entity));
        Assert.assertFalse((String)"Other shouldn't be allowed to modify", (boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"other"), ApplicationAccessType.MODIFY_APP, entity));
        Assert.assertTrue((String)"Admin should be allowed to modify", (boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"admin"), ApplicationAccessType.MODIFY_APP, entity));
    }

    @Test
    public void testCorruptedOwnerInfoForEntity() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.acl.enable", true);
        conf.set("yarn.admin.acl", "owner");
        TimelineACLsManager timelineACLsManager = new TimelineACLsManager((Configuration)conf);
        timelineACLsManager.setTimelineStore((TimelineStore)new TestTimelineStore(null));
        TimelineEntity entity = new TimelineEntity();
        try {
            timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"owner"), ApplicationAccessType.VIEW_APP, entity);
            Assert.fail((String)"Exception is expected");
        }
        catch (YarnException e) {
            Assert.assertTrue((String)"It's not the exact expected exception", (boolean)e.getMessage().contains("doesn't exist."));
        }
    }

    @Test
    public void testYarnACLsNotEnabledForDomain() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.acl.enable", false);
        TimelineACLsManager timelineACLsManager = new TimelineACLsManager((Configuration)conf);
        TimelineDomain domain = new TimelineDomain();
        domain.setOwner("owner");
        Assert.assertTrue((String)"Always true when ACLs are not enabled", (boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"user"), domain));
    }

    @Test
    public void testYarnACLsEnabledForDomain() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.acl.enable", true);
        conf.set("yarn.admin.acl", "admin");
        TimelineACLsManager timelineACLsManager = new TimelineACLsManager((Configuration)conf);
        TimelineDomain domain = new TimelineDomain();
        domain.setOwner("owner");
        Assert.assertTrue((String)"Owner should be allowed to access", (boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"owner"), domain));
        Assert.assertFalse((String)"Other shouldn't be allowed to access", (boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"other"), domain));
        Assert.assertTrue((String)"Admin should be allowed to access", (boolean)timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"admin"), domain));
    }

    @Test
    public void testCorruptedOwnerInfoForDomain() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.acl.enable", true);
        conf.set("yarn.admin.acl", "owner");
        TimelineACLsManager timelineACLsManager = new TimelineACLsManager((Configuration)conf);
        TimelineDomain domain = new TimelineDomain();
        try {
            timelineACLsManager.checkAccess(UserGroupInformation.createRemoteUser((String)"owner"), domain);
            Assert.fail((String)"Exception is expected");
        }
        catch (YarnException e) {
            Assert.assertTrue((String)"It's not the exact expected exception", (boolean)e.getMessage().contains("is corrupted."));
        }
    }

    static /* synthetic */ TimelineDomain access$100() {
        return domain;
    }

    static {
        domain.setId("domain_id_1");
        domain.setOwner("owner");
        domain.setReaders("reader");
        domain.setWriters("writer");
    }
}

