/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomains;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEvents;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.timeline.EntityIdentifier;
import org.apache.hadoop.yarn.server.timeline.GenericObjectMapper;
import org.apache.hadoop.yarn.server.timeline.LeveldbTimelineStore;
import org.apache.hadoop.yarn.server.timeline.NameValuePair;
import org.apache.hadoop.yarn.server.timeline.TimelineReader;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.WriteBatch;
import org.iq80.leveldb.WriteOptions;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LeveldbTimelineStore
extends AbstractService
implements TimelineStore {
    private static final Log LOG = LogFactory.getLog(LeveldbTimelineStore.class);
    @InterfaceAudience.Private
    @VisibleForTesting
    static final String FILENAME = "leveldb-timeline-store.ldb";
    private static final byte[] START_TIME_LOOKUP_PREFIX = "k".getBytes();
    private static final byte[] ENTITY_ENTRY_PREFIX = "e".getBytes();
    private static final byte[] INDEXED_ENTRY_PREFIX = "i".getBytes();
    private static final byte[] EVENTS_COLUMN = "e".getBytes();
    private static final byte[] PRIMARY_FILTERS_COLUMN = "f".getBytes();
    private static final byte[] OTHER_INFO_COLUMN = "i".getBytes();
    private static final byte[] RELATED_ENTITIES_COLUMN = "r".getBytes();
    private static final byte[] INVISIBLE_REVERSE_RELATED_ENTITIES_COLUMN = "z".getBytes();
    private static final byte[] DOMAIN_ID_COLUMN = "d".getBytes();
    private static final byte[] DOMAIN_ENTRY_PREFIX = "d".getBytes();
    private static final byte[] OWNER_LOOKUP_PREFIX = "o".getBytes();
    private static final byte[] DESCRIPTION_COLUMN = "d".getBytes();
    private static final byte[] OWNER_COLUMN = "o".getBytes();
    private static final byte[] READER_COLUMN = "r".getBytes();
    private static final byte[] WRITER_COLUMN = "w".getBytes();
    private static final byte[] TIMESTAMP_COLUMN = "t".getBytes();
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final String TIMELINE_STORE_VERSION_KEY = "timeline-store-version";
    private static final Version CURRENT_VERSION_INFO = Version.newInstance((int)1, (int)0);
    @InterfaceAudience.Private
    @VisibleForTesting
    static final FsPermission LEVELDB_DIR_UMASK = FsPermission.createImmutable((short)448);
    private Map<EntityIdentifier, StartAndInsertTime> startTimeWriteCache;
    private Map<EntityIdentifier, Long> startTimeReadCache;
    private final LockMap<EntityIdentifier> writeLocks = new LockMap(null);
    private final ReentrantReadWriteLock deleteLock = new ReentrantReadWriteLock();
    private DB db;
    private Thread deletionThread;

    public LeveldbTimelineStore() {
        super(LeveldbTimelineStore.class.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceInit(Configuration conf) throws Exception {
        Options options = new Options();
        options.createIfMissing(true);
        options.cacheSize(conf.getLong("yarn.timeline-service.leveldb-timeline-store.read-cache-size", 0x6400000L));
        JniDBFactory factory = new JniDBFactory();
        Path dbPath = new Path(conf.get("yarn.timeline-service.leveldb-timeline-store.path"), "leveldb-timeline-store.ldb");
        LocalFileSystem localFS = null;
        try {
            localFS = FileSystem.getLocal((Configuration)conf);
            if (!localFS.exists(dbPath)) {
                if (!localFS.mkdirs(dbPath)) {
                    throw new IOException("Couldn't create directory for leveldb timeline store " + dbPath);
                }
                localFS.setPermission(dbPath, LEVELDB_DIR_UMASK);
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{localFS});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{localFS});
        LOG.info((Object)("Using leveldb path " + dbPath));
        this.db = factory.open(new File(dbPath.toString()), options);
        this.checkVersion();
        this.startTimeWriteCache = Collections.synchronizedMap(new LRUMap(LeveldbTimelineStore.getStartTimeWriteCacheSize((Configuration)conf)));
        this.startTimeReadCache = Collections.synchronizedMap(new LRUMap(LeveldbTimelineStore.getStartTimeReadCacheSize((Configuration)conf)));
        if (conf.getBoolean("yarn.timeline-service.ttl-enable", true)) {
            this.deletionThread = new EntityDeletionThread(this, conf);
            this.deletionThread.start();
        }
        super.serviceInit(conf);
    }

    protected void serviceStop() throws Exception {
        if (this.deletionThread != null) {
            this.deletionThread.interrupt();
            LOG.info((Object)"Waiting for deletion thread to complete its current action");
            try {
                this.deletionThread.join();
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Interrupted while waiting for deletion thread to complete, closing db now", (Throwable)e);
            }
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.db});
        super.serviceStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimelineEntity getEntity(String entityId, String entityType, EnumSet<TimelineReader.Field> fields) throws IOException {
        TimelineEntity timelineEntity;
        Long revStartTime = this.getStartTimeLong(entityId, entityType);
        if (revStartTime == null) {
            return null;
        }
        byte[] prefix = KeyBuilder.newInstance().add(ENTITY_ENTRY_PREFIX).add(entityType).add(GenericObjectMapper.writeReverseOrderedLong((long)revStartTime)).add(entityId).getBytesForLookup();
        DBIterator iterator = null;
        try {
            iterator = this.db.iterator();
            iterator.seek(prefix);
            timelineEntity = LeveldbTimelineStore.getEntity((String)entityId, (String)entityType, (Long)revStartTime, fields, (DBIterator)iterator, (byte[])prefix, (int)prefix.length);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{iterator});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{iterator});
        return timelineEntity;
    }

    private static TimelineEntity getEntity(String entityId, String entityType, Long startTime, EnumSet<TimelineReader.Field> fields, DBIterator iterator, byte[] prefix, int prefixlen) throws IOException {
        byte[] key;
        if (fields == null) {
            fields = EnumSet.allOf(TimelineReader.Field.class);
        }
        TimelineEntity entity = new TimelineEntity();
        boolean events = false;
        boolean lastEvent = false;
        if (fields.contains(TimelineReader.Field.EVENTS)) {
            events = true;
        } else if (fields.contains(TimelineReader.Field.LAST_EVENT_ONLY)) {
            lastEvent = true;
        } else {
            entity.setEvents(null);
        }
        boolean relatedEntities = false;
        if (fields.contains(TimelineReader.Field.RELATED_ENTITIES)) {
            relatedEntities = true;
        } else {
            entity.setRelatedEntities(null);
        }
        boolean primaryFilters = false;
        if (fields.contains(TimelineReader.Field.PRIMARY_FILTERS)) {
            primaryFilters = true;
        } else {
            entity.setPrimaryFilters(null);
        }
        boolean otherInfo = false;
        if (fields.contains(TimelineReader.Field.OTHER_INFO)) {
            otherInfo = true;
        } else {
            entity.setOtherInfo(null);
        }
        while (iterator.hasNext() && LeveldbTimelineStore.prefixMatches((byte[])prefix, (int)prefixlen, (byte[])(key = (byte[])iterator.peekNext().getKey()))) {
            if (key.length != prefixlen) {
                if (key[prefixlen] == PRIMARY_FILTERS_COLUMN[0]) {
                    if (primaryFilters) {
                        LeveldbTimelineStore.addPrimaryFilter((TimelineEntity)entity, (byte[])key, (int)(prefixlen + PRIMARY_FILTERS_COLUMN.length));
                    }
                } else if (key[prefixlen] == OTHER_INFO_COLUMN[0]) {
                    if (otherInfo) {
                        entity.addOtherInfo(LeveldbTimelineStore.parseRemainingKey((byte[])key, (int)(prefixlen + OTHER_INFO_COLUMN.length)), GenericObjectMapper.read((byte[])((byte[])iterator.peekNext().getValue())));
                    }
                } else if (key[prefixlen] == RELATED_ENTITIES_COLUMN[0]) {
                    if (relatedEntities) {
                        LeveldbTimelineStore.addRelatedEntity((TimelineEntity)entity, (byte[])key, (int)(prefixlen + RELATED_ENTITIES_COLUMN.length));
                    }
                } else if (key[prefixlen] == EVENTS_COLUMN[0]) {
                    TimelineEvent event;
                    if ((events || lastEvent && entity.getEvents().size() == 0) && (event = LeveldbTimelineStore.getEntityEvent(null, (byte[])key, (int)(prefixlen + EVENTS_COLUMN.length), (byte[])((byte[])iterator.peekNext().getValue()))) != null) {
                        entity.addEvent(event);
                    }
                } else if (key[prefixlen] == DOMAIN_ID_COLUMN[0]) {
                    byte[] v = (byte[])iterator.peekNext().getValue();
                    String domainId = new String(v);
                    entity.setDomainId(domainId);
                } else if (key[prefixlen] != INVISIBLE_REVERSE_RELATED_ENTITIES_COLUMN[0]) {
                    LOG.warn((Object)String.format("Found unexpected column for entity %s of type %s (0x%02x)", entityId, entityType, key[prefixlen]));
                }
            }
            iterator.next();
        }
        entity.setEntityId(entityId);
        entity.setEntityType(entityType);
        entity.setStartTime(startTime);
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimelineEvents getEntityTimelines(String entityType, SortedSet<String> entityIds, Long limit, Long windowStart, Long windowEnd, Set<String> eventType) throws IOException {
        TimelineEvents events = new TimelineEvents();
        if (entityIds == null || entityIds.isEmpty()) {
            return events;
        }
        TreeMap<byte[], ArrayList<EntityIdentifier>> startTimeMap = new TreeMap<byte[], ArrayList<EntityIdentifier>>((Comparator<byte[]>)new /* Unavailable Anonymous Inner Class!! */);
        DBIterator iterator = null;
        try {
            for (String string : entityIds) {
                byte[] startTime = this.getStartTime(string, entityType);
                if (startTime == null) continue;
                ArrayList<EntityIdentifier> entities = (ArrayList<EntityIdentifier>)startTimeMap.get(startTime);
                if (entities == null) {
                    entities = new ArrayList<EntityIdentifier>();
                    startTimeMap.put(startTime, entities);
                }
                entities.add(new EntityIdentifier(string, entityType));
            }
            for (Map.Entry entry : startTimeMap.entrySet()) {
                byte[] revStartTime = (byte[])entry.getKey();
                for (EntityIdentifier entityIdentifier : (List)entry.getValue()) {
                    byte[] key;
                    TimelineEvents.EventsOfOneEntity entity = new TimelineEvents.EventsOfOneEntity();
                    entity.setEntityId(entityIdentifier.getId());
                    entity.setEntityType(entityType);
                    events.addEvent(entity);
                    KeyBuilder kb = KeyBuilder.newInstance().add(ENTITY_ENTRY_PREFIX).add(entityType).add(revStartTime).add(entityIdentifier.getId()).add(EVENTS_COLUMN);
                    byte[] prefix = kb.getBytesForLookup();
                    if (windowEnd == null) {
                        windowEnd = Long.MAX_VALUE;
                    }
                    byte[] revts = GenericObjectMapper.writeReverseOrderedLong((long)windowEnd);
                    kb.add(revts);
                    byte[] first = kb.getBytesForLookup();
                    byte[] last = null;
                    if (windowStart != null) {
                        last = KeyBuilder.newInstance().add(prefix).add(GenericObjectMapper.writeReverseOrderedLong((long)windowStart)).getBytesForLookup();
                    }
                    if (limit == null) {
                        limit = 100L;
                    }
                    iterator = this.db.iterator();
                    iterator.seek(first);
                    while ((long)entity.getEvents().size() < limit && iterator.hasNext() && LeveldbTimelineStore.prefixMatches((byte[])prefix, (int)prefix.length, (byte[])(key = (byte[])iterator.peekNext().getKey())) && (last == null || WritableComparator.compareBytes((byte[])key, (int)0, (int)key.length, (byte[])last, (int)0, (int)last.length) <= 0)) {
                        TimelineEvent event = LeveldbTimelineStore.getEntityEvent(eventType, (byte[])key, (int)prefix.length, (byte[])((byte[])iterator.peekNext().getValue()));
                        if (event != null) {
                            entity.addEvent(event);
                        }
                        iterator.next();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{iterator});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{iterator});
        return events;
    }

    private static boolean prefixMatches(byte[] prefix, int prefixlen, byte[] b) {
        if (b.length < prefixlen) {
            return false;
        }
        return WritableComparator.compareBytes((byte[])prefix, (int)0, (int)prefixlen, (byte[])b, (int)0, (int)prefixlen) == 0;
    }

    public TimelineEntities getEntities(String entityType, Long limit, Long windowStart, Long windowEnd, String fromId, Long fromTs, NameValuePair primaryFilter, Collection<NameValuePair> secondaryFilters, EnumSet<TimelineReader.Field> fields) throws IOException {
        if (primaryFilter == null) {
            return this.getEntityByTime(ENTITY_ENTRY_PREFIX, entityType, limit, windowStart, windowEnd, fromId, fromTs, secondaryFilters, fields);
        }
        byte[] base = KeyBuilder.newInstance().add(INDEXED_ENTRY_PREFIX).add(primaryFilter.getName()).add(GenericObjectMapper.write((Object)primaryFilter.getValue()), true).add(ENTITY_ENTRY_PREFIX).getBytesForLookup();
        return this.getEntityByTime(base, entityType, limit, windowStart, windowEnd, fromId, fromTs, secondaryFilters, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private TimelineEntities getEntityByTime(byte[] base, String entityType, Long limit, Long starttime, Long endtime, String fromId, Long fromTs, Collection<NameValuePair> secondaryFilters, EnumSet<TimelineReader.Field> fields) throws IOException {
        block14: {
            iterator = null;
            kb = KeyBuilder.newInstance().add(base).add(entityType);
            prefix = kb.getBytesForLookup();
            if (endtime == null) {
                endtime = 0x7FFFFFFFFFFFFFFFL;
            }
            first = null;
            if (fromId == null) ** GOTO lbl18
            fromIdStartTime = this.getStartTimeLong(fromId, entityType);
            if (fromIdStartTime != null) break block14;
            var15_15 = new TimelineEntities();
            IOUtils.cleanup((Log)LeveldbTimelineStore.LOG, (Closeable[])new Closeable[]{iterator});
            return var15_15;
        }
        try {
            if (fromIdStartTime <= endtime) {
                first = kb.add(GenericObjectMapper.writeReverseOrderedLong((long)fromIdStartTime)).add(fromId).getBytesForLookup();
            }
lbl18:
            // 4 sources

            if (first == null) {
                first = kb.add(GenericObjectMapper.writeReverseOrderedLong((long)endtime)).getBytesForLookup();
            }
            last = null;
            if (starttime != null) {
                last = KeyBuilder.newInstance().add(base).add(entityType).add(GenericObjectMapper.writeReverseOrderedLong((long)starttime)).getBytesForLookup();
            }
            if (limit == null) {
                limit = 100L;
            }
            entities = new TimelineEntities();
            iterator = this.db.iterator();
            iterator.seek(first);
            while ((long)entities.getEntities().size() < limit && iterator.hasNext() && LeveldbTimelineStore.prefixMatches((byte[])prefix, (int)prefix.length, (byte[])(key = (byte[])iterator.peekNext().getKey())) && (last == null || WritableComparator.compareBytes((byte[])key, (int)0, (int)key.length, (byte[])last, (int)0, (int)last.length) <= 0)) {
                kp = new KeyParser(key, prefix.length);
                startTime = kp.getNextLong();
                entityId = kp.getNextString();
                if (fromTs != null && (insertTime = GenericObjectMapper.readReverseOrderedLong((byte[])((byte[])iterator.peekNext().getValue()), (int)0)) > fromTs) {
                    firstKey = key;
                    while (iterator.hasNext() && LeveldbTimelineStore.prefixMatches((byte[])firstKey, (int)kp.getOffset(), (byte[])key)) {
                        iterator.next();
                        key = (byte[])iterator.peekNext().getKey();
                    }
                    continue;
                }
                entity = LeveldbTimelineStore.getEntity((String)entityId, (String)entityType, (Long)startTime, fields, (DBIterator)iterator, (byte[])key, (int)kp.getOffset());
                filterPassed = true;
                if (secondaryFilters != null) {
                    for (NameValuePair filter : secondaryFilters) {
                        v = entity.getOtherInfo().get(filter.getName());
                        if (v == null) {
                            vs = (Set)entity.getPrimaryFilters().get(filter.getName());
                            if (vs == null || vs.contains(filter.getValue())) continue;
                            filterPassed = false;
                            break;
                        }
                        if (v.equals(filter.getValue())) continue;
                        filterPassed = false;
                        break;
                    }
                }
                if (!filterPassed) continue;
                entities.addEntity(entity);
            }
            var16_17 = entities;
        }
        catch (Throwable var26_28) {
            IOUtils.cleanup((Log)LeveldbTimelineStore.LOG, (Closeable[])new Closeable[]{iterator});
            throw var26_28;
        }
        IOUtils.cleanup((Log)LeveldbTimelineStore.LOG, (Closeable[])new Closeable[]{iterator});
        return var16_17;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void put(TimelineEntity entity, TimelinePutResponse response, boolean allowEmptyDomainId) {
        block26: {
            block25: {
                lock = this.writeLocks.getLock((Object)new EntityIdentifier(entity.getEntityId(), entity.getEntityType()));
                lock.lock();
                writeBatch = null;
                relatedEntitiesWithoutStartTimes = new ArrayList<EntityIdentifier>();
                revStartTime = null;
                primaryFilters = null;
                writeBatch = this.db.createWriteBatch();
                events = entity.getEvents();
                startAndInsertTime = this.getAndSetStartTime(entity.getEntityId(), entity.getEntityType(), entity.getStartTime(), events);
                if (startAndInsertTime != null) break block25;
                error = new TimelinePutResponse.TimelinePutError();
                error.setEntityId(entity.getEntityId());
                error.setEntityType(entity.getEntityType());
                error.setErrorCode(1);
                response.addError(error);
                lock.unlock();
                this.writeLocks.returnLock(lock);
                IOUtils.cleanup((Log)LeveldbTimelineStore.LOG, (Closeable[])new Closeable[]{writeBatch});
                return;
            }
            revStartTime = GenericObjectMapper.writeReverseOrderedLong((long)startAndInsertTime.startTime);
            primaryFilters = entity.getPrimaryFilters();
            markerKey = LeveldbTimelineStore.createEntityMarkerKey((String)entity.getEntityId(), (String)entity.getEntityType(), (byte[])revStartTime);
            markerValue = GenericObjectMapper.writeReverseOrderedLong((long)startAndInsertTime.insertTime);
            writeBatch.put(markerKey, markerValue);
            LeveldbTimelineStore.writePrimaryFilterEntries((WriteBatch)writeBatch, (Map)primaryFilters, (byte[])markerKey, (byte[])markerValue);
            if (events != null && !events.isEmpty()) {
                for (TimelineEvent event : events) {
                    revts = GenericObjectMapper.writeReverseOrderedLong((long)event.getTimestamp());
                    key = LeveldbTimelineStore.createEntityEventKey((String)entity.getEntityId(), (String)entity.getEntityType(), (byte[])revStartTime, (byte[])revts, (String)event.getEventType());
                    value = GenericObjectMapper.write((Object)event.getEventInfo());
                    writeBatch.put(key, value);
                    LeveldbTimelineStore.writePrimaryFilterEntries((WriteBatch)writeBatch, (Map)primaryFilters, (byte[])key, (byte[])value);
                }
            }
            if ((relatedEntities = entity.getRelatedEntities()) != null && !relatedEntities.isEmpty()) {
                for (Map.Entry<K, V> relatedEntityList : relatedEntities.entrySet()) {
                    relatedEntityType = (String)relatedEntityList.getKey();
                    for (String relatedEntityId : (Set)relatedEntityList.getValue()) {
                        key = LeveldbTimelineStore.createReverseRelatedEntityKey((String)entity.getEntityId(), (String)entity.getEntityType(), (byte[])revStartTime, (String)relatedEntityId, (String)relatedEntityType);
                        writeBatch.put(key, LeveldbTimelineStore.EMPTY_BYTES);
                        relatedEntityStartTime = this.getStartTime(relatedEntityId, relatedEntityType);
                        if (relatedEntityStartTime == null) {
                            relatedEntitiesWithoutStartTimes.add(new EntityIdentifier(relatedEntityId, relatedEntityType));
                            continue;
                        }
                        domainIdBytes = this.db.get(LeveldbTimelineStore.createDomainIdKey((String)relatedEntityId, (String)relatedEntityType, (byte[])relatedEntityStartTime));
                        domainId = null;
                        domainId = domainIdBytes == null ? "DEFAULT" : new String(domainIdBytes);
                        if (!domainId.equals(entity.getDomainId())) {
                            error = new TimelinePutResponse.TimelinePutError();
                            error.setEntityId(entity.getEntityId());
                            error.setEntityType(entity.getEntityType());
                            error.setErrorCode(6);
                            response.addError(error);
                            continue;
                        }
                        key = LeveldbTimelineStore.createRelatedEntityKey((String)relatedEntityId, (String)relatedEntityType, (byte[])relatedEntityStartTime, (String)entity.getEntityId(), (String)entity.getEntityType());
                        writeBatch.put(key, LeveldbTimelineStore.EMPTY_BYTES);
                    }
                }
            }
            if (primaryFilters != null && !primaryFilters.isEmpty()) {
                for (Map.Entry<K, V> primaryFilter : primaryFilters.entrySet()) {
                    for (E primaryFilterValue : (Set)primaryFilter.getValue()) {
                        key = LeveldbTimelineStore.createPrimaryFilterKey((String)entity.getEntityId(), (String)entity.getEntityType(), (byte[])revStartTime, (String)((String)primaryFilter.getKey()), primaryFilterValue);
                        writeBatch.put(key, LeveldbTimelineStore.EMPTY_BYTES);
                        LeveldbTimelineStore.writePrimaryFilterEntries((WriteBatch)writeBatch, (Map)primaryFilters, (byte[])key, (byte[])LeveldbTimelineStore.EMPTY_BYTES);
                    }
                }
            }
            if ((otherInfo = entity.getOtherInfo()) != null && !otherInfo.isEmpty()) {
                for (Map.Entry<K, V> i : otherInfo.entrySet()) {
                    key = LeveldbTimelineStore.createOtherInfoKey((String)entity.getEntityId(), (String)entity.getEntityType(), (byte[])revStartTime, (String)((String)i.getKey()));
                    value = GenericObjectMapper.write(i.getValue());
                    writeBatch.put(key, value);
                    LeveldbTimelineStore.writePrimaryFilterEntries((WriteBatch)writeBatch, (Map)primaryFilters, (byte[])key, (byte[])value);
                }
            }
            key = LeveldbTimelineStore.createDomainIdKey((String)entity.getEntityId(), (String)entity.getEntityType(), (byte[])revStartTime);
            if (entity.getDomainId() != null && entity.getDomainId().length() != 0) break block26;
            if (allowEmptyDomainId) ** GOTO lbl100
            error = new TimelinePutResponse.TimelinePutError();
            error.setEntityId(entity.getEntityId());
            error.setEntityType(entity.getEntityType());
            error.setErrorCode(5);
            response.addError(error);
            lock.unlock();
            this.writeLocks.returnLock(lock);
            IOUtils.cleanup((Log)LeveldbTimelineStore.LOG, (Closeable[])new Closeable[]{writeBatch});
            return;
        }
        try {
            writeBatch.put(key, entity.getDomainId().getBytes());
            LeveldbTimelineStore.writePrimaryFilterEntries((WriteBatch)writeBatch, (Map)primaryFilters, (byte[])key, (byte[])entity.getDomainId().getBytes());
lbl100:
            // 2 sources

            this.db.write(writeBatch);
        }
        catch (IOException e) {
            try {
                LeveldbTimelineStore.LOG.error((Object)("Error putting entity " + entity.getEntityId() + " of type " + entity.getEntityType()), (Throwable)e);
                error = new TimelinePutResponse.TimelinePutError();
                error.setEntityId(entity.getEntityId());
                error.setEntityType(entity.getEntityType());
                error.setErrorCode(2);
                response.addError(error);
            }
            catch (Throwable var24_27) {
                lock.unlock();
                this.writeLocks.returnLock(lock);
                IOUtils.cleanup((Log)LeveldbTimelineStore.LOG, (Closeable[])new Closeable[]{writeBatch});
                throw var24_27;
            }
            lock.unlock();
            this.writeLocks.returnLock(lock);
            IOUtils.cleanup((Log)LeveldbTimelineStore.LOG, (Closeable[])new Closeable[]{writeBatch});
        }
        lock.unlock();
        this.writeLocks.returnLock(lock);
        IOUtils.cleanup((Log)LeveldbTimelineStore.LOG, (Closeable[])new Closeable[]{writeBatch});
        for (EntityIdentifier relatedEntity : relatedEntitiesWithoutStartTimes) {
            lock = this.writeLocks.getLock((Object)relatedEntity);
            lock.lock();
            try {
                relatedEntityStartAndInsertTime = this.getAndSetStartTime(relatedEntity.getId(), relatedEntity.getType(), Long.valueOf(GenericObjectMapper.readReverseOrderedLong((byte[])revStartTime, (int)0)), null);
                if (relatedEntityStartAndInsertTime == null) {
                    throw new IOException("Error setting start time for related entity");
                }
                relatedEntityStartTime = GenericObjectMapper.writeReverseOrderedLong((long)relatedEntityStartAndInsertTime.startTime);
                key = LeveldbTimelineStore.createDomainIdKey((String)relatedEntity.getId(), (String)relatedEntity.getType(), (byte[])relatedEntityStartTime);
                this.db.put(key, entity.getDomainId().getBytes());
                this.db.put(LeveldbTimelineStore.createRelatedEntityKey((String)relatedEntity.getId(), (String)relatedEntity.getType(), (byte[])relatedEntityStartTime, (String)entity.getEntityId(), (String)entity.getEntityType()), LeveldbTimelineStore.EMPTY_BYTES);
                this.db.put(LeveldbTimelineStore.createEntityMarkerKey((String)relatedEntity.getId(), (String)relatedEntity.getType(), (byte[])relatedEntityStartTime), GenericObjectMapper.writeReverseOrderedLong((long)relatedEntityStartAndInsertTime.insertTime));
            }
            catch (IOException e) {
                LeveldbTimelineStore.LOG.error((Object)("Error putting related entity " + relatedEntity.getId() + " of type " + relatedEntity.getType() + " for entity " + entity.getEntityId() + " of type " + entity.getEntityType()), (Throwable)e);
                error = new TimelinePutResponse.TimelinePutError();
                error.setEntityId(entity.getEntityId());
                error.setEntityType(entity.getEntityType());
                error.setErrorCode(2);
                response.addError(error);
            }
            finally {
                lock.unlock();
                this.writeLocks.returnLock(lock);
            }
        }
    }

    private static void writePrimaryFilterEntries(WriteBatch writeBatch, Map<String, Set<Object>> primaryFilters, byte[] key, byte[] value) throws IOException {
        if (primaryFilters != null && !primaryFilters.isEmpty()) {
            for (Map.Entry<String, Set<Object>> pf : primaryFilters.entrySet()) {
                for (Object pfval : pf.getValue()) {
                    writeBatch.put(LeveldbTimelineStore.addPrimaryFilterToKey((String)pf.getKey(), (Object)pfval, (byte[])key), value);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimelinePutResponse put(TimelineEntities entities) {
        try {
            this.deleteLock.readLock().lock();
            TimelinePutResponse response = new TimelinePutResponse();
            for (TimelineEntity entity : entities.getEntities()) {
                this.put(entity, response, false);
            }
            TimelinePutResponse timelinePutResponse = response;
            return timelinePutResponse;
        }
        finally {
            this.deleteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @VisibleForTesting
    public TimelinePutResponse putWithNoDomainId(TimelineEntities entities) {
        try {
            this.deleteLock.readLock().lock();
            TimelinePutResponse response = new TimelinePutResponse();
            for (TimelineEntity entity : entities.getEntities()) {
                this.put(entity, response, true);
            }
            TimelinePutResponse timelinePutResponse = response;
            return timelinePutResponse;
        }
        finally {
            this.deleteLock.readLock().unlock();
        }
    }

    private byte[] getStartTime(String entityId, String entityType) throws IOException {
        Long l = this.getStartTimeLong(entityId, entityType);
        return l == null ? null : GenericObjectMapper.writeReverseOrderedLong((long)l);
    }

    private Long getStartTimeLong(String entityId, String entityType) throws IOException {
        EntityIdentifier entity = new EntityIdentifier(entityId, entityType);
        if (this.startTimeReadCache.containsKey(entity)) {
            return (Long)this.startTimeReadCache.get(entity);
        }
        byte[] b = LeveldbTimelineStore.createStartTimeLookupKey((String)entity.getId(), (String)entity.getType());
        byte[] v = this.db.get(b);
        if (v == null) {
            return null;
        }
        Long l = GenericObjectMapper.readReverseOrderedLong((byte[])v, (int)0);
        this.startTimeReadCache.put(entity, l);
        return l;
    }

    private StartAndInsertTime getAndSetStartTime(String entityId, String entityType, Long startTime, List<TimelineEvent> events) throws IOException {
        EntityIdentifier entity = new EntityIdentifier(entityId, entityType);
        if (startTime == null) {
            if (this.startTimeWriteCache.containsKey(entity)) {
                return (StartAndInsertTime)this.startTimeWriteCache.get(entity);
            }
            if (events != null) {
                Long min = Long.MAX_VALUE;
                for (TimelineEvent e : events) {
                    if (min <= e.getTimestamp()) continue;
                    min = e.getTimestamp();
                }
                startTime = min;
            }
            return this.checkStartTimeInDb(entity, startTime);
        }
        if (this.startTimeWriteCache.containsKey(entity)) {
            return (StartAndInsertTime)this.startTimeWriteCache.get(entity);
        }
        return this.checkStartTimeInDb(entity, startTime);
    }

    private StartAndInsertTime checkStartTimeInDb(EntityIdentifier entity, Long suggestedStartTime) throws IOException {
        StartAndInsertTime startAndInsertTime = null;
        byte[] b = LeveldbTimelineStore.createStartTimeLookupKey((String)entity.getId(), (String)entity.getType());
        byte[] v = this.db.get(b);
        if (v == null) {
            if (suggestedStartTime == null) {
                return null;
            }
            startAndInsertTime = new StartAndInsertTime(suggestedStartTime.longValue(), System.currentTimeMillis());
            v = new byte[16];
            GenericObjectMapper.writeReverseOrderedLong((long)suggestedStartTime, (byte[])v, (int)0);
            GenericObjectMapper.writeReverseOrderedLong((long)startAndInsertTime.insertTime, (byte[])v, (int)8);
            WriteOptions writeOptions = new WriteOptions();
            writeOptions.sync(true);
            this.db.put(b, v, writeOptions);
        } else {
            startAndInsertTime = new StartAndInsertTime(GenericObjectMapper.readReverseOrderedLong((byte[])v, (int)0), GenericObjectMapper.readReverseOrderedLong((byte[])v, (int)8));
        }
        this.startTimeWriteCache.put(entity, startAndInsertTime);
        this.startTimeReadCache.put(entity, startAndInsertTime.startTime);
        return startAndInsertTime;
    }

    private static byte[] createStartTimeLookupKey(String entityId, String entityType) throws IOException {
        return KeyBuilder.newInstance().add(START_TIME_LOOKUP_PREFIX).add(entityType).add(entityId).getBytes();
    }

    private static byte[] createEntityMarkerKey(String entityId, String entityType, byte[] revStartTime) throws IOException {
        return KeyBuilder.newInstance().add(ENTITY_ENTRY_PREFIX).add(entityType).add(revStartTime).add(entityId).getBytesForLookup();
    }

    private static byte[] addPrimaryFilterToKey(String primaryFilterName, Object primaryFilterValue, byte[] key) throws IOException {
        return KeyBuilder.newInstance().add(INDEXED_ENTRY_PREFIX).add(primaryFilterName).add(GenericObjectMapper.write((Object)primaryFilterValue), true).add(key).getBytes();
    }

    private static byte[] createEntityEventKey(String entityId, String entityType, byte[] revStartTime, byte[] revEventTimestamp, String eventType) throws IOException {
        return KeyBuilder.newInstance().add(ENTITY_ENTRY_PREFIX).add(entityType).add(revStartTime).add(entityId).add(EVENTS_COLUMN).add(revEventTimestamp).add(eventType).getBytes();
    }

    private static TimelineEvent getEntityEvent(Set<String> eventTypes, byte[] key, int offset, byte[] value) throws IOException {
        KeyParser kp = new KeyParser(key, offset);
        long ts = kp.getNextLong();
        String tstype = kp.getNextString();
        if (eventTypes == null || eventTypes.contains(tstype)) {
            TimelineEvent event = new TimelineEvent();
            event.setTimestamp(ts);
            event.setEventType(tstype);
            Object o = GenericObjectMapper.read((byte[])value);
            if (o == null) {
                event.setEventInfo(null);
            } else if (o instanceof Map) {
                Map m = (Map)o;
                event.setEventInfo(m);
            } else {
                throw new IOException("Couldn't deserialize event info map");
            }
            return event;
        }
        return null;
    }

    private static byte[] createPrimaryFilterKey(String entityId, String entityType, byte[] revStartTime, String name, Object value) throws IOException {
        return KeyBuilder.newInstance().add(ENTITY_ENTRY_PREFIX).add(entityType).add(revStartTime).add(entityId).add(PRIMARY_FILTERS_COLUMN).add(name).add(GenericObjectMapper.write((Object)value)).getBytes();
    }

    private static void addPrimaryFilter(TimelineEntity entity, byte[] key, int offset) throws IOException {
        KeyParser kp = new KeyParser(key, offset);
        String name = kp.getNextString();
        Object value = GenericObjectMapper.read((byte[])key, (int)kp.getOffset());
        entity.addPrimaryFilter(name, value);
    }

    private static byte[] createOtherInfoKey(String entityId, String entityType, byte[] revStartTime, String name) throws IOException {
        return KeyBuilder.newInstance().add(ENTITY_ENTRY_PREFIX).add(entityType).add(revStartTime).add(entityId).add(OTHER_INFO_COLUMN).add(name).getBytes();
    }

    private static String parseRemainingKey(byte[] b, int offset) {
        return new String(b, offset, b.length - offset);
    }

    private static byte[] createRelatedEntityKey(String entityId, String entityType, byte[] revStartTime, String relatedEntityId, String relatedEntityType) throws IOException {
        return KeyBuilder.newInstance().add(ENTITY_ENTRY_PREFIX).add(entityType).add(revStartTime).add(entityId).add(RELATED_ENTITIES_COLUMN).add(relatedEntityType).add(relatedEntityId).getBytes();
    }

    private static void addRelatedEntity(TimelineEntity entity, byte[] key, int offset) throws IOException {
        KeyParser kp = new KeyParser(key, offset);
        String type = kp.getNextString();
        String id = kp.getNextString();
        entity.addRelatedEntity(type, id);
    }

    private static byte[] createReverseRelatedEntityKey(String entityId, String entityType, byte[] revStartTime, String relatedEntityId, String relatedEntityType) throws IOException {
        return KeyBuilder.newInstance().add(ENTITY_ENTRY_PREFIX).add(entityType).add(revStartTime).add(entityId).add(INVISIBLE_REVERSE_RELATED_ENTITIES_COLUMN).add(relatedEntityType).add(relatedEntityId).getBytes();
    }

    private static byte[] createDomainIdKey(String entityId, String entityType, byte[] revStartTime) throws IOException {
        return KeyBuilder.newInstance().add(ENTITY_ENTRY_PREFIX).add(entityType).add(revStartTime).add(entityId).add(DOMAIN_ID_COLUMN).getBytes();
    }

    @VisibleForTesting
    void clearStartTimeCache() {
        this.startTimeWriteCache.clear();
        this.startTimeReadCache.clear();
    }

    @VisibleForTesting
    static int getStartTimeReadCacheSize(Configuration conf) {
        return conf.getInt("yarn.timeline-service.leveldb-timeline-store.start-time-read-cache-size", 10000);
    }

    @VisibleForTesting
    static int getStartTimeWriteCacheSize(Configuration conf) {
        return conf.getInt("yarn.timeline-service.leveldb-timeline-store.start-time-write-cache-size", 10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    List<String> getEntityTypes() throws IOException {
        ArrayList<String> arrayList;
        DBIterator iterator = null;
        try {
            byte[] key;
            iterator = this.getDbIterator(false);
            ArrayList<String> entityTypes = new ArrayList<String>();
            iterator.seek(ENTITY_ENTRY_PREFIX);
            while (iterator.hasNext() && (key = (byte[])iterator.peekNext().getKey())[0] == ENTITY_ENTRY_PREFIX[0]) {
                KeyParser kp = new KeyParser(key, ENTITY_ENTRY_PREFIX.length);
                String entityType = kp.getNextString();
                entityTypes.add(entityType);
                byte[] lookupKey = KeyBuilder.newInstance().add(ENTITY_ENTRY_PREFIX).add(entityType).getBytesForLookup();
                if (lookupKey[lookupKey.length - 1] != 0) {
                    throw new IOException("Found unexpected end byte in lookup key");
                }
                lookupKey[lookupKey.length - 1] = 1;
                iterator.seek(lookupKey);
            }
            arrayList = entityTypes;
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{iterator});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{iterator});
        return arrayList;
    }

    private void deleteKeysWithPrefix(WriteBatch writeBatch, byte[] prefix, DBIterator iterator) {
        byte[] key;
        iterator.seek(prefix);
        while (iterator.hasNext() && LeveldbTimelineStore.prefixMatches((byte[])prefix, (int)prefix.length, (byte[])(key = (byte[])iterator.peekNext().getKey()))) {
            writeBatch.delete(key);
            iterator.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean deleteNextEntity(String entityType, byte[] reverseTimestamp, DBIterator iterator, DBIterator pfIterator, boolean seeked) throws IOException {
        boolean bl;
        byte[] entityKey;
        byte[] typePrefix;
        WriteBatch writeBatch;
        block21: {
            block20: {
                writeBatch = null;
                KeyBuilder kb = KeyBuilder.newInstance().add(ENTITY_ENTRY_PREFIX).add(entityType);
                typePrefix = kb.getBytesForLookup();
                kb.add(reverseTimestamp);
                if (!seeked) {
                    iterator.seek(kb.getBytesForLookup());
                }
                if (iterator.hasNext()) break block20;
                boolean bl2 = false;
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{writeBatch});
                return bl2;
            }
            entityKey = (byte[])iterator.peekNext().getKey();
            if (LeveldbTimelineStore.prefixMatches((byte[])typePrefix, (int)typePrefix.length, (byte[])entityKey)) break block21;
            boolean bl3 = false;
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{writeBatch});
            return bl3;
        }
        try {
            byte[] key;
            KeyParser kp = new KeyParser(entityKey, typePrefix.length + 8);
            String entityId = kp.getNextString();
            int prefixlen = kp.getOffset();
            byte[] deletePrefix = new byte[prefixlen];
            System.arraycopy(entityKey, 0, deletePrefix, 0, prefixlen);
            writeBatch = this.db.createWriteBatch();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Deleting entity type:" + entityType + " id:" + entityId));
            }
            writeBatch.delete(LeveldbTimelineStore.createStartTimeLookupKey((String)entityId, (String)entityType));
            EntityIdentifier entityIdentifier = new EntityIdentifier(entityId, entityType);
            this.startTimeReadCache.remove(entityIdentifier);
            this.startTimeWriteCache.remove(entityIdentifier);
            while (iterator.hasNext() && LeveldbTimelineStore.prefixMatches((byte[])entityKey, (int)prefixlen, (byte[])(key = (byte[])iterator.peekNext().getKey()))) {
                writeBatch.delete(key);
                if (key.length != prefixlen) {
                    byte[] relatedEntityStartTime;
                    String id;
                    String type;
                    if (key[prefixlen] == PRIMARY_FILTERS_COLUMN[0]) {
                        kp = new KeyParser(key, prefixlen + PRIMARY_FILTERS_COLUMN.length);
                        String name = kp.getNextString();
                        Object value = GenericObjectMapper.read((byte[])key, (int)kp.getOffset());
                        this.deleteKeysWithPrefix(writeBatch, LeveldbTimelineStore.addPrimaryFilterToKey((String)name, (Object)value, (byte[])deletePrefix), pfIterator);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Deleting entity type:" + entityType + " id:" + entityId + " primary filter entry " + name + " " + value));
                        }
                    } else if (key[prefixlen] == RELATED_ENTITIES_COLUMN[0]) {
                        kp = new KeyParser(key, prefixlen + RELATED_ENTITIES_COLUMN.length);
                        type = kp.getNextString();
                        id = kp.getNextString();
                        relatedEntityStartTime = this.getStartTime(id, type);
                        if (relatedEntityStartTime == null) {
                            LOG.warn((Object)("Found no start time for related entity " + id + " of type " + type + " while " + "deleting " + entityId + " of type " + entityType));
                        } else {
                            writeBatch.delete(LeveldbTimelineStore.createReverseRelatedEntityKey((String)id, (String)type, (byte[])relatedEntityStartTime, (String)entityId, (String)entityType));
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Deleting entity type:" + entityType + " id:" + entityId + " from invisible reverse related entity " + "entry of type:" + type + " id:" + id));
                            }
                        }
                    } else if (key[prefixlen] == INVISIBLE_REVERSE_RELATED_ENTITIES_COLUMN[0]) {
                        kp = new KeyParser(key, prefixlen + INVISIBLE_REVERSE_RELATED_ENTITIES_COLUMN.length);
                        type = kp.getNextString();
                        id = kp.getNextString();
                        relatedEntityStartTime = this.getStartTime(id, type);
                        if (relatedEntityStartTime == null) {
                            LOG.warn((Object)("Found no start time for reverse related entity " + id + " of type " + type + " while " + "deleting " + entityId + " of type " + entityType));
                        } else {
                            writeBatch.delete(LeveldbTimelineStore.createRelatedEntityKey((String)id, (String)type, (byte[])relatedEntityStartTime, (String)entityId, (String)entityType));
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Deleting entity type:" + entityType + " id:" + entityId + " from related entity entry of type:" + type + " id:" + id));
                            }
                        }
                    }
                }
                iterator.next();
            }
            WriteOptions writeOptions = new WriteOptions();
            writeOptions.sync(true);
            this.db.write(writeBatch, writeOptions);
            bl = true;
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{writeBatch});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{writeBatch});
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    void discardOldEntities(long timestamp) throws IOException, InterruptedException {
        byte[] reverseTimestamp = GenericObjectMapper.writeReverseOrderedLong((long)timestamp);
        long totalCount = 0L;
        long t1 = System.currentTimeMillis();
        try {
            List entityTypes = this.getEntityTypes();
            for (String entityType : entityTypes) {
                DBIterator iterator = null;
                DBIterator pfIterator = null;
                long typeCount = 0L;
                try {
                    this.deleteLock.writeLock().lock();
                    iterator = this.getDbIterator(false);
                    pfIterator = this.getDbIterator(false);
                    if (this.deletionThread != null && this.deletionThread.isInterrupted()) {
                        throw new InterruptedException();
                    }
                    boolean seeked = false;
                    while (this.deleteNextEntity(entityType, reverseTimestamp, iterator, pfIterator, seeked)) {
                        ++typeCount;
                        ++totalCount;
                        seeked = true;
                        if (this.deletionThread == null || !this.deletionThread.isInterrupted()) continue;
                        throw new InterruptedException();
                    }
                }
                catch (IOException e) {
                    try {
                        LOG.error((Object)("Got IOException while deleting entities for type " + entityType + ", continuing to next type"), (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{iterator, pfIterator});
                        this.deleteLock.writeLock().unlock();
                        if (typeCount <= 0L) throw throwable;
                        LOG.info((Object)("Deleted " + typeCount + " entities of type " + entityType));
                        throw throwable;
                        return;
                    }
                    IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{iterator, pfIterator});
                    this.deleteLock.writeLock().unlock();
                    if (typeCount <= 0L) continue;
                    LOG.info((Object)("Deleted " + typeCount + " entities of type " + entityType));
                    continue;
                }
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{iterator, pfIterator});
                this.deleteLock.writeLock().unlock();
                if (typeCount <= 0L) continue;
                LOG.info((Object)("Deleted " + typeCount + " entities of type " + entityType));
            }
        }
        finally {
            long t2 = System.currentTimeMillis();
            LOG.info((Object)("Discarded " + totalCount + " entities for timestamp " + timestamp + " and earlier in " + (double)(t2 - t1) / 1000.0 + " seconds"));
        }
    }

    @VisibleForTesting
    DBIterator getDbIterator(boolean fillCache) {
        ReadOptions readOptions = new ReadOptions();
        readOptions.fillCache(fillCache);
        return this.db.iterator(readOptions);
    }

    Version loadVersion() throws IOException {
        byte[] data = this.db.get(JniDBFactory.bytes((String)"timeline-store-version"));
        if (data == null || data.length == 0) {
            return Version.newInstance((int)1, (int)0);
        }
        VersionPBImpl version = new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom((byte[])data));
        return version;
    }

    @VisibleForTesting
    void storeVersion(Version state) throws IOException {
        this.dbStoreVersion(state);
    }

    private void dbStoreVersion(Version state) throws IOException {
        String key = "timeline-store-version";
        byte[] data = ((VersionPBImpl)state).getProto().toByteArray();
        try {
            this.db.put(JniDBFactory.bytes((String)key), data);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    private void checkVersion() throws IOException {
        Version loadedVersion = this.loadVersion();
        LOG.info((Object)("Loaded timeline store version info " + loadedVersion));
        if (loadedVersion.equals((Object)this.getCurrentVersion())) {
            return;
        }
        if (!loadedVersion.isCompatibleTo(this.getCurrentVersion())) {
            String incompatibleMessage = "Incompatible version for timeline store: expecting version " + this.getCurrentVersion() + ", but loading version " + loadedVersion;
            LOG.fatal((Object)incompatibleMessage);
            throw new IOException(incompatibleMessage);
        }
        LOG.info((Object)("Storing timeline store version info " + this.getCurrentVersion()));
        this.dbStoreVersion(CURRENT_VERSION_INFO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(TimelineDomain domain) throws IOException {
        WriteBatch writeBatch = null;
        try {
            writeBatch = this.db.createWriteBatch();
            if (domain.getId() == null || domain.getId().length() == 0) {
                throw new IllegalArgumentException("Domain doesn't have an ID");
            }
            if (domain.getOwner() == null || domain.getOwner().length() == 0) {
                throw new IllegalArgumentException("Domain doesn't have an owner.");
            }
            byte[] domainEntryKey = LeveldbTimelineStore.createDomainEntryKey((String)domain.getId(), (byte[])DESCRIPTION_COLUMN);
            byte[] ownerLookupEntryKey = LeveldbTimelineStore.createOwnerLookupKey((String)domain.getOwner(), (String)domain.getId(), (byte[])DESCRIPTION_COLUMN);
            if (domain.getDescription() != null) {
                writeBatch.put(domainEntryKey, domain.getDescription().getBytes());
                writeBatch.put(ownerLookupEntryKey, domain.getDescription().getBytes());
            } else {
                writeBatch.put(domainEntryKey, EMPTY_BYTES);
                writeBatch.put(ownerLookupEntryKey, EMPTY_BYTES);
            }
            domainEntryKey = LeveldbTimelineStore.createDomainEntryKey((String)domain.getId(), (byte[])OWNER_COLUMN);
            ownerLookupEntryKey = LeveldbTimelineStore.createOwnerLookupKey((String)domain.getOwner(), (String)domain.getId(), (byte[])OWNER_COLUMN);
            writeBatch.put(domainEntryKey, domain.getOwner().getBytes());
            writeBatch.put(ownerLookupEntryKey, domain.getOwner().getBytes());
            domainEntryKey = LeveldbTimelineStore.createDomainEntryKey((String)domain.getId(), (byte[])READER_COLUMN);
            ownerLookupEntryKey = LeveldbTimelineStore.createOwnerLookupKey((String)domain.getOwner(), (String)domain.getId(), (byte[])READER_COLUMN);
            if (domain.getReaders() != null && domain.getReaders().length() > 0) {
                writeBatch.put(domainEntryKey, domain.getReaders().getBytes());
                writeBatch.put(ownerLookupEntryKey, domain.getReaders().getBytes());
            } else {
                writeBatch.put(domainEntryKey, EMPTY_BYTES);
                writeBatch.put(ownerLookupEntryKey, EMPTY_BYTES);
            }
            domainEntryKey = LeveldbTimelineStore.createDomainEntryKey((String)domain.getId(), (byte[])WRITER_COLUMN);
            ownerLookupEntryKey = LeveldbTimelineStore.createOwnerLookupKey((String)domain.getOwner(), (String)domain.getId(), (byte[])WRITER_COLUMN);
            if (domain.getWriters() != null && domain.getWriters().length() > 0) {
                writeBatch.put(domainEntryKey, domain.getWriters().getBytes());
                writeBatch.put(ownerLookupEntryKey, domain.getWriters().getBytes());
            } else {
                writeBatch.put(domainEntryKey, EMPTY_BYTES);
                writeBatch.put(ownerLookupEntryKey, EMPTY_BYTES);
            }
            domainEntryKey = LeveldbTimelineStore.createDomainEntryKey((String)domain.getId(), (byte[])TIMESTAMP_COLUMN);
            ownerLookupEntryKey = LeveldbTimelineStore.createOwnerLookupKey((String)domain.getOwner(), (String)domain.getId(), (byte[])TIMESTAMP_COLUMN);
            long currentTimestamp = System.currentTimeMillis();
            byte[] timestamps = this.db.get(domainEntryKey);
            if (timestamps == null) {
                timestamps = new byte[16];
                GenericObjectMapper.writeReverseOrderedLong((long)currentTimestamp, (byte[])timestamps, (int)0);
                GenericObjectMapper.writeReverseOrderedLong((long)currentTimestamp, (byte[])timestamps, (int)8);
            } else {
                GenericObjectMapper.writeReverseOrderedLong((long)currentTimestamp, (byte[])timestamps, (int)8);
            }
            writeBatch.put(domainEntryKey, timestamps);
            writeBatch.put(ownerLookupEntryKey, timestamps);
            this.db.write(writeBatch);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{writeBatch});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{writeBatch});
    }

    private static byte[] createDomainEntryKey(String domainId, byte[] columnName) throws IOException {
        return KeyBuilder.newInstance().add(DOMAIN_ENTRY_PREFIX).add(domainId).add(columnName).getBytes();
    }

    private static byte[] createOwnerLookupKey(String owner, String domainId, byte[] columnName) throws IOException {
        return KeyBuilder.newInstance().add(OWNER_LOOKUP_PREFIX).add(owner).add(domainId).add(columnName).getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimelineDomain getDomain(String domainId) throws IOException {
        TimelineDomain timelineDomain;
        DBIterator iterator = null;
        try {
            byte[] prefix = KeyBuilder.newInstance().add(DOMAIN_ENTRY_PREFIX).add(domainId).getBytesForLookup();
            iterator = this.db.iterator();
            iterator.seek(prefix);
            timelineDomain = LeveldbTimelineStore.getTimelineDomain((DBIterator)iterator, (String)domainId, (byte[])prefix);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{iterator});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{iterator});
        return timelineDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimelineDomains getDomains(String owner) throws IOException {
        TimelineDomains timelineDomains;
        DBIterator iterator = null;
        try {
            byte[] key;
            byte[] prefix = KeyBuilder.newInstance().add(OWNER_LOOKUP_PREFIX).add(owner).getBytesForLookup();
            ArrayList<TimelineDomain> domains = new ArrayList<TimelineDomain>();
            iterator = this.db.iterator();
            iterator.seek(prefix);
            while (iterator.hasNext() && LeveldbTimelineStore.prefixMatches((byte[])prefix, (int)prefix.length, (byte[])(key = (byte[])iterator.peekNext().getKey()))) {
                byte[] prefixExt;
                KeyParser kp = new KeyParser(key, prefix.length);
                String domainId = kp.getNextString();
                TimelineDomain domainToReturn = LeveldbTimelineStore.getTimelineDomain((DBIterator)iterator, (String)domainId, (byte[])(prefixExt = KeyBuilder.newInstance().add(OWNER_LOOKUP_PREFIX).add(owner).add(domainId).getBytesForLookup()));
                if (domainToReturn == null) continue;
                domains.add(domainToReturn);
            }
            Collections.sort(domains, new /* Unavailable Anonymous Inner Class!! */);
            TimelineDomains domainsToReturn = new TimelineDomains();
            domainsToReturn.addDomains(domains);
            timelineDomains = domainsToReturn;
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{iterator});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{iterator});
        return timelineDomains;
    }

    private static TimelineDomain getTimelineDomain(DBIterator iterator, String domainId, byte[] prefix) throws IOException {
        byte[] key;
        TimelineDomain domain = new TimelineDomain();
        domain.setId(domainId);
        boolean noRows = true;
        while (iterator.hasNext() && LeveldbTimelineStore.prefixMatches((byte[])prefix, (int)prefix.length, (byte[])(key = (byte[])iterator.peekNext().getKey()))) {
            byte[] value;
            if (noRows) {
                noRows = false;
            }
            if ((value = (byte[])iterator.peekNext().getValue()) != null && value.length > 0) {
                if (key[prefix.length] == DESCRIPTION_COLUMN[0]) {
                    domain.setDescription(new String(value));
                } else if (key[prefix.length] == OWNER_COLUMN[0]) {
                    domain.setOwner(new String(value));
                } else if (key[prefix.length] == READER_COLUMN[0]) {
                    domain.setReaders(new String(value));
                } else if (key[prefix.length] == WRITER_COLUMN[0]) {
                    domain.setWriters(new String(value));
                } else if (key[prefix.length] == TIMESTAMP_COLUMN[0]) {
                    domain.setCreatedTime(Long.valueOf(GenericObjectMapper.readReverseOrderedLong((byte[])value, (int)0)));
                    domain.setModifiedTime(Long.valueOf(GenericObjectMapper.readReverseOrderedLong((byte[])value, (int)8)));
                } else {
                    LOG.error((Object)("Unrecognized domain column: " + key[prefix.length]));
                }
            }
            iterator.next();
        }
        if (noRows) {
            return null;
        }
        return domain;
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }
}

