/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryClientService;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManager;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManagerOnTimelineStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.TestApplicationHistoryManagerOnTimelineStore;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestApplicationHistoryClientService {
    private static ApplicationHistoryClientService clientService;

    @BeforeClass
    public static void setup() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        TimelineStore store = TestApplicationHistoryManagerOnTimelineStore.createStore((int)2);
        TimelineACLsManager aclsManager = new TimelineACLsManager((Configuration)conf);
        TimelineDataManager dataManager = new TimelineDataManager(store, aclsManager);
        ApplicationACLsManager appAclsManager = new ApplicationACLsManager((Configuration)conf);
        ApplicationHistoryManagerOnTimelineStore historyManager = new ApplicationHistoryManagerOnTimelineStore(dataManager, appAclsManager);
        historyManager.init((Configuration)conf);
        historyManager.start();
        clientService = new ApplicationHistoryClientService((ApplicationHistoryManager)historyManager);
    }

    @Test
    public void testApplicationReport() throws IOException, YarnException {
        ApplicationId appId = null;
        appId = ApplicationId.newInstance((long)0L, (int)1);
        GetApplicationReportRequest request = GetApplicationReportRequest.newInstance((ApplicationId)appId);
        GetApplicationReportResponse response = clientService.getClientHandler().getApplicationReport(request);
        ApplicationReport appReport = response.getApplicationReport();
        Assert.assertNotNull((Object)appReport);
        Assert.assertEquals((Object)"application_0_0001", (Object)appReport.getApplicationId().toString());
        Assert.assertEquals((Object)"test app type", (Object)appReport.getApplicationType().toString());
        Assert.assertEquals((Object)"test queue", (Object)appReport.getQueue().toString());
    }

    @Test
    public void testApplications() throws IOException, YarnException {
        ApplicationId appId = null;
        appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationId appId1 = ApplicationId.newInstance((long)0L, (int)2);
        GetApplicationsRequest request = GetApplicationsRequest.newInstance();
        GetApplicationsResponse response = clientService.getClientHandler().getApplications(request);
        List appReport = response.getApplicationList();
        Assert.assertNotNull((Object)appReport);
        Assert.assertEquals((Object)appId, (Object)((ApplicationReport)appReport.get(0)).getApplicationId());
        Assert.assertEquals((Object)appId1, (Object)((ApplicationReport)appReport.get(1)).getApplicationId());
    }

    @Test
    public void testApplicationAttemptReport() throws IOException, YarnException {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        GetApplicationAttemptReportRequest request = GetApplicationAttemptReportRequest.newInstance((ApplicationAttemptId)appAttemptId);
        GetApplicationAttemptReportResponse response = clientService.getClientHandler().getApplicationAttemptReport(request);
        ApplicationAttemptReport attemptReport = response.getApplicationAttemptReport();
        Assert.assertNotNull((Object)attemptReport);
        Assert.assertEquals((Object)"appattempt_0_0001_000001", (Object)attemptReport.getApplicationAttemptId().toString());
    }

    @Test
    public void testApplicationAttempts() throws IOException, YarnException {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ApplicationAttemptId appAttemptId1 = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)2);
        GetApplicationAttemptsRequest request = GetApplicationAttemptsRequest.newInstance((ApplicationId)appId);
        GetApplicationAttemptsResponse response = clientService.getClientHandler().getApplicationAttempts(request);
        List attemptReports = response.getApplicationAttemptList();
        Assert.assertNotNull((Object)attemptReports);
        Assert.assertEquals((Object)appAttemptId, (Object)((ApplicationAttemptReport)attemptReports.get(0)).getApplicationAttemptId());
        Assert.assertEquals((Object)appAttemptId1, (Object)((ApplicationAttemptReport)attemptReports.get(1)).getApplicationAttemptId());
    }

    @Test
    public void testContainerReport() throws IOException, YarnException {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        GetContainerReportRequest request = GetContainerReportRequest.newInstance((ContainerId)containerId);
        GetContainerReportResponse response = clientService.getClientHandler().getContainerReport(request);
        ContainerReport container = response.getContainerReport();
        Assert.assertNotNull((Object)container);
        Assert.assertEquals((Object)containerId, (Object)container.getContainerId());
        Assert.assertEquals((Object)"http://0.0.0.0:8188/applicationhistory/logs/test host:100/container_0_0001_01_000001/container_0_0001_01_000001/user1", (Object)container.getLogUrl());
    }

    @Test
    public void testContainers() throws IOException, YarnException {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        ContainerId containerId1 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)2L);
        GetContainersRequest request = GetContainersRequest.newInstance((ApplicationAttemptId)appAttemptId);
        GetContainersResponse response = clientService.getClientHandler().getContainers(request);
        List containers = response.getContainerList();
        Assert.assertNotNull((Object)containers);
        Assert.assertEquals((Object)containerId, (Object)((ContainerReport)containers.get(1)).getContainerId());
        Assert.assertEquals((Object)containerId1, (Object)((ContainerReport)containers.get(0)).getContainerId());
    }
}

