/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.ApplicationHistoryProtocol;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryClientService;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManager;
import org.apache.hadoop.yarn.server.timeline.security.authorize.TimelinePolicyProvider;

public class ApplicationHistoryClientService
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(ApplicationHistoryClientService.class);
    private ApplicationHistoryManager history;
    private ApplicationHistoryProtocol protocolHandler;
    private Server server;
    private InetSocketAddress bindAddress;

    public ApplicationHistoryClientService(ApplicationHistoryManager history) {
        super("ApplicationHistoryClientService");
        this.history = history;
        this.protocolHandler = new ApplicationHSClientProtocolHandler(this, null);
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        InetSocketAddress address = conf.getSocketAddr("yarn.timeline-service.bind-host", "yarn.timeline-service.address", "0.0.0.0:10200", 10200);
        this.server = rpc.getServer(ApplicationHistoryProtocol.class, (Object)this.protocolHandler, address, conf, null, conf.getInt("yarn.timeline-service.handler-thread-count", 10));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.refreshServiceAcls(conf, (PolicyProvider)new TimelinePolicyProvider());
        }
        this.server.start();
        this.bindAddress = conf.updateConnectAddr("yarn.timeline-service.bind-host", "yarn.timeline-service.address", "0.0.0.0:10200", this.server.getListenerAddress());
        LOG.info((Object)("Instantiated ApplicationHistoryClientService at " + this.bindAddress));
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        super.serviceStop();
    }

    @InterfaceAudience.Private
    public ApplicationHistoryProtocol getClientHandler() {
        return this.protocolHandler;
    }

    @InterfaceAudience.Private
    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    private void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAcl(configuration, policyProvider);
    }

    static /* synthetic */ ApplicationHistoryManager access$100(ApplicationHistoryClientService x0) {
        return x0.history;
    }
}

