/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.client;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.URL;
import java.util.Properties;
import org.apache.catalina.Context;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.startup.Tomcat;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.AuthenticatorTestCase;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.SystemDefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;

public class AuthenticatorTestCase {
    private Server server;
    private String host = null;
    private int port = -1;
    private boolean useTomcat = false;
    private Tomcat tomcat = null;
    org.mortbay.jetty.servlet.Context context;
    private static Properties authenticatorConfig;
    private String POST = "test";

    public AuthenticatorTestCase() {
    }

    public AuthenticatorTestCase(boolean useTomcat) {
        this.useTomcat = useTomcat;
    }

    protected static void setAuthenticationHandlerConfig(Properties config) {
        authenticatorConfig = config;
    }

    protected int getLocalPort() throws Exception {
        ServerSocket ss = new ServerSocket(0);
        int ret = ss.getLocalPort();
        ss.close();
        return ret;
    }

    protected void start() throws Exception {
        if (this.useTomcat) {
            this.startTomcat();
        } else {
            this.startJetty();
        }
    }

    protected void startJetty() throws Exception {
        this.server = new Server(0);
        this.context = new org.mortbay.jetty.servlet.Context();
        this.context.setContextPath("/foo");
        this.server.setHandler((Handler)this.context);
        this.context.addFilter(new FilterHolder(TestFilter.class), "/*", 0);
        this.context.addServlet(new ServletHolder(TestServlet.class), "/bar");
        this.host = "localhost";
        this.port = this.getLocalPort();
        this.server.getConnectors()[0].setHost(this.host);
        this.server.getConnectors()[0].setPort(this.port);
        this.server.start();
        System.out.println("Running embedded servlet container at: http://" + this.host + ":" + this.port);
    }

    protected void startTomcat() throws Exception {
        this.tomcat = new Tomcat();
        File base = new File(System.getProperty("java.io.tmpdir"));
        Context ctx = this.tomcat.addContext("/foo", base.getAbsolutePath());
        FilterDef fd = new FilterDef();
        fd.setFilterClass(TestFilter.class.getName());
        fd.setFilterName("TestFilter");
        FilterMap fm = new FilterMap();
        fm.setFilterName("TestFilter");
        fm.addURLPattern("/*");
        fm.addServletName("/bar");
        ctx.addFilterDef(fd);
        ctx.addFilterMap(fm);
        Tomcat.addServlet((Context)ctx, (String)"/bar", (String)TestServlet.class.getName());
        ctx.addServletMapping("/bar", "/bar");
        this.host = "localhost";
        this.port = this.getLocalPort();
        this.tomcat.setHostname(this.host);
        this.tomcat.setPort(this.port);
        this.tomcat.start();
    }

    protected void stop() throws Exception {
        if (this.useTomcat) {
            this.stopTomcat();
        } else {
            this.stopJetty();
        }
    }

    protected void stopJetty() throws Exception {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.server.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void stopTomcat() throws Exception {
        try {
            this.tomcat.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.tomcat.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getBaseURL() {
        return "http://" + this.host + ":" + this.port + "/foo/bar";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _testAuthentication(Authenticator authenticator, boolean doPost) throws Exception {
        this.start();
        try {
            URL url = new URL(this.getBaseURL());
            AuthenticatedURL.Token token = new AuthenticatedURL.Token();
            Assert.assertFalse((boolean)token.isSet());
            TestConnectionConfigurator connConf = new TestConnectionConfigurator(null);
            AuthenticatedURL aUrl = new AuthenticatedURL(authenticator, (ConnectionConfigurator)connConf);
            HttpURLConnection conn = aUrl.openConnection(url, token);
            Assert.assertTrue((boolean)connConf.invoked);
            String tokenStr = token.toString();
            if (doPost) {
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
            }
            conn.connect();
            if (doPost) {
                OutputStreamWriter writer = new OutputStreamWriter(conn.getOutputStream());
                writer.write(this.POST);
                ((Writer)writer).close();
            }
            Assert.assertEquals((long)200L, (long)conn.getResponseCode());
            if (doPost) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String echo = reader.readLine();
                Assert.assertEquals((Object)this.POST, (Object)echo);
                Assert.assertNull((Object)reader.readLine());
            }
            aUrl = new AuthenticatedURL();
            conn = aUrl.openConnection(url, token);
            conn.connect();
            Assert.assertEquals((long)200L, (long)conn.getResponseCode());
            Assert.assertEquals((Object)tokenStr, (Object)token.toString());
        }
        finally {
            this.stop();
        }
    }

    private SystemDefaultHttpClient getHttpClient() {
        SystemDefaultHttpClient httpClient = new SystemDefaultHttpClient();
        httpClient.getAuthSchemes().register("Negotiate", (AuthSchemeFactory)new SPNegoSchemeFactory(true));
        1 use_jaas_creds = new /* Unavailable Anonymous Inner Class!! */;
        httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)use_jaas_creds);
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHttpClientRequest(HttpClient httpClient, HttpUriRequest request) throws Exception {
        HttpResponse response = null;
        try {
            response = httpClient.execute(request);
            int httpStatus = response.getStatusLine().getStatusCode();
            Assert.assertEquals((long)200L, (long)httpStatus);
        }
        finally {
            if (response != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _testAuthenticationHttpClient(Authenticator authenticator, boolean doPost) throws Exception {
        this.start();
        try {
            SystemDefaultHttpClient httpClient = this.getHttpClient();
            this.doHttpClientRequest((HttpClient)httpClient, (HttpUriRequest)new HttpGet(this.getBaseURL()));
            if (doPost) {
                HttpPost post = new HttpPost(this.getBaseURL());
                byte[] postBytes = this.POST.getBytes();
                ByteArrayInputStream bis = new ByteArrayInputStream(postBytes);
                InputStreamEntity entity = new InputStreamEntity((InputStream)bis, (long)postBytes.length);
                Assert.assertFalse((boolean)entity.isRepeatable());
                post.setEntity((HttpEntity)entity);
                this.doHttpClientRequest((HttpClient)httpClient, (HttpUriRequest)post);
            }
        }
        finally {
            this.stop();
        }
    }

    static /* synthetic */ Properties access$000() {
        return authenticatorConfig;
    }
}

