/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthenticatedURL {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticatedURL.class);
    public static final String AUTH_COOKIE = "hadoop.auth";
    private static Class<? extends Authenticator> DEFAULT_AUTHENTICATOR = KerberosAuthenticator.class;
    private Authenticator authenticator;
    private ConnectionConfigurator connConfigurator;

    public static void setDefaultAuthenticator(Class<? extends Authenticator> authenticator) {
        DEFAULT_AUTHENTICATOR = authenticator;
    }

    public static Class<? extends Authenticator> getDefaultAuthenticator() {
        return DEFAULT_AUTHENTICATOR;
    }

    public AuthenticatedURL() {
        this(null);
    }

    public AuthenticatedURL(Authenticator authenticator) {
        this(authenticator, null);
    }

    public AuthenticatedURL(Authenticator authenticator, ConnectionConfigurator connConfigurator) {
        try {
            this.authenticator = authenticator != null ? authenticator : (Authenticator)DEFAULT_AUTHENTICATOR.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.connConfigurator = connConfigurator;
        this.authenticator.setConnectionConfigurator(connConfigurator);
    }

    protected Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public HttpURLConnection openConnection(URL url, Token token) throws IOException, AuthenticationException {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be NULL");
        }
        if (!url.getProtocol().equalsIgnoreCase("http") && !url.getProtocol().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("url must be for a HTTP or HTTPS resource");
        }
        if (token == null) {
            throw new IllegalArgumentException("token cannot be NULL");
        }
        this.authenticator.authenticate(url, token);
        return token.openConnection(url, this.connConfigurator);
    }

    public static void injectToken(HttpURLConnection conn, Token token) {
        HttpCookie authCookie = AuthCookieHandler.access$200((AuthCookieHandler)Token.access$400((Token)token));
        if (authCookie != null) {
            conn.addRequestProperty("Cookie", authCookie.toString());
        }
    }

    public static void extractToken(HttpURLConnection conn, Token token) throws IOException, AuthenticationException {
        int respCode = conn.getResponseCode();
        if (respCode != 200 && respCode != 201 && respCode != 202) {
            if (respCode == 404) {
                LOG.trace("Setting token value to null ({}), resp={}", (Object)token, (Object)respCode);
                token.set(null);
                throw new FileNotFoundException(conn.getURL().toString());
            }
            LOG.trace("Setting token value to null ({}), resp={}", (Object)token, (Object)respCode);
            token.set(null);
            throw new AuthenticationException("Authentication failed, URL: " + conn.getURL() + ", status: " + conn.getResponseCode() + ", message: " + conn.getResponseMessage());
        }
        Token.access$400((Token)token).put(null, conn.getHeaderFields());
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }
}

