/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn.highavailability;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.blob.FileSystemBlobStore;
import org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServicesUtils;
import org.apache.flink.runtime.jobmanager.HighAvailabilityMode;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.apache.flink.yarn.highavailability.YarnIntraNonHaMasterServices;
import org.apache.flink.yarn.highavailability.YarnPreConfiguredMasterNonHaServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class YarnHighAvailabilityServices
implements HighAvailabilityServices {
    public static final String FLINK_RECOVERY_DATA_DIR = "flink_recovery_data";
    protected static final Logger LOG = LoggerFactory.getLogger(YarnHighAvailabilityServices.class);
    private final ReentrantLock lock;
    protected final FileSystem flinkFileSystem;
    protected final org.apache.hadoop.fs.FileSystem hadoopFileSystem;
    protected final Path workingDirectory;
    protected final Path haDataDirectory;
    protected final BlobStoreService blobStoreService;
    private volatile boolean closed;

    protected YarnHighAvailabilityServices(Configuration config, org.apache.hadoop.conf.Configuration hadoopConf) throws IOException {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)hadoopConf);
        this.lock = new ReentrantLock();
        URI fsUri = org.apache.hadoop.fs.FileSystem.getDefaultUri((org.apache.hadoop.conf.Configuration)hadoopConf);
        if (fsUri.getScheme() == null || !"hdfs".equals(fsUri.getScheme().toLowerCase())) {
            throw new IOException("Invalid file system found for YarnHighAvailabilityServices: Expected 'hdfs', but found '" + fsUri.getScheme() + "'.");
        }
        try {
            Class fsClass = org.apache.hadoop.fs.FileSystem.getFileSystemClass((String)fsUri.getScheme(), (org.apache.hadoop.conf.Configuration)hadoopConf);
            this.hadoopFileSystem = (org.apache.hadoop.fs.FileSystem)InstantiationUtil.instantiate((Class)fsClass);
            this.hadoopFileSystem.initialize(fsUri, hadoopConf);
        }
        catch (Exception e) {
            throw new IOException("Cannot instantiate YARN's Hadoop file system for " + fsUri, e);
        }
        this.flinkFileSystem = new HadoopFileSystem(this.hadoopFileSystem);
        this.workingDirectory = new Path(this.hadoopFileSystem.getWorkingDirectory().toUri());
        this.haDataDirectory = new Path(this.workingDirectory, FLINK_RECOVERY_DATA_DIR);
        try {
            this.flinkFileSystem.mkdirs(this.haDataDirectory);
        }
        catch (Exception e) {
            throw new IOException("Could not create the directory for recovery data in YARN's file system at '" + this.haDataDirectory + "'.", e);
        }
        LOG.info("Flink YARN application will store recovery data at {}", (Object)this.haDataDirectory);
        this.blobStoreService = new FileSystemBlobStore(this.flinkFileSystem, this.haDataDirectory.toString());
    }

    public BlobStore createBlobStore() throws IOException {
        this.enter();
        try {
            BlobStoreService blobStoreService = this.blobStoreService;
            return blobStoreService;
        }
        finally {
            this.exit();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() throws Exception {
        this.lock.lock();
        try {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Throwable exception = null;
            try {
                this.blobStoreService.close();
            }
            catch (Throwable t) {
                exception = t;
            }
            try {
                this.hadoopFileSystem.close();
            }
            catch (Throwable t) {
                exception = ExceptionUtils.firstOrSuppressed((Throwable)t, (Throwable)exception);
            }
            if (exception != null) {
                ExceptionUtils.rethrowException((Throwable)exception, (String)"Could not properly close the YarnHighAvailabilityServices.");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void closeAndCleanupAllData() throws Exception {
        this.lock.lock();
        try {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"YarnHighAvailabilityServices are already closed");
            Throwable exception = null;
            try {
                this.blobStoreService.closeAndCleanupAllData();
            }
            catch (Throwable t) {
                exception = t;
            }
            try {
                this.flinkFileSystem.delete(this.haDataDirectory, true);
            }
            catch (Throwable t) {
                exception = ExceptionUtils.firstOrSuppressed((Throwable)t, (Throwable)exception);
            }
            try {
                this.close();
            }
            catch (Throwable t) {
                exception = ExceptionUtils.firstOrSuppressed((Throwable)t, (Throwable)exception);
            }
            if (exception != null) {
                ExceptionUtils.rethrowException((Throwable)exception, (String)exception.getMessage());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void enter() {
        if (!this.enterUnlessClosed()) {
            throw new IllegalStateException("closed");
        }
    }

    boolean enterUnlessClosed() {
        this.lock.lock();
        if (!this.closed) {
            return true;
        }
        this.lock.unlock();
        return false;
    }

    void exit() {
        this.lock.unlock();
    }

    public static YarnHighAvailabilityServices forSingleJobAppMaster(Configuration flinkConfig, org.apache.hadoop.conf.Configuration hadoopConfig) throws IOException {
        Preconditions.checkNotNull((Object)flinkConfig, (String)"flinkConfig");
        Preconditions.checkNotNull((Object)hadoopConfig, (String)"hadoopConfig");
        HighAvailabilityMode mode = HighAvailabilityMode.fromConfig((Configuration)flinkConfig);
        switch (mode) {
            case NONE: {
                return new YarnIntraNonHaMasterServices(flinkConfig, hadoopConfig);
            }
            case ZOOKEEPER: {
                throw new UnsupportedOperationException("to be implemented");
            }
        }
        throw new IllegalConfigurationException("Unrecognized high availability mode: " + mode);
    }

    public static YarnHighAvailabilityServices forYarnTaskManager(Configuration flinkConfig, org.apache.hadoop.conf.Configuration hadoopConfig) throws IOException {
        Preconditions.checkNotNull((Object)flinkConfig, (String)"flinkConfig");
        Preconditions.checkNotNull((Object)hadoopConfig, (String)"hadoopConfig");
        HighAvailabilityMode mode = HighAvailabilityMode.fromConfig((Configuration)flinkConfig);
        switch (mode) {
            case NONE: {
                return new YarnPreConfiguredMasterNonHaServices(flinkConfig, hadoopConfig, HighAvailabilityServicesUtils.AddressResolution.TRY_ADDRESS_RESOLUTION);
            }
            case ZOOKEEPER: {
                throw new UnsupportedOperationException("to be implemented");
            }
        }
        throw new IllegalConfigurationException("Unrecognized high availability mode: " + mode);
    }
}

