/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.yarn;

import org.apache.flink.client.deployment.ClusterDeploymentException;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.yarn.AbstractYarnClusterDescriptor;
import org.apache.flink.yarn.entrypoint.YarnJobClusterEntrypoint;
import org.apache.flink.yarn.entrypoint.YarnSessionClusterEntrypoint;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

public class YarnClusterDescriptor
extends AbstractYarnClusterDescriptor {
    public YarnClusterDescriptor(Configuration flinkConfiguration, YarnConfiguration yarnConfiguration, String configurationDirectory, YarnClient yarnClient, boolean sharedYarnClient) {
        super(flinkConfiguration, yarnConfiguration, configurationDirectory, yarnClient, sharedYarnClient);
    }

    @Override
    protected String getYarnSessionClusterEntrypoint() {
        return YarnSessionClusterEntrypoint.class.getName();
    }

    @Override
    protected String getYarnJobClusterEntrypoint() {
        return YarnJobClusterEntrypoint.class.getName();
    }

    public ClusterClient<ApplicationId> deployJobCluster(ClusterSpecification clusterSpecification, JobGraph jobGraph, boolean detached) throws ClusterDeploymentException {
        jobGraph.setAllowQueuedScheduling(true);
        try {
            return this.deployInternal(clusterSpecification, "Flink per-job cluster", this.getYarnJobClusterEntrypoint(), jobGraph, detached);
        }
        catch (Exception e) {
            throw new ClusterDeploymentException("Could not deploy Yarn job cluster.", (Throwable)e);
        }
    }

    @Override
    protected ClusterClient<ApplicationId> createYarnClusterClient(AbstractYarnClusterDescriptor descriptor, int numberTaskManagers, int slotsPerTaskManager, ApplicationReport report, Configuration flinkConfiguration, boolean perJobCluster) throws Exception {
        return new RestClusterClient(flinkConfiguration, (Object)report.getApplicationId());
    }
}

