/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.triggers;

import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.GlobalWindow;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.Types;
import org.apache.flink.table.runtime.triggers.StateCleaningCountTrigger$;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001B\u0001\u0003\u0001=\u0011\u0011d\u0015;bi\u0016\u001cE.Z1oS:<7i\\;oiR\u0013\u0018nZ4fe*\u00111\u0001B\u0001\tiJLwmZ3sg*\u0011QAB\u0001\beVtG/[7f\u0015\t9\u0001\"A\u0003uC\ndWM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\tEI2$I\u0007\u0002%)\u00111a\u0005\u0006\u0003)U\t\u0011b^5oI><\u0018N\\4\u000b\u0005Y9\u0012aA1qS*\u0011\u0001\u0004C\u0001\ngR\u0014X-Y7j]\u001eL!A\u0007\n\u0003\u000fQ\u0013\u0018nZ4feB\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t\u0019\u0011I\\=\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011\u001a\u0012aB<j]\u0012|wo]\u0005\u0003M\r\u0012Ab\u00127pE\u0006dw+\u001b8e_^D\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!K\u0001\u0011[&t'+\u001a;f]RLwN\u001c+j[\u0016\u0004\"\u0001\b\u0016\n\u0005-j\"\u0001\u0002'p]\u001eD\u0001\"\f\u0001\u0003\u0002\u0003\u0006I!K\u0001\u0011[\u0006D(+\u001a;f]RLwN\u001c+j[\u0016D\u0001b\f\u0001\u0003\u0002\u0003\u0006I!K\u0001\t[\u0006D8i\\;oi\")\u0011\u0007\u0001C\u0001e\u00051A(\u001b8jiz\"BaM\u001b7oA\u0011A\u0007A\u0007\u0002\u0005!)\u0001\u0006\ra\u0001S!)Q\u0006\ra\u0001S!)q\u0006\ra\u0001S!9\u0011\b\u0001b\u0001\n#Q\u0014\u0001F:uCR,7\t\\3b]&tw-\u00128bE2,G-F\u0001<!\taB(\u0003\u0002>;\t9!i\\8mK\u0006t\u0007BB \u0001A\u0003%1(A\u000bti\u0006$Xm\u00117fC:LgnZ#oC\ndW\r\u001a\u0011\t\u000f\u0005\u0003!\u0019!C\u0005\u0005\u0006I1\u000f^1uK\u0012+7oY\u000b\u0002\u0007B\u0019AI\u0013'\u000e\u0003\u0015S!AR$\u0002\u000bM$\u0018\r^3\u000b\u0005!K\u0015AB2p[6|gN\u0003\u0002\u0017\u0011%\u00111*\u0012\u0002\u0018%\u0016$WoY5oON#\u0018\r^3EKN\u001c'/\u001b9u_J\u0004\"!\u0014*\u000e\u00039S!a\u0014)\u0002\t1\fgn\u001a\u0006\u0002#\u0006!!.\u0019<b\u0013\tYc\n\u0003\u0004U\u0001\u0001\u0006IaQ\u0001\u000bgR\fG/\u001a#fg\u000e\u0004\u0003b\u0002,\u0001\u0005\u0004%IaV\u0001\u0011G2,\u0017M\\;q'R\fG/\u001a#fg\u000e,\u0012\u0001\u0017\t\u0004\tfc\u0015B\u0001.F\u0005Q1\u0016\r\\;f'R\fG/\u001a#fg\u000e\u0014\u0018\u000e\u001d;pe\"1A\f\u0001Q\u0001\na\u000b\u0011c\u00197fC:,\bo\u0015;bi\u0016$Um]2!\u0011\u0015q\u0006\u0001\"\u0011`\u0003!\u0019\u0017M\\'fe\u001e,G#A\u001e\t\u000b\u0005\u0004A\u0011\t2\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u0019\t\u0003I.t!!Z5\u0011\u0005\u0019lR\"A4\u000b\u0005!t\u0011A\u0002\u001fs_>$h(\u0003\u0002k;\u00051\u0001K]3eK\u001aL!\u0001\\7\u0003\rM#(/\u001b8h\u0015\tQW\u0004C\u0003p\u0001\u0011\u0005\u0003/A\u0005p]\u0016cW-\\3oiR)\u0011\u000f\u001e<yuB\u0011\u0011C]\u0005\u0003gJ\u0011Q\u0002\u0016:jO\u001e,'OU3tk2$\b\"B;o\u0001\u0004Y\u0012aB3mK6,g\u000e\u001e\u0005\u0006o:\u0004\r!K\u0001\ni&lWm\u001d;b[BDQ!\u001f8A\u0002\u0005\naa^5oI><\b\"B>o\u0001\u0004a\u0018aA2uqB\u0019Q0!\b\u000f\u0007y\fIBD\u0002\u0000\u0003/qA!!\u0001\u0002\u00169!\u00111AA\n\u001d\u0011\t)!!\u0005\u000f\t\u0005\u001d\u0011q\u0002\b\u0005\u0003\u0013\tiAD\u0002g\u0003\u0017I\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005aA\u0011B\u0001\f\u0018\u0013\t!R#\u0003\u0002\u0004'%\u0019\u00111\u0004\n\u0002\u000fQ\u0013\u0018nZ4fe&!\u0011qDA\u0011\u00059!&/[4hKJ\u001cuN\u001c;fqRT1!a\u0007\u0013\u0011\u001d\t)\u0003\u0001C!\u0003O\t\u0001c\u001c8Qe>\u001cWm]:j]\u001e$\u0016.\\3\u0015\u000fE\fI#!\f\u00020!9\u00111FA\u0012\u0001\u0004I\u0013\u0001\u0002;j[\u0016Da!_A\u0012\u0001\u0004\t\u0003BB>\u0002$\u0001\u0007A\u0010C\u0004\u00024\u0001!\t%!\u000e\u0002\u0017=tWI^3oiRKW.\u001a\u000b\bc\u0006]\u0012\u0011HA\u001e\u0011\u001d\tY#!\rA\u0002%Ba!_A\u0019\u0001\u0004\t\u0003BB>\u00022\u0001\u0007A\u0010C\u0004\u0002@\u0001!\t%!\u0011\u0002\u000b\rdW-\u0019:\u0015\r\u0005\r\u0013\u0011JA&!\ra\u0012QI\u0005\u0004\u0003\u000fj\"\u0001B+oSRDa!_A\u001f\u0001\u0004\t\u0003BB>\u0002>\u0001\u0007ApB\u0004\u0002P\tA\t!!\u0015\u00023M#\u0018\r^3DY\u0016\fg.\u001b8h\u0007>,h\u000e\u001e+sS\u001e<WM\u001d\t\u0004i\u0005McAB\u0001\u0003\u0011\u0003\t)f\u0005\u0004\u0002T\u0005]\u0013Q\f\t\u00049\u0005e\u0013bAA.;\t1\u0011I\\=SK\u001a\u00042\u0001HA0\u0013\r\t\t'\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\bc\u0005MC\u0011AA3)\t\t\t\u0006\u0003\u0005\u0002j\u0005MC\u0011AA6\u0003\tyg\rF\u00034\u0003[\nY\b\u0003\u0005\u0002p\u0005\u001d\u0004\u0019AA9\u0003\u0019\u0019wN\u001c4jOB!\u00111OA<\u001b\t\t)H\u0003\u0002\u0017\r%!\u0011\u0011PA;\u0005-!\u0016M\u00197f\u0007>tg-[4\t\r=\n9\u00071\u0001*\r\u001d\ty(a\u0015\u0001\u0003\u0003\u00131aU;n'\u0019\ti(a!\u0002\nB\u0019Q*!\"\n\u0007\u0005\u001deJ\u0001\u0004PE*,7\r\u001e\t\u0006\u0003\u0017\u000b\t\nT\u0007\u0003\u0003\u001bS1!a$H\u0003%1WO\\2uS>t7/\u0003\u0003\u0002\u0014\u00065%A\u0004*fIV\u001cWMR;oGRLwN\u001c\u0005\bc\u0005uD\u0011AAL)\t\tI\n\u0005\u0003\u0002\u001c\u0006uTBAA*\u0011!\ty*! \u0005B\u0005\u0005\u0016A\u0002:fIV\u001cW\rF\u0003M\u0003G\u000b9\u000bC\u0004\u0002&\u0006u\u0005\u0019\u0001'\u0002\rY\fG.^32\u0011\u001d\tI+!(A\u00021\u000baA^1mk\u0016\u0014\u0004BCAW\u0003'\n\t\u0011\"\u0003\u00020\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\u0019\t")
public class StateCleaningCountTrigger
extends Trigger<Object, GlobalWindow> {
    private final long minRetentionTime;
    private final long maxRetentionTime;
    private final long maxCount;
    private final boolean stateCleaningEnabled;
    private final ReducingStateDescriptor<Long> stateDesc;
    private final ValueStateDescriptor<Long> cleanupStateDesc;

    public static StateCleaningCountTrigger of(TableConfig tableConfig, long l) {
        return StateCleaningCountTrigger$.MODULE$.of(tableConfig, l);
    }

    public boolean stateCleaningEnabled() {
        return this.stateCleaningEnabled;
    }

    private ReducingStateDescriptor<Long> stateDesc() {
        return this.stateDesc;
    }

    private ValueStateDescriptor<Long> cleanupStateDesc() {
        return this.cleanupStateDesc;
    }

    public boolean canMerge() {
        return false;
    }

    public String toString() {
        return new StringBuilder(106).append("CountTriggerGlobalWindowithCleanupState(minIdleStateRetentionTime=").append(this.minRetentionTime).append(", ").append("maxIdleStateRetentionTime=").append(this.maxRetentionTime).append(", ").append("maxCount=").append(this.maxCount).append(")").toString();
    }

    public TriggerResult onElement(Object element, long timestamp, GlobalWindow window, Trigger.TriggerContext ctx) {
        TriggerResult triggerResult;
        Long curCleanupTime;
        long currentTime = ctx.getCurrentProcessingTime();
        if (this.stateCleaningEnabled() && ((curCleanupTime = (Long)((ValueState)ctx.getPartitionedState(this.cleanupStateDesc())).value()) == null || currentTime + this.minRetentionTime > Predef$.MODULE$.Long2long(curCleanupTime))) {
            long cleanupTime = currentTime + this.maxRetentionTime;
            ctx.registerProcessingTimeTimer(cleanupTime);
            if (curCleanupTime != null) {
                ctx.deleteProcessingTimeTimer(Predef$.MODULE$.Long2long(curCleanupTime));
            }
            ((ValueState)ctx.getPartitionedState(this.cleanupStateDesc())).update((Object)Predef$.MODULE$.long2Long(cleanupTime));
        }
        ReducingState count = (ReducingState)ctx.getPartitionedState(this.stateDesc());
        count.add((Object)Predef$.MODULE$.long2Long(1L));
        if (Predef$.MODULE$.Long2long((Long)count.get()) >= this.maxCount) {
            count.clear();
            triggerResult = TriggerResult.FIRE;
        } else {
            triggerResult = TriggerResult.CONTINUE;
        }
        return triggerResult;
    }

    public TriggerResult onProcessingTime(long time, GlobalWindow window, Trigger.TriggerContext ctx) {
        if (this.stateCleaningEnabled()) {
            this.clear(window, ctx);
            return TriggerResult.FIRE_AND_PURGE;
        }
        return TriggerResult.CONTINUE;
    }

    public TriggerResult onEventTime(long time, GlobalWindow window, Trigger.TriggerContext ctx) {
        return TriggerResult.CONTINUE;
    }

    public void clear(GlobalWindow window, Trigger.TriggerContext ctx) {
        ctx.getPartitionedState(this.stateDesc()).clear();
        ctx.getPartitionedState(this.cleanupStateDesc()).clear();
    }

    public StateCleaningCountTrigger(long minRetentionTime, long maxRetentionTime, long maxCount) {
        this.minRetentionTime = minRetentionTime;
        this.maxRetentionTime = maxRetentionTime;
        this.maxCount = maxCount;
        this.stateCleaningEnabled = minRetentionTime > 1L;
        this.stateDesc = new ReducingStateDescriptor("count", (ReduceFunction)new Sum(), Types.LONG());
        this.cleanupStateDesc = new ValueStateDescriptor("countCleanup", Types.LONG());
    }

    public static class Sum
    implements ReduceFunction<Long> {
        public Long reduce(Long value1, Long value2) {
            return Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(value1) + Predef$.MODULE$.Long2long(value2));
        }
    }
}

