/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.SchemaVersion;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.DatabaseCalciteSchema;

@Internal
public class CatalogCalciteSchema
implements Schema {
    private final boolean isStreamingMode;
    private final String catalogName;
    private final CatalogManager catalogManager;
    private final TableConfig tableConfig;

    public CatalogCalciteSchema(boolean isStreamingMode, String catalogName, CatalogManager catalogManager, TableConfig tableConfig) {
        this.isStreamingMode = isStreamingMode;
        this.catalogName = catalogName;
        this.catalogManager = catalogManager;
        this.tableConfig = tableConfig;
    }

    @Override
    public Schema getSubSchema(String schemaName) {
        if (this.catalogManager.schemaExists(this.catalogName, schemaName)) {
            return new DatabaseCalciteSchema(this.isStreamingMode, schemaName, this.catalogName, this.catalogManager, this.tableConfig);
        }
        return null;
    }

    @Override
    public Set<String> getSubSchemaNames() {
        return this.catalogManager.listSchemas(this.catalogName);
    }

    @Override
    public Table getTable(String name) {
        return null;
    }

    @Override
    public Set<String> getTableNames() {
        return new HashSet<String>();
    }

    @Override
    public RelProtoDataType getType(String name) {
        return null;
    }

    @Override
    public Set<String> getTypeNames() {
        return new HashSet<String>();
    }

    @Override
    public Collection<Function> getFunctions(String s) {
        return new HashSet<Function>();
    }

    @Override
    public Set<String> getFunctionNames() {
        return new HashSet<String>();
    }

    @Override
    public Expression getExpression(SchemaPlus parentSchema, String name) {
        return Schemas.subSchemaExpression(parentSchema, name, this.getClass());
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public Schema snapshot(SchemaVersion schemaVersion) {
        return this;
    }
}

