/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes;

import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.plan.nodes.CommonJoin;
import org.apache.flink.table.plan.util.PythonUtil$;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;

public abstract class CommonJoin$class {
    public static void validatePythonFunctionInJoinCondition(CommonJoin $this, RexNode joinCondition) {
        if (PythonUtil$.MODULE$.containsPythonCall(joinCondition, PythonUtil$.MODULE$.containsPythonCall$default$2())) {
            throw new TableException("Only inner join condition with equality predicates supports the Python UDF taking the inputs from the left table and the right table at the same time, e.g., ON T1.id = T2.id && pythonUdf(T1.a, T2.b)");
        }
    }

    public static String joinSelectionToString(CommonJoin $this, RelDataType inputType) {
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(inputType.getFieldNames()).asScala()).toList().mkString(", ");
    }

    public static String joinConditionToString(CommonJoin $this, RelDataType inputType, RexNode joinCondition, Function3 expression2) {
        List inFields = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(inputType.getFieldNames()).asScala()).toList();
        return (String)expression2.apply((Object)joinCondition, (Object)inFields, (Object)None$.MODULE$);
    }

    public static String joinTypeToString(CommonJoin $this, JoinRelType joinType) {
        JoinRelType joinRelType;
        block8: {
            String string;
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    joinRelType = joinType;
                                    if (!((Object)((Object)JoinRelType.INNER)).equals((Object)joinRelType)) break block2;
                                    string = "InnerJoin";
                                    break block3;
                                }
                                if (!((Object)((Object)JoinRelType.LEFT)).equals((Object)joinRelType)) break block4;
                                string = "LeftOuterJoin";
                                break block3;
                            }
                            if (!((Object)((Object)JoinRelType.RIGHT)).equals((Object)joinRelType)) break block5;
                            string = "RightOuterJoin";
                            break block3;
                        }
                        if (!((Object)((Object)JoinRelType.FULL)).equals((Object)joinRelType)) break block6;
                        string = "FullOuterJoin";
                        break block3;
                    }
                    if (!((Object)((Object)JoinRelType.SEMI)).equals((Object)joinRelType)) break block7;
                    string = "SemiJoin";
                    break block3;
                }
                if (!((Object)((Object)JoinRelType.ANTI)).equals((Object)joinRelType)) break block8;
                string = "AntiJoin";
            }
            return string;
        }
        throw new MatchError((Object)joinRelType);
    }

    public static String temporalJoinToString(CommonJoin $this, RelDataType inputType, RexNode joinCondition, JoinRelType joinType, Function3 expression2) {
        return new StringBuilder().append((Object)"Temporal").append((Object)$this.joinToString(inputType, joinCondition, joinType, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)expression2)).toString();
    }

    public static String joinToString(CommonJoin $this, RelDataType inputType, RexNode joinCondition, JoinRelType joinType, Function3 expression2) {
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.joinTypeToString(joinType)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(where: (", "), "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.joinConditionToString(inputType, joinCondition, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)expression2)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"join: (", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.joinSelectionToString(inputType)}))).toString();
    }

    public static RelWriter joinExplainTerms(CommonJoin $this, RelWriter pw, RelDataType inputType, RexNode joinCondition, JoinRelType joinType, Function3 expression2) {
        return pw.item("where", $this.joinConditionToString(inputType, joinCondition, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)expression2)).item("join", $this.joinSelectionToString(inputType)).item("joinType", $this.joinTypeToString(joinType));
    }

    public static void $init$(CommonJoin $this) {
    }
}

