/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks;

import java.util.UUID;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.operators.collect.CollectResultIterator;
import org.apache.flink.streaming.api.operators.collect.CollectSinkOperator;
import org.apache.flink.streaming.api.operators.collect.CollectSinkOperatorFactory;
import org.apache.flink.streaming.api.operators.collect.CollectStreamSink;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.internal.SelectResultProvider;
import org.apache.flink.table.sinks.RetractStreamTableSink;
import org.apache.flink.table.sinks.SelectTableSinkSchemaConverter;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.CloseableIterator;

public class StreamSelectTableSink
implements RetractStreamTableSink<Row> {
    private final TableSchema tableSchema;
    private CollectResultIterator<Tuple2<Boolean, Row>> iterator;

    public StreamSelectTableSink(TableSchema tableSchema) {
        this.tableSchema = SelectTableSinkSchemaConverter.convertTimeAttributeToRegularTimestamp(tableSchema);
    }

    public TypeInformation<Row> getRecordType() {
        return this.tableSchema.toRowType();
    }

    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    public TableSink<Tuple2<Boolean, Row>> configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        throw new UnsupportedOperationException();
    }

    public DataStreamSink<?> consumeDataStream(DataStream<Tuple2<Boolean, Row>> dataStream) {
        StreamExecutionEnvironment env = dataStream.getExecutionEnvironment();
        TupleTypeInfo tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{Types.BOOLEAN, this.tableSchema.toRowType()});
        TypeSerializer typeSerializer = tupleTypeInfo.createSerializer(new ExecutionConfig());
        String accumulatorName = "tableResultCollect_" + UUID.randomUUID();
        CollectSinkOperatorFactory factory = new CollectSinkOperatorFactory(typeSerializer, accumulatorName);
        CollectSinkOperator operator = (CollectSinkOperator)factory.getOperator();
        this.iterator = new CollectResultIterator(operator.getOperatorIdFuture(), typeSerializer, accumulatorName, env.getCheckpointConfig());
        CollectStreamSink sink = new CollectStreamSink(dataStream, factory);
        dataStream.getExecutionEnvironment().addOperator((Transformation)sink.getTransformation());
        return sink.name("Streaming select table sink");
    }

    public SelectResultProvider getSelectResultProvider() {
        return new SelectResultProvider(){

            public void setJobClient(JobClient jobClient) {
                StreamSelectTableSink.this.iterator.setJobClient(jobClient);
            }

            public CloseableIterator<Row> getResultIterator() {
                return new RowIteratorWrapper((CollectResultIterator<Tuple2<Boolean, Row>>)StreamSelectTableSink.this.iterator);
            }
        };
    }

    private static class RowIteratorWrapper
    implements CloseableIterator<Row> {
        private final CollectResultIterator<Tuple2<Boolean, Row>> iterator;

        public RowIteratorWrapper(CollectResultIterator<Tuple2<Boolean, Row>> iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Row next() {
            Tuple2 tuple2 = (Tuple2)this.iterator.next();
            RowKind rowKind = (Boolean)tuple2.f0 != false ? RowKind.INSERT : RowKind.DELETE;
            Row row = (Row)tuple2.f1;
            row.setKind(rowKind);
            return row;
        }

        public void close() throws Exception {
            this.iterator.close();
        }
    }
}

