/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec;

import java.io.IOException;
import java.util.List;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.serde.ExecNodeGraphJsonPlanGenerator;
import org.apache.flink.table.planner.plan.nodes.exec.serde.SerdeContext;
import org.apache.flink.util.Preconditions;

public class ExecNodeGraph {
    private final String flinkVersion;
    private final List<ExecNode<?>> rootNodes;

    public ExecNodeGraph(List<ExecNode<?>> rootNodes) {
        this(EnvironmentInformation.getVersion(), rootNodes);
    }

    public ExecNodeGraph(String flinkVersion, List<ExecNode<?>> rootNodes) {
        this.flinkVersion = (String)Preconditions.checkNotNull((Object)flinkVersion, (String)"The flinkVersion should not be null.");
        this.rootNodes = (List)Preconditions.checkNotNull(rootNodes, (String)"The rootNodes should not be null.");
        Preconditions.checkArgument((!rootNodes.isEmpty() ? 1 : 0) != 0, (Object)"The rootNodes should not be empty.");
    }

    public List<ExecNode<?>> getRootNodes() {
        return this.rootNodes;
    }

    public String getFlinkVersion() {
        return this.flinkVersion;
    }

    public static String createJsonPlan(ExecNodeGraph execGraph, SerdeContext serdeCtx) {
        try {
            return ExecNodeGraphJsonPlanGenerator.generateJsonPlan(execGraph, serdeCtx);
        }
        catch (IOException e) {
            throw new TableException("Failed to create json plan.", (Throwable)e);
        }
    }

    public static ExecNodeGraph createExecNodeGraph(String jsonPlan, SerdeContext serdeCtx) {
        try {
            return ExecNodeGraphJsonPlanGenerator.generateExecNodeGraph(jsonPlan, serdeCtx);
        }
        catch (IOException e) {
            throw new TableException("Failed to create ExecNodeGraph.", (Throwable)e);
        }
    }
}

