/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.aggfunctions;

import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.expressions.ApiExpressionUtils;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.planner.expressions.ExpressionBuilder;
import org.apache.flink.table.planner.functions.aggfunctions.DeclarativeAggregateFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;

public abstract class IncrSumAggFunction
extends DeclarativeAggregateFunction {
    private UnresolvedReferenceExpression sum = ApiExpressionUtils.unresolvedRef((String)"sum");

    @Override
    public int operandCount() {
        return 1;
    }

    @Override
    public UnresolvedReferenceExpression[] aggBufferAttributes() {
        return new UnresolvedReferenceExpression[]{this.sum};
    }

    @Override
    public DataType[] getAggBufferTypes() {
        return new DataType[]{this.getResultType()};
    }

    @Override
    public Expression[] initialValuesExpressions() {
        return new Expression[]{ExpressionBuilder.nullOf(this.getResultType())};
    }

    @Override
    public Expression[] accumulateExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.or((Expression)ExpressionBuilder.isNull((Expression)this.operand(0)), (Expression)ExpressionBuilder.lessThan((Expression)this.operand(0), (Expression)ExpressionBuilder.literal(0L))), (Expression)this.sum, (Expression)ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.sum), (Expression)this.operand(0), (Expression)ExpressionBuilder.plus((Expression)this.sum, (Expression)this.operand(0))))};
    }

    @Override
    public Expression[] retractExpressions() {
        throw new TableException("This function does not support retraction, Please choose SumWithRetractAggFunction.");
    }

    @Override
    public Expression[] mergeExpressions() {
        return new Expression[]{ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.mergeOperand(this.sum)), (Expression)this.sum, (Expression)ExpressionBuilder.ifThenElse((Expression)ExpressionBuilder.isNull((Expression)this.sum), (Expression)this.mergeOperand(this.sum), (Expression)ExpressionBuilder.plus((Expression)this.sum, (Expression)this.mergeOperand(this.sum))))};
    }

    @Override
    public Expression getValueExpression() {
        return this.sum;
    }

    public static class DecimalIncrSumAggFunction
    extends IncrSumAggFunction {
        private DecimalType decimalType;

        public DecimalIncrSumAggFunction(DecimalType decimalType) {
            this.decimalType = decimalType;
        }

        @Override
        public DataType getResultType() {
            DecimalType sumType = (DecimalType)LogicalTypeMerging.findSumAggType((LogicalType)this.decimalType);
            return DataTypes.DECIMAL((int)sumType.getPrecision(), (int)sumType.getScale());
        }
    }

    public static class DoubleIncrSumAggFunction
    extends IncrSumAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.DOUBLE();
        }
    }

    public static class FloatIncrSumAggFunction
    extends IncrSumAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.FLOAT();
        }
    }

    public static class LongIncrSumAggFunction
    extends IncrSumAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.BIGINT();
        }
    }

    public static class ShortIncrSumAggFunction
    extends IncrSumAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.SMALLINT();
        }
    }

    public static class ByteIncrSumAggFunction
    extends IncrSumAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.TINYINT();
        }
    }

    public static class IntIncrSumAggFunction
    extends IncrSumAggFunction {
        @Override
        public DataType getResultType() {
            return DataTypes.INT();
        }
    }
}

