/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.calcite;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import scala.Function1;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U4Q!\u0001\u0002\u0002\u0002M\u0011\u0011cV1uKJl\u0017M]6BgNLwM\\3s\u0015\t\u0019A!A\u0004dC2\u001c\u0017\u000e^3\u000b\u0005\u00151\u0011!\u00028pI\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tQ\u0001^1cY\u0016T!!\u0004\b\u0002\u000b\u0019d\u0017N\\6\u000b\u0005=\u0001\u0012AB1qC\u000eDWMC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001635\taC\u0003\u0002\u00181\u0005\u0019!/\u001a7\u000b\u0005\rq\u0011B\u0001\u000e\u0017\u0005%\u0019\u0016N\\4mKJ+G\u000e\u0003\u0005\u001d\u0001\t\u0005\t\u0015!\u0003\u001e\u0003\u001d\u0019G.^:uKJ\u0004\"A\b\u0011\u000e\u0003}Q!a\u0002\r\n\u0005\u0005z\"!\u0004*fY>\u0003Ho\u00117vgR,'\u000f\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0003\u0019!(/Y5ugB\u0011a$J\u0005\u0003M}\u00111BU3m)J\f\u0017\u000e^*fi\"A\u0001\u0006\u0001B\u0001B\u0003%\u0011&\u0001\u0005j]B,HOU3m!\t)\"&\u0003\u0002,-\t9!+\u001a7O_\u0012,\u0007\u0002C\u0017\u0001\u0005\u000b\u0007I\u0011\u0001\u0018\u0002#I|w\u000f^5nK\u001aKW\r\u001c3J]\u0012,\u00070F\u00010!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\rIe\u000e\u001e\u0005\tm\u0001\u0011\t\u0011)A\u0005_\u0005\u0011\"o\\<uS6,g)[3mI&sG-\u001a=!\u0011!A\u0004A!b\u0001\n\u0003I\u0014!D<bi\u0016\u0014X.\u0019:l\u000bb\u0004(/F\u0001;!\tYd(D\u0001=\u0015\ti\u0004$A\u0002sKbL!a\u0010\u001f\u0003\u000fI+\u0007PT8eK\"A\u0011\t\u0001B\u0001B\u0003%!(\u0001\bxCR,'/\\1sW\u0016C\bO\u001d\u0011\t\u000b\r\u0003A\u0011\u0001#\u0002\rqJg.\u001b;?)\u0019)u\tS%K\u0017B\u0011a\tA\u0007\u0002\u0005!)AD\u0011a\u0001;!)1E\u0011a\u0001I!)\u0001F\u0011a\u0001S!)QF\u0011a\u0001_!)\u0001H\u0011a\u0001u!)Q\n\u0001C!\u001d\u0006iA-\u001a:jm\u0016\u0014vn\u001e+za\u0016$\u0012a\u0014\t\u0003!Nk\u0011!\u0015\u0006\u0003%Z\tA\u0001^=qK&\u0011A+\u0015\u0002\f%\u0016dG)\u0019;b)f\u0004X\rC\u0003W\u0001\u0011\u0005s+\u0001\u0007fqBd\u0017-\u001b8UKJl7\u000f\u0006\u0002Y7B\u0011Q#W\u0005\u00035Z\u0011\u0011BU3m/JLG/\u001a:\t\u000bq+\u0006\u0019\u0001-\u0002\u0005A<\b\"\u00020\u0001\t\u0003z\u0016\u0001B2paf$2!\u000b1c\u0011\u0015\tW\f1\u0001%\u0003!!(/Y5u'\u0016$\b\"B2^\u0001\u0004!\u0017AB5oaV$8\u000fE\u0002fU&j\u0011A\u001a\u0006\u0003O\"\fA!\u001e;jY*\t\u0011.\u0001\u0003kCZ\f\u0017BA6g\u0005\u0011a\u0015n\u001d;\t\u000by\u0003a\u0011A7\u0015\u000b%rw.]:\t\u000b\u0005d\u0007\u0019\u0001\u0013\t\u000bAd\u0007\u0019A\u0015\u0002\u000b%t\u0007/\u001e;\t\u000bId\u0007\u0019A\u0018\u0002\u000fI|w\u000f^5nK\")A\u000f\u001ca\u0001u\u0005Iq/\u0019;fe6\f'o\u001b")
public abstract class WatermarkAssigner
extends SingleRel {
    private final RelOptCluster cluster;
    private final RelNode inputRel;
    private final int rowtimeFieldIndex;
    private final RexNode watermarkExpr;

    public int rowtimeFieldIndex() {
        return this.rowtimeFieldIndex;
    }

    public RexNode watermarkExpr() {
        return this.watermarkExpr;
    }

    @Override
    public RelDataType deriveRowType() {
        RelDataType inputRowType = this.inputRel.getRowType();
        FlinkTypeFactory typeFactory = (FlinkTypeFactory)this.cluster.getTypeFactory();
        Buffer newFieldList = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(inputRowType.getFieldList()).map((Function1 & java.io.Serializable & Serializable)f -> {
            RelDataTypeField relDataTypeField;
            if (f.getIndex() == this.rowtimeFieldIndex()) {
                RelDataType rowtimeIndicatorType = typeFactory.createRowtimeIndicatorType(f.getType().isNullable());
                relDataTypeField = new RelDataTypeFieldImpl(f.getName(), f.getIndex(), rowtimeIndicatorType);
            } else {
                relDataTypeField = f;
            }
            return relDataTypeField;
        }, Buffer$.MODULE$.canBuildFrom());
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        builder.addAll((Iterable)JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList(newFieldList));
        return builder.build();
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        String rowtimeFieldName = this.inputRel.getRowType().getFieldNames().get(this.rowtimeFieldIndex());
        return super.explainTerms(pw).item("rowtime", rowtimeFieldName).item("watermark", this.watermarkExpr().toString());
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        String rowtimeFieldName = this.inputRel.getRowType().getFieldNames().get(this.rowtimeFieldIndex());
        RelNode newInputRel = inputs.get(0);
        int newIndex = newInputRel.getRowType().getFieldNames().indexOf(rowtimeFieldName);
        return this.copy(traitSet, newInputRel, newIndex, this.watermarkExpr());
    }

    public abstract RelNode copy(RelTraitSet var1, RelNode var2, int var3, RexNode var4);

    public WatermarkAssigner(RelOptCluster cluster, RelTraitSet traits, RelNode inputRel, int rowtimeFieldIndex, RexNode watermarkExpr) {
        this.cluster = cluster;
        this.inputRel = inputRel;
        this.rowtimeFieldIndex = rowtimeFieldIndex;
        this.watermarkExpr = watermarkExpr;
        super(cluster, traits, inputRel);
    }
}

