/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.ddl;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlCreate;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;

public class SqlCreateDatabase
extends SqlCreate {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE DATABASE", SqlKind.OTHER_DDL);
    private final SqlIdentifier databaseName;
    private final SqlNodeList propertyList;
    @Nullable
    private final SqlCharStringLiteral comment;

    public SqlCreateDatabase(SqlParserPos pos, SqlIdentifier databaseName, SqlNodeList propertyList, SqlCharStringLiteral comment, boolean ifNotExists) {
        super(OPERATOR, pos, false, ifNotExists);
        this.databaseName = Objects.requireNonNull(databaseName, "tableName should not be null");
        this.propertyList = Objects.requireNonNull(propertyList, "propertyList should not be null");
        this.comment = comment;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.databaseName, this.propertyList, this.comment);
    }

    public SqlIdentifier getDatabaseName() {
        return this.databaseName;
    }

    public SqlNodeList getPropertyList() {
        return this.propertyList;
    }

    public Optional<SqlCharStringLiteral> getComment() {
        return Optional.ofNullable(this.comment);
    }

    public boolean isIfNotExists() {
        return this.ifNotExists;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE DATABASE");
        if (this.isIfNotExists()) {
            writer.keyword("IF NOT EXISTS");
        }
        this.databaseName.unparse(writer, leftPrec, rightPrec);
        if (this.comment != null) {
            writer.newlineAndIndent();
            writer.keyword("COMMENT");
            this.comment.unparse(writer, leftPrec, rightPrec);
        }
        if (this.propertyList.size() > 0) {
            writer.keyword("WITH");
            SqlWriter.Frame withFrame = writer.startList("(", ")");
            for (SqlNode property : this.propertyList) {
                this.printIndent(writer);
                property.unparse(writer, leftPrec, rightPrec);
            }
            writer.newlineAndIndent();
            writer.endList(withFrame);
        }
    }

    protected void printIndent(SqlWriter writer) {
        writer.sep(",", false);
        writer.newlineAndIndent();
        writer.print("  ");
    }

    public String[] fullDatabaseName() {
        return this.databaseName.names.toArray(new String[0]);
    }
}

