/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.batch;

import java.util.LinkedList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.functions.python.PythonFunctionKind;
import org.apache.flink.table.planner.plan.nodes.FlinkConventions;
import org.apache.flink.table.planner.plan.nodes.logical.FlinkLogicalAggregate;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchExecPythonGroupAggregate;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistribution;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil;
import org.apache.flink.table.planner.plan.utils.PythonUtil;
import org.apache.flink.table.types.DataType;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;

public class BatchExecPythonAggregateRule
extends ConverterRule {
    public static final RelOptRule INSTANCE = new BatchExecPythonAggregateRule();

    private BatchExecPythonAggregateRule() {
        super(FlinkLogicalAggregate.class, FlinkConventions.LOGICAL(), FlinkConventions.BATCH_PHYSICAL(), "BatchExecPythonAggregateRule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FlinkLogicalAggregate agg = (FlinkLogicalAggregate)call.rel(0);
        List<AggregateCall> aggCalls = agg.getAggCallList();
        boolean existGeneralPythonFunction = aggCalls.stream().anyMatch(x -> PythonUtil.isPythonAggregate(x, PythonFunctionKind.GENERAL));
        boolean existPandasFunction = aggCalls.stream().anyMatch(x -> PythonUtil.isPythonAggregate(x, PythonFunctionKind.PANDAS));
        boolean existJavaFunction = aggCalls.stream().anyMatch(x -> !PythonUtil.isPythonAggregate(x, null));
        if (existPandasFunction || existGeneralPythonFunction) {
            if (existGeneralPythonFunction) {
                throw new TableException("non-Pandas UDAFs are not supported in batch mode currently.");
            }
            if (existJavaFunction) {
                throw new TableException("Python UDAF and Java/Scala UDAF cannot be used together.");
            }
            return true;
        }
        return false;
    }

    @Override
    public RelNode convert(RelNode relNode) {
        FlinkLogicalAggregate agg = (FlinkLogicalAggregate)relNode;
        RelNode input = agg.getInput();
        int[] groupSet = agg.getGroupSet().toArray();
        RelTraitSet traitSet = relNode.getTraitSet().replace(FlinkConventions.BATCH_PHYSICAL());
        Tuple2<int[], Seq<AggregateCall>> auxGroupSetAndCallsTuple = AggregateUtil.checkAndSplitAggCalls(agg);
        int[] auxGroupSet = (int[])auxGroupSetAndCallsTuple._1;
        Seq aggCallsWithoutAuxGroupCalls = (Seq)auxGroupSetAndCallsTuple._2;
        Tuple3<int[][], DataType[][], UserDefinedFunction[]> aggBufferTypesAndFunctions = AggregateUtil.transformToBatchAggregateFunctions((Seq<AggregateCall>)aggCallsWithoutAuxGroupCalls, input.getRowType(), null);
        UserDefinedFunction[] aggFunctions = (UserDefinedFunction[])aggBufferTypesAndFunctions._3();
        RelTraitSet requiredTraitSet = input.getTraitSet().replace(FlinkConventions.BATCH_PHYSICAL());
        if (groupSet.length != 0) {
            FlinkRelDistribution requiredDistribution = FlinkRelDistribution.hash(groupSet, false);
            requiredTraitSet = requiredTraitSet.replace(requiredDistribution);
            RelCollation sortCollation = this.createRelCollation(groupSet);
            requiredTraitSet = requiredTraitSet.replace(sortCollation);
        } else {
            requiredTraitSet = requiredTraitSet.replace(FlinkRelDistribution.SINGLETON());
        }
        RelNode convInput = RelOptRule.convert(input, requiredTraitSet);
        return new BatchExecPythonGroupAggregate(relNode.getCluster(), traitSet, convInput, agg.getRowType(), convInput.getRowType(), convInput.getRowType(), groupSet, auxGroupSet, (Seq<AggregateCall>)aggCallsWithoutAuxGroupCalls, aggFunctions);
    }

    private RelCollation createRelCollation(int[] groupSet) {
        LinkedList<RelFieldCollation> fields2 = new LinkedList<RelFieldCollation>();
        for (int value : groupSet) {
            fields2.add(FlinkRelOptUtil.ofRelFieldCollation(value));
        }
        return RelCollations.of(fields2);
    }
}

