/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.config.OptimizerConfigOptions;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.ModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.planner.delegation.BatchExecutor;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.operations.PlannerQueryOperation;
import org.apache.flink.table.planner.plan.nodes.exec.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNode;
import org.apache.flink.table.planner.plan.nodes.process.DAGProcessContext;
import org.apache.flink.table.planner.plan.nodes.process.DAGProcessor;
import org.apache.flink.table.planner.plan.optimize.BatchCommonSubGraphBasedOptimizer;
import org.apache.flink.table.planner.plan.optimize.Optimizer;
import org.apache.flink.table.planner.plan.processors.DeadlockBreakupProcessor;
import org.apache.flink.table.planner.plan.processors.MultipleInputNodeCreationProcessor;
import org.apache.flink.table.planner.plan.trait.FlinkRelDistributionTraitDef$;
import org.apache.flink.table.planner.plan.utils.ExecNodePlanDumper$;
import org.apache.flink.table.planner.plan.utils.FlinkRelOptUtil$;
import org.apache.flink.table.planner.sinks.BatchSelectTableSink;
import org.apache.flink.table.planner.sinks.SelectTableSinkBase;
import org.apache.flink.table.planner.utils.DummyStreamExecutionEnvironment;
import org.apache.flink.table.planner.utils.ExecutorUtils;
import org.apache.flink.table.planner.utils.PlanUtil$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u0001\u0003\u0001=\u0011ABQ1uG\"\u0004F.\u00198oKJT!a\u0001\u0003\u0002\u0015\u0011,G.Z4bi&|gN\u0003\u0002\u0006\r\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0004\t\u0003\u0015!\u0018M\u00197f\u0015\tI!\"A\u0003gY&t7N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0001A\n\u0003\u0001A\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003\u0017Ac\u0017M\u001c8fe\n\u000b7/\u001a\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u0005AQ\r_3dkR|'\u000f\u0005\u0002\u001835\t\u0001D\u0003\u0002\u0004\r%\u0011!\u0004\u0007\u0002\t\u000bb,7-\u001e;pe\"AA\u0004\u0001B\u0001B\u0003%Q$\u0001\u0004d_:4\u0017n\u001a\t\u0003=\u0005j\u0011a\b\u0006\u0003A\u0019\t1!\u00199j\u0013\t\u0011sDA\u0006UC\ndWmQ8oM&<\u0007\"\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013,\u0003=1WO\\2uS>t7)\u0019;bY><\u0007C\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0007\u0003\u001d\u0019\u0017\r^1m_\u001eL!AK\u0014\u0003\u001f\u0019+hn\u0019;j_:\u001c\u0015\r^1m_\u001eL!\u0001\n\n\t\u00135\u0002!\u0011!Q\u0001\n9\n\u0014AD2bi\u0006dwnZ'b]\u0006<WM\u001d\t\u0003M=J!\u0001M\u0014\u0003\u001d\r\u000bG/\u00197pO6\u000bg.Y4fe&\u0011QF\u0005\u0005\u0006g\u0001!\t\u0001N\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bU2t\u0007O\u001d\u0011\u0005E\u0001\u0001\"B\u000b3\u0001\u00041\u0002\"\u0002\u000f3\u0001\u0004i\u0002\"\u0002\u00133\u0001\u0004)\u0003\"B\u00173\u0001\u0004q\u0003\"B\u001e\u0001\t#b\u0014\u0001D4fiR\u0013\u0018-\u001b;EK\u001a\u001cX#A\u001f\u0011\u0007y\n5)D\u0001@\u0015\u0005\u0001\u0015!B:dC2\f\u0017B\u0001\"@\u0005\u0015\t%O]1za\t!e\nE\u0002F\u00152k\u0011A\u0012\u0006\u0003\u000f\"\u000bA\u0001\u001d7b]*\u0011\u0011JC\u0001\bG\u0006d7-\u001b;f\u0013\tYeIA\u0006SK2$&/Y5u\t\u00164\u0007CA'O\u0019\u0001!\u0011b\u0014\u001e\u0002\u0002\u0003\u0005)\u0011\u0001)\u0003\u0007}#\u0013'\u0005\u0002R)B\u0011aHU\u0005\u0003'~\u0012qAT8uQ&tw\r\u0005\u0002F+&\u0011aK\u0012\u0002\t%\u0016dGK]1ji\")\u0001\f\u0001C)3\u0006aq-\u001a;PaRLW.\u001b>feV\t!\f\u0005\u0002\\?6\tAL\u0003\u0002^=\u0006Aq\u000e\u001d;j[&TXM\u0003\u0002H\t%\u0011\u0001\r\u0018\u0002\n\u001fB$\u0018.\\5{KJDaA\u0019\u0001\u0005B!\u0019\u0017a\u0006;sC:\u001cH.\u0019;f)>,\u00050Z2O_\u0012,\u0007\u000b\\1o)\t!w\u0010E\u0002fU2l\u0011A\u001a\u0006\u0003O\"\fA!\u001e;jY*\t\u0011.\u0001\u0003kCZ\f\u0017BA6g\u0005\u0011a\u0015n\u001d;1\u000754X\u0010\u0005\u0003ogVdX\"A8\u000b\u0005A\f\u0018\u0001B3yK\u000eT!A\u001d0\u0002\u000b9|G-Z:\n\u0005Q|'\u0001C#yK\u000etu\u000eZ3\u0011\u000553H!C<b\u0003\u0003\u0005\tQ!\u0001y\u0005\ryFEM\t\u0003#f\u0004\"A\u0010>\n\u0005m|$aA!osB\u0011Q* \u0003\n}\u0006\f\t\u0011!A\u0003\u0002a\u00141a\u0018\u00134\u0011\u001d\t\t!\u0019a\u0001\u0003\u0007\t\u0011c\u001c9uS6L'0\u001a3SK2tu\u000eZ3t!\u0019\t)!!\u0006\u0002\u001c9!\u0011qAA\t\u001d\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007\u001d\u00051AH]8pizJ\u0011\u0001Q\u0005\u0004\u0003'y\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003/\tIBA\u0002TKFT1!a\u0005@!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011\u0011\u0006\u0019!/\u001a7\n\t\u0005\u0015\u0012q\u0004\u0002\b%\u0016dgj\u001c3f\u0011\u001d\tI\u0003\u0001C)\u0003W\tq\u0002\u001e:b]Nd\u0017\r^3U_Bc\u0017M\u001c\u000b\u0005\u0003[\t)\u0005\u0005\u0003fU\u0006=\u0002\u0007BA\u0019\u0003\u0003\u0002b!a\r\u0002<\u0005}RBAA\u001b\u0015\u0011\t9$!\u000f\u0002\u0007\u0011\fwM\u0003\u0002!\u0011%!\u0011QHA\u001b\u00059!&/\u00198tM>\u0014X.\u0019;j_:\u00042!TA!\t-\t\u0019%a\n\u0002\u0002\u0003\u0005)\u0011\u0001=\u0003\u0007}#c\u0007\u0003\u0005\u0002H\u0005\u001d\u0002\u0019AA%\u0003%)\u00070Z2O_\u0012,7\u000f\u0005\u0003fU\u0006-\u0003GBA'\u0003#\n9\u0006\u0005\u0004og\u0006=\u0013Q\u000b\t\u0004\u001b\u0006ECaCA*\u0003\u000b\n\t\u0011!A\u0003\u0002a\u00141a\u0018\u00135!\ri\u0015q\u000b\u0003\f\u00033\n)%!A\u0001\u0002\u000b\u0005\u0001PA\u0002`IUBq!!\u0018\u0001\t#\ny&A\u000bde\u0016\fG/Z*fY\u0016\u001cG\u000fV1cY\u0016\u001c\u0016N\\6\u0015\t\u0005\u0005\u0014Q\u000f\u0019\u0005\u0003G\n\t\b\u0005\u0004\u0002f\u0005-\u0014qN\u0007\u0003\u0003OR1!!\u001b\u0005\u0003\u0015\u0019\u0018N\\6t\u0013\u0011\ti'a\u001a\u0003'M+G.Z2u)\u0006\u0014G.Z*j].\u0014\u0015m]3\u0011\u00075\u000b\t\bB\u0006\u0002t\u0005m\u0013\u0011!A\u0001\u0006\u0003A(aA0%o!A\u0011qOA.\u0001\u0004\tI(A\u0006uC\ndWmU2iK6\f\u0007c\u0001\u0010\u0002|%\u0019\u0011QP\u0010\u0003\u0017Q\u000b'\r\\3TG\",W.\u0019\u0005\b\u0003\u0003\u0003A\u0011IAB\u0003\u001d)\u0007\u0010\u001d7bS:$b!!\"\u0002\u0014\u0006\r\u0006\u0003BAD\u0003\u001bs1APAE\u0013\r\tYiP\u0001\u0007!J,G-\u001a4\n\t\u0005=\u0015\u0011\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005-u\b\u0003\u0005\u0002\u0016\u0006}\u0004\u0019AAL\u0003)y\u0007/\u001a:bi&|gn\u001d\t\u0005K*\fI\n\u0005\u0003\u0002\u001c\u0006}UBAAO\u0015\r\t)JB\u0005\u0005\u0003C\u000biJA\u0005Pa\u0016\u0014\u0018\r^5p]\"A\u0011QUA@\u0001\u0004\t9+\u0001\u0007fqR\u0014\u0018\rR3uC&d7\u000fE\u0003?\u0003S\u000bi+C\u0002\u0002,~\u0012!\u0002\u0010:fa\u0016\fG/\u001a3?!\rq\u0012qV\u0005\u0004\u0003c{\"!D#ya2\f\u0017N\u001c#fi\u0006LG\u000eC\u0004\u00026\u0002!I!a.\u0002%\r\u0014X-\u0019;f\tVlW.\u001f)mC:tWM\u001d\u000b\u0002k\u0001")
public class BatchPlanner
extends PlannerBase {
    private final TableConfig config;

    @Override
    public RelTraitDef<? extends RelTrait>[] getTraitDefs() {
        return (RelTraitDef[])((Object[])new RelTraitDef[]{ConventionTraitDef.INSTANCE, FlinkRelDistributionTraitDef$.MODULE$.INSTANCE(), RelCollationTraitDef.INSTANCE});
    }

    @Override
    public Optimizer getOptimizer() {
        return new BatchCommonSubGraphBasedOptimizer(this);
    }

    @Override
    public List<ExecNode<?, ?>> translateToExecNodePlan(Seq<RelNode> optimizedRelNodes) {
        List<ExecNode<?, ?>> execNodePlan = super.translateToExecNodePlan(optimizedRelNodes);
        DAGProcessContext context = new DAGProcessContext(this);
        ArrayList<DAGProcessor> processors = new ArrayList<DAGProcessor>();
        processors.add(new DeadlockBreakupProcessor());
        Object object = this.getTableConfig().getConfiguration().getBoolean(OptimizerConfigOptions.TABLE_OPTIMIZER_MULTIPLE_INPUT_ENABLED) ? BoxesRunTime.boxToBoolean((boolean)processors.add(new MultipleInputNodeCreationProcessor(false))) : BoxedUnit.UNIT;
        return (List)JavaConversions$.MODULE$.asScalaBuffer(processors).foldLeft(execNodePlan, (Function2)new Serializable(this, context){
            public static final long serialVersionUID = 0L;
            private final DAGProcessContext context$1;

            public final List<ExecNode<?, ?>> apply(List<ExecNode<?, ?>> sinkNodes, DAGProcessor processor) {
                return processor.process(sinkNodes, this.context$1);
            }
            {
                this.context$1 = context$1;
            }
        });
    }

    @Override
    public List<Transformation<?>> translateToPlan(List<ExecNode<?, ?>> execNodes) {
        BatchPlanner planner = this.createDummyPlanner();
        planner.overrideEnvParallelism();
        return JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(execNodes).map((Function1)new Serializable(this, planner){
            public static final long serialVersionUID = 0L;
            private final BatchPlanner planner$1;

            public final Transformation<?> apply(ExecNode<?, ?> x0$2) {
                ExecNode<?, ?> execNode = x0$2;
                if (execNode instanceof BatchExecNode) {
                    BatchExecNode batchExecNode = (BatchExecNode)execNode;
                    Transformation<T> transformation = batchExecNode.translateToPlan(this.planner$1);
                    return transformation;
                }
                throw new TableException("Cannot generate BoundedStream due to an invalid logical plan. This is a bug and should not happen. Please file an issue.");
            }
            {
                this.planner$1 = planner$1;
            }
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    @Override
    public SelectTableSinkBase<?> createSelectTableSink(TableSchema tableSchema) {
        return new BatchSelectTableSink(tableSchema);
    }

    public String explain(List<Operation> operations, Seq<ExplainDetail> extraDetails) {
        Predef$.MODULE$.require(JavaConversions$.MODULE$.asScalaBuffer(operations).nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "operations should not be empty";
            }
        });
        Buffer sinkRelNodes = (Buffer)JavaConversions$.MODULE$.asScalaBuffer(operations).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BatchPlanner $outer;

            public final RelNode apply(Operation x0$3) {
                Operation operation;
                block7: {
                    RelNode relNode;
                    block6: {
                        block5: {
                            RelNode relNode2;
                            operation = x0$3;
                            if (!(operation instanceof QueryOperation)) break block5;
                            QueryOperation queryOperation = (QueryOperation)operation;
                            RelNode relNode3 = this.$outer.getRelBuilder().queryOperation(queryOperation).build();
                            RelNode relNode4 = relNode3;
                            if (relNode4 instanceof LogicalTableModify) {
                                LogicalTableModify logicalTableModify = (LogicalTableModify)relNode4;
                                List<String> qualifiedName = logicalTableModify.getTable().getQualifiedName();
                                Predef$.MODULE$.require(qualifiedName.size() == 3, (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "the length of qualified name should be 3.";
                                    }
                                });
                                CatalogSinkModifyOperation modifyOperation = new CatalogSinkModifyOperation(ObjectIdentifier.of((String)qualifiedName.get(0), (String)qualifiedName.get(1), (String)qualifiedName.get(2)), (QueryOperation)new PlannerQueryOperation(logicalTableModify.getInput()));
                                relNode2 = this.$outer.translateToRel((ModifyOperation)modifyOperation);
                            } else {
                                relNode2 = relNode3;
                            }
                            relNode = relNode2;
                            break block6;
                        }
                        if (!(operation instanceof ModifyOperation)) break block7;
                        ModifyOperation modifyOperation = (ModifyOperation)operation;
                        relNode = this.$outer.translateToRel(modifyOperation);
                    }
                    return relNode;
                }
                throw new TableException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported operation: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation.getClass().getCanonicalName()})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Buffer$.MODULE$.canBuildFrom());
        Seq<RelNode> optimizedRelNodes = this.optimize((Seq<RelNode>)sinkRelNodes);
        List<ExecNode<?, ?>> execNodes = this.translateToExecNodePlan(optimizedRelNodes);
        List<Transformation<?>> transformations = this.translateToPlan(execNodes);
        StreamExecutionEnvironment execEnv = this.getExecEnv();
        ExecutorUtils.setBatchProperties(execEnv, this.getTableConfig());
        StreamGraph streamGraph = ExecutorUtils.generateStreamGraph(execEnv, transformations);
        ExecutorUtils.setBatchProperties(streamGraph, this.getTableConfig());
        String executionPlan = PlanUtil$.MODULE$.explainStreamGraph(streamGraph);
        StringBuilder sb = new StringBuilder();
        sb.append("== Abstract Syntax Tree ==");
        sb.append(System.lineSeparator());
        sinkRelNodes.foreach((Function1)new Serializable(this, sb){
            public static final long serialVersionUID = 0L;
            private final StringBuilder sb$1;

            public final StringBuilder apply(RelNode sink) {
                this.sb$1.append(FlinkRelOptUtil$.MODULE$.toString(sink, FlinkRelOptUtil$.MODULE$.toString$default$2(), FlinkRelOptUtil$.MODULE$.toString$default$3(), FlinkRelOptUtil$.MODULE$.toString$default$4(), FlinkRelOptUtil$.MODULE$.toString$default$5()));
                return this.sb$1.append(System.lineSeparator());
            }
            {
                this.sb$1 = sb$1;
            }
        });
        sb.append("== Optimized Logical Plan ==");
        sb.append(System.lineSeparator());
        SqlExplainLevel explainLevel = extraDetails.contains((Object)ExplainDetail.ESTIMATED_COST) ? SqlExplainLevel.ALL_ATTRIBUTES : SqlExplainLevel.EXPPLAN_ATTRIBUTES;
        sb.append(ExecNodePlanDumper$.MODULE$.dagToString((Seq<ExecNode<?, ?>>)JavaConversions$.MODULE$.asScalaBuffer(execNodes), explainLevel, ExecNodePlanDumper$.MODULE$.dagToString$default$3(), ExecNodePlanDumper$.MODULE$.dagToString$default$4(), ExecNodePlanDumper$.MODULE$.dagToString$default$5(), ExecNodePlanDumper$.MODULE$.dagToString$default$6()));
        sb.append(System.lineSeparator());
        sb.append("== Physical Execution Plan ==");
        sb.append(System.lineSeparator());
        sb.append(executionPlan);
        return sb.toString();
    }

    private BatchPlanner createDummyPlanner() {
        DummyStreamExecutionEnvironment dummyExecEnv = new DummyStreamExecutionEnvironment(this.getExecEnv());
        BatchExecutor executor = new BatchExecutor(dummyExecEnv);
        return new BatchPlanner(executor, this.config, super.functionCatalog(), super.catalogManager());
    }

    public String explain(List<Operation> operations, ExplainDetail[] extraDetails) {
        return this.explain(operations, (Seq<ExplainDetail>)Predef$.MODULE$.wrapRefArray((Object[])extraDetails));
    }

    public BatchPlanner(Executor executor, TableConfig config, FunctionCatalog functionCatalog, CatalogManager catalogManager) {
        this.config = config;
        super(executor, config, functionCatalog, catalogManager, false);
    }
}

