/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen.agg.batch;

import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.functions.AggregateFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.ExprCodeGenerator;
import org.apache.flink.table.planner.codegen.GenerateUtils$;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.codegen.GeneratedExpression$;
import org.apache.flink.table.planner.codegen.OperatorCodeGenerator$;
import org.apache.flink.table.planner.codegen.agg.batch.AggCodeGenHelper$;
import org.apache.flink.table.planner.codegen.agg.batch.HashAggCodeGenHelper;
import org.apache.flink.table.planner.codegen.agg.batch.HashAggCodeGenHelper$;
import org.apache.flink.table.planner.codegen.sort.SortCodeGenerator;
import org.apache.flink.table.planner.expressions.DeclarativeExpressionResolver;
import org.apache.flink.table.planner.expressions.converter.ExpressionConverter;
import org.apache.flink.table.planner.functions.aggfunctions.DeclarativeAggregateFunction;
import org.apache.flink.table.planner.plan.utils.AggregateInfo;
import org.apache.flink.table.planner.plan.utils.SortUtil$;
import org.apache.flink.table.runtime.generated.GeneratedNormalizedKeyComputer;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.NormalizedKeyComputer;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.aggregate.BytesHashMap;
import org.apache.flink.table.runtime.operators.aggregate.BytesHashMapSpillMemorySegmentPool;
import org.apache.flink.table.runtime.operators.sort.BufferedKVExternalSorter;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class HashAggCodeGenHelper$ {
    public static final HashAggCodeGenHelper$ MODULE$;

    static {
        new HashAggCodeGenHelper$();
    }

    public void prepareHashAggKVTypes(CodeGeneratorContext ctx, String aggMapKeyTypesTerm, String aggBufferTypesTerm, RowType aggMapKeyType, RowType aggBufferType) {
        ctx.addReusableObjectWithName(aggMapKeyType.getChildren().toArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(LogicalType.class))), aggMapKeyTypesTerm, ctx.addReusableObjectWithName$default$3());
        ctx.addReusableObjectWithName(aggBufferType.getChildren().toArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(LogicalType.class))), aggBufferTypesTerm, ctx.addReusableObjectWithName$default$3());
    }

    public void prepareHashAggMap(CodeGeneratorContext ctx, String groupKeyTypesTerm, String aggBufferTypesTerm, String aggregateMapTerm) {
        String mapTypeTerm = BytesHashMap.class.getName();
        ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"private transient ", " ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mapTypeTerm, aggregateMapTerm})));
        ctx.addReusableOpenStatement(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aggregateMapTerm}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"= new ", "("})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mapTypeTerm}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"this.getContainingTask(),"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"this.getContainingTask().getEnvironment().getMemoryManager(),"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"computeMemorySize(),"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{groupKeyTypesTerm}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aggBufferTypesTerm}))).toString());
        ctx.addReusableCloseStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".free();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aggregateMapTerm})));
        ctx.addReusableCloseStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""})).s((Seq)Nil$.MODULE$));
    }

    public Tuple3<String, String, String> prepareTermForAggMapIteration(CodeGeneratorContext ctx, String outputTerm, RowType outputType, RowType aggMapKeyType, RowType aggBufferType, Class<? extends RowData> outputClass) {
        String reuseAggMapKeyTerm = CodeGenUtils$.MODULE$.newName("reuseAggMapKey");
        String reuseAggBufferTerm = CodeGenUtils$.MODULE$.newName("reuseAggBuffer");
        String reuseAggMapEntryTerm = CodeGenUtils$.MODULE$.newName("reuseAggMapEntry");
        String binaryRow = BinaryRowData.class.getName();
        String mapEntryTypeTerm = BytesHashMap.Entry.class.getCanonicalName();
        ctx.addReusableOutputRecord((LogicalType)outputType, outputClass, outputTerm, ctx.addReusableOutputRecord$default$4());
        ctx.addReusableMember(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"private transient ", " ", " = "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binaryRow, reuseAggMapKeyTerm}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"new ", "(", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binaryRow, BoxesRunTime.boxToInteger((int)aggMapKeyType.getFieldCount())}))).toString());
        ctx.addReusableMember(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"private transient ", " ", " = "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binaryRow, reuseAggBufferTerm}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"new ", "(", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binaryRow, BoxesRunTime.boxToInteger((int)aggBufferType.getFieldCount())}))).toString());
        ctx.addReusableMember(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"private transient ", " ", " = "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mapEntryTypeTerm, reuseAggMapEntryTerm}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"new ", "(", ", ", ");"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mapEntryTypeTerm, reuseAggMapKeyTerm, reuseAggBufferTerm}))).toString());
        return new Tuple3((Object)reuseAggMapEntryTerm, (Object)reuseAggMapKeyTerm, (Object)reuseAggBufferTerm);
    }

    public Tuple3<GeneratedExpression, GeneratedExpression, GeneratedExpression> genHashAggCodes(boolean isMerge, boolean isFinal, CodeGeneratorContext ctx, RelBuilder builder, scala.Tuple2<int[], int[]> groupingAndAuxGrouping, String inputTerm, RowType inputType, Seq<AggregateInfo> aggInfos, String currentAggBufferTerm, RowType aggBufferRowType2, LogicalType[][] aggBufferTypes, String outputTerm, RowType outputType, String groupKeyTerm, String aggBufferTerm) {
        scala.Tuple2<int[], int[]> tuple2 = groupingAndAuxGrouping;
        if (tuple2 != null) {
            scala.Tuple2 tuple22;
            int[] grouping = (int[])tuple2._1();
            int[] auxGrouping = (int[])tuple2._2();
            scala.Tuple2 tuple23 = tuple22 = new scala.Tuple2((Object)grouping, (Object)auxGrouping);
            int[] grouping2 = (int[])tuple23._1();
            int[] auxGrouping2 = (int[])tuple23._2();
            scala.Tuple2<Object, LogicalType>[][] argsMapping = AggCodeGenHelper$.MODULE$.buildAggregateArgsMapping(isMerge, grouping2.length, inputType, auxGrouping2, aggInfos, aggBufferTypes);
            scala.Tuple2<Object, LogicalType>[][] aggBuffMapping = this.buildAggregateAggBuffMapping(aggBufferTypes);
            GeneratedExpression initedAggBuffer = this.genReusableEmptyAggBuffer(ctx, builder, inputTerm, inputType, auxGrouping2, aggInfos, aggBufferRowType2);
            if (Predef$.MODULE$.intArrayOps(auxGrouping2).isEmpty()) {
                ctx.addReusableOpenStatement(initedAggBuffer.code());
            }
            GeneratedExpression aggregate = this.genAggregate(isMerge, ctx, builder, inputType, inputTerm, auxGrouping2, aggInfos, argsMapping, aggBuffMapping, currentAggBufferTerm, aggBufferRowType2);
            GeneratedExpression outputExpr = this.genHashAggOutputExpr(isMerge, isFinal, ctx, builder, auxGrouping2, aggInfos, argsMapping, aggBuffMapping, outputTerm, outputType, inputTerm, inputType, (Option<String>)new Some((Object)groupKeyTerm), aggBufferTerm, aggBufferRowType2);
            return new Tuple3((Object)initedAggBuffer, (Object)aggregate, (Object)outputExpr);
        }
        throw new MatchError(tuple2);
    }

    public scala.Tuple2<Object, LogicalType>[][] buildAggregateAggBuffMapping(LogicalType[][] aggBufferTypes) {
        IntRef aggBuffOffset = IntRef.create((int)0);
        IndexedSeq mapping = (IndexedSeq)Predef$.MODULE$.refArrayOps((Object[])aggBufferTypes).indices().map((Function1)new Serializable(aggBufferTypes, aggBuffOffset){
            public static final long serialVersionUID = 0L;
            private final LogicalType[][] aggBufferTypes$1;
            private final IntRef aggBuffOffset$1;

            public final scala.Tuple2<Object, LogicalType>[] apply(int aggIndex) {
                LogicalType[] types = this.aggBufferTypes$1[aggIndex];
                int[] indexes = (int[])RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.aggBuffOffset$1.elem), this.aggBuffOffset$1.elem + types.length).toArray(ClassTag$.MODULE$.Int());
                this.aggBuffOffset$1.elem += types.length;
                return (scala.Tuple2[])Predef$.MODULE$.intArrayOps(indexes).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])types), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(scala.Tuple2.class)));
            }
            {
                this.aggBufferTypes$1 = aggBufferTypes$1;
                this.aggBuffOffset$1 = aggBuffOffset$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return (scala.Tuple2[][])mapping.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(scala.Tuple2.class)));
    }

    public GeneratedExpression genReusableEmptyAggBuffer(CodeGeneratorContext ctx, RelBuilder builder, String inputTerm, RowType inputType, int[] auxGrouping, Seq<AggregateInfo> aggInfos, RowType aggBufferType) {
        ExprCodeGenerator exprCodeGen = new ExprCodeGenerator(ctx, false).bindInput((LogicalType)inputType, inputTerm, (Option<int[]>)new Some((Object)auxGrouping));
        ExpressionConverter converter = new ExpressionConverter(builder);
        GeneratedExpression[] initAuxGroupingExprs = (GeneratedExpression[])Predef$.MODULE$.intArrayOps(auxGrouping).map((Function1)new Serializable(ctx, inputTerm, inputType){
            public static final long serialVersionUID = 0L;
            private final CodeGeneratorContext ctx$1;
            private final String inputTerm$1;
            private final RowType inputType$1;

            public final GeneratedExpression apply(int idx) {
                return GenerateUtils$.MODULE$.generateFieldAccess(this.ctx$1, (LogicalType)this.inputType$1, this.inputTerm$1, idx);
            }
            {
                this.ctx$1 = ctx$1;
                this.inputTerm$1 = inputTerm$1;
                this.inputType$1 = inputType$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GeneratedExpression.class)));
        Seq initAggCallBufferExprs = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)aggInfos.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DeclarativeAggregateFunction apply(AggregateInfo x$2) {
                return (DeclarativeAggregateFunction)x$2.function();
            }
        }, Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<Expression> apply(DeclarativeAggregateFunction x$3) {
                return Predef$.MODULE$.refArrayOps((Object[])x$3.initialValuesExpressions());
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(converter){
            public static final long serialVersionUID = 0L;
            private final ExpressionConverter converter$1;

            public final RexNode apply(Expression x$4) {
                return (RexNode)x$4.accept((ExpressionVisitor)this.converter$1);
            }
            {
                this.converter$1 = converter$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(exprCodeGen){
            public static final long serialVersionUID = 0L;
            private final ExprCodeGenerator exprCodeGen$1;

            public final GeneratedExpression apply(RexNode rex) {
                return this.exprCodeGen$1.generateExpression(rex);
            }
            {
                this.exprCodeGen$1 = exprCodeGen$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        GeneratedExpression[] initAggBufferExprs = (GeneratedExpression[])Predef$.MODULE$.refArrayOps((Object[])initAuxGroupingExprs).$plus$plus((GenTraversableOnce)initAggCallBufferExprs, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(GeneratedExpression.class)));
        String emptyAggBufferTerm = CodeGenUtils$.MODULE$.newName("emptyAggBuffer");
        String emptyAggBufferWriterTerm = CodeGenUtils$.MODULE$.newName("emptyAggBufferWriterTerm");
        return exprCodeGen.generateResultExpression((Seq<GeneratedExpression>)Predef$.MODULE$.wrapRefArray((Object[])initAggBufferExprs), aggBufferType, BinaryRowData.class, emptyAggBufferTerm, (Option<String>)new Some((Object)emptyAggBufferWriterTerm), exprCodeGen.generateResultExpression$default$6(), exprCodeGen.generateResultExpression$default$7(), exprCodeGen.generateResultExpression$default$8(), exprCodeGen.generateResultExpression$default$9());
    }

    public GeneratedExpression genAggregate(boolean isMerge, CodeGeneratorContext ctx, RelBuilder builder, RowType inputType, String inputTerm, int[] auxGrouping, Seq<AggregateInfo> aggInfos, scala.Tuple2<Object, LogicalType>[][] argsMapping, scala.Tuple2<Object, LogicalType>[][] aggBuffMapping, String currentAggBufferTerm, RowType aggBufferRowType2) {
        return isMerge ? this.genMergeAggBuffer(ctx, builder, inputTerm, inputType, currentAggBufferTerm, auxGrouping, aggInfos, argsMapping, aggBuffMapping, aggBufferRowType2) : this.genAccumulateAggBuffer(ctx, builder, inputTerm, inputType, currentAggBufferTerm, auxGrouping, aggInfos, argsMapping, aggBuffMapping, aggBufferRowType2);
    }

    public GeneratedExpression genHashAggOutputExpr(boolean isMerge, boolean isFinal, CodeGeneratorContext ctx, RelBuilder builder, int[] auxGrouping, Seq<AggregateInfo> aggInfos, scala.Tuple2<Object, LogicalType>[][] argsMapping, scala.Tuple2<Object, LogicalType>[][] aggBuffMapping, String outputTerm, RowType outputType, String inputTerm, RowType inputType, Option<String> groupKeyTerm, String aggBufferTerm, RowType aggBufferType) {
        GeneratedExpression generatedExpression;
        GeneratedExpression generatedExpression2;
        ExprCodeGenerator qual$1 = new ExprCodeGenerator(ctx, false);
        RowType x$20 = inputType;
        String x$21 = inputTerm;
        Option<int[]> x$22 = qual$1.bindInput$default$3();
        ExprCodeGenerator qual$2 = qual$1.bindInput((LogicalType)x$20, x$21, x$22);
        RowType x$23 = aggBufferType;
        String x$24 = aggBufferTerm;
        Option<int[]> x$25 = qual$2.bindSecondInput$default$3();
        ExprCodeGenerator exprCodeGen = qual$2.bindSecondInput((LogicalType)x$23, x$24, x$25);
        ExpressionConverter converter = new ExpressionConverter(builder);
        if (isFinal) {
            int bindRefOffset = inputType.getFieldCount();
            IndexedSeq getAuxGroupingExprs = (IndexedSeq)Predef$.MODULE$.intArrayOps(auxGrouping).indices().map((Function1)new Serializable(builder, aggBuffMapping, bindRefOffset){
                public static final long serialVersionUID = 0L;
                private final RelBuilder builder$1;
                private final scala.Tuple2[][] aggBuffMapping$1;
                private final int bindRefOffset$1;

                public final ResolvedExpression apply(int idx) {
                    scala.Tuple2 tuple2 = this.aggBuffMapping$1[idx][0];
                    if (tuple2 != null) {
                        LogicalType resultType2;
                        LogicalType logicalType;
                        LogicalType resultType3 = logicalType = (resultType2 = (LogicalType)tuple2._2());
                        return DeclarativeExpressionResolver.toRexInputRef(this.builder$1, this.bindRefOffset$1 + idx, resultType3);
                    }
                    throw new MatchError((Object)tuple2);
                }
                {
                    this.builder$1 = builder$1;
                    this.aggBuffMapping$1 = aggBuffMapping$1;
                    this.bindRefOffset$1 = bindRefOffset$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            Seq getAggValueExprs = (Seq)aggInfos.map((Function1)new Serializable(isMerge, ctx, builder, auxGrouping, argsMapping, aggBuffMapping, bindRefOffset){
                public static final long serialVersionUID = 0L;
                private final boolean isMerge$1;
                private final CodeGeneratorContext ctx$2;
                private final RelBuilder builder$1;
                private final int[] auxGrouping$1;
                private final scala.Tuple2[][] argsMapping$1;
                private final scala.Tuple2[][] aggBuffMapping$1;
                private final int bindRefOffset$1;

                public final ResolvedExpression apply(AggregateInfo aggInfo) {
                    int aggBufferIdx = this.auxGrouping$1.length + aggInfo.aggIndex();
                    DeclarativeAggregateFunction function = (DeclarativeAggregateFunction)aggInfo.function();
                    HashAggCodeGenHelper.ResolveReference ref = new HashAggCodeGenHelper.ResolveReference(this.ctx$2, this.builder$1, this.isMerge$1, this.bindRefOffset$1, function, aggBufferIdx, this.argsMapping$1, this.aggBuffMapping$1);
                    return (ResolvedExpression)function.getValueExpression().accept((ExpressionVisitor)ref);
                }
                {
                    this.isMerge$1 = isMerge$1;
                    this.ctx$2 = ctx$2;
                    this.builder$1 = builder$1;
                    this.auxGrouping$1 = auxGrouping$1;
                    this.argsMapping$1 = argsMapping$1;
                    this.aggBuffMapping$1 = aggBuffMapping$1;
                    this.bindRefOffset$1 = bindRefOffset$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            IndexedSeq getValueExprs = (IndexedSeq)((TraversableLike)((TraversableLike)getAuxGroupingExprs.$plus$plus((GenTraversableOnce)getAggValueExprs, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(converter){
                public static final long serialVersionUID = 0L;
                private final ExpressionConverter converter$2;

                public final RexNode apply(ResolvedExpression x$5) {
                    return (RexNode)x$5.accept((ExpressionVisitor)this.converter$2);
                }
                {
                    this.converter$2 = converter$2;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(exprCodeGen){
                public static final long serialVersionUID = 0L;
                private final ExprCodeGenerator exprCodeGen$2;

                public final GeneratedExpression apply(RexNode rex) {
                    return this.exprCodeGen$2.generateExpression(rex);
                }
                {
                    this.exprCodeGen$2 = exprCodeGen$2;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            String aggValueTerm = CodeGenUtils$.MODULE$.newName("aggVal");
            RowType valueType = RowType.of((LogicalType[])((LogicalType[])((TraversableOnce)getValueExprs.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final LogicalType apply(GeneratedExpression x$6) {
                    return x$6.resultType();
                }
            }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(LogicalType.class))));
            generatedExpression2 = exprCodeGen.generateResultExpression((Seq<GeneratedExpression>)getValueExprs, valueType, GenericRowData.class, aggValueTerm, exprCodeGen.generateResultExpression$default$5(), exprCodeGen.generateResultExpression$default$6(), exprCodeGen.generateResultExpression$default$7(), exprCodeGen.generateResultExpression$default$8(), exprCodeGen.generateResultExpression$default$9());
        } else {
            generatedExpression2 = new GeneratedExpression(aggBufferTerm, "false", "", (LogicalType)aggBufferType, GeneratedExpression$.MODULE$.$lessinit$greater$default$5());
        }
        GeneratedExpression resultExpr = generatedExpression2;
        Option<String> option = groupKeyTerm;
        if (option instanceof Some) {
            Some some = (Some)option;
            String key = (String)some.x();
            String output = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", "\n             |", ".replace(", ", ", ");\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{resultExpr.code(), outputTerm, key, resultExpr.resultTerm()})))).stripMargin();
            generatedExpression = new GeneratedExpression(outputTerm, "false", output, (LogicalType)outputType, GeneratedExpression$.MODULE$.$lessinit$greater$default$5());
        } else {
            generatedExpression = resultExpr;
        }
        return generatedExpression;
    }

    public GeneratedExpression genMergeAggBuffer(CodeGeneratorContext ctx, RelBuilder builder, String inputTerm, RowType inputType, String currentAggBufferTerm, int[] auxGrouping, Seq<AggregateInfo> aggInfos, scala.Tuple2<Object, LogicalType>[][] argsMapping, scala.Tuple2<Object, LogicalType>[][] aggBuffMapping, RowType aggBufferType) {
        ExprCodeGenerator qual$3 = new ExprCodeGenerator(ctx, false);
        RowType x$26 = inputType;
        String x$27 = inputTerm;
        Option<int[]> x$28 = qual$3.bindInput$default$3();
        ExprCodeGenerator qual$4 = qual$3.bindInput((LogicalType)x$26, x$27, x$28);
        RowType x$29 = aggBufferType;
        String x$30 = currentAggBufferTerm;
        Option<int[]> x$31 = qual$4.bindSecondInput$default$3();
        ExprCodeGenerator exprCodeGen = qual$4.bindSecondInput((LogicalType)x$29, x$30, x$31);
        ExpressionConverter converter = new ExpressionConverter(builder);
        Seq mergeExprs = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)((IterableLike)aggInfos.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final UserDefinedFunction apply(AggregateInfo x$10) {
                return x$10.function();
            }
        }, Seq$.MODULE$.canBuildFrom())).zipWithIndex(Seq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(ctx, builder, inputType, auxGrouping, argsMapping, aggBuffMapping){
            public static final long serialVersionUID = 0L;
            private final CodeGeneratorContext ctx$3;
            private final RelBuilder builder$2;
            private final RowType inputType$2;
            private final int[] auxGrouping$2;
            private final scala.Tuple2[][] argsMapping$2;
            private final scala.Tuple2[][] aggBuffMapping$2;

            public final ArrayOps<ResolvedExpression> apply(scala.Tuple2<UserDefinedFunction, Object> x0$1) {
                scala.Tuple2<UserDefinedFunction, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    UserDefinedFunction agg = (UserDefinedFunction)tuple2._1();
                    int aggIndex = tuple2._2$mcI$sp();
                    if (agg instanceof DeclarativeAggregateFunction) {
                        DeclarativeAggregateFunction declarativeAggregateFunction = (DeclarativeAggregateFunction)agg;
                        int aggBufferIdx = this.auxGrouping$2.length + aggIndex;
                        int bindRefOffset = this.inputType$2.getFieldCount();
                        HashAggCodeGenHelper.ResolveReference ref = new HashAggCodeGenHelper.ResolveReference(this.ctx$3, this.builder$2, true, bindRefOffset, declarativeAggregateFunction, aggBufferIdx, this.argsMapping$2, this.aggBuffMapping$2);
                        ArrayOps arrayOps = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])declarativeAggregateFunction.mergeExpressions()).map((Function1)new Serializable(this, ref){
                            public static final long serialVersionUID = 0L;
                            private final HashAggCodeGenHelper.ResolveReference ref$1;

                            public final ResolvedExpression apply(Expression x$11) {
                                return (ResolvedExpression)x$11.accept((ExpressionVisitor)this.ref$1);
                            }
                            {
                                this.ref$1 = ref$1;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ResolvedExpression.class))));
                        return arrayOps;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.ctx$3 = ctx$3;
                this.builder$2 = builder$2;
                this.inputType$2 = inputType$2;
                this.auxGrouping$2 = auxGrouping$2;
                this.argsMapping$2 = argsMapping$2;
                this.aggBuffMapping$2 = aggBuffMapping$2;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(converter){
            public static final long serialVersionUID = 0L;
            private final ExpressionConverter converter$3;

            public final RexNode apply(ResolvedExpression x$12) {
                return (RexNode)x$12.accept((ExpressionVisitor)this.converter$3);
            }
            {
                this.converter$3 = converter$3;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(exprCodeGen){
            public static final long serialVersionUID = 0L;
            private final ExprCodeGenerator exprCodeGen$3;

            public final GeneratedExpression apply(RexNode rex) {
                return this.exprCodeGen$3.generateExpression(rex);
            }
            {
                this.exprCodeGen$3 = exprCodeGen$3;
            }
        }, Seq$.MODULE$.canBuildFrom());
        RowType aggBufferTypeWithoutAuxGrouping = Predef$.MODULE$.intArrayOps(auxGrouping).nonEmpty() ? RowType.of((LogicalType[])((LogicalType[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(aggBufferType.getChildren()).slice(auxGrouping.length, aggBufferType.getFieldCount())).toArray(ClassTag$.MODULE$.apply(LogicalType.class))), (String[])((String[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(aggBufferType.getFieldNames()).slice(auxGrouping.length, aggBufferType.getFieldCount())).toArray(ClassTag$.MODULE$.apply(String.class)))) : aggBufferType;
        Map mergeExprIdxToOutputRowPosMap = ((TraversableOnce)mergeExprs.indices().map((Function1)new Serializable(auxGrouping){
            public static final long serialVersionUID = 0L;
            private final int[] auxGrouping$2;

            public final scala.Tuple2<Object, Object> apply(int i) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)i)), (Object)BoxesRunTime.boxToInteger((int)(i + this.auxGrouping$2.length)));
            }
            {
                this.auxGrouping$2 = auxGrouping$2;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return exprCodeGen.generateResultExpression((Seq<GeneratedExpression>)mergeExprs, (Map<Object, Object>)mergeExprIdxToOutputRowPosMap, aggBufferTypeWithoutAuxGrouping, BinaryRowData.class, currentAggBufferTerm, (Option<String>)None$.MODULE$, true, true, false, null);
    }

    public GeneratedExpression genAccumulateAggBuffer(CodeGeneratorContext ctx, RelBuilder builder, String inputTerm, RowType inputType, String currentAggBufferTerm, int[] auxGrouping, Seq<AggregateInfo> aggInfos, scala.Tuple2<Object, LogicalType>[][] argsMapping, scala.Tuple2<Object, LogicalType>[][] aggBuffMapping, RowType aggBufferType) {
        ExprCodeGenerator qual$5 = new ExprCodeGenerator(ctx, false);
        RowType x$32 = inputType;
        String x$33 = inputTerm;
        Option<int[]> x$34 = qual$5.bindInput$default$3();
        ExprCodeGenerator qual$6 = qual$5.bindInput((LogicalType)x$32, x$33, x$34);
        RowType x$35 = aggBufferType;
        String x$36 = currentAggBufferTerm;
        Option<int[]> x$37 = qual$6.bindSecondInput$default$3();
        ExprCodeGenerator exprCodeGen = qual$6.bindSecondInput((LogicalType)x$35, x$36, x$37);
        ExpressionConverter converter = new ExpressionConverter(builder);
        int bindRefOffset = inputType.getFieldCount();
        Seq accumulateExprsWithFilterArgs = (Seq)aggInfos.flatMap((Function1)new Serializable(ctx, builder, auxGrouping, argsMapping, aggBuffMapping, exprCodeGen, converter, bindRefOffset){
            public static final long serialVersionUID = 0L;
            private final CodeGeneratorContext ctx$4;
            private final RelBuilder builder$3;
            private final int[] auxGrouping$3;
            private final scala.Tuple2[][] argsMapping$3;
            private final scala.Tuple2[][] aggBuffMapping$3;
            public final ExprCodeGenerator exprCodeGen$4;
            public final ExpressionConverter converter$4;
            private final int bindRefOffset$2;

            public final ArrayOps<scala.Tuple2<GeneratedExpression, Object>> apply(AggregateInfo aggInfo) {
                int aggBufferIdx = this.auxGrouping$3.length + aggInfo.aggIndex();
                DeclarativeAggregateFunction function = (DeclarativeAggregateFunction)aggInfo.function();
                HashAggCodeGenHelper.ResolveReference ref = new HashAggCodeGenHelper.ResolveReference(this.ctx$4, this.builder$3, false, this.bindRefOffset$2, function, aggBufferIdx, this.argsMapping$3, this.aggBuffMapping$3);
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])function.accumulateExpressions()).map((Function1)new Serializable(this, ref){
                    public static final long serialVersionUID = 0L;
                    private final HashAggCodeGenHelper.ResolveReference ref$2;

                    public final ResolvedExpression apply(Expression x$13) {
                        return (ResolvedExpression)x$13.accept((ExpressionVisitor)this.ref$2);
                    }
                    {
                        this.ref$2 = ref$2;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ResolvedExpression.class)))).map((Function1)new Serializable(this, aggInfo){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.18 $outer;
                    private final AggregateInfo aggInfo$1;

                    public final scala.Tuple2<GeneratedExpression, Object> apply(ResolvedExpression e) {
                        return new scala.Tuple2((Object)this.$outer.exprCodeGen$4.generateExpression((RexNode)e.accept((ExpressionVisitor)this.$outer.converter$4)), (Object)BoxesRunTime.boxToInteger((int)this.aggInfo$1.agg().filterArg));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.aggInfo$1 = aggInfo$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(scala.Tuple2.class))));
            }
            {
                this.ctx$4 = ctx$4;
                this.builder$3 = builder$3;
                this.auxGrouping$3 = auxGrouping$3;
                this.argsMapping$3 = argsMapping$3;
                this.aggBuffMapping$3 = aggBuffMapping$3;
                this.exprCodeGen$4 = exprCodeGen$4;
                this.converter$4 = converter$4;
                this.bindRefOffset$2 = bindRefOffset$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        String code = ((TraversableOnce)((TraversableLike)accumulateExprsWithFilterArgs.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(ctx, inputTerm, currentAggBufferTerm, auxGrouping, aggBufferType){
            public static final long serialVersionUID = 0L;
            private final CodeGeneratorContext ctx$4;
            private final String inputTerm$2;
            private final String currentAggBufferTerm$1;
            private final int[] auxGrouping$3;
            private final RowType aggBufferType$1;

            public final String apply(scala.Tuple2<scala.Tuple2<GeneratedExpression, Object>, Object> x0$2) {
                scala.Tuple2<scala.Tuple2<GeneratedExpression, Object>, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    scala.Tuple2 tuple22 = (scala.Tuple2)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    if (tuple22 != null) {
                        String string;
                        GeneratedExpression accumulateExpr = (GeneratedExpression)tuple22._1();
                        int filterArg = tuple22._2$mcI$sp();
                        int idx = this.auxGrouping$3.length + index;
                        LogicalType t = this.aggBufferType$1.getTypeAt(idx);
                        String writeCode = CodeGenUtils$.MODULE$.binaryRowFieldSetAccess(idx, this.currentAggBufferTerm$1, t, accumulateExpr.resultTerm());
                        String innerCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", "\n             |if (", ") {\n             |  ", ";\n             |} else {\n             |  ", ";\n             |}\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{accumulateExpr.code(), accumulateExpr.nullTerm(), CodeGenUtils$.MODULE$.binaryRowSetNull(idx, this.currentAggBufferTerm$1, t), writeCode})))).stripMargin().trim();
                        if (filterArg >= 0) {
                            String filterTerm = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getBoolean(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.inputTerm$2, BoxesRunTime.boxToInteger((int)filterArg)}));
                            if (this.ctx$4.nullCheck()) {
                                filterTerm = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"!", ".isNullAt(", ") && "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.inputTerm$2, BoxesRunTime.boxToInteger((int)filterArg)}))).append((Object)filterTerm).toString();
                            }
                            string = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |if (", ") {\n             | ", "\n             |}\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filterTerm, innerCode})))).stripMargin();
                        } else {
                            string = innerCode;
                        }
                        String string2 = string;
                        return string2;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                this.ctx$4 = ctx$4;
                this.inputTerm$2 = inputTerm$2;
                this.currentAggBufferTerm$1 = currentAggBufferTerm$1;
                this.auxGrouping$3 = auxGrouping$3;
                this.aggBufferType$1 = aggBufferType$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n");
        return new GeneratedExpression(currentAggBufferTerm, "false", code, (LogicalType)aggBufferType, GeneratedExpression$.MODULE$.apply$default$5());
    }

    public String genAggMapIterationAndOutput(CodeGeneratorContext ctx, boolean isFinal, String aggregateMapTerm, String reuseAggMapEntryTerm, String reuseAggBufferTerm, GeneratedExpression outputExpr) {
        String inputUnboxingCode = isFinal ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ctx.reuseInputUnboxingCode(reuseAggBufferTerm)})) : "";
        String iteratorTerm = CodeGenUtils$.MODULE$.newName("iterator");
        String mapEntryTypeTerm = BytesHashMap.Entry.class.getCanonicalName();
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |org.apache.flink.util.MutableObjectIterator<", "> ", " =\n       |  ", ".getEntryIterator();\n       |while (", ".next(", ") != null) {\n       |   // set result and output\n       |   ", "\n       |   ", "\n       |   ", "\n       |}\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mapEntryTypeTerm, iteratorTerm, aggregateMapTerm, iteratorTerm, reuseAggMapEntryTerm, inputUnboxingCode, outputExpr.code(), OperatorCodeGenerator$.MODULE$.generateCollect(outputExpr.resultTerm())})))).stripMargin();
    }

    public String genRetryAppendToMap(String aggregateMapTerm, String currentKeyTerm, GeneratedExpression initedAggBuffer, String lookupInfo, String currentAggBufferTerm) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       | // reset aggregate map retry append\n       |", ".reset();\n       |", " = ", ".lookup(", ");\n       |try {\n       |  ", " =\n       |    ", ".append(", ", ", ");\n       |} catch (java.io.EOFException e) {\n       |  throw new OutOfMemoryError(\"BytesHashMap Out of Memory.\");\n       |}\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aggregateMapTerm, lookupInfo, aggregateMapTerm, currentKeyTerm, currentAggBufferTerm, aggregateMapTerm, lookupInfo, initedAggBuffer.resultTerm()})))).stripMargin();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public scala.Tuple2<String, String> genAggMapOOMHandling(boolean isFinal, CodeGeneratorContext ctx, RelBuilder builder, scala.Tuple2<int[], int[]> groupingAndAuxGrouping, Seq<AggregateInfo> aggInfos, Map<AggregateFunction<?, ?>, String> functionIdentifiers, String logTerm, String aggregateMapTerm, scala.Tuple2<String, String> aggMapKVTypesTerm, scala.Tuple2<RowType, RowType> aggMapKVRowType, String[][] aggBufferNames, LogicalType[][] aggBufferTypes, String outputTerm, RowType outputType, String outputResultFromMap, String sorterTerm, String retryAppend) {
        scala.Tuple2 tuple2;
        scala.Tuple2 tuple22;
        scala.Tuple2<int[], int[]> tuple23 = groupingAndAuxGrouping;
        if (tuple23 == null) throw new MatchError(tuple23);
        int[] grouping = (int[])tuple23._1();
        int[] auxGrouping = (int[])tuple23._2();
        scala.Tuple2 tuple24 = tuple22 = new scala.Tuple2((Object)grouping, (Object)auxGrouping);
        int[] grouping2 = (int[])tuple24._1();
        int[] auxGrouping2 = (int[])tuple24._2();
        if (isFinal) {
            scala.Tuple2 tuple25;
            scala.Tuple2 tuple26;
            String logMapSpilling = CodeGenUtils$.MODULE$.genLogInfo(logTerm, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BytesHashMap out of memory with {} entries, start spilling."})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getNumElements()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aggregateMapTerm})));
            scala.Tuple2<String, String> tuple27 = aggMapKVTypesTerm;
            if (tuple27 == null) throw new MatchError(tuple27);
            String groupKeyTypesTerm = (String)tuple27._1();
            String aggBufferTypesTerm = (String)tuple27._2();
            scala.Tuple2 tuple28 = tuple26 = new scala.Tuple2((Object)groupKeyTypesTerm, (Object)aggBufferTypesTerm);
            String groupKeyTypesTerm2 = (String)tuple28._1();
            String aggBufferTypesTerm2 = (String)tuple28._2();
            scala.Tuple2<RowType, RowType> tuple29 = aggMapKVRowType;
            if (tuple29 == null) throw new MatchError(tuple29);
            RowType groupKeyRowType = (RowType)tuple29._1();
            RowType aggBufferRowType2 = (RowType)tuple29._2();
            scala.Tuple2 tuple210 = tuple25 = new scala.Tuple2((Object)groupKeyRowType, (Object)aggBufferRowType2);
            RowType groupKeyRowType2 = (RowType)tuple210._1();
            RowType aggBufferRowType3 = (RowType)tuple210._2();
            this.prepareFallbackSorter(ctx, sorterTerm);
            String createSorter = this.genCreateFallbackSorter(ctx, groupKeyRowType2, groupKeyTypesTerm2, aggBufferTypesTerm2, sorterTerm);
            String fallbackToSortAggCode = this.genFallbackToSortAgg(ctx, builder, grouping2, auxGrouping2, aggInfos, functionIdentifiers, aggregateMapTerm, (scala.Tuple2<RowType, RowType>)new scala.Tuple2((Object)groupKeyRowType2, (Object)aggBufferRowType3), aggregateMapTerm, sorterTerm, outputTerm, outputType, aggBufferNames, aggBufferTypes);
            String memPoolTypeTerm = BytesHashMapSpillMemorySegmentPool.class.getName();
            String dealWithAggHashMapOOM = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           | // hash map out of memory, spill to external sorter\n           |if (", " == null) {\n           |  ", "\n           |}\n           | // sort and spill\n           |", ".sortAndSpill(\n           |  ", ".getRecordAreaMemorySegments(),\n           |  ", ".getNumElements(),\n           |  new ", "(", ".getBucketAreaMemorySegments()));\n           | // retry append\n           |", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logMapSpilling, sorterTerm, createSorter, sorterTerm, aggregateMapTerm, aggregateMapTerm, memPoolTypeTerm, aggregateMapTerm, retryAppend})))).stripMargin();
            tuple2 = new scala.Tuple2((Object)dealWithAggHashMapOOM, (Object)fallbackToSortAggCode);
            return tuple2;
        } else {
            String logMapOutput = CodeGenUtils$.MODULE$.genLogInfo(logTerm, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BytesHashMap out of memory with {} entries, output directly."})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".getNumElements()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{aggregateMapTerm})));
            String dealWithAggHashMapOOM = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           | // hash map out of memory, output directly\n           |", "\n           | // retry append\n           |", "\n          "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logMapOutput, outputResultFromMap, retryAppend})))).stripMargin();
            tuple2 = new scala.Tuple2((Object)dealWithAggHashMapOOM, (Object)"");
        }
        return tuple2;
    }

    public void prepareFallbackSorter(CodeGeneratorContext ctx, String sorterTerm) {
        String sorterTypeTerm = BufferedKVExternalSorter.class.getName();
        ctx.addReusableMember(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"transient ", " ", ";"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sorterTypeTerm, sorterTerm})));
        ctx.addReusableCloseStatement(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"if (", " != null) ", ".close();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sorterTerm, sorterTerm})));
    }

    public void prepareMetrics(CodeGeneratorContext ctx, String hashTerm, String sorterTerm) {
        String gauge = Gauge.class.getCanonicalName();
        String longType = Long.class.getCanonicalName();
        String numSpillFiles = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |getMetricGroup().gauge(\"numSpillFiles\", new ", "<", ">() {\n         | @Override\n         | public ", " getValue() {\n         |  return ", ".getNumSpillFiles();\n         |  }\n         | });\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{gauge, longType, longType, hashTerm})))).stripMargin().trim();
        String memoryUsedSizeInBytes = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |getMetricGroup().gauge(\"memoryUsedSizeInBytes\", new ", "<", ">() {\n         | @Override\n         | public ", " getValue() {\n         |  return ", ".getUsedMemoryInBytes();\n         |  }\n         | });\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{gauge, longType, longType, hashTerm})))).stripMargin().trim();
        ctx.addReusableOpenStatement(numSpillFiles);
        ctx.addReusableOpenStatement(memoryUsedSizeInBytes);
        if (sorterTerm != null) {
            String spillInBytes = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           | getMetricGroup().gauge(\"spillInBytes\", new ", "<", ">() {\n           |  @Override\n           |  public ", " getValue() {\n           |    return ", ".getSpillInBytes();\n           |   }\n           |});\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{gauge, longType, longType, hashTerm})))).stripMargin().trim();
            ctx.addReusableOpenStatement(spillInBytes);
        }
    }

    public String genCreateFallbackSorter(CodeGeneratorContext ctx, RowType groupKeyRowType, String groupKeyTypesTerm, String aggBufferTypesTerm, String sorterTerm) {
        String keyComputerTerm = CodeGenUtils$.MODULE$.newName("keyComputer");
        String recordComparatorTerm = CodeGenUtils$.MODULE$.newName("recordComparator");
        String prepareSorterCode = this.genKVSorterPrepareCode(ctx, keyComputerTerm, recordComparatorTerm, groupKeyRowType);
        String binaryRowSerializerTypeTerm = BinaryRowDataSerializer.class.getName();
        String sorterTypeTerm = BufferedKVExternalSorter.class.getName();
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |  ", "\n       |  ", " = new ", "(\n       |    getContainingTask().getEnvironment().getIOManager(),\n       |    new ", "(", ".length),\n       |    new ", "(", ".length),\n       |    ", ", ", ",\n       |    getContainingTask().getEnvironment().getMemoryManager().getPageSize(),\n       |    getContainingTask().getJobConfiguration()\n       |  );\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prepareSorterCode, sorterTerm, sorterTypeTerm, binaryRowSerializerTypeTerm, groupKeyTypesTerm, binaryRowSerializerTypeTerm, aggBufferTypesTerm, keyComputerTerm, recordComparatorTerm})))).stripMargin();
    }

    public String genFallbackToSortAgg(CodeGeneratorContext ctx, RelBuilder builder, int[] grouping, int[] auxGrouping, Seq<AggregateInfo> aggInfos, Map<AggregateFunction<?, ?>, String> functionIdentifiers, String mapTerm, scala.Tuple2<RowType, RowType> mapKVRowTypes, String aggregateMapTerm, String sorterTerm, String outputTerm, RowType outputType, String[][] aggBufferNames, LogicalType[][] aggBufferTypes) {
        scala.Tuple2<RowType, RowType> tuple2 = mapKVRowTypes;
        if (tuple2 != null) {
            RowType fallbackInputType;
            scala.Tuple2 tuple22;
            RowType groupKeyRowType = (RowType)tuple2._1();
            RowType aggBufferRowType2 = (RowType)tuple2._2();
            scala.Tuple2 tuple23 = tuple22 = new scala.Tuple2((Object)groupKeyRowType, (Object)aggBufferRowType2);
            RowType groupKeyRowType2 = (RowType)tuple23._1();
            RowType aggBufferRowType3 = (RowType)tuple23._2();
            String keyTerm = CodeGenUtils$.MODULE$.newName("key");
            String lastKeyTerm = CodeGenUtils$.MODULE$.newName("lastKey");
            String keyNotEquals = AggCodeGenHelper$.MODULE$.genGroupKeyChangedCheckCode(keyTerm, lastKeyTerm);
            String joinedRow = JoinedRowData.class.getName();
            String fallbackInputTerm = ctx.addReusableLocalVariable(joinedRow, "fallbackInput");
            Tuple3<String, String, GeneratedExpression> tuple3 = AggCodeGenHelper$.MODULE$.genSortAggCodes(true, true, ctx, builder, grouping, auxGrouping, aggInfos, functionIdentifiers, fallbackInputTerm, fallbackInputType = RowType.of((LogicalType[])((LogicalType[])JavaConversions$.MODULE$.asScalaBuffer(groupKeyRowType2.getChildren()).$plus$plus((GenTraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(aggBufferRowType3.getChildren())).toArray(ClassTag$.MODULE$.apply(LogicalType.class))), (String[])((String[])JavaConversions$.MODULE$.asScalaBuffer(groupKeyRowType2.getFieldNames()).$plus$plus((GenTraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(aggBufferRowType3.getFieldNames())).toArray(ClassTag$.MODULE$.apply(String.class)))), aggBufferNames, aggBufferTypes, outputType, true);
            if (tuple3 != null) {
                Tuple3 tuple32;
                String initAggBufferCode = (String)tuple3._1();
                String updateAggBufferCode = (String)tuple3._2();
                GeneratedExpression resultExpr = (GeneratedExpression)tuple3._3();
                Tuple3 tuple33 = tuple32 = new Tuple3((Object)initAggBufferCode, (Object)updateAggBufferCode, (Object)resultExpr);
                String initAggBufferCode2 = (String)tuple33._1();
                String updateAggBufferCode2 = (String)tuple33._2();
                GeneratedExpression resultExpr2 = (GeneratedExpression)tuple33._3();
                String kvPairTerm = CodeGenUtils$.MODULE$.newName("kvPair");
                String kvPairTypeTerm = Tuple2.class.getName();
                String aggBuffTerm = CodeGenUtils$.MODULE$.newName("val");
                String binaryRow = BinaryRowData.class.getName();
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |  ", " ", " = null;\n       |  ", "<", ", ", "> ", " = null;\n       |  ", " ", " = null;\n       |  ", " ", " = null;\n       |  ", " = new ", "();\n       |\n       |  // free hash map memory, but not release back to memory manager\n       |\n       |  org.apache.flink.util.MutableObjectIterator<", "<", ", ", ">>\n       |    iterator = ", ".getKVIterator();\n       |\n       |  while (\n       |    (", " = (", "<", ", ", ">) iterator.next()) != null) {\n       |    ", " = (", ") ", ".f0;\n       |    ", " = (", ") ", ".f1;\n       |    // prepare input\n       |    ", ".replace(", ", ", ");\n       |    if (", " == null) {\n       |      // found first key group\n       |      ", " = ", ".copy();\n       |      ", "\n       |    } else if (", ") {\n       |      // output current group aggregate result\n       |      ", "\n       |      ", ".replace(", ", ", ");\n       |      ", "\n       |      // found new group\n       |      ", " = ", ".copy();\n       |      ", "\n       |    }\n       |    // reusable field access codes for agg buffer merge\n       |    ", "\n       |    // merge aggregate map's value into aggregate buffer fields\n       |    ", "\n       |  }\n       |\n       |  // output last key group aggregate result\n       |  ", "\n       |  ", ".replace(", ", ", ");\n       |  ", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{binaryRow, lastKeyTerm, kvPairTypeTerm, binaryRow, binaryRow, kvPairTerm, binaryRow, keyTerm, binaryRow, aggBuffTerm, fallbackInputTerm, joinedRow, kvPairTypeTerm, binaryRow, binaryRow, sorterTerm, kvPairTerm, kvPairTypeTerm, binaryRow, binaryRow, keyTerm, binaryRow, kvPairTerm, aggBuffTerm, binaryRow, kvPairTerm, fallbackInputTerm, keyTerm, aggBuffTerm, lastKeyTerm, lastKeyTerm, keyTerm, initAggBufferCode2, keyNotEquals, resultExpr2.code(), outputTerm, lastKeyTerm, resultExpr2.resultTerm(), OperatorCodeGenerator$.MODULE$.generateCollect(outputTerm), lastKeyTerm, keyTerm, initAggBufferCode2, ctx.reuseInputUnboxingCode(fallbackInputTerm), updateAggBufferCode2, resultExpr2.code(), outputTerm, lastKeyTerm, resultExpr2.resultTerm(), OperatorCodeGenerator$.MODULE$.generateCollect(outputTerm)})))).stripMargin();
            }
            throw new MatchError(tuple3);
        }
        throw new MatchError(tuple2);
    }

    public String genKVSorterPrepareCode(CodeGeneratorContext ctx, String keyComputerTerm, String recordComparatorTerm, RowType aggMapKeyType) {
        LogicalType[] keyFieldTypes = (LogicalType[])aggMapKeyType.getChildren().toArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(LogicalType.class)));
        int[] keys = (int[])Predef$.MODULE$.refArrayOps((Object[])keyFieldTypes).indices().toArray(ClassTag$.MODULE$.Int());
        boolean[] orders = (boolean[])Predef$.MODULE$.intArrayOps(keys).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int x$19) {
                return this.apply$mcZI$sp(x$19);
            }

            public boolean apply$mcZI$sp(int x$19) {
                return true;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean()));
        boolean[] nullsIsLast = SortUtil$.MODULE$.getNullDefaultOrders(orders);
        SortCodeGenerator sortCodeGenerator = new SortCodeGenerator(ctx.tableConfig(), keys, keyFieldTypes, orders, nullsIsLast);
        GeneratedNormalizedKeyComputer computer = sortCodeGenerator.generateNormalizedKeyComputer("AggMapKeyComputer");
        GeneratedRecordComparator comparator = sortCodeGenerator.generateRecordComparator("AggMapValueComparator");
        String keyComputerTypeTerm = NormalizedKeyComputer.class.getName();
        String keyComputeInnerClassTerm = computer.getClassName();
        String recordComparatorTypeTerm = RecordComparator.class.getName();
        String recordComparatorInnerClassTerm = comparator.getClassName();
        ctx.addReusableInnerClass(keyComputeInnerClassTerm, computer.getCode());
        ctx.addReusableInnerClass(recordComparatorInnerClassTerm, comparator.getCode());
        String computerRefs = ctx.addReusableObject(computer.getReferences(), "computerRefs", ctx.addReusableObject$default$3());
        String comparatorRefs = ctx.addReusableObject(comparator.getReferences(), "comparatorRefs", ctx.addReusableObject$default$3());
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |  ", " ", " = new ", "(", ");\n       |  ", " ", " =\n       |    new ", "(", ");\n       |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{keyComputerTypeTerm, keyComputerTerm, keyComputeInnerClassTerm, computerRefs, recordComparatorTypeTerm, recordComparatorTerm, recordComparatorInnerClassTerm, comparatorRefs})))).stripMargin();
    }

    private HashAggCodeGenHelper$() {
        MODULE$ = this;
    }
}

