/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.util.BitString;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;

public class SqlLiteralChainOperator
extends SqlSpecialOperator {
    SqlLiteralChainOperator() {
        super("$LiteralChain", SqlKind.LITERAL_CHAIN, 80, true, ReturnTypes.ARG0, InferTypes.FIRST_KNOWN, OperandTypes.VARIADIC);
    }

    private boolean argTypesValid(SqlCallBinding callBinding) {
        if (callBinding.getOperandCount() < 2) {
            return true;
        }
        RelDataType firstType = null;
        for (Ord<SqlNode> operand : Ord.zip(callBinding.operands())) {
            RelDataType type = SqlTypeUtil.deriveType(callBinding, (SqlNode)operand.e);
            if (operand.i == 0) {
                firstType = type;
                continue;
            }
            if (SqlTypeUtil.sameNamedType(firstType, type)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (!this.argTypesValid(callBinding)) {
            if (throwOnFailure) {
                throw callBinding.newValidationSignatureError();
            }
            return false;
        }
        return true;
    }

    @Override
    public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
        RelDataType ret = opBinding.getOperandType(0);
        SqlTypeName typeName = ret.getSqlTypeName();
        assert (typeName.allowsPrecNoScale()) : "LiteralChain has impossible operand type " + (Object)((Object)typeName);
        int size = 0;
        for (RelDataType type : opBinding.collectOperandTypes()) {
            size += type.getPrecision();
            assert (type.getSqlTypeName() == typeName);
        }
        return opBinding.getTypeFactory().createSqlType(typeName, size);
    }

    @Override
    public String getAllowedSignatures(String opName) {
        return opName + "(...)";
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        List<SqlNode> operandList = call.getOperandList();
        for (int i = 1; i < operandList.size(); ++i) {
            SqlParserPos prevPos = operandList.get(i - 1).getParserPosition();
            SqlNode operand = operandList.get(i);
            SqlParserPos pos = operand.getParserPosition();
            if (pos.getLineNum() > prevPos.getLineNum()) continue;
            throw validator.newValidationError(operand, Static.RESOURCE.stringFragsOnSameLine());
        }
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startList("", "");
        SqlCollation collation = null;
        for (Ord<SqlNode> operand : Ord.zip(call.getOperandList())) {
            SqlLiteral rand = (SqlLiteral)operand.e;
            if (operand.i > 0) {
                writer.newlineAndIndent();
            }
            if (rand instanceof SqlCharStringLiteral) {
                NlsString nls = rand.getValueAs(NlsString.class);
                if (operand.i == 0) {
                    collation = nls.getCollation();
                    writer.literal(nls.asSql(true, false, writer.getDialect()));
                    continue;
                }
                writer.literal(nls.asSql(false, false, writer.getDialect()));
                continue;
            }
            if (operand.i == 0) {
                rand.unparse(writer, leftPrec, rightPrec);
                continue;
            }
            if (rand.getTypeName() == SqlTypeName.BINARY) {
                BitString bs = (BitString)rand.getValue();
                writer.literal("'" + bs.toHexString() + "'");
                continue;
            }
            writer.literal("'" + rand.toValue() + "'");
        }
        if (collation != null) {
            collation.unparse(writer);
        }
        writer.endList(frame);
    }

    public static SqlLiteral concatenateOperands(SqlCall call) {
        List<SqlNode> operandList = call.getOperandList();
        assert (operandList.size() > 0);
        assert (operandList.get(0) instanceof SqlLiteral) : operandList.get(0).getClass();
        return SqlUtil.concatenateLiterals(Util.cast(operandList, SqlLiteral.class));
    }
}

