/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io.checkpointing;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetricsBuilder;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.io.network.api.CheckpointBarrier;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.clock.Clock;

public abstract class CheckpointBarrierHandler
implements Closeable {
    private static final long OUTSIDE_OF_ALIGNMENT = Long.MIN_VALUE;
    private final AbstractInvokable toNotifyOnCheckpoint;
    private final Clock clock;
    private CompletableFuture<Long> latestAlignmentDurationNanos = new CompletableFuture();
    private long latestCheckpointStartDelayNanos;
    private long startOfAlignmentTimestamp = Long.MIN_VALUE;
    private long bytesProcessedDuringAlignment;
    private CompletableFuture<Long> latestBytesProcessedDuringAlignment = new CompletableFuture();

    public CheckpointBarrierHandler(AbstractInvokable toNotifyOnCheckpoint, Clock clock) {
        this.toNotifyOnCheckpoint = (AbstractInvokable)Preconditions.checkNotNull((Object)toNotifyOnCheckpoint);
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
    }

    @Override
    public void close() throws IOException {
    }

    public abstract void processBarrier(CheckpointBarrier var1, InputChannelInfo var2) throws IOException;

    public abstract void processBarrierAnnouncement(CheckpointBarrier var1, int var2, InputChannelInfo var3) throws IOException;

    public abstract void processCancellationBarrier(CancelCheckpointMarker var1) throws IOException;

    public abstract void processEndOfPartition() throws IOException;

    public abstract long getLatestCheckpointId();

    public long getAlignmentDurationNanos() {
        if (this.isDuringAlignment()) {
            return this.clock.relativeTimeNanos() - this.startOfAlignmentTimestamp;
        }
        return (Long)FutureUtils.getOrDefault(this.latestAlignmentDurationNanos, (Object)0L);
    }

    public long getCheckpointStartDelayNanos() {
        return this.latestCheckpointStartDelayNanos;
    }

    public CompletableFuture<Void> getAllBarriersReceivedFuture(long checkpointId) {
        return CompletableFuture.completedFuture(null);
    }

    protected void notifyCheckpoint(CheckpointBarrier checkpointBarrier) throws IOException {
        CheckpointMetaData checkpointMetaData = new CheckpointMetaData(checkpointBarrier.getId(), checkpointBarrier.getTimestamp());
        CheckpointMetricsBuilder checkpointMetrics = new CheckpointMetricsBuilder().setAlignmentDurationNanos(this.latestAlignmentDurationNanos).setBytesProcessedDuringAlignment(this.latestBytesProcessedDuringAlignment).setCheckpointStartDelayNanos(this.latestCheckpointStartDelayNanos);
        this.toNotifyOnCheckpoint.triggerCheckpointOnBarrier(checkpointMetaData, checkpointBarrier.getCheckpointOptions(), checkpointMetrics);
    }

    protected void notifyAbortOnCancellationBarrier(long checkpointId) throws IOException {
        this.notifyAbort(checkpointId, new CheckpointException(CheckpointFailureReason.CHECKPOINT_DECLINED_ON_CANCELLATION_BARRIER));
    }

    protected void notifyAbort(long checkpointId, CheckpointException cause) throws IOException {
        this.resetAlignment();
        this.toNotifyOnCheckpoint.abortCheckpointOnBarrier(checkpointId, cause);
    }

    protected void markAlignmentStartAndEnd(long checkpointCreationTimestamp) {
        this.markAlignmentStart(checkpointCreationTimestamp);
        this.markAlignmentEnd(0L);
    }

    protected void markAlignmentStart(long checkpointCreationTimestamp) {
        this.latestCheckpointStartDelayNanos = 1000000L * Math.max(0L, this.clock.absoluteTimeMillis() - checkpointCreationTimestamp);
        this.resetAlignment();
        this.startOfAlignmentTimestamp = this.clock.relativeTimeNanos();
    }

    protected void markAlignmentEnd() {
        this.markAlignmentEnd(this.clock.relativeTimeNanos() - this.startOfAlignmentTimestamp);
    }

    protected void markAlignmentEnd(long alignmentDuration) {
        this.latestAlignmentDurationNanos.complete(alignmentDuration);
        this.latestBytesProcessedDuringAlignment.complete(this.bytesProcessedDuringAlignment);
        this.startOfAlignmentTimestamp = Long.MIN_VALUE;
        this.bytesProcessedDuringAlignment = 0L;
    }

    private void resetAlignment() {
        this.markAlignmentEnd(0L);
        this.latestAlignmentDurationNanos = new CompletableFuture();
        this.latestBytesProcessedDuringAlignment = new CompletableFuture();
    }

    protected abstract boolean isCheckpointPending();

    public void addProcessedBytes(int bytes) {
        if (this.isDuringAlignment()) {
            this.bytesProcessedDuringAlignment += (long)bytes;
        }
    }

    private boolean isDuringAlignment() {
        return this.startOfAlignmentTimestamp > Long.MIN_VALUE;
    }

    protected final Clock getClock() {
        return this.clock;
    }

    static interface Cancellable {
        public void cancel();
    }
}

