/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.source;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.eventtime.TimestampAssigner;
import org.apache.flink.api.common.eventtime.Watermark;
import org.apache.flink.api.connector.source.ReaderOutput;
import org.apache.flink.api.connector.source.SourceOutput;
import org.apache.flink.streaming.api.operators.source.TimestampsAndWatermarks;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ExceptionInChainedOperatorException;
import org.apache.flink.util.Preconditions;

@Internal
public class NoOpTimestampsAndWatermarks<T>
implements TimestampsAndWatermarks<T> {
    private final TimestampAssigner<T> timestamps;

    public NoOpTimestampsAndWatermarks(TimestampAssigner<T> timestamps) {
        this.timestamps = (TimestampAssigner)Preconditions.checkNotNull(timestamps);
    }

    @Override
    public ReaderOutput<T> createMainOutput(PushingAsyncDataInput.DataOutput<T> output) {
        Preconditions.checkNotNull(output);
        return new TimestampsOnlyOutput(output, this.timestamps);
    }

    @Override
    public void startPeriodicWatermarkEmits() {
    }

    @Override
    public void stopPeriodicWatermarkEmits() {
    }

    private static final class TimestampsOnlyOutput<T>
    implements ReaderOutput<T> {
        private final PushingAsyncDataInput.DataOutput<T> output;
        private final TimestampAssigner<T> timestampAssigner;
        private final StreamRecord<T> reusingRecord;

        private TimestampsOnlyOutput(PushingAsyncDataInput.DataOutput<T> output, TimestampAssigner<T> timestampAssigner) {
            this.output = output;
            this.timestampAssigner = timestampAssigner;
            this.reusingRecord = new StreamRecord<Object>(null);
        }

        public void collect(T record) {
            this.collect(record, Long.MIN_VALUE);
        }

        public void collect(T record, long timestamp) {
            try {
                this.output.emitRecord(this.reusingRecord.replace(record, this.timestampAssigner.extractTimestamp(record, timestamp)));
            }
            catch (ExceptionInChainedOperatorException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ExceptionInChainedOperatorException(e);
            }
        }

        public void emitWatermark(Watermark watermark) {
        }

        public void markIdle() {
        }

        public SourceOutput<T> createOutputForSplit(String splitId) {
            return this;
        }

        public void releaseOutputForSplit(String splitId) {
        }
    }
}

