/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.split;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.flink.connector.pulsar.common.utils.PulsarSerdeUtils;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicRange;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.RangeGenerator;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplit;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.transaction.TxnID;

public class PulsarPartitionSplitSerializer
implements SimpleVersionedSerializer<PulsarPartitionSplit> {
    public static final PulsarPartitionSplitSerializer INSTANCE = new PulsarPartitionSplitSerializer();
    public static final int CURRENT_VERSION = 1;

    private PulsarPartitionSplitSerializer() {
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(PulsarPartitionSplit obj) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream out = new DataOutputStream(baos);){
                this.serializePulsarPartitionSplit(out, obj);
                out.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public PulsarPartitionSplit deserialize(int version, byte[] serialized) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(serialized);){
            PulsarPartitionSplit pulsarPartitionSplit;
            try (DataInputStream in = new DataInputStream(bais);){
                pulsarPartitionSplit = this.deserializePulsarPartitionSplit(version, in);
            }
            return pulsarPartitionSplit;
        }
    }

    public void serializePulsarPartitionSplit(DataOutputStream out, PulsarPartitionSplit split) throws IOException {
        this.serializeTopicPartition(out, split.getPartition());
        PulsarSerdeUtils.serializeObject(out, split.getStopCursor());
        MessageId latestConsumedId = split.getLatestConsumedId();
        if (latestConsumedId == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            PulsarSerdeUtils.serializeBytes(out, latestConsumedId.toByteArray());
        }
        TxnID uncommittedTransactionId = split.getUncommittedTransactionId();
        if (uncommittedTransactionId == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeLong(uncommittedTransactionId.getMostSigBits());
            out.writeLong(uncommittedTransactionId.getLeastSigBits());
        }
    }

    public PulsarPartitionSplit deserializePulsarPartitionSplit(int version, DataInputStream in) throws IOException {
        TopicPartition partition = this.deserializeTopicPartition(version, in);
        StopCursor stopCursor = (StopCursor)PulsarSerdeUtils.deserializeObject(in);
        MessageId latestConsumedId = null;
        if (in.readBoolean()) {
            byte[] messageIdBytes = PulsarSerdeUtils.deserializeBytes(in);
            latestConsumedId = MessageId.fromByteArray(messageIdBytes);
        }
        TxnID uncommittedTransactionId = null;
        if (in.readBoolean()) {
            long mostSigBits = in.readLong();
            long leastSigBits = in.readLong();
            uncommittedTransactionId = new TxnID(mostSigBits, leastSigBits);
        }
        return new PulsarPartitionSplit(partition, stopCursor, latestConsumedId, uncommittedTransactionId);
    }

    public void serializeTopicPartition(DataOutputStream out, TopicPartition partition) throws IOException {
        out.writeUTF(partition.getTopic());
        out.writeInt(partition.getPartitionId());
        PulsarSerdeUtils.serializeList(out, partition.getRanges(), (o, r) -> {
            o.writeInt(r.getStart());
            o.writeInt(r.getEnd());
        });
        out.writeInt(partition.getMode().ordinal());
    }

    public TopicPartition deserializeTopicPartition(int version, DataInputStream in) throws IOException {
        RangeGenerator.KeySharedMode keySharedMode;
        List<TopicRange> ranges;
        String topic = in.readUTF();
        int partitionId = in.readInt();
        if (version == 0) {
            int start = in.readInt();
            int end = in.readInt();
            TopicRange range = new TopicRange(start, end);
            ranges = Collections.singletonList(range);
            keySharedMode = RangeGenerator.KeySharedMode.SPLIT;
        } else {
            ranges = PulsarSerdeUtils.deserializeList(in, i -> {
                int start = i.readInt();
                int end = i.readInt();
                return new TopicRange(start, end);
            });
            keySharedMode = RangeGenerator.KeySharedMode.values()[in.readInt()];
        }
        return new TopicPartition(topic, partitionId, ranges, keySharedMode);
    }
}

