/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.topic.range;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicMetadata;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicRange;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.RangeGenerator;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class SplitRangeGenerator
implements RangeGenerator {
    private static final long serialVersionUID = -8682286436352905249L;
    private final int start;
    private final int end;

    public SplitRangeGenerator() {
        this(0, 65535);
    }

    public SplitRangeGenerator(int start, int end) {
        Preconditions.checkArgument((start >= 0 ? 1 : 0) != 0, (Object)"Start range should be equal to or great than the min range 0");
        Preconditions.checkArgument((end <= 65535 ? 1 : 0) != 0, (Object)"End range should below or less than the max range 65535");
        Preconditions.checkArgument((start <= end ? 1 : 0) != 0, (Object)"Start range should be equal to or less than the end range");
        this.start = start;
        this.end = end;
    }

    @Override
    public List<TopicRange> range(TopicMetadata metadata, int parallelism) {
        int range = this.end - this.start + 1;
        int size = Math.min(range, parallelism);
        int startRange = this.start;
        ArrayList<TopicRange> results = new ArrayList<TopicRange>(size);
        for (int i = 1; i < size; ++i) {
            int nextStartRange = i * range / size + this.start;
            results.add(new TopicRange(startRange, nextStartRange - 1));
            startRange = nextStartRange;
        }
        results.add(new TopicRange(startRange, this.end));
        return results;
    }

    @Override
    public RangeGenerator.KeySharedMode keyShareMode(TopicMetadata metadata, int parallelism) {
        return RangeGenerator.KeySharedMode.SPLIT;
    }
}

