/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.subscriber.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.connector.pulsar.source.enumerator.subscriber.PulsarSubscriber;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicMetadata;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicNameUtils;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicRange;
import org.apache.flink.connector.pulsar.source.enumerator.topic.range.RangeGenerator;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;

public abstract class BasePulsarSubscriber
implements PulsarSubscriber {
    private static final long serialVersionUID = 2053021503331058888L;

    protected TopicMetadata queryTopicMetadata(PulsarAdmin pulsarAdmin, String topicName) {
        String completeTopicName = TopicNameUtils.topicName(topicName);
        try {
            PartitionedTopicMetadata metadata = pulsarAdmin.topics().getPartitionedTopicMetadata(completeTopicName);
            return new TopicMetadata(topicName, metadata.partitions);
        }
        catch (PulsarAdminException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw new IllegalStateException(e);
        }
    }

    protected List<TopicPartition> toTopicPartitions(TopicMetadata metadata, List<TopicRange> ranges, RangeGenerator.KeySharedMode mode) {
        if (!metadata.isPartitioned()) {
            return this.toTopicPartitions(metadata.getName(), -1, ranges, mode);
        }
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
        for (int i = 0; i < metadata.getPartitionSize(); ++i) {
            partitions.addAll(this.toTopicPartitions(metadata.getName(), i, ranges, mode));
        }
        return partitions;
    }

    protected List<TopicPartition> toTopicPartitions(String topic, int partitionId, List<TopicRange> ranges, RangeGenerator.KeySharedMode mode) {
        switch (mode) {
            case JOIN: {
                return Collections.singletonList(new TopicPartition(topic, partitionId, ranges, mode));
            }
            case SPLIT: {
                ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>(ranges.size());
                for (TopicRange range : ranges) {
                    TopicPartition partition = new TopicPartition(topic, partitionId, Collections.singletonList(range), mode);
                    partitions.add(partition);
                }
                return partitions;
            }
        }
        throw new UnsupportedOperationException((Object)((Object)mode) + " isn't supported.");
    }
}

