/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.cursor;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.MessageId;

@PublicEvolving
public final class CursorPosition
implements Serializable {
    private static final long serialVersionUID = -802405183307684549L;
    private final Type type;
    private final MessageId messageId;
    private final Long timestamp;

    public CursorPosition(MessageId messageId) {
        Preconditions.checkNotNull((Object)messageId, (String)"Message id couldn't be null.");
        this.type = Type.MESSAGE_ID;
        this.messageId = messageId;
        this.timestamp = null;
    }

    public CursorPosition(Long timestamp) {
        Preconditions.checkNotNull((Object)timestamp, (String)"Timestamp couldn't be null.");
        this.type = Type.TIMESTAMP;
        this.messageId = null;
        this.timestamp = timestamp;
    }

    @Internal
    public Type getType() {
        return this.type;
    }

    @Internal
    public MessageId getMessageId() {
        return this.messageId;
    }

    @Internal
    public Long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        if (this.type == Type.TIMESTAMP) {
            return "timestamp: " + this.timestamp;
        }
        return "message id: " + this.messageId;
    }

    @Internal
    public static enum Type {
        TIMESTAMP,
        MESSAGE_ID;

    }
}

