/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.source.enumerator.assigner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.connector.source.SplitsAssignment;
import org.apache.flink.connector.pulsar.source.enumerator.PulsarSourceEnumState;
import org.apache.flink.connector.pulsar.source.enumerator.assigner.SplitAssigner;
import org.apache.flink.connector.pulsar.source.enumerator.cursor.StopCursor;
import org.apache.flink.connector.pulsar.source.enumerator.topic.TopicPartition;
import org.apache.flink.connector.pulsar.source.split.PulsarPartitionSplit;

abstract class SplitAssignerBase
implements SplitAssigner {
    protected final StopCursor stopCursor;
    protected final boolean enablePartitionDiscovery;
    protected final SplitEnumeratorContext<PulsarPartitionSplit> context;
    protected final Set<TopicPartition> appendedPartitions;
    protected final Map<Integer, Set<PulsarPartitionSplit>> pendingPartitionSplits;
    protected boolean initialized;

    protected SplitAssignerBase(StopCursor stopCursor, boolean enablePartitionDiscovery, SplitEnumeratorContext<PulsarPartitionSplit> context, PulsarSourceEnumState enumState) {
        this.stopCursor = stopCursor;
        this.enablePartitionDiscovery = enablePartitionDiscovery;
        this.context = context;
        this.appendedPartitions = enumState.getAppendedPartitions();
        this.pendingPartitionSplits = new HashMap<Integer, Set<PulsarPartitionSplit>>(context.currentParallelism());
        this.initialized = false;
    }

    @Override
    public Optional<SplitsAssignment<PulsarPartitionSplit>> createAssignment(List<Integer> readers) {
        if (this.pendingPartitionSplits.isEmpty() || readers.isEmpty()) {
            return Optional.empty();
        }
        HashMap<Integer, ArrayList<PulsarPartitionSplit>> assignMap = new HashMap<Integer, ArrayList<PulsarPartitionSplit>>(this.pendingPartitionSplits.size());
        for (Integer reader : readers) {
            Set<PulsarPartitionSplit> splits = this.pendingPartitionSplits.remove(reader);
            if (splits == null || splits.isEmpty()) continue;
            assignMap.put(reader, new ArrayList<PulsarPartitionSplit>(splits));
        }
        if (assignMap.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new SplitsAssignment(assignMap));
    }

    @Override
    public boolean noMoreSplits(Integer reader) {
        return !this.enablePartitionDiscovery && this.initialized && !this.pendingPartitionSplits.containsKey(reader);
    }

    @Override
    public PulsarSourceEnumState snapshotState() {
        return new PulsarSourceEnumState(this.appendedPartitions);
    }

    protected void addSplitToPendingList(int readerId, PulsarPartitionSplit split) {
        Set splits = this.pendingPartitionSplits.computeIfAbsent(readerId, i -> new HashSet());
        splits.add(split);
    }

    protected int partitionOwner(TopicPartition partition) {
        return SplitAssignerBase.calculatePartitionOwner(partition.getTopic(), partition.getPartitionId(), this.context.currentParallelism());
    }

    @VisibleForTesting
    static int calculatePartitionOwner(String topic, int partitionId, int parallelism) {
        int startIndex = (topic.hashCode() * 31 & Integer.MAX_VALUE) % parallelism;
        return (startIndex + partitionId) % parallelism;
    }
}

