/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.sink.config;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.pulsar.common.config.PulsarConfigValidator;
import org.apache.flink.connector.pulsar.common.config.PulsarOptions;
import org.apache.flink.connector.pulsar.sink.PulsarSinkOptions;
import org.apache.flink.connector.pulsar.sink.config.SinkConfiguration;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.ProducerAccessMode;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;

@Internal
public final class PulsarSinkConfigUtils {
    public static final PulsarConfigValidator SINK_CONFIG_VALIDATOR = PulsarConfigValidator.builder().requiredOption(PulsarOptions.PULSAR_SERVICE_URL).requiredOption(PulsarOptions.PULSAR_ADMIN_URL).conflictOptions(PulsarOptions.PULSAR_AUTH_PARAMS, PulsarOptions.PULSAR_AUTH_PARAM_MAP).conflictOptions(PulsarOptions.PULSAR_MEMORY_LIMIT_BYTES, PulsarSinkOptions.PULSAR_MAX_PENDING_MESSAGES).conflictOptions(PulsarOptions.PULSAR_MEMORY_LIMIT_BYTES, PulsarSinkOptions.PULSAR_MAX_PENDING_MESSAGES_ACROSS_PARTITIONS).build();

    private PulsarSinkConfigUtils() {
    }

    public static <T> ProducerBuilder<T> createProducerBuilder(PulsarClient client, Schema<T> schema, SinkConfiguration configuration) {
        ProducerBuilder builder = client.newProducer(schema);
        configuration.useOption(PulsarSinkOptions.PULSAR_PRODUCER_NAME, producerName -> String.format(producerName, UUID.randomUUID()), builder::producerName);
        configuration.useOption(PulsarSinkOptions.PULSAR_SEND_TIMEOUT_MS, Math::toIntExact, ms -> builder.sendTimeout((int)ms, TimeUnit.MILLISECONDS));
        configuration.useOption(PulsarSinkOptions.PULSAR_MAX_PENDING_MESSAGES, builder::maxPendingMessages);
        configuration.useOption(PulsarSinkOptions.PULSAR_MAX_PENDING_MESSAGES_ACROSS_PARTITIONS, builder::maxPendingMessagesAcrossPartitions);
        configuration.useOption(PulsarSinkOptions.PULSAR_BATCHING_MAX_PUBLISH_DELAY_MICROS, s2 -> builder.batchingMaxPublishDelay((long)s2, TimeUnit.MICROSECONDS));
        configuration.useOption(PulsarSinkOptions.PULSAR_BATCHING_PARTITION_SWITCH_FREQUENCY_BY_PUBLISH_DELAY, builder::roundRobinRouterBatchingPartitionSwitchFrequency);
        configuration.useOption(PulsarSinkOptions.PULSAR_BATCHING_MAX_MESSAGES, builder::batchingMaxMessages);
        configuration.useOption(PulsarSinkOptions.PULSAR_BATCHING_MAX_BYTES, builder::batchingMaxBytes);
        configuration.useOption(PulsarSinkOptions.PULSAR_BATCHING_ENABLED, builder::enableBatching);
        configuration.useOption(PulsarSinkOptions.PULSAR_CHUNKING_ENABLED, builder::enableChunking);
        configuration.useOption(PulsarSinkOptions.PULSAR_COMPRESSION_TYPE, builder::compressionType);
        configuration.useOption(PulsarSinkOptions.PULSAR_INITIAL_SEQUENCE_ID, builder::initialSequenceId);
        Map<String, String> properties = configuration.getProperties(PulsarSinkOptions.PULSAR_PRODUCER_PROPERTIES);
        if (!properties.isEmpty()) {
            builder.properties(properties);
        }
        builder.blockIfQueueFull(true).messageRoutingMode(MessageRoutingMode.SinglePartition).enableMultiSchema(false).autoUpdatePartitions(false).accessMode(ProducerAccessMode.Shared).enableLazyStartPartitionedProducers(false);
        return builder;
    }
}

