/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.pulsar.common.schema;

import com.google.protobuf.Message;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.connector.pulsar.common.schema.PulsarSchemaFactory;
import org.apache.flink.connector.pulsar.common.schema.factories.AvroSchemaFactory;
import org.apache.flink.connector.pulsar.common.schema.factories.JSONSchemaFactory;
import org.apache.flink.connector.pulsar.common.schema.factories.KeyValueSchemaFactory;
import org.apache.flink.connector.pulsar.common.schema.factories.PrimitiveSchemaFactory;
import org.apache.flink.connector.pulsar.common.schema.factories.ProtobufNativeSchemaFactory;
import org.apache.flink.connector.pulsar.common.schema.factories.ProtobufSchemaFactory;
import org.apache.flink.connector.pulsar.common.schema.factories.StringSchemaFactory;
import org.apache.flink.util.Preconditions;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.schema.BooleanSchema;
import org.apache.pulsar.client.impl.schema.ByteSchema;
import org.apache.pulsar.client.impl.schema.BytesSchema;
import org.apache.pulsar.client.impl.schema.DateSchema;
import org.apache.pulsar.client.impl.schema.DoubleSchema;
import org.apache.pulsar.client.impl.schema.FloatSchema;
import org.apache.pulsar.client.impl.schema.InstantSchema;
import org.apache.pulsar.client.impl.schema.IntSchema;
import org.apache.pulsar.client.impl.schema.LocalDateSchema;
import org.apache.pulsar.client.impl.schema.LocalDateTimeSchema;
import org.apache.pulsar.client.impl.schema.LocalTimeSchema;
import org.apache.pulsar.client.impl.schema.LongSchema;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.client.impl.schema.ShortSchema;
import org.apache.pulsar.client.impl.schema.TimeSchema;
import org.apache.pulsar.client.impl.schema.TimestampSchema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

@Internal
public final class PulsarSchemaUtils {
    private static final Class<Message> PROTOBUF_MESSAGE_CLASS;
    private static final Map<SchemaType, PulsarSchemaFactory<?>> FACTORY_REGISTER;
    public static final String CLASS_INFO_PLACEHOLDER = "INTERNAL.pulsar.schema.type.class.name";

    private PulsarSchemaUtils() {
    }

    public static boolean haveProtobuf() {
        return PROTOBUF_MESSAGE_CLASS != null;
    }

    public static <T> boolean isProtobufTypeClass(Class<T> clazz) {
        return ((Class)Preconditions.checkNotNull(PROTOBUF_MESSAGE_CLASS)).isAssignableFrom(clazz);
    }

    private static <T> void registerPrimitiveFactory(Schema<T> schema, TypeInformation<T> information) {
        PulsarSchemaUtils.registerSchemaFactory(new PrimitiveSchemaFactory<T>(schema, information));
    }

    private static void registerSchemaFactory(PulsarSchemaFactory<?> factory) {
        FACTORY_REGISTER.put(factory.type(), factory);
    }

    public static <T> Schema<T> createSchema(SchemaInfo info) {
        PulsarSchemaFactory<?> factory = FACTORY_REGISTER.get((Object)info.getType());
        Preconditions.checkNotNull(factory, (String)"This schema info %s is not supported.", (Object[])new Object[]{info});
        return factory.createSchema(info);
    }

    public static <T> TypeInformation<T> createTypeInformation(SchemaInfo info) {
        PulsarSchemaFactory<?> factory = FACTORY_REGISTER.get((Object)info.getType());
        Preconditions.checkNotNull(factory, (String)"This schema info %s is not supported.", (Object[])new Object[]{info});
        return factory.createTypeInfo(info);
    }

    public static SchemaInfo encodeClassInfo(SchemaInfo schemaInfo, Class<?> typeClass) {
        HashMap<String, String> properties = new HashMap<String, String>(schemaInfo.getProperties());
        properties.put(CLASS_INFO_PLACEHOLDER, typeClass.getName());
        return new SchemaInfoImpl(schemaInfo.getName(), schemaInfo.getSchema(), schemaInfo.getType(), properties);
    }

    public static <T> Class<T> decodeClassInfo(SchemaInfo schemaInfo) {
        Map<String, String> properties = schemaInfo.getProperties();
        String className = (String)Preconditions.checkNotNull((Object)properties.get(CLASS_INFO_PLACEHOLDER), (String)"This schema don't contain a class name.");
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Couldn't find the schema class " + className);
        }
    }

    static {
        Class<?> messageClass;
        FACTORY_REGISTER = new EnumMap(SchemaType.class);
        try {
            messageClass = Class.forName("com.google.protobuf.Message");
        }
        catch (ClassNotFoundException e) {
            messageClass = null;
        }
        PROTOBUF_MESSAGE_CLASS = messageClass;
        PulsarSchemaUtils.registerSchemaFactory(new AvroSchemaFactory());
        PulsarSchemaUtils.registerSchemaFactory(new JSONSchemaFactory());
        PulsarSchemaUtils.registerSchemaFactory(new KeyValueSchemaFactory());
        if (PulsarSchemaUtils.haveProtobuf()) {
            PulsarSchemaUtils.registerSchemaFactory(new ProtobufNativeSchemaFactory());
            PulsarSchemaUtils.registerSchemaFactory(new ProtobufSchemaFactory());
        }
        PulsarSchemaUtils.registerSchemaFactory(new StringSchemaFactory());
        PulsarSchemaUtils.registerSchemaFactory(new PrimitiveSchemaFactory<byte[]>(SchemaType.NONE, BytesSchema.of(), (TypeInformation<byte[]>)PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO));
        PulsarSchemaUtils.registerPrimitiveFactory(BooleanSchema.of(), Types.BOOLEAN);
        PulsarSchemaUtils.registerPrimitiveFactory(ByteSchema.of(), Types.BYTE);
        PulsarSchemaUtils.registerPrimitiveFactory(BytesSchema.of(), PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO);
        PulsarSchemaUtils.registerPrimitiveFactory(DateSchema.of(), BasicTypeInfo.DATE_TYPE_INFO);
        PulsarSchemaUtils.registerPrimitiveFactory(DoubleSchema.of(), Types.DOUBLE);
        PulsarSchemaUtils.registerPrimitiveFactory(FloatSchema.of(), Types.FLOAT);
        PulsarSchemaUtils.registerPrimitiveFactory(InstantSchema.of(), Types.INSTANT);
        PulsarSchemaUtils.registerPrimitiveFactory(IntSchema.of(), Types.INT);
        PulsarSchemaUtils.registerPrimitiveFactory(LocalDateSchema.of(), Types.LOCAL_DATE);
        PulsarSchemaUtils.registerPrimitiveFactory(LocalDateTimeSchema.of(), Types.LOCAL_DATE_TIME);
        PulsarSchemaUtils.registerPrimitiveFactory(LocalTimeSchema.of(), Types.LOCAL_TIME);
        PulsarSchemaUtils.registerPrimitiveFactory(LongSchema.of(), Types.LONG);
        PulsarSchemaUtils.registerPrimitiveFactory(ShortSchema.of(), Types.SHORT);
        PulsarSchemaUtils.registerPrimitiveFactory(TimeSchema.of(), Types.SQL_TIME);
        PulsarSchemaUtils.registerPrimitiveFactory(TimestampSchema.of(), Types.SQL_TIMESTAMP);
    }
}

