/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.util.Preconditions;

public class CheckpointMetrics
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long bytesProcessedDuringAlignment;
    private final long bytesPersistedDuringAlignment;
    private final long alignmentDurationNanos;
    private final long syncDurationMillis;
    private final long asyncDurationMillis;
    private final long checkpointStartDelayNanos;

    public CheckpointMetrics() {
        this(-1L, -1L, -1L, -1L, -1L, -1L);
    }

    public CheckpointMetrics(long bytesProcessedDuringAlignment, long bytesPersistedDuringAlignment, long alignmentDurationNanos, long syncDurationMillis, long asyncDurationMillis, long checkpointStartDelayNanos) {
        Preconditions.checkArgument((bytesProcessedDuringAlignment >= -1L ? 1 : 0) != 0);
        Preconditions.checkArgument((bytesPersistedDuringAlignment >= -1L ? 1 : 0) != 0);
        Preconditions.checkArgument((syncDurationMillis >= -1L ? 1 : 0) != 0);
        Preconditions.checkArgument((asyncDurationMillis >= -1L ? 1 : 0) != 0);
        Preconditions.checkArgument((alignmentDurationNanos >= -1L ? 1 : 0) != 0);
        Preconditions.checkArgument((checkpointStartDelayNanos >= -1L ? 1 : 0) != 0);
        this.bytesProcessedDuringAlignment = bytesProcessedDuringAlignment;
        this.bytesPersistedDuringAlignment = bytesPersistedDuringAlignment;
        this.alignmentDurationNanos = alignmentDurationNanos;
        this.syncDurationMillis = syncDurationMillis;
        this.asyncDurationMillis = asyncDurationMillis;
        this.checkpointStartDelayNanos = checkpointStartDelayNanos;
    }

    public long getBytesProcessedDuringAlignment() {
        return this.bytesProcessedDuringAlignment;
    }

    public long getBytesPersistedDuringAlignment() {
        return this.bytesPersistedDuringAlignment;
    }

    public long getAlignmentDurationNanos() {
        return this.alignmentDurationNanos;
    }

    public long getSyncDurationMillis() {
        return this.syncDurationMillis;
    }

    public long getAsyncDurationMillis() {
        return this.asyncDurationMillis;
    }

    public long getCheckpointStartDelayNanos() {
        return this.checkpointStartDelayNanos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointMetrics that = (CheckpointMetrics)o;
        return this.bytesProcessedDuringAlignment == that.bytesProcessedDuringAlignment && this.bytesPersistedDuringAlignment == that.bytesPersistedDuringAlignment && this.alignmentDurationNanos == that.alignmentDurationNanos && this.syncDurationMillis == that.syncDurationMillis && this.asyncDurationMillis == that.asyncDurationMillis && this.checkpointStartDelayNanos == that.checkpointStartDelayNanos;
    }

    public int hashCode() {
        return Objects.hash(this.bytesProcessedDuringAlignment, this.bytesPersistedDuringAlignment, this.alignmentDurationNanos, this.syncDurationMillis, this.asyncDurationMillis, this.checkpointStartDelayNanos);
    }

    public String toString() {
        return "CheckpointMetrics{bytesProcessedDuringAlignment=" + this.bytesProcessedDuringAlignment + ", bytesPersistedDuringAlignment=" + this.bytesPersistedDuringAlignment + ", alignmentDurationNanos=" + this.alignmentDurationNanos + ", syncDurationMillis=" + this.syncDurationMillis + ", asyncDurationMillis=" + this.asyncDurationMillis + ", checkpointStartDelayNanos=" + this.checkpointStartDelayNanos + '}';
    }
}

