/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest.messages.checkpoints;

import java.util.Objects;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=CompletedSubtaskCheckpointStatistics.class, name="completed"), @JsonSubTypes.Type(value=PendingSubtaskCheckpointStatistics.class, name="pending")})
public class SubtaskCheckpointStatistics {
    public static final String FIELD_NAME_INDEX = "index";
    public static final String FIELD_NAME_CHECKPOINT_STATUS = "status";
    @JsonProperty(value="index")
    private final int index;
    @JsonProperty(value="status")
    private final String checkpointStatus;

    @JsonCreator
    private SubtaskCheckpointStatistics(@JsonProperty(value="index") int index, @JsonProperty(value="status") String checkpointStatus) {
        this.index = index;
        this.checkpointStatus = checkpointStatus;
    }

    public int getIndex() {
        return this.index;
    }

    public String getCheckpointStatus() {
        return this.checkpointStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubtaskCheckpointStatistics that = (SubtaskCheckpointStatistics)o;
        return this.index == that.index && Objects.equals(this.checkpointStatus, that.checkpointStatus);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.checkpointStatus);
    }

    public static final class PendingSubtaskCheckpointStatistics
    extends SubtaskCheckpointStatistics {
        @JsonCreator
        public PendingSubtaskCheckpointStatistics(@JsonProperty(value="index") int index) {
            super(index, "pending_or_failed");
        }
    }

    public static final class CompletedSubtaskCheckpointStatistics
    extends SubtaskCheckpointStatistics {
        public static final String FIELD_NAME_ACK_TIMESTAMP = "ack_timestamp";
        public static final String FIELD_NAME_DURATION = "end_to_end_duration";
        public static final String FIELD_NAME_STATE_SIZE = "state_size";
        public static final String FIELD_NAME_CHECKPOINT_DURATION = "checkpoint";
        public static final String FIELD_NAME_ALIGNMENT = "alignment";
        public static final String FIELD_NAME_START_DELAY = "start_delay";
        @JsonProperty(value="ack_timestamp")
        private final long ackTimestamp;
        @JsonProperty(value="end_to_end_duration")
        private final long duration;
        @JsonProperty(value="state_size")
        private final long stateSize;
        @JsonProperty(value="checkpoint")
        private final CheckpointDuration checkpointDuration;
        @JsonProperty(value="alignment")
        private final CheckpointAlignment alignment;
        @JsonProperty(value="start_delay")
        private final long startDelay;

        @JsonCreator
        public CompletedSubtaskCheckpointStatistics(@JsonProperty(value="index") int index, @JsonProperty(value="ack_timestamp") long ackTimestamp, @JsonProperty(value="end_to_end_duration") long duration, @JsonProperty(value="state_size") long stateSize, @JsonProperty(value="checkpoint") CheckpointDuration checkpointDuration, @JsonProperty(value="alignment") CheckpointAlignment alignment, @JsonProperty(value="start_delay") long startDelay) {
            super(index, "completed");
            this.ackTimestamp = ackTimestamp;
            this.duration = duration;
            this.stateSize = stateSize;
            this.checkpointDuration = checkpointDuration;
            this.alignment = alignment;
            this.startDelay = startDelay;
        }

        public long getAckTimestamp() {
            return this.ackTimestamp;
        }

        public long getDuration() {
            return this.duration;
        }

        public long getStateSize() {
            return this.stateSize;
        }

        public CheckpointDuration getCheckpointDuration() {
            return this.checkpointDuration;
        }

        public CheckpointAlignment getAlignment() {
            return this.alignment;
        }

        public long getStartDelay() {
            return this.startDelay;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompletedSubtaskCheckpointStatistics that = (CompletedSubtaskCheckpointStatistics)o;
            return this.ackTimestamp == that.ackTimestamp && this.duration == that.duration && this.stateSize == that.stateSize && Objects.equals(this.checkpointDuration, that.checkpointDuration) && Objects.equals(this.alignment, that.alignment) && this.startDelay == that.startDelay;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.ackTimestamp, this.duration, this.stateSize, this.checkpointDuration, this.alignment, this.startDelay);
        }

        public static final class CheckpointAlignment {
            public static final String FIELD_NAME_ALIGNMENT_BUFFERED = "buffered";
            public static final String FIELD_NAME_ALIGNMENT_PROCESSED = "processed";
            public static final String FIELD_NAME_ALIGNMENT_PERSISTED = "persisted";
            public static final String FIELD_NAME_ALIGNMENT_DURATION = "duration";
            @JsonProperty(value="buffered")
            private final long alignmentBuffered;
            @JsonProperty(value="processed")
            private final long processed;
            @JsonProperty(value="persisted")
            private final long persisted;
            @JsonProperty(value="duration")
            private final long alignmentDuration;

            @JsonCreator
            public CheckpointAlignment(@JsonProperty(value="buffered") long alignmentBuffered, @JsonProperty(value="processed") long processed, @JsonProperty(value="persisted") long persisted, @JsonProperty(value="duration") long alignmentDuration) {
                this.alignmentBuffered = alignmentBuffered;
                this.processed = processed;
                this.persisted = persisted;
                this.alignmentDuration = alignmentDuration;
            }

            public long getAlignmentDuration() {
                return this.alignmentDuration;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                CheckpointAlignment that = (CheckpointAlignment)o;
                return this.alignmentBuffered == that.alignmentBuffered && this.processed == that.processed && this.persisted == that.persisted && this.alignmentDuration == that.alignmentDuration;
            }

            public int hashCode() {
                return Objects.hash(this.alignmentBuffered, this.processed, this.persisted, this.alignmentDuration);
            }
        }

        public static final class CheckpointDuration {
            public static final String FIELD_NAME_SYNC_DURATION = "sync";
            public static final String FIELD_NAME_ASYNC_DURATION = "async";
            @JsonProperty(value="sync")
            private final long syncDuration;
            @JsonProperty(value="async")
            private final long asyncDuration;

            @JsonCreator
            public CheckpointDuration(@JsonProperty(value="sync") long syncDuration, @JsonProperty(value="async") long asyncDuration) {
                this.syncDuration = syncDuration;
                this.asyncDuration = asyncDuration;
            }

            public long getSyncDuration() {
                return this.syncDuration;
            }

            public long getAsyncDuration() {
                return this.asyncDuration;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                CheckpointDuration that = (CheckpointDuration)o;
                return this.syncDuration == that.syncDuration && this.asyncDuration == that.asyncDuration;
            }

            public int hashCode() {
                return Objects.hash(this.syncDuration, this.asyncDuration);
            }
        }
    }
}

