/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.tasks;

import java.io.IOException;
import java.util.concurrent.Future;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetricsBuilder;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

public abstract class AbstractInvokable {
    private final Environment environment;
    private volatile boolean shouldInterruptOnCancel = true;

    public AbstractInvokable(Environment environment) {
        this.environment = (Environment)Preconditions.checkNotNull((Object)environment);
    }

    public abstract void invoke() throws Exception;

    public void cancel() throws Exception {
    }

    public void setShouldInterruptOnCancel(boolean shouldInterruptOnCancel) {
        this.shouldInterruptOnCancel = shouldInterruptOnCancel;
    }

    public boolean shouldInterruptOnCancel() {
        return this.shouldInterruptOnCancel;
    }

    public final Environment getEnvironment() {
        return this.environment;
    }

    public final ClassLoader getUserCodeClassLoader() {
        return this.getEnvironment().getUserCodeClassLoader().asClassLoader();
    }

    public int getCurrentNumberOfSubtasks() {
        return this.environment.getTaskInfo().getNumberOfParallelSubtasks();
    }

    public int getIndexInSubtaskGroup() {
        return this.environment.getTaskInfo().getIndexOfThisSubtask();
    }

    public final Configuration getTaskConfiguration() {
        return this.environment.getTaskConfiguration();
    }

    public Configuration getJobConfiguration() {
        return this.environment.getJobConfiguration();
    }

    public ExecutionConfig getExecutionConfig() {
        return this.environment.getExecutionConfig();
    }

    public Future<Boolean> triggerCheckpointAsync(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, boolean advanceToEndOfEventTime) {
        throw new UnsupportedOperationException(String.format("triggerCheckpointAsync not supported by %s", this.getClass().getName()));
    }

    public void triggerCheckpointOnBarrier(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, CheckpointMetricsBuilder checkpointMetrics) throws IOException {
        throw new UnsupportedOperationException(String.format("triggerCheckpointOnBarrier not supported by %s", this.getClass().getName()));
    }

    public void abortCheckpointOnBarrier(long checkpointId, Throwable cause) throws IOException {
        throw new UnsupportedOperationException(String.format("abortCheckpointOnBarrier not supported by %s", this.getClass().getName()));
    }

    public Future<Void> notifyCheckpointCompleteAsync(long checkpointId) {
        throw new UnsupportedOperationException(String.format("notifyCheckpointCompleteAsync not supported by %s", this.getClass().getName()));
    }

    public Future<Void> notifyCheckpointAbortAsync(long checkpointId) {
        throw new UnsupportedOperationException(String.format("notifyCheckpointAbortAsync not supported by %s", this.getClass().getName()));
    }

    public void dispatchOperatorEvent(OperatorID operator, SerializedValue<OperatorEvent> event) throws FlinkException {
        throw new UnsupportedOperationException("dispatchOperatorEvent not supported by " + this.getClass().getName());
    }
}

